/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bitbucket.dc;

import ch.mibex.atlassian.Logging;
import ch.mibex.atlassian.cache.Cache;
import ch.mibex.atlassian.cache.Cache$;
import ch.mibex.atlassian.dc.AppKeyProvider;
import ch.mibex.bitbucket.dc.ChangedFilesCollector$DiffKey$;
import ch.mibex.bitbucket.dc.ChangedFilesCollector$PatchIdsKey$;
import ch.mibex.bitbucket.dc.ChangedFilesCollector$package$;
import ch.mibex.bitbucket.dc.CommitRefs;
import ch.mibex.bitbucket.dc.DCPRGitRefs$package$DCPRGitRefs$;
import ch.mibex.bitbucket.dc.GitError$;
import ch.mibex.bitbucket.dc.GitVersionNotSupported$;
import ch.mibex.bitbucket.dc.ImpersonificationService;
import ch.mibex.bitbucket.dc.NoCommonAncestor$;
import ch.mibex.bitbucket.dc.PatchIdOutputHandler;
import ch.mibex.bitbucket.dc.RangeDiffOutputHandler;
import ch.mibex.bitbucket.dc.RangeDiffParseResult;
import ch.mibex.bitbucket.dc.RescopeDiffFailure;
import ch.mibex.cache.CacheStats;
import ch.mibex.git.ChangesInDiff;
import ch.mibex.git.ChangesInDiff$;
import ch.mibex.git.CommitSha;
import ch.mibex.git.FileDiffInfo;
import ch.mibex.git.GitCommandResultParser$;
import ch.mibex.telemetry.TelemetryContext;
import ch.mibex.telemetry.events.globals$package$;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.compare.CompareService;
import com.atlassian.bitbucket.content.AbstractChangeCallback;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.io.LineInputHandler;
import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.CommonAncestorCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandBuilder;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderSupport;
import com.atlassian.bitbucket.scm.git.command.GitCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import com.atlassian.cache.CacheFactory;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import scala.util.hashing.MurmurHash3$;

public class ChangedFilesCollector
implements Logging {
    private volatile Logger ch$mibex$atlassian$Logging$$logger;
    private final CompareService compareService;
    private final ImpersonificationService impersonification;
    public final GitCommandBuilderFactory ch$mibex$bitbucket$dc$ChangedFilesCollector$$builderFactory;
    private final GitCommandFactory commandFactory;
    private final TelemetryContext telemetryContext;
    public final ChangedFilesCollector$DiffKey$ DiffKey$lzy1;
    private final Cache<CommitRefs<Repository>, DiffKey, ChangesInDiff> cachedChangedFiles;
    public final ChangedFilesCollector$PatchIdsKey$ PatchIdsKey$lzy1;
    private final Cache<CommitRefs<Repository>, PatchIdsKey, Either<RescopeDiffFailure, List<String>>> cachedPatchIds;

    public ChangedFilesCollector(CompareService compareService, ImpersonificationService impersonification, GitCommandBuilderFactory builderFactory, GitCommandFactory commandFactory, CacheFactory cacheFactory, AppKeyProvider appKeyProvider, TelemetryContext telemetryContext) {
        this.compareService = compareService;
        this.impersonification = impersonification;
        this.ch$mibex$bitbucket$dc$ChangedFilesCollector$$builderFactory = builderFactory;
        this.commandFactory = commandFactory;
        this.telemetryContext = telemetryContext;
        this.DiffKey$lzy1 = new ChangedFilesCollector$DiffKey$(this);
        this.PatchIdsKey$lzy1 = new ChangedFilesCollector$PatchIdsKey$(this);
        Logging.$init$(this);
        Function1<CommitRefs, DiffKey> & Serializable intersect = (Function1<CommitRefs, DiffKey> & Serializable)refs -> this.DiffKey().apply(refs.from().sha(), refs.to().sha());
        Function1<CommitRefs, ChangesInDiff> & Serializable intersect2 = (Function1<CommitRefs, ChangesInDiff> & Serializable)diff -> this.findChangeFilesForce((CommitRefs<Repository>)diff);
        FiniteDuration finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minutes();
        String string2 = new StringBuilder(24).append(appKeyProvider.appKey()).append(":changed-files-collector").toString();
        Function2<CacheStats, String, BoxedUnit> function2 = globals$package$.MODULE$.sendCacheEvent(this.given_TelemetryContext());
        Function1 function1 = Cache$.MODULE$.$lessinit$greater$default$8();
        this.cachedChangedFiles = new Cache(intersect, intersect2, true, finiteDuration, 10000, cacheFactory, string2, function1, function2);
        Function1<CommitRefs, PatchIdsKey> & Serializable intersect3 = (Function1<CommitRefs, PatchIdsKey> & Serializable)refs -> this.PatchIdsKey().apply(refs.from().sha(), refs.to().sha(), ((Repository)refs.from().repo()).getId(), ((Repository)refs.to().repo()).getId());
        Function1<CommitRefs, Either> & Serializable intersect4 = (Function1<CommitRefs, Either> & Serializable)diff -> this.calculatePatchIdsForce((CommitRefs<Repository>)diff);
        FiniteDuration finiteDuration2 = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
        String string3 = new StringBuilder(10).append(appKeyProvider.appKey()).append(":patch-ids").toString();
        Function1<Either, Boolean> & Serializable intersect5 = (Function1<Either, Boolean> & Serializable)_$5 -> _$5.isRight();
        Function2<CacheStats, String, BoxedUnit> function22 = globals$package$.MODULE$.sendCacheEvent(this.given_TelemetryContext());
        this.cachedPatchIds = new Cache(intersect3, intersect4, true, finiteDuration2, 10000, cacheFactory, string3, intersect5, function22);
    }

    @Override
    public Logger ch$mibex$atlassian$Logging$$logger() {
        return this.ch$mibex$atlassian$Logging$$logger;
    }

    @Override
    public void ch$mibex$atlassian$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$atlassian$Logging$$logger = x$1;
    }

    public final TelemetryContext given_TelemetryContext() {
        return this.telemetryContext;
    }

    public final ChangedFilesCollector$DiffKey$ DiffKey() {
        return this.DiffKey$lzy1;
    }

    public Set<FileDiffInfo> findFilesInDiffWithModificationInfo(PullRequest pr) {
        return this.findFilesInDiffWithModificationInfo(DCPRGitRefs$package$DCPRGitRefs$.MODULE$.refs(pr));
    }

    public Set<FileDiffInfo> findFilesInDiffWithModificationInfo(CommitRefs<Repository> diff) {
        return this.cachedChangedFiles.get(diff).affectedFilesInfo();
    }

    public ChangesInDiff findChangesInDiff(PullRequest pr) {
        return this.findChangesInDiff(DCPRGitRefs$package$DCPRGitRefs$.MODULE$.refs(pr));
    }

    public ChangesInDiff findChangesInDiff(CommitRefs<Repository> diff) {
        return this.cachedChangedFiles.get(diff);
    }

    private ChangesInDiff findChangeFilesForce(CommitRefs<Repository> diff) {
        return (ChangesInDiff)this.time(new StringBuilder(30).append("Locate changed files in diff: ").append(diff).toString(), () -> this.findChangeFilesForce$$anonfun$1(diff));
    }

    public Either<RescopeDiffFailure, ChangesInDiff> findChangedFilesInRescopeDiff(CommitRefs<Repository> currentDiff, CommitRefs<Repository> previousDiff) {
        return (Either)this.impersonification.AsCurrentUser().runWithPermission(Permission.REPO_READ, "We might read a PR with source reference from a private repo (e.g. forked repo)", () -> this.findChangedFilesInRescopeDiff$$anonfun$1(previousDiff, currentDiff));
    }

    private Either<RescopeDiffFailure, ChangesInDiff> changedFilesInRescope(CommitRefs<Repository> currentDiff, CommitRefs<Repository> previousDiff) {
        return this.getCommonAncestor(previousDiff).flatMap((Function1<String, Either> & Serializable)previousAncestor -> this.getCommonAncestor(currentDiff).flatMap((Function1<String, Either> & Serializable)currentAncestor -> {
            this.debug(() -> ChangedFilesCollector.changedFilesInRescope$$anonfun$1$$anonfun$1$$anonfun$1(previousAncestor, currentAncestor));
            return (previousAncestor.equals(currentAncestor) ? this.findChangedFilesUsingGitDiff(currentDiff, previousDiff) : this.findChangedFilesUsingRangeDiff(currentDiff, previousDiff, (String)currentAncestor, (String)previousAncestor)).map((Function1<ChangesInDiff, ChangesInDiff> & Serializable)changedFiles -> changedFiles);
        }));
    }

    private Either<RescopeDiffFailure, ChangesInDiff> findChangedFilesUsingGitDiff(CommitRefs<Repository> current, CommitRefs<Repository> previous) {
        this.debug(() -> ChangedFilesCollector.findChangedFilesUsingGitDiff$$anonfun$1(current, previous));
        return package$.MODULE$.Right().apply(this.findChangesInDiff(new CommitRefs<Repository>(current, previous){
            private final CommitRefs current$2;
            private final CommitRefs previous$2;
            {
                this.current$2 = current$5;
                this.previous$2 = previous$4;
            }

            public CommitSha from() {
                return this.current$2.from();
            }

            public CommitSha to() {
                return this.previous$2.from();
            }
        }));
    }

    private Either<RescopeDiffFailure, ChangesInDiff> findChangedFilesUsingRangeDiff(CommitRefs<Repository> current, CommitRefs<Repository> previous, String currentAncestor, String previousAncestor) {
        Either<RescopeDiffFailure, RangeDiffParseResult> parsedRangeDiffResult;
        this.debug(() -> ChangedFilesCollector.findChangedFilesUsingRangeDiff$$anonfun$1(current, previous));
        Either<RescopeDiffFailure, RangeDiffParseResult> either = parsedRangeDiffResult = this.parseRangeDiff(current, previous, currentAncestor, previousAncestor);
        if (either instanceof Right) {
            Right right = (Right)either;
            RangeDiffParseResult parseResult = (RangeDiffParseResult)right.value();
            if (parseResult.rangeUpdated()) {
                Right pathsInAddedAndRemoved = parseResult.commitsWithChanges().nonEmpty() ? this.getChangedFilesInAddedOrRemovedCommits(current.from().repo(), parseResult.commitsWithChanges()) : package$.MODULE$.Right().apply(Predef$.MODULE$.Set().empty());
                return pathsInAddedAndRemoved.map((Function1<Set, Set> & Serializable)_$3 -> (Set)_$3.$plus$plus(parseResult.modifiedPaths())).map((Function1<Set, ChangesInDiff> & Serializable)_$4 -> ChangesInDiff$.MODULE$.apply((Set<FileDiffInfo>)_$4));
            }
            return package$.MODULE$.Right().apply(ChangesInDiff$.MODULE$.empty());
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            RescopeDiffFailure other = (RescopeDiffFailure)left.value();
            return package$.MODULE$.Left().apply(other);
        }
        throw new MatchError(either);
    }

    private Either<RescopeDiffFailure, Object> isUpdatedFromPatchId(CommitRefs<Repository> previous, CommitRefs<Repository> current) {
        Either<RescopeDiffFailure, Object> isUpdated = this.calculatePatchIds(previous).flatMap((Function1<List, Either> & Serializable)oldPatchIds -> this.calculatePatchIds(current).map((Function1<List, Boolean> & Serializable)newPatchIds -> {
            this.debug(() -> ChangedFilesCollector.$anonfun$6$$anonfun$1$$anonfun$1(oldPatchIds, newPatchIds));
            return !oldPatchIds.equals(newPatchIds);
        }));
        return isUpdated;
    }

    public final ChangedFilesCollector$PatchIdsKey$ PatchIdsKey() {
        return this.PatchIdsKey$lzy1;
    }

    public Either<RescopeDiffFailure, List<String>> calculatePatchIds(CommitRefs<Repository> diff) {
        return this.cachedPatchIds.get(diff);
    }

    private Either<RescopeDiffFailure, List<String>> calculatePatchIdsForce(CommitRefs<Repository> diff) {
        Either either;
        GitScmCommandBuilder diffBuilder = (GitScmCommandBuilder)((GitCommandBuilderSupport)this.ch$mibex$bitbucket$dc$ChangedFilesCollector$$builderFactory.builder(diff.to().repo()).command("diff").argument("--binary").argument("--full-index").argument(new StringBuilder(3).append(diff.to().id()).append("...").append(diff.from().id()).toString()).argument("--")).alternates(diff.from().repo(), new Repository[0]);
        try {
            List patchIds = (List)diffBuilder.build((CommandOutputHandler)new CommandOutputHandler<List<String>>(diff, this){
                private final CommitRefs diff$2;
                private List result;
                private final /* synthetic */ ChangedFilesCollector $outer;
                {
                    this.diff$2 = diff$3;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(StandardCharsets.UTF_8);
                }

                public void processReader(LineReader lineReader) {
                    List gitResult;
                    LineInputHandler inputHandler = new LineInputHandler((Iterable)lineReader);
                    this.result = gitResult = (List)((GitScmCommandBuilder)((ScmCommandBuilder)this.$outer.ch$mibex$bitbucket$dc$ChangedFilesCollector$$builderFactory.builder((Repository)this.diff$2.to().repo()).alternates((Repository)this.diff$2.from().repo(), new Repository[0])).command("patch-id").argument("--stable").inputHandler((CommandInputHandler)inputHandler)).build((CommandOutputHandler)new PatchIdOutputHandler()).call();
                }

                public List getOutput() {
                    return this.result;
                }
            }).call();
            either = package$.MODULE$.Right().apply(patchIds);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = option.get();
                this.warn("Failed to calculate patch-ids", e);
                either = package$.MODULE$.Left().apply(GitError$.MODULE$.apply(e.getMessage()));
            }
            throw throwable;
        }
        return either;
    }

    private Either<RescopeDiffFailure, RangeDiffParseResult> parseRangeDiff(CommitRefs<Repository> currentDiff, CommitRefs<Repository> previousDiff, String currentAncestor, String previousAncestor) {
        Either either;
        try {
            RangeDiffParseResult result = (RangeDiffParseResult)((GitScmCommandBuilder)this.ch$mibex$bitbucket$dc$ChangedFilesCollector$$builderFactory.builder(currentDiff.from().repo()).command("range-diff").argument("--no-color").argument(new StringBuilder(2).append(previousAncestor).append("..").append(previousDiff.from().id()).toString()).argument(new StringBuilder(2).append(currentAncestor).append("..").append(currentDiff.from().id()).toString())).build((CommandOutputHandler)new RangeDiffOutputHandler()).call();
            this.debug(() -> ChangedFilesCollector.parseRangeDiff$$anonfun$1(result));
            either = package$.MODULE$.Right().apply(result);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            CommandFailedException commandFailedException;
            CommandFailedException err;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof CommandFailedException && (err = (commandFailedException = (CommandFailedException)throwable2)).getMessage().contains("is not a git command")) {
                this.warn("Git range-diff not available, use Git >= 2.23", (Throwable)err);
                either = package$.MODULE$.Left().apply(GitVersionNotSupported$.MODULE$);
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable err2 = throwable3 = option.get();
                this.warn("Git range-diff failed:", err2);
                either = package$.MODULE$.Left().apply(GitError$.MODULE$.apply(err2.getMessage()));
            }
            throw throwable;
        }
        return either;
    }

    public Either<RescopeDiffFailure, Set<FileDiffInfo>> getChangedFilesInAddedOrRemovedCommits(Repository fromRepo, Seq<String> commits) {
        Either either;
        try {
            this.debug(() -> ChangedFilesCollector.getChangedFilesInAddedOrRemovedCommits$$anonfun$1(commits));
            GitScmCommandBuilder showCommand = (GitScmCommandBuilder)this.ch$mibex$bitbucket$dc$ChangedFilesCollector$$builderFactory.builder(fromRepo).command("show").argument("--pretty=format:").argument("--name-status").argument("-M");
            commits.foreach((Function1<String, GitScmCommandBuilder> & Serializable)x$0 -> (GitScmCommandBuilder)showCommand.argument(x$0));
            Set result = (Set)showCommand.build((CommandOutputHandler)new CommandOutputHandler<Set<FileDiffInfo>>(){
                private final Builder result;
                {
                    this.result = package$.MODULE$.IndexedSeq().newBuilder();
                }

                public Builder result() {
                    return this.result;
                }

                public void processReader(LineReader reader) {
                    String line = reader.readLine();
                    while (line != null) {
                        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line))) {
                            this.result().$plus$plus$eq(GitCommandResultParser$.MODULE$.parseNameStatusOutputLine(line));
                        }
                        line = reader.readLine();
                    }
                }

                public Set getOutput() {
                    return ((IterableOnceOps)this.result().result()).toSet();
                }
            }).call();
            either = package$.MODULE$.Right().apply(result);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable err = throwable3 = option.get();
                this.warn("Git show failed:", err);
                either = package$.MODULE$.Left().apply(GitError$.MODULE$.apply(err.getMessage()));
            }
            throw throwable;
        }
        return either;
    }

    public Either<RescopeDiffFailure, String> getCommonAncestor(CommitRefs<Repository> diffSpec) {
        CommonAncestorCommandParameters ancestorCommandParameters = new CommonAncestorCommandParameters.Builder().commitId(diffSpec.to().id(), new String[]{diffSpec.from().id()}).secondaryRepository(diffSpec.to().repo()).build();
        return Option$.MODULE$.apply(this.commandFactory.commonAncestor(diffSpec.from().repo(), ancestorCommandParameters).call()).map((Function1<MinimalCommit, String> & Serializable)_$6 -> _$6.getId()).toRight(() -> this.getCommonAncestor$$anonfun$2(diffSpec));
    }

    private final void findChangeFilesForce$$anonfun$1$$anonfun$1(CompareRequest compareRequest$1, ObjectRef changedFiles$1) {
        this.compareService.streamChanges(compareRequest$1, (ChangeCallback)new AbstractChangeCallback(changedFiles$1){
            private final ObjectRef changedFiles$2;
            {
                this.changedFiles$2 = changedFiles$3;
            }

            public boolean onChange(Change change) {
                ChangedFilesCollector$package$.MODULE$.changeToFileDiffInfo(change).foreach(_$2 -> {
                    this.changedFiles$2.elem = (HashSet)((HashSet)this.changedFiles$2.elem).$plus(_$2);
                });
                return true;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onChange$$anonfun$1(ch.mibex.git.FileDiffInfo )}, serializedLambda);
            }
        });
    }

    private final ChangesInDiff findChangeFilesForce$$anonfun$1(CommitRefs diff$1) {
        CompareRequest compareRequest = new CompareRequest.Builder().fromRef(diff$1.from().id(), (Repository)diff$1.from().repo()).toRef(diff$1.to().id(), (Repository)diff$1.to().repo()).build();
        ObjectRef changedFiles = ObjectRef.create(new HashSet());
        this.impersonification.AsCurrentUser().runWithPermission(Permission.REPO_READ, "We might read a PR with source reference from a private repo (e.g. forked repo)", (Function0<Object> & Serializable)() -> {
            this.findChangeFilesForce$$anonfun$1$$anonfun$1(compareRequest, changedFiles);
            return BoxedUnit.UNIT;
        });
        return ChangesInDiff$.MODULE$.apply((HashSet)changedFiles.elem);
    }

    private final /* synthetic */ Either findChangedFilesInRescopeDiff$$anonfun$1$$anonfun$1(CommitRefs currentDiff$2, CommitRefs previousDiff$2, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return this.changedFilesInRescope(currentDiff$2, previousDiff$2);
        }
        if (!bl) {
            return package$.MODULE$.Right().apply(ChangesInDiff$.MODULE$.apply((Set<FileDiffInfo>)Predef$.MODULE$.Set().empty()));
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(bl));
    }

    private final Either findChangedFilesInRescopeDiff$$anonfun$1(CommitRefs previousDiff$1, CommitRefs currentDiff$1) {
        return this.isUpdatedFromPatchId(previousDiff$1, currentDiff$1).flatMap((Function1<Object, Either> & Serializable)x$1 -> this.findChangedFilesInRescopeDiff$$anonfun$1$$anonfun$1(currentDiff$1, previousDiff$1, BoxesRunTime.unboxToBoolean(x$1)));
    }

    private static final String changedFilesInRescope$$anonfun$1$$anonfun$1$$anonfun$1(String previousAncestor$2, String currentAncestor$1) {
        return new StringBuilder(53).append("[files-in-rescope] ancestors -> previous: ").append(previousAncestor$2).append(", current: ").append(currentAncestor$1).toString();
    }

    private static final String findChangedFilesUsingGitDiff$$anonfun$1(CommitRefs current$1, CommitRefs previous$1) {
        return new StringBuilder(62).append("[files-in-rescope] same ancestor: using git diff between ").append(current$1.from().id()).append(" and ").append(previous$1.from().id()).toString();
    }

    private static final String findChangedFilesUsingRangeDiff$$anonfun$1(CommitRefs current$3, CommitRefs previous$3) {
        return new StringBuilder(72).append("[files-in-rescope] different ancestors: try git range-diff between ").append(current$3.from().id()).append(" and ").append(previous$3.from().id()).toString();
    }

    private static final String $anonfun$6$$anonfun$1$$anonfun$1(List oldPatchIds$2, List newPatchIds$1) {
        return new StringBuilder(36).append("Old patch ID(s): ").append(oldPatchIds$2).append("; new patch ID(s): ").append(newPatchIds$1).toString();
    }

    private static final String parseRangeDiff$$anonfun$1(RangeDiffParseResult result$1) {
        return new StringBuilder(17).append("RangeDiffResult: ").append(result$1).toString();
    }

    private static final String getChangedFilesInAddedOrRemovedCommits$$anonfun$1(Seq commits$1) {
        return new StringBuilder(50).append("[auto-unapprove] generating git show for commits: ").append(commits$1).toString();
    }

    private static final String getCommonAncestor$$anonfun$2$$anonfun$1(CommitRefs diffSpec$2) {
        return new StringBuilder(44).append("Could not find common ancestor between ").append(diffSpec$2.to().id()).append(" and ").append(diffSpec$2.from().id()).toString();
    }

    private final NoCommonAncestor$ getCommonAncestor$$anonfun$2(CommitRefs diffSpec$1) {
        this.debug(() -> ChangedFilesCollector.getCommonAncestor$$anonfun$2$$anonfun$1(diffSpec$1));
        return NoCommonAncestor$.MODULE$;
    }

    public class DiffKey
    implements Product,
    Serializable {
        private final String fromRefSha;
        private final String toRefSha;
        private final /* synthetic */ ChangedFilesCollector $outer;

        public DiffKey(ChangedFilesCollector $outer, String fromRefSha, String toRefSha) {
            this.fromRefSha = fromRefSha;
            this.toRefSha = toRefSha;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash(this, -781521880, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            DiffKey diffKey;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DiffKey)) return false;
            if (((DiffKey)object).ch$mibex$bitbucket$dc$ChangedFilesCollector$DiffKey$$$outer() != this.$outer) return false;
            DiffKey diffKey2 = diffKey = (DiffKey)object;
            String string2 = this.fromRefSha();
            String string3 = diffKey2.fromRefSha();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            String string4 = this.toRefSha();
            String string5 = diffKey2.toRefSha();
            if (string4 == null) {
                if (string5 != null) {
                    return false;
                }
            } else if (!string4.equals(string5)) return false;
            if (!diffKey2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof DiffKey;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "DiffKey";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fromRefSha";
            }
            if (1 == n2) {
                return "toRefSha";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String fromRefSha() {
            return this.fromRefSha;
        }

        public String toRefSha() {
            return this.toRefSha;
        }

        public DiffKey copy(String fromRefSha, String toRefSha) {
            return new DiffKey(this.$outer, fromRefSha, toRefSha);
        }

        public String copy$default$1() {
            return this.fromRefSha();
        }

        public String copy$default$2() {
            return this.toRefSha();
        }

        public String _1() {
            return this.fromRefSha();
        }

        public String _2() {
            return this.toRefSha();
        }

        public final /* synthetic */ ChangedFilesCollector ch$mibex$bitbucket$dc$ChangedFilesCollector$DiffKey$$$outer() {
            return this.$outer;
        }
    }

    public class PatchIdsKey
    implements Product,
    Serializable {
        private final String fromRefSha;
        private final String toRefSha;
        private final int fromRepoId;
        private final int toRepoId;
        private final /* synthetic */ ChangedFilesCollector $outer;

        public PatchIdsKey(ChangedFilesCollector $outer, String fromRefSha, String toRefSha, int fromRepoId, int toRepoId) {
            this.fromRefSha = fromRefSha;
            this.toRefSha = toRefSha;
            this.fromRepoId = fromRepoId;
            this.toRepoId = toRepoId;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, 1915933391);
            n = Statics.mix(n, Statics.anyHash(this.fromRefSha()));
            n = Statics.mix(n, Statics.anyHash(this.toRefSha()));
            n = Statics.mix(n, this.fromRepoId());
            n = Statics.mix(n, this.toRepoId());
            return Statics.finalizeHash(n, 4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            PatchIdsKey patchIdsKey;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PatchIdsKey)) return false;
            if (((PatchIdsKey)object).ch$mibex$bitbucket$dc$ChangedFilesCollector$PatchIdsKey$$$outer() != this.$outer) return false;
            PatchIdsKey patchIdsKey2 = patchIdsKey = (PatchIdsKey)object;
            if (this.fromRepoId() != patchIdsKey2.fromRepoId()) return false;
            if (this.toRepoId() != patchIdsKey2.toRepoId()) return false;
            String string2 = this.fromRefSha();
            String string3 = patchIdsKey2.fromRefSha();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            String string4 = this.toRefSha();
            String string5 = patchIdsKey2.toRefSha();
            if (string4 == null) {
                if (string5 != null) {
                    return false;
                }
            } else if (!string4.equals(string5)) return false;
            if (!patchIdsKey2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof PatchIdsKey;
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "PatchIdsKey";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger(this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger(this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "fromRefSha";
                }
                case 1: {
                    return "toRefSha";
                }
                case 2: {
                    return "fromRepoId";
                }
                case 3: {
                    return "toRepoId";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String fromRefSha() {
            return this.fromRefSha;
        }

        public String toRefSha() {
            return this.toRefSha;
        }

        public int fromRepoId() {
            return this.fromRepoId;
        }

        public int toRepoId() {
            return this.toRepoId;
        }

        public PatchIdsKey copy(String fromRefSha, String toRefSha, int fromRepoId, int toRepoId) {
            return new PatchIdsKey(this.$outer, fromRefSha, toRefSha, fromRepoId, toRepoId);
        }

        public String copy$default$1() {
            return this.fromRefSha();
        }

        public String copy$default$2() {
            return this.toRefSha();
        }

        public int copy$default$3() {
            return this.fromRepoId();
        }

        public int copy$default$4() {
            return this.toRepoId();
        }

        public String _1() {
            return this.fromRefSha();
        }

        public String _2() {
            return this.toRefSha();
        }

        public int _3() {
            return this.fromRepoId();
        }

        public int _4() {
            return this.toRepoId();
        }

        public final /* synthetic */ ChangedFilesCollector ch$mibex$bitbucket$dc$ChangedFilesCollector$PatchIdsKey$$$outer() {
            return this.$outer;
        }
    }
}

