/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.tasks;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.SonarQubeEdition$;
import ch.mibex.bamboo.sonar4bamboo.Utils$;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarConstants$;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarUtils$;
import ch.mibex.bamboo.sonar4bamboo.sonar.projectinfo.ProjectInfo;
import ch.mibex.bamboo.sonar4bamboo.sonar.projectinfo.SonarProjectInfoAnalyzer;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarTaskConfigConstants$;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarVersions$;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class SonarBranchOrPrParamAnalyzer
implements Logging {
    private Logger log;
    private final CustomVariableContext customVariableContext;
    private final DefaultArtifactVersion SonarVersion8Series;
    private final DefaultArtifactVersion FirstSonarVersionWithoutSonarBranchTargetParam;
    private final DefaultArtifactVersion FirstSonarVersion8RequiringWellFormattedProjectKey;
    private final DefaultArtifactVersion FirstSonarVersion7RequiringWellFormattedProjectKey;

    public SonarBranchOrPrParamAnalyzer(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
        Logging.$init$(this);
        this.SonarVersion8Series = new DefaultArtifactVersion("8.0.0");
        this.FirstSonarVersionWithoutSonarBranchTargetParam = new DefaultArtifactVersion("8.1.0");
        this.FirstSonarVersion8RequiringWellFormattedProjectKey = new DefaultArtifactVersion("8.3.0");
        this.FirstSonarVersion7RequiringWellFormattedProjectKey = new DefaultArtifactVersion("7.9.3");
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public List<String> deduceSonarAnalysisParameters(TaskContext taskContext) {
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[0]));
        if (!Utils$.MODULE$.isMSBuildEndTask(taskContext)) {
            if (SonarQubeEdition$.MODULE$.branchStyle(taskContext.getRuntimeTaskContext(), taskContext.getConfigurationMap()).nativeSonarBranches()) {
                this.useBranchOrPullRequestParams(taskContext, params);
            } else {
                this.appendBranchToProjectKey(taskContext, params);
            }
        }
        return params.toList();
    }

    private boolean supportsBranchTargetParam(TaskContext taskContext) {
        return SonarVersions$.MODULE$.sonarVersionBelow(this.FirstSonarVersionWithoutSonarBranchTargetParam, taskContext);
    }

    private void appendBranchToProjectKey(TaskContext taskContext, ListBuffer<String> params) {
        SonarProjectInfoAnalyzer sonarProjectInfoAnalyzer = new SonarProjectInfoAnalyzer(this.customVariableContext);
        ProjectInfo projectInfo = sonarProjectInfoAnalyzer.analyzeProjectInfo(taskContext);
        String sonarBranch = this.determineSonarBranchName(taskContext);
        String sonarBranchSuffix = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sonarBranch.trim())) ? new StringBuilder(1).append(":").append(sonarBranch).toString() : "";
        String projectKeyAndBranch = new StringBuilder(0).append(projectInfo.key()).append(sonarBranchSuffix).toString();
        SonarUtils$.MODULE$.addToCommandIfDefined(taskContext, SonarConstants$.MODULE$.SonarProjectKey(), projectKeyAndBranch, params);
        String projectNameAndBranch = new StringBuilder(0).append((String)Utils$.MODULE$.getValueIfConfigured(projectInfo.name()).getOrElse(() -> SonarBranchOrPrParamAnalyzer.$anonfun$1(projectInfo))).append(sonarBranchSuffix).toString();
        SonarUtils$.MODULE$.addToCommandIfDefined(taskContext, SonarConstants$.MODULE$.SonarProjectName(), projectNameAndBranch, params);
    }

    private void useBranchOrPullRequestParams(TaskContext taskContext, ListBuffer<String> params) {
        Map<String, VariableDefinitionContext> variables = Utils$.MODULE$.getBuildVariables(this.customVariableContext);
        ConfigurationMap config = taskContext.getConfigurationMap();
        SonarUtils$.MODULE$.addToCommandIfDefined(taskContext, SonarConstants$.MODULE$.SonarProjectKey(), (String)config.get((Object)SonarTaskConfigConstants$.MODULE$.SonarProjectKeyField()), params);
        SonarUtils$.MODULE$.addToCommandIfDefined(taskContext, SonarConstants$.MODULE$.SonarProjectName(), (String)config.get((Object)SonarTaskConfigConstants$.MODULE$.SonarProjectNameField()), params);
        if (SonarQubeEdition$.MODULE$.branchStyle(taskContext).useSonarPullRequestAnalysis() && variables.get("repository.pr.sourceBranch").isDefined()) {
            String sourceBranch = ((VariableDefinitionContext)variables.getOrElse("repository.pr.sourceBranch", SonarBranchOrPrParamAnalyzer::$anonfun$2)).getValue();
            String targetBranch = ((VariableDefinitionContext)variables.getOrElse("repository.pr.targetBranch", SonarBranchOrPrParamAnalyzer::$anonfun$3)).getValue();
            String pullRequestKey = ((VariableDefinitionContext)variables.getOrElse("repository.pr.key", SonarBranchOrPrParamAnalyzer::$anonfun$4)).getValue();
            SonarUtils$.MODULE$.addToCommandIfDefined(taskContext, SonarConstants$.MODULE$.SonarPrBranch(), sourceBranch, params);
            SonarUtils$.MODULE$.addToCommandIfDefined(taskContext, SonarConstants$.MODULE$.SonarPrBase(), targetBranch, params);
            SonarUtils$.MODULE$.addToCommandIfDefined(taskContext, SonarConstants$.MODULE$.SonarPrKey(), pullRequestKey, params);
            return;
        }
        this.debug(SonarBranchOrPrParamAnalyzer::useBranchOrPullRequestParams$$anonfun$1);
        String sonarBranch = (String)Utils$.MODULE$.getCurrentGitBranch(this.customVariableContext).getOrElse(SonarBranchOrPrParamAnalyzer::$anonfun$5);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sonarBranch.trim()))) {
            String string2 = sonarBranch;
            String string3 = this.getSonarMainBranchName(config);
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                this.addBuildLogEntry(new StringBuilder(4).append(SonarConstants$.MODULE$.SonarBranchName()).append(": '").append(sonarBranch).append("'").toString(), taskContext);
                SonarUtils$.MODULE$.addToCommandIfDefined(taskContext, SonarConstants$.MODULE$.SonarBranchName(), sonarBranch, params);
            }
            if (this.supportsBranchTargetParam(taskContext)) {
                this.fillBranchTargetNameIfAvailable(taskContext, params);
                return;
            }
            return;
        }
        this.warn("No branch name found, skipping sonar.branch.name option");
    }

    private void fillBranchTargetNameIfAvailable(TaskContext taskContext, ListBuffer<String> params) {
        Some some;
        String branchTargetName;
        Option option = Option$.MODULE$.apply(taskContext.getRuntimeTaskContext().get(SonarConstants$.MODULE$.SonarBranchTargetName()));
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(branchTargetName = (String)(some = (Some)option).value()))) {
            this.addBuildLogEntry(new StringBuilder(35).append("Will use '").append(branchTargetName).append("' as sonar.branch.target.").toString(), taskContext);
            SonarUtils$.MODULE$.addToCommandIfDefined(taskContext, SonarConstants$.MODULE$.SonarBranchTarget(), branchTargetName, params);
            return;
        }
        this.addBuildLogEntry("No branch target found, will not configure sonar.branch.target.", taskContext);
    }

    private String getSonarMainBranchName(ConfigurationMap taskConfig) {
        Some some;
        String mainBranch;
        Option<Object> option = Option$.MODULE$.apply(taskConfig.get((Object)SonarTaskConfigConstants$.MODULE$.SonarMainBranchField()));
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((mainBranch = (String)(some = (Some)option).value()).trim()))) {
            return mainBranch;
        }
        return "master";
    }

    private String determineSonarBranchName(TaskContext taskContext) {
        ConfigurationMap config = taskContext.getConfigurationMap();
        String originalBranchName = (String)(config.getAsBoolean(SonarTaskConfigConstants$.MODULE$.AutoBranchField()) ? Utils$.MODULE$.getCurrentGitBranch(this.customVariableContext) : Option$.MODULE$.apply(config.get((Object)SonarTaskConfigConstants$.MODULE$.SonarBranchField()))).getOrElse(SonarBranchOrPrParamAnalyzer::$anonfun$6);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(originalBranchName)) && config.getAsBoolean(SonarTaskConfigConstants$.MODULE$.ReplaceSpecialBranchCharsField())) {
            String replacement = (String)Option$.MODULE$.apply(config.get((Object)SonarTaskConfigConstants$.MODULE$.IllegalBranchCharsReplacementField())).getOrElse(SonarBranchOrPrParamAnalyzer::$anonfun$7);
            String normalizedBranchName = SonarUtils$.MODULE$.escapeInvalidBranchCharacters(originalBranchName, replacement);
            this.debug(() -> SonarBranchOrPrParamAnalyzer.determineSonarBranchName$$anonfun$1(originalBranchName, normalizedBranchName, replacement));
            return normalizedBranchName;
        }
        if (this.requireWellFormattedProjectKey$1(taskContext)) {
            String normalizedBranchName = SonarUtils$.MODULE$.escapeInvalidBranchCharacters(originalBranchName, "-");
            this.debug(() -> SonarBranchOrPrParamAnalyzer.determineSonarBranchName$$anonfun$2(originalBranchName, normalizedBranchName, taskContext));
            return normalizedBranchName;
        }
        this.debug(() -> SonarBranchOrPrParamAnalyzer.determineSonarBranchName$$anonfun$3(originalBranchName));
        return originalBranchName;
    }

    private static final String $anonfun$1(ProjectInfo projectInfo$1) {
        return projectInfo$1.key();
    }

    private static final VariableDefinitionContext $anonfun$2() {
        throw new IllegalStateException("Pull request parameter repository.pr.sourceBranch not set");
    }

    private static final VariableDefinitionContext $anonfun$3() {
        throw new IllegalStateException("Pull request parameter repository.pr.targetBranch not set");
    }

    private static final VariableDefinitionContext $anonfun$4() {
        throw new IllegalStateException("Pull request parameter repository.pr.key not set");
    }

    private static final String useBranchOrPullRequestParams$$anonfun$1() {
        return "no PR analysis because it is just a branch build, Bamboo < 6.9 or PR analysis task option is disabled";
    }

    private static final String $anonfun$5() {
        return "";
    }

    private final boolean requireWellFormattedProjectKey$1(TaskContext taskContext) {
        return SonarVersions$.MODULE$.sonarVersionAboveOrEqual(this.FirstSonarVersion8RequiringWellFormattedProjectKey, taskContext) || SonarVersions$.MODULE$.sonarVersionAboveOrEqual(this.FirstSonarVersion7RequiringWellFormattedProjectKey, taskContext) && SonarVersions$.MODULE$.sonarVersionBelow(this.SonarVersion8Series, taskContext);
    }

    private static final String $anonfun$6() {
        return "";
    }

    private static final String $anonfun$7() {
        return "_";
    }

    private static final String determineSonarBranchName$$anonfun$1(String originalBranchName$1, String normalizedBranchName$1, String replacement$1) {
        return new StringBuilder(35).append("Branch name ").append(originalBranchName$1).append(" -> ").append(normalizedBranchName$1).append(" with replacement: ").append(replacement$1).toString();
    }

    private static final String determineSonarBranchName$$anonfun$2(String originalBranchName$2, String normalizedBranchName$2, TaskContext taskContext$1) {
        return new StringBuilder(91).append("Branch name ").append(originalBranchName$2).append(" -> ").append(normalizedBranchName$2).append(" with replacement -, because SonarQube ").append(SonarVersions$.MODULE$.getSonarVersion(taskContext$1)).append(" requires well formatted project key").toString();
    }

    private static final String determineSonarBranchName$$anonfun$3(String originalBranchName$3) {
        return new StringBuilder(42).append("Branch name ").append(originalBranchName$3).append(" -> ").append(originalBranchName$3).append(", no replacement character").toString();
    }
}

