/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.tasks;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.Logging$;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.QgStatusBuildBreaker;
import ch.mibex.bamboo.sonar4bamboo.results.SonarBuildResultSummary$;
import ch.mibex.bamboo.sonar4bamboo.results.TaskResultVisitUrl;
import ch.mibex.bamboo.sonar4bamboo.results.TaskResultVisitUrl$;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClientImpl;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarConstants$;
import ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption;
import ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption$;
import ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption$BreakBuildOnBrokenQualityGates$;
import ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption$IgnoreQualityGates$;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarBranchOrPrParamAnalyzer;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarCapabilityHelper;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarCredentialsLogMutator;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarLogParser;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarTaskConfigConstants$;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarVersions$;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.LogMutator;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.LogMemorisingInterceptor;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.utils.process.ExternalProcess;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class AbstractSonarTask
implements TaskType,
Logging {
    private Logger log;
    private final ProcessService processService;
    private final CapabilityContext capabilityContext;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final SonarCapabilityHelper capabilityHelper;
    private final CustomVariableContext customVariableContext;

    public AbstractSonarTask(ProcessService processService, CapabilityContext capabilityContext, EnvironmentVariableAccessor environmentVariableAccessor, SonarCapabilityHelper capabilityHelper, CustomVariableContext customVariableContext) {
        this.processService = processService;
        this.capabilityContext = capabilityContext;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityHelper = capabilityHelper;
        this.customVariableContext = customVariableContext;
        Logging.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public TaskResult execute(TaskContext taskContext) {
        this.logPreparationLogLines(taskContext);
        return (TaskResult)Logging$.MODULE$.withTaskLogging(taskContext, () -> this.execute$$anonfun$1(taskContext));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TaskResult executeSonarAnalysis(TaskContext taskContext) {
        if (SonarVersions$.MODULE$.sonarVersionBelow(SonarVersions$.MODULE$.RequiredMinimumVersion(), taskContext)) {
            taskContext.getBuildContext().getBuildResult().addBuildErrors(Collections.singletonList(new StringBuilder(47).append("SONAR4BAMBOO: SonarQube version >= ").append(SonarVersions$.MODULE$.RequiredMinimumVersion()).append(" is required").toString()));
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        ConfigurationMap config = taskContext.getConfigurationMap();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        int numOfLinesToRemember = 100000;
        LogMemorisingInterceptor logMemorizer = new LogMemorisingInterceptor(numOfLinesToRemember);
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        buildLogger.getInterceptorStack().add((LogInterceptor)logMemorizer);
        buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
        SonarCredentialsLogMutator credentialsLogMutator = new SonarCredentialsLogMutator();
        buildLogger.getMutatorStack().add((LogMutator)credentialsLogMutator);
        if (this.isIncrementalModeEnabled(taskContext) && this.shouldSkipTaskBecauseIncrementalNotPossible(taskContext)) {
            this.addBuildLogEntry("will not run Sonar analysis as incremental mode cannot be applied because either branch does not match configured regex or no open pull request could be found for it.", taskContext);
            return this.successfulResult(taskContext);
        }
        scala.collection.immutable.Seq<String> cmdLine = this.getCommandLine(taskContext);
        List<String> logErrors = (List<String>)((Object)Nil$.MODULE$);
        try {
            TaskResult taskResult;
            try {
                List<String> foundErrors;
                this.debug(() -> AbstractSonarTask.executeSonarAnalysis$$anonfun$1(cmdLine));
                ExternalProcess externalProcess = this.processService.createExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().workingDirectory(taskContext.getWorkingDirectory()).env(this.buildEnv(config, taskContext)).command(CollectionConverters$.MODULE$.SeqHasAsJava(cmdLine).asJava()));
                externalProcess.execute();
                Tuple2<TaskResult, List<String>> tuple2 = this.checkBuildResult(logMemorizer, externalProcess, taskContext);
                if (tuple2 == null) throw new MatchError(tuple2);
                Tuple2<TaskResult, List<String>> $1$ = tuple2;
                Tuple2<TaskResult, List<String>> tuple22 = $1$;
                TaskResult taskResult2 = tuple22._1();
                logErrors = foundErrors = tuple22._2();
                TaskState taskState = taskResult2.getTaskState();
                TaskState taskState2 = TaskState.SUCCESS;
                if (!(taskState != null ? !taskState.equals(taskState2) : taskState2 != null)) {
                    if (this.shouldCheckQualityGates() && this.shouldFetchQualityGates(taskContext)) {
                        taskResult = this.fetchQualityGateStatus(taskContext);
                        return taskResult;
                    }
                }
                TaskState taskState3 = taskResult2.getTaskState();
                TaskState taskState4 = TaskState.SUCCESS;
                if ((taskState3 == null ? taskState4 != null : !taskState3.equals(taskState4)) && this.shouldIgnoreTaskErrors(taskContext)) {
                    taskResult = this.successfulResult(taskContext);
                    return taskResult;
                }
                taskResult = taskResult2;
                return taskResult;
            }
            catch (Exception e) {
                this.error("Failed task due with exception", e);
                if (!this.shouldIgnoreTaskErrors(taskContext)) throw new TaskException("Failed to execute task", (Throwable)e);
                taskResult = this.successfulResult(taskContext);
                return taskResult;
            }
        }
        finally {
            if (!this.shouldIgnoreTaskErrors(taskContext)) {
                taskContext.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
                taskContext.getBuildContext().getBuildResult().addBuildErrors(CollectionConverters$.MODULE$.SeqHasAsJava(logErrors).asJava());
            }
        }
    }

    private boolean shouldFetchQualityGates(TaskContext taskContext) {
        Option option = Option$.MODULE$.apply(taskContext.getRuntimeTaskContext().get(SonarConstants$.MODULE$.SonarQualityGateOption()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String id = (String)some.value();
            BrokenQualityGateOption brokenQualityGateOption = BrokenQualityGateOption$.MODULE$.fromString(id);
            BrokenQualityGateOption$IgnoreQualityGates$ brokenQualityGateOption$IgnoreQualityGates$ = BrokenQualityGateOption$IgnoreQualityGates$.MODULE$;
            return brokenQualityGateOption == null ? brokenQualityGateOption$IgnoreQualityGates$ != null : !brokenQualityGateOption.equals(brokenQualityGateOption$IgnoreQualityGates$);
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    private boolean shouldBreakBuildOnBrokenQualityGate(TaskContext taskContext) {
        Option option = Option$.MODULE$.apply(taskContext.getRuntimeTaskContext().get(SonarConstants$.MODULE$.SonarQualityGateOption()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String id = (String)some.value();
            BrokenQualityGateOption brokenQualityGateOption = BrokenQualityGateOption$.MODULE$.fromString(id);
            BrokenQualityGateOption$BreakBuildOnBrokenQualityGates$ brokenQualityGateOption$BreakBuildOnBrokenQualityGates$ = BrokenQualityGateOption$BreakBuildOnBrokenQualityGates$.MODULE$;
            return !(brokenQualityGateOption != null ? !brokenQualityGateOption.equals(brokenQualityGateOption$BreakBuildOnBrokenQualityGates$) : brokenQualityGateOption$BreakBuildOnBrokenQualityGates$ != null);
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    private boolean shouldIgnoreTaskErrors(TaskContext taskContext) {
        return Option$.MODULE$.apply(taskContext.getConfigurationMap().get((Object)SonarTaskConfigConstants$.MODULE$.FailBuildForTaskErrorsField())).nonEmpty() && !taskContext.getConfigurationMap().getAsBoolean(SonarTaskConfigConstants$.MODULE$.FailBuildForTaskErrorsField());
    }

    private TaskResult successfulResult(TaskContext taskContext) {
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).build();
    }

    private boolean shouldSkipTaskBecauseIncrementalNotPossible(TaskContext taskContext) {
        Option optSkipTask = this.getBambooVariable("repository.git.branch").map((Function1<String, Tuple2> & Serializable)branch -> {
            ConfigurationMap taskConfig = taskContext.getConfigurationMap();
            return Tuple2$.MODULE$.apply(branch, taskConfig);
        }).flatMap((Function1<Tuple2, Option> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String branch = (String)tuple2._1();
                ConfigurationMap taskConfig = (ConfigurationMap)tuple2._2();
                return Option$.MODULE$.apply(taskConfig.get((Object)SonarTaskConfigConstants$.MODULE$.IncrementalModeGitBranchPatternField())).map((Function1<String, Boolean> & Serializable)branchPattern -> !branch.matches((String)branchPattern) && this.skipTaskIfIncrementalNotMatches(taskConfig) || this.skipTaskIfIncrementalNoPullRequest(taskContext));
            }
            throw new MatchError(tuple2);
        });
        return BoxesRunTime.unboxToBoolean(optSkipTask.getOrElse(AbstractSonarTask::shouldSkipTaskBecauseIncrementalNotPossible$$anonfun$1));
    }

    private Option<String> getRuntimeProviderError(TaskContext taskContext) {
        return Option$.MODULE$.apply(taskContext.getRuntimeTaskContext().get(SonarConstants$.MODULE$.RuntimeProviderError()));
    }

    private boolean skipTaskIfIncrementalNoPullRequest(TaskContext taskContext) {
        return Option$.MODULE$.apply(taskContext.getRuntimeTaskContext().get(SonarConstants$.MODULE$.SonarNoPullRequest())).isDefined();
    }

    private boolean skipTaskIfIncrementalNotMatches(ConfigurationMap config) {
        Option<Object> option = Option$.MODULE$.apply(config.get((Object)SonarTaskConfigConstants$.MODULE$.IncrementalModeNotPossibleField()));
        if (option instanceof Some) {
            String incrementalNotPossible;
            Some some = (Some)option;
            String string2 = incrementalNotPossible = (String)some.value();
            String string3 = SonarTaskConfigConstants$.MODULE$.IncrementalModeSkipTaskField();
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return true;
            }
        }
        return false;
    }

    private Option<String> getBambooVariable(String variableKey) {
        Some some;
        VariableDefinitionContext variable;
        Map buildVariables = this.customVariableContext.getVariableContexts();
        Option option = Option$.MODULE$.apply(buildVariables.get(variableKey));
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((variable = (VariableDefinitionContext)(some = (Some)option).value()).getValue()))) {
            return Option$.MODULE$.apply(variable.getValue());
        }
        return None$.MODULE$;
    }

    private boolean isIncrementalModeEnabled(TaskContext taskContext) {
        return taskContext.getConfigurationMap().getAsBoolean(SonarTaskConfigConstants$.MODULE$.IncrementalModeField());
    }

    public abstract boolean shouldCheckQualityGates();

    private TaskResult fetchQualityGateStatus(TaskContext taskContext) {
        QgStatusBuildBreaker buildBreaker = new QgStatusBuildBreaker(new SonarClientImpl(), this.customVariableContext);
        boolean breakBuild = this.shouldBreakBuildOnBrokenQualityGate(taskContext);
        return buildBreaker.breakBuildIfQualityGatesFailed(taskContext, breakBuild);
    }

    private Tuple2<TaskResult, List<String>> checkBuildResult(LogMemorisingInterceptor logMemorizer, ExternalProcess externalProcess, TaskContext taskContext) {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(externalProcess, 0);
        CurrentBuildResult buildResult = taskContext.getBuildContext().getBuildResult();
        List emittedLogLines = CollectionConverters$.MODULE$.IterableHasAsScala(logMemorizer.getLogEntries()).asScala().toList();
        Tuple3 tuple3 = (Tuple3)this.getLogParser(taskContext.getBuildLogger()).map((Function1<SonarLogParser, Tuple3> & Serializable)p -> p.parseLog(emittedLogLines)).getOrElse(AbstractSonarTask::$anonfun$4);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Tuple3 $3$ = tuple3;
        Tuple3 tuple32 = $3$;
        List sonarErrors = (List)tuple32._1();
        Option sonarVisitUrl = (Option)tuple32._2();
        Option taskId = (Option)tuple32._3();
        sonarVisitUrl.map((Function1<String, String> & Serializable)url -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply(buildResult.getCustomBuildData().get(SonarConstants$.MODULE$.SonarTasksVisitUrls())).map((Function1<String, TaskResultVisitUrl[]> & Serializable)_$1 -> {
                Object object = Predef$.MODULE$.refArrayOps(SonarBuildResultSummary$.MODULE$.fromTaskResultVisitUrls((String)_$1));
                return (TaskResultVisitUrl[])ArrayOps$.MODULE$.toArray$extension(object, ClassTag$.MODULE$.apply(TaskResultVisitUrl.class));
            }).getOrElse(AbstractSonarTask::$anonfun$6));
            TaskResultVisitUrl[] visitUrls = (TaskResultVisitUrl[])ArrayOps$.MODULE$.$colon$plus$extension(object, TaskResultVisitUrl$.MODULE$.apply(taskContext.getId(), (String)url), ClassTag$.MODULE$.apply(TaskResultVisitUrl.class));
            return buildResult.getCustomBuildData().put(SonarConstants$.MODULE$.SonarTasksVisitUrls(), SonarBuildResultSummary$.MODULE$.toTaskResultVisitUrls(visitUrls));
        });
        Option$.MODULE$.apply(taskContext.getRuntimeTaskContext().get(SonarConstants$.MODULE$.SonarHostUrl())).map((Function1<String, String> & Serializable)url -> buildResult.getCustomBuildData().put(SonarConstants$.MODULE$.SonarHostUrl(), url));
        Option$.MODULE$.apply(taskContext.getRuntimeTaskContext().get(SonarConstants$.MODULE$.DisplaySonarHostUrl())).map((Function1<String, String> & Serializable)url -> buildResult.getCustomBuildData().put(SonarConstants$.MODULE$.DisplaySonarHostUrl(), url));
        this.debug(() -> AbstractSonarTask.checkBuildResult$$anonfun$4(taskId));
        if (this.shouldFailBuildForSonarErrors(taskContext.getConfigurationMap()) && sonarErrors.nonEmpty()) {
            this.debug(() -> AbstractSonarTask.checkBuildResult$$anonfun$5(sonarErrors));
            return Tuple2$.MODULE$.apply(taskResultBuilder.failedWithError().build(), sonarErrors);
        }
        this.debug(AbstractSonarTask::checkBuildResult$$anonfun$6);
        return Tuple2$.MODULE$.apply(taskResultBuilder.build(), (Object)Nil$.MODULE$);
    }

    private boolean shouldFailBuildForSonarErrors(ConfigurationMap config) {
        return config.getAsBoolean(SonarTaskConfigConstants$.MODULE$.FailBuildForSonarErrorsField());
    }

    private scala.collection.immutable.Seq<String> getCommandLine(TaskContext taskContext) {
        ConfigurationMap config = taskContext.getConfigurationMap();
        Builder argsBuilder = package$.MODULE$.Seq().newBuilder();
        argsBuilder.addOne(this.getExecutablePath(config, taskContext));
        argsBuilder.addAll(this.getCommandLineArgs(config).toBuffer());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)Option$.MODULE$.apply(config.get((Object)SonarTaskConfigConstants$.MODULE$.AdditionalPropertiesField())).getOrElse(AbstractSonarTask::getCommandLine$$anonfun$1)))) {
            String additionalProps = (String)config.get((Object)SonarTaskConfigConstants$.MODULE$.AdditionalPropertiesField());
            String normalizedProps = additionalProps.replaceAll("\\s+", " ");
            java.util.List extraArgs = CommandlineStringUtils.tokeniseCommandline((String)normalizedProps);
            argsBuilder.addAll(CollectionConverters$.MODULE$.ListHasAsScala(extraArgs).asScala());
        }
        SonarBranchOrPrParamAnalyzer sonarBranchOrPrParamDeducer = new SonarBranchOrPrParamAnalyzer(this.customVariableContext);
        List<String> branchArgs = sonarBranchOrPrParamDeducer.deduceSonarAnalysisParameters(taskContext);
        argsBuilder.addAll(branchArgs);
        return (scala.collection.immutable.Seq)argsBuilder.result();
    }

    public Map<String, String> buildEnv(ConfigurationMap config, TaskContext taskContext) {
        String envVars = (String)config.get((Object)"environmentVariables");
        boolean processBackslashes = false;
        return this.environmentVariableAccessor.splitEnvironmentAssignments(envVars, processBackslashes);
    }

    public String getExecutablePath(ConfigurationMap config, TaskContext taskContext) {
        String home = this.getExecutableHome(config, taskContext);
        scala.collection.immutable.Seq executablesToTry = (scala.collection.immutable.Seq)((SeqOps)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)new File(home)), Nil$.MODULE$)).appendedAll((IterableOnce)this.capabilityHelper.getExecutableNames().map((Function1<String, File> & Serializable)e -> new File(home, (String)e)))).appendedAll((IterableOnce)this.capabilityHelper.getExecutableNames().map((Function1<String, File> & Serializable)e -> new File(new File(home, "bin"), (String)e)));
        return this.searchExecutable(home, executablesToTry, taskContext);
    }

    public String searchExecutable(String home, scala.collection.immutable.Seq<File> executablesToTry, TaskContext taskContext) {
        Option option = executablesToTry.find((Function1<File, Boolean> & Serializable)f -> this.isExecutable((File)f));
        if (option instanceof Some) {
            Some some = (Some)option;
            File found = (File)some.value();
            this.addBuildLogEntry(new StringBuilder(18).append("Executable found: ").append(found).toString(), taskContext);
            return found.getAbsolutePath();
        }
        if (None$.MODULE$.equals(option)) {
            File lastEntry = (File)executablesToTry.last();
            this.addBuildLogEntry(new StringBuilder(42).append("No executable found. Searched for names: ").append(this.capabilityHelper.getExecutableNames().mkString(",")).append(" ").append(new StringBuilder(22).append("in ").append(home).append(". Tried locations: ").append(executablesToTry.mkString(",")).toString()).toString(), taskContext);
            return lastEntry.getAbsolutePath();
        }
        throw new MatchError(option);
    }

    private boolean isExecutable(File file) {
        return file.exists() && file.isFile() && file.canExecute();
    }

    public String getExecutableHome(ConfigurationMap config, TaskContext taskContext) {
        String capabilityKey = !this.isExecutableDefined(config) ? this.capabilityHelper.getCapabilityKey() : new StringBuilder(1).append(this.capabilityHelper.getDefaultCapabilityKey()).append(".").append(config.get((Object)SonarTaskConfigConstants$.MODULE$.ExecutableField())).toString();
        String capabilityValue = this.capabilityContext.getCapabilityValue(capabilityKey);
        if (Option$.MODULE$.apply(capabilityValue).isEmpty()) {
            capabilityValue = this.capabilityContext.getCapabilityValue(this.capabilityHelper.getDefaultCapabilityKey());
        }
        return capabilityValue;
    }

    private boolean isExecutableDefined(ConfigurationMap config) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)Option$.MODULE$.apply(config.get((Object)SonarTaskConfigConstants$.MODULE$.ExecutableField())).getOrElse(AbstractSonarTask::isExecutableDefined$$anonfun$1)));
    }

    public abstract Option<SonarLogParser> getLogParser(BuildLogger var1);

    public abstract scala.collection.immutable.Seq<String> getCommandLineArgs(ConfigurationMap var1);

    private void logPreparationLogLines(TaskContext taskContext) {
        Object[] logLines = ((String)taskContext.getRuntimeTaskContext().get(SonarConstants$.MODULE$.PreparationLog())).split("\n");
        Object object = Predef$.MODULE$.refArrayOps(logLines);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1<String, String> & Serializable)l -> taskContext.getBuildLogger().addBuildLogEntry(l));
    }

    private final TaskResult execute$$anonfun$1(TaskContext taskContext$1) {
        Option<String> option = this.getRuntimeProviderError(taskContext$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            String error = (String)some.value();
            this.addBuildLogEntry(error, taskContext$1);
            taskContext$1.getBuildContext().getBuildResult().addBuildErrors(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(14).append("SONAR4BAMBOO: ").append(error).toString()), Nil$.MODULE$))).asJava());
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext$1).setState(TaskState.ERROR).build();
        }
        if (None$.MODULE$.equals(option)) {
            return this.executeSonarAnalysis(taskContext$1);
        }
        throw new MatchError(option);
    }

    private static final String executeSonarAnalysis$$anonfun$1(scala.collection.immutable.Seq cmdLine$1) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Executing %s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{cmdLine$1.mkString(" ")}));
    }

    private static final boolean shouldSkipTaskBecauseIncrementalNotPossible$$anonfun$1() {
        throw new IllegalStateException("SONAR4BAMBOO: was not able to determine Git branch.");
    }

    private static final Tuple3 $anonfun$4() {
        return Tuple3$.MODULE$.apply((Object)Nil$.MODULE$, None$.MODULE$, None$.MODULE$);
    }

    private static final TaskResultVisitUrl[] $anonfun$6() {
        return (TaskResultVisitUrl[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(TaskResultVisitUrl.class));
    }

    private static final String checkBuildResult$$anonfun$4$$anonfun$1() {
        return "?";
    }

    private static final String checkBuildResult$$anonfun$4(Option taskId$1) {
        return new StringBuilder(29).append("Checking quality gate for ").append(taskId$1.getOrElse(AbstractSonarTask::checkBuildResult$$anonfun$4$$anonfun$1)).append("...").toString();
    }

    private static final String checkBuildResult$$anonfun$5(List sonarErrors$1) {
        return new StringBuilder(34).append("Failed build with Sonar error(s): ").append(sonarErrors$1.mkString("\n")).toString();
    }

    private static final String checkBuildResult$$anonfun$6() {
        return "Analysis successful.";
    }

    private static final String getCommandLine$$anonfun$1() {
        return "";
    }

    private static final String isExecutableDefined$$anonfun$1() {
        return "";
    }
}

