/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.sonar;

import ch.mibex.bamboo.sonar4bamboo.config.SonarServerEntity;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarConstants$;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarTaskConfigConstants$;
import com.atlassian.bamboo.security.EncryptionException;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;

public final class Credentials$
implements Mirror.Product,
Serializable {
    private static final Pattern LoginPattern;
    private static final Pattern PwPattern;
    public static final Credentials$ MODULE$;

    private Credentials$() {
    }

    static {
        MODULE$ = new Credentials$();
        LoginPattern = Pattern.compile(".*?(?:-D|\\/d:)sonar\\.login=([^\\s]+).*");
        PwPattern = Pattern.compile(".*?(?:-D|\\/d:)sonar\\.password=([^\\s]+).*");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Credentials$.class);
    }

    public Credentials apply(String login, Option<String> password) {
        return new Credentials(login, password);
    }

    public Credentials unapply(Credentials x$1) {
        return x$1;
    }

    public Credentials by(RuntimeTaskDefinition runtimeTaskDefinition, CustomVariableContext customVariableContext) {
        return this.by(CollectionConverters$.MODULE$.MapHasAsScala(runtimeTaskDefinition.getConfiguration()).asScala().toMap($less$colon$less$.MODULE$.refl()), CollectionConverters$.MODULE$.MapHasAsScala(runtimeTaskDefinition.getRuntimeContext()).asScala().toMap($less$colon$less$.MODULE$.refl()), customVariableContext);
    }

    public Credentials by(TaskContext taskContext, CustomVariableContext customVariableContext) {
        return this.by(CollectionConverters$.MODULE$.MapHasAsScala(taskContext.getConfigurationMap()).asScala().toMap($less$colon$less$.MODULE$.refl()), CollectionConverters$.MODULE$.MapHasAsScala(taskContext.getRuntimeTaskContext()).asScala().toMap($less$colon$less$.MODULE$.refl()), customVariableContext);
    }

    public Credentials by(Map<String, String> configuration, Map<String, String> runtimeContext, CustomVariableContext customVariableContext) {
        Option option = configuration.get(SonarTaskConfigConstants$.MODULE$.AdditionalPropertiesField());
        if (option instanceof Some) {
            Some some = (Some)option;
            String additionalProps = (String)some.value();
            Matcher loginMatch = LoginPattern.matcher(additionalProps);
            Matcher pwMatch = PwPattern.matcher(additionalProps);
            if (loginMatch.find() && loginMatch.groupCount() == 1) {
                return this.apply(loginMatch.group(1), pwMatch.find() && pwMatch.groupCount() == 1 ? Option$.MODULE$.apply(pwMatch.group(1)) : None$.MODULE$);
            }
            return this.useCredentialsFromSonarConfig(runtimeContext, customVariableContext);
        }
        if (None$.MODULE$.equals(option)) {
            return this.useCredentialsFromSonarConfig(runtimeContext, customVariableContext);
        }
        throw new MatchError(option);
    }

    public Option<Credentials> by(SonarServerEntity serverConfig, VariableDefinitionManager variableDefinitionManager, EncryptionService encryptionService) {
        boolean isSimpleAuth;
        boolean bl = isSimpleAuth = serverConfig.getServerUsername() != null;
        if (isSimpleAuth) {
            Some some;
            String pwVariable;
            Option<String> login = Option$.MODULE$.apply(serverConfig.getServerUsername()).filter((Function1<String, Object>)(Function1<String, Boolean> & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1.trim())));
            Option<String> option = Option$.MODULE$.apply(serverConfig.getServerPwBambooVar());
            Option<String> pw = option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((pwVariable = (String)(some = (Some)option).value()).trim())) ? this.getVariableValue(pwVariable, variableDefinitionManager) : this.decrypt(Option$.MODULE$.apply(serverConfig.getServerPassword()), encryptionService);
            return Some$.MODULE$.apply(this.apply((String)login.orNull($less$colon$less$.MODULE$.refl()), pw));
        }
        if (serverConfig.getServerTokenBambooVar() != null) {
            String tokenVariable = (String)this.getVariableValue(serverConfig.getServerTokenBambooVar(), variableDefinitionManager).orNull($less$colon$less$.MODULE$.refl());
            return Some$.MODULE$.apply(this.apply(tokenVariable, None$.MODULE$));
        }
        if (serverConfig.getServerUsertoken() != null) {
            String token = (String)this.decrypt(Option$.MODULE$.apply(serverConfig.getServerUsertoken()), encryptionService).orNull($less$colon$less$.MODULE$.refl());
            return Some$.MODULE$.apply(this.apply(token, None$.MODULE$));
        }
        return None$.MODULE$;
    }

    public Option<String> getVariableValue(String key, VariableDefinitionManager variableDefinitionManager) {
        return Option$.MODULE$.apply(variableDefinitionManager.getGlobalVariableByKey(key)).flatMap((Function1<VariableDefinition, Option> & Serializable)globalVar -> Option$.MODULE$.apply(globalVar.getValue()).map((Function1<String, String> & Serializable)globalValue -> globalValue));
    }

    public Option<String> decrypt(Option<String> password, EncryptionService encryptionService) {
        return password.map((Function1<String, String> & Serializable)pw -> {
            String string2;
            try {
                string2 = encryptionService.decrypt(pw);
            }
            catch (EncryptionException encryptionException) {
                string2 = pw;
            }
            return string2;
        });
    }

    private Credentials useCredentialsFromSonarConfig(Map<String, String> runtimeContext, CustomVariableContext customVariableContext) {
        Some some;
        String userName;
        Option option = runtimeContext.get(SonarConstants$.MODULE$.SonarLogin());
        None$ login = option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((userName = (String)(some = (Some)option).value()).trim())) ? Option$.MODULE$.apply(customVariableContext.substituteString(userName)) : None$.MODULE$;
        return this.apply((String)login.orNull($less$colon$less$.MODULE$.refl()), runtimeContext.get(SonarConstants$.MODULE$.SonarPassword()).map((Function1<String, String> & Serializable)x$0 -> customVariableContext.substituteString(x$0)));
    }

    @Override
    public Credentials fromProduct(Product x$0) {
        String string2 = (String)x$0.productElement(0);
        Option option = (Option)x$0.productElement(1);
        return new Credentials(string2, option);
    }
}

