<h3>[@ww.text name='sonar4bamboo.taskconfig.serverconfig.title' /]</h3>

[#--old checkbox to select if sonar config should be taken form build, replaced by radio selection--]
[@s.hidden name="useGlobalSonarServerConfig" id="useGlobalSonarServerConfigId" toggle="true"/]

[@s.radio
    name="sonarServerSelection"
    id="sonarConfig_"
    onchange="onSonarEditionChange()"
    list='sonarServerSelectionOptions'
    toggle="true"/]

[@ui.bambooSection dependsOn='sonarServerSelection' showOn='fromServerConfig']
    [@ww.select
        name='chosenSonarConfigId' id='chosenSonarConfigId'
        labelKey='sonar4bamboo.taskconfig.server.choose'
        listKey='id()' listValue='serverName()'
        toggle='true'
        list=sonarServerConfigs
        required='true'
        onchange="onSonarEditionChange()"/]
    <br/>
    [@ww.checkbox
        name='overrideSonarLogin' id='overrideSonarLogin'
        labelKey='sonar4bamboo.taskconfig.override.login.label'
        toggle='true' /]
    [@ui.bambooSection dependsOn='overrideSonarLogin' showOn=true]
        [@ww.select
            name='overrideSonarLoginVariable' id='overrideSonarLoginVariable'
            labelKey='sonar4bamboo.taskconfig.override.login.token.label'
            descriptionKey="sonar4bamboo.taskconfig.override.login.token.description"
            listKey='key' listValue='key' toggle='true' list=overrideSonarLoginOptions/]
    [/@ui.bambooSection]

[/@ui.bambooSection]

[@ui.bambooSection dependsOn='sonarServerSelection' showOn='fromBuild']
    [@s.radio
        name="sonarEditionSelection"
        id="edition_"
        label="SonarQube Edition"
        list='sonarEditionSelectionOptions'
        onchange="onSonarEditionChange()"
        toggle="true"/]

[/@ui.bambooSection]

[#include "sonarCommonConfigs1.ftl"]

<script type="text/javascript">
    function setCheckboxValue(checkbox,value) {
        if (checkbox.checked!=value) {
            checkbox.click();
        }
    }

    function initServerSelection() {
        let fromServerCfgField = document.getElementById("sonarConfig_fromServerConfig");
        let fromBuildCfgField = document.getElementById("sonarConfig_fromBuild");

        if(!fromBuildCfgField.checked && !fromServerCfgField.checked){
            if( document.getElementById("useGlobalSonarServerConfigId").value) {
                setCheckboxValue(fromServerCfgField, true)
            } else {
                setCheckboxValue(fromBuildCfgField, true)
            }
        }
    }

    function onSonarEditionChange(toggleLegacyBranchField) {
        const legacyBranchField = document.getElementById("legacyBranchingId")

        function hideByClassname(className) {
            for (let val of document.getElementsByClassName(className)) {
                val.style.display = 'none';
            }
        }
        function showByClassname(className) {
            for (let val of document.getElementsByClassName(className)) {
                val.style.display = 'block';
            }
        }
        function onCommunity(toggleEdition, toggleLegacyBranchField) {
            if(toggleEdition){
                document.getElementById("edition_COMMUNITY_EDITION").checked = true
            }

            // moving DOM nodes https://stackoverflow.com/questions/324303/cut-and-paste-moving-nodes-in-the-dom-with-javascript
            // document.getElementById('branchCharCommunityLocation')
            //     .insertAdjacentElement('afterend', document.getElementById('branchCharContainer'));

            // TODO: SONARBOO-386 Update Firefox version to >47
            // Meanwhile use JQuery instead insertAdjacentElement
            // https://stackoverflow.com/questions/6617829/insertadjacenthtml-in-jquery
            AJS.$(document.getElementById('branchCharCommunityLocation'))
                .after( document.getElementById('branchCharContainer'))

            hideByClassname("onlyCommercial")
            showByClassname("onlyCommunity")

            if(toggleLegacyBranchField) {
                setCheckboxValue(legacyBranchField, true)
            }
        }

        function onCommercial(toggleEdition, toggleLegacyBranchField) {
            if(toggleEdition){
                document.getElementById("edition_COMMERCIAL_EDITION").checked = true
            }

            // document.getElementById('branchCharCommercialLocation').
            //     .insertAdjacentElement('afterbegin', document.getElementById('branchCharContainer'));
            // TODO: SONARBOO-386 Update Firefox version to >47
            // Meanwhile use JQuery instead insertAdjacentElement
            // https://stackoverflow.com/questions/6617829/insertadjacenthtml-in-jquery
            AJS.$(document.getElementById('branchCharCommercialLocation'))
                .prepend( document.getElementById('branchCharContainer'))

            hideByClassname("onlyCommunity")
            showByClassname("onlyCommercial")
            if(toggleLegacyBranchField) {
                setCheckboxValue(legacyBranchField, true)
            }

        }

        if(document.getElementById("sonarConfig_fromServerConfig").checked) {
            const selectedId = document.getElementById("chosenSonarConfigId");
            // Flatten out the java bean as a JS object
            const servers = [
                [#list sonarServerConfigs as server]
                    {id: "${server.id()}", edition: "${(server.sonarEdition())!'unknown'}"},
                [/#list]
            ]
            const selectedSrv = servers.find( (srv, _) => { return srv.id === selectedId.value})

            if (selectedSrv !== undefined && selectedSrv.edition !== 'unknown') {
                if(selectedSrv.edition === "COMMUNITY_EDITION") {
                    onCommunity(true, toggleLegacyBranchField)
                } else { // COMMERCIAL_EDITION and COMMUNITY_EDITION_BRANCH
                    onCommercial(true, toggleLegacyBranchField)
                }
            }
        } else {
            if (document.getElementById("edition_COMMUNITY_EDITION").checked) {
                onCommunity(false, toggleLegacyBranchField)
            } else if (document.getElementById("edition_COMMERCIAL_EDITION").checked) {
                onCommercial(false, toggleLegacyBranchField)
            } else {
                hideByClassname("onlyCommercial")
                hideByClassname("onlyCommunity")
            }
        }
    }

    initServerSelection();
    onSonarEditionChange(false);
</script>