[#macro format_plan plan]
    <a href="${req.contextPath}/browse/${plan.key}" target="_blank">
        ${plan.name} <em>${plan.key}</em>
    </a>&nbsp;&nbsp;
    <a href="${req.contextPath}/chain/admin/config/defaultStages.action?buildKey=${plan.key}" target="_blank">
        Configure plan
    </a>
[/#macro]

[#macro abbreviate list formatter max_size]
    [#assign short_list = (list?size > max_size) ? then(list[0..max_size - 1], list)]
    [#foreach e in short_list]
        [@formatter e /]<br>
    [/#foreach]
    [#if list?size > max_size]
        <br>... (truncated, list exceeds ${max_size} plans)
    [/#if]
[/#macro]

[#macro edit_server_config server_id server_config_name]
    <a href="[@ww.url action='editSonarServer' namespace='/admin/sonar4bamboo' /]?serverConfigId=${server_id}">
        <strong>${server_config_name}</strong>
    </a>
[/#macro]

[#macro showPlansUsingThisServerConfig]
    <div id="plansUsingThisServerConfig">
        [#assign plans = plansUsingThisServerConfig /]
            [@ui.messageBox type="info"]
                [#if plans?has_content]
                    <p>[@s.text name="sonar4bamboo.admin.usage.description"/]
                        [@edit_server_config serverConfigId serverConfigName/]
                    </p>
                    <br>
                    [#assign maxPlans = maxPlansToShow - 1 /]
                    [@abbreviate plans format_plan maxPlans /]
                [#else]
                    <p>[@s.text name="sonar4bamboo.admin.usage.none"/]:
                        [@edit_server_config serverConfigId serverConfigName/]
                    </p>
                [/#if]
            [/@ui.messageBox]
    </div>
[/#macro]

<html>

<head>
    <title>[@ww.text name='sonar4bamboo.admin.usage.title' /]</title>
    <meta name="decorator" content="adminpage">
</head>

<body>
<h1>[@ww.text name='sonar4bamboo.admin.usage.title' /]</h1>
[@ww.form action='viewSonarServerUsage'
namespace='/admin/sonar4bamboo'
cancelUri='/admin/sonar4bamboo/viewSonarServerConfigs.action'
showActionErrors='true']
    [@ww.hidden name='serverConfigId' /]
    [@showPlansUsingThisServerConfig/]
[/@ww.form]

</body>
</html>