/*
 * Decompiled with CFR 0.152.
 */
package io.circe.numbers;

import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.BiggerDecimal$;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;

public final class SigAndExp
extends BiggerDecimal {
    private final BigInteger unscaled;
    private final BigInteger scale;

    public SigAndExp(BigInteger unscaled, BigInteger scale) {
        this.unscaled = unscaled;
        this.scale = scale;
    }

    public BigInteger unscaled() {
        return this.unscaled;
    }

    public BigInteger scale() {
        return this.scale;
    }

    @Override
    public boolean isWhole() {
        return this.scale().signum() < 1;
    }

    @Override
    public boolean isNegativeZero() {
        return false;
    }

    @Override
    public int signum() {
        return this.unscaled().signum();
    }

    @Override
    public Option<BigDecimal> toBigDecimal() {
        if (this.scale().compareTo(BiggerDecimal$.MODULE$.MaxInt()) <= 0 && this.scale().compareTo(BiggerDecimal$.MODULE$.MinInt()) >= 0) {
            return Some$.MODULE$.apply(new BigDecimal(this.unscaled(), this.scale().intValue()));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<BigInteger> toBigIntegerWithMaxDigits(BigInteger maxDigits) {
        if (!this.isWhole()) {
            return None$.MODULE$;
        }
        BigInteger digits = BigInteger.valueOf(this.unscaled().abs().toString().length()).subtract(this.scale());
        if (digits.compareTo(maxDigits) > 0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(new BigDecimal(this.unscaled(), this.scale().intValue()).toBigInteger());
    }

    @Override
    public double toDouble() {
        if (this.scale().compareTo(BiggerDecimal$.MODULE$.MaxInt()) <= 0 && this.scale().compareTo(BiggerDecimal$.MODULE$.MinInt()) >= 0) {
            return new BigDecimal(this.unscaled(), this.scale().intValue()).doubleValue();
        }
        return (this.scale().signum() == 1 ? 0.0 : Double.POSITIVE_INFINITY) * (double)this.unscaled().signum();
    }

    @Override
    public float toFloat() {
        if (this.scale().compareTo(BiggerDecimal$.MODULE$.MaxInt()) <= 0 && this.scale().compareTo(BiggerDecimal$.MODULE$.MinInt()) >= 0) {
            return new BigDecimal(this.unscaled(), this.scale().intValue()).floatValue();
        }
        return (this.scale().signum() == 1 ? 0.0f : Float.POSITIVE_INFINITY) * (float)this.unscaled().signum();
    }

    @Override
    public Option<Object> toLong() {
        if (!this.isWhole()) {
            return None$.MODULE$;
        }
        Option<BigInteger> option = this.toBigInteger();
        if (option instanceof Some) {
            BigInteger i = (BigInteger)((Some)option).value();
            long asLong = i.longValue();
            if (BoxesRunTime.equals(BigInteger.valueOf(asLong), i)) {
                return Some$.MODULE$.apply(BoxesRunTime.boxToLong(asLong));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof SigAndExp) {
            SigAndExp other = (SigAndExp)object;
            return BoxesRunTime.equals(this.unscaled(), other.unscaled()) && BoxesRunTime.equals(this.scale(), other.scale());
        }
        return false;
    }

    public int hashCode() {
        return this.scale().hashCode() + this.unscaled().hashCode();
    }

    public String toString() {
        if (BoxesRunTime.equals(this.scale(), BigInteger.ZERO)) {
            return this.unscaled().toString();
        }
        return new StringBuilder(1).append(this.unscaled()).append("e").append(this.scale().negate()).toString();
    }

    @Override
    public void appendToStringBuilder(StringBuilder builder) {
        builder.append(this.unscaled());
        if (!BoxesRunTime.equals(this.scale(), BigInteger.ZERO)) {
            builder.append('e');
            builder.append(this.scale().negate());
            return;
        }
    }
}

