/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.atlassian.dc;

import ch.mibex.atlassian.Logging;
import ch.mibex.atlassian.dc.AbuseDetection;
import ch.mibex.atlassian.dc.EvalAbuseDetected;
import ch.mibex.atlassian.dc.EvalAbuseDetected$;
import ch.mibex.atlassian.dc.InvalidLicenseInfo;
import ch.mibex.atlassian.dc.InvalidLicenseInfo$;
import ch.mibex.atlassian.dc.LicenseChecker$;
import ch.mibex.atlassian.dc.LicenseIssue;
import ch.mibex.atlassian.dc.LicenseWarning;
import ch.mibex.atlassian.dc.LicenseWarning$;
import ch.mibex.atlassian.dc.reflection.Invoker;
import ch.mibex.atlassian.dc.reflection.Invoker$;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters$;
import scala.jdk.OptionConverters$RichOption$;
import scala.jdk.OptionConverters$RichOptional$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class LicenseChecker
implements Logging {
    private volatile Logger ch$mibex$atlassian$Logging$$logger;
    private final PluginLicenseManager licenseManager;
    private final AbuseDetection abuseDetection;
    private final int TwoWeek;

    public static <T> RichJOption<T> RichJOption(com.atlassian.upm.api.util.Option<T> option) {
        return LicenseChecker$.MODULE$.RichJOption(option);
    }

    public static scala.collection.immutable.Map<String, String> translations(String string2) {
        return LicenseChecker$.MODULE$.translations(string2);
    }

    public LicenseChecker(PluginLicenseManager licenseManager, AbuseDetection abuseDetection) {
        this.licenseManager = licenseManager;
        this.abuseDetection = abuseDetection;
        Logging.$init$(this);
        this.TwoWeek = 14;
    }

    @Override
    public Logger ch$mibex$atlassian$Logging$$logger() {
        return this.ch$mibex$atlassian$Logging$$logger;
    }

    @Override
    public void ch$mibex$atlassian$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$atlassian$Logging$$logger = x$1;
    }

    public int TwoWeek() {
        return this.TwoWeek;
    }

    public Optional<LicenseIssue> validateLicenseJava(Function1<String, String> translations) {
        Option<LicenseIssue> option = OptionConverters$.MODULE$.RichOption(this.validateLicense(translations, (Function0<Object>)((Function0<Boolean> & Serializable)LicenseChecker::validateLicenseJava$$anonfun$1), this.validateLicense$default$3()));
        return OptionConverters$RichOption$.MODULE$.toJava$extension(option);
    }

    public Option<InvalidLicenseInfo> validLicenseWithGracePeriod(Function1<String, String> translations) {
        return this.validateLicense(translations, (Function0<Object>)((Function0<Boolean> & Serializable)LicenseChecker::validLicenseWithGracePeriod$$anonfun$1), this.validateLicense$default$3()).collect(new Serializable(){

            public final boolean isDefinedAt(LicenseIssue x) {
                LicenseIssue licenseIssue = x;
                if (licenseIssue instanceof InvalidLicenseInfo) {
                    InvalidLicenseInfo invalidLicenseInfo;
                    InvalidLicenseInfo i = invalidLicenseInfo = (InvalidLicenseInfo)licenseIssue;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(LicenseIssue x, Function1 function1) {
                LicenseIssue licenseIssue = x;
                if (licenseIssue instanceof InvalidLicenseInfo) {
                    InvalidLicenseInfo invalidLicenseInfo;
                    InvalidLicenseInfo i = invalidLicenseInfo = (InvalidLicenseInfo)licenseIssue;
                    return i;
                }
                return function1.apply(x);
            }
        });
    }

    public Option<LicenseIssue> validateLicense(Function1<String, String> translations, Function0<Object> showLicenseWarnings, Instant currentDate) {
        Option option;
        block11: {
            if (Option$.MODULE$.apply(this.licenseManager).isEmpty()) {
                option = Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.noinfo"));
            } else {
                try {
                    Option option2 = LicenseChecker$.MODULE$.RichJOption(this.licenseManager.getLicense()).asScala();
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        PluginLicense pluginLicense = (PluginLicense)some.value();
                        PluginLicense l = pluginLicense;
                        if (l.isValid()) {
                            Some some2;
                            Instant expiryDate;
                            Option<Instant> expirationDate = this.extractExpirationDate(l);
                            Option<Instant> option3 = expirationDate;
                            option = option3 instanceof Some && ChronoUnit.DAYS.between(currentDate, expiryDate = (Instant)(some2 = (Some)option3).value()) <= (long)this.TwoWeek() ? Some$.MODULE$.apply(LicenseWarning$.MODULE$.apply("license.expiring.soon.warning")) : None$.MODULE$;
                        } else {
                            Some some3;
                            LicenseError e;
                            PluginLicense l2 = pluginLicense;
                            Option option4 = LicenseChecker$.MODULE$.RichJOption(l2.getError()).asScala();
                            if (option4 instanceof Some && (e = (LicenseError)(some3 = (Some)option4).value()) != null) {
                                option = this.handleLicenseError(l2, e);
                            } else {
                                this.warn("No license info found");
                                option = Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.unknown.error"));
                            }
                        }
                        break block11;
                    }
                    if (None$.MODULE$.equals(option2)) {
                        option = Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.nolicense"));
                        break block11;
                    }
                    if (option2 == null) {
                        option = None$.MODULE$;
                        break block11;
                    }
                    throw new MatchError(option2);
                }
                catch (Exception e) {
                    this.warn("Failed to retrieve license information", e);
                    option = Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.unresolved.exception"));
                }
            }
        }
        Some<InvalidLicenseInfo> result = option;
        return result.filter((Function1<InvalidLicenseInfo, Object>)(Function1<Serializable, Boolean> & Serializable)x$1 -> {
            Serializable serializable = x$1;
            if (serializable instanceof LicenseWarning) {
                LicenseWarning licenseWarning = (LicenseWarning)serializable;
                return showLicenseWarnings.apply$mcZ$sp();
            }
            return true;
        }).map((Function1<Serializable, LicenseIssue> & Serializable)x$1 -> {
            Product product;
            Serializable serializable = x$1;
            if (serializable instanceof InvalidLicenseInfo) {
                String string2;
                InvalidLicenseInfo invalidLicenseInfo = (InvalidLicenseInfo)serializable;
                InvalidLicenseInfo invalidLicenseInfo2 = InvalidLicenseInfo$.MODULE$.unapply(invalidLicenseInfo);
                String reason = string2 = invalidLicenseInfo2._1();
                product = InvalidLicenseInfo$.MODULE$.apply((String)translations.apply(reason));
            } else if (serializable instanceof LicenseWarning) {
                String string3;
                LicenseWarning licenseWarning = (LicenseWarning)serializable;
                LicenseWarning licenseWarning2 = LicenseWarning$.MODULE$.unapply(licenseWarning);
                String text = string3 = licenseWarning2._1();
                product = LicenseWarning$.MODULE$.apply((String)translations.apply(text));
            } else {
                throw new MatchError(serializable);
            }
            return product;
        }).orElse(this::validateLicense$$anonfun$3);
    }

    public Instant validateLicense$default$3() {
        return Instant.now();
    }

    private Some<Serializable> handleLicenseError(PluginLicense l, LicenseError e) {
        LicenseError licenseError = e;
        LicenseError licenseError2 = LicenseError.EXPIRED;
        LicenseError licenseError3 = licenseError;
        if (!(licenseError2 != null ? !licenseError2.equals(licenseError3) : licenseError3 != null)) {
            if (l.isEvaluation()) {
                return Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.evaluation.expired"));
            }
            if (!l.isDataCenter() && l.isMaintenanceExpired()) {
                return Some$.MODULE$.apply(LicenseWarning$.MODULE$.apply("license.maintenance.expired"));
            }
            return Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.expired"));
        }
        LicenseError licenseError4 = LicenseError.TYPE_MISMATCH;
        LicenseError licenseError5 = licenseError;
        if (!(licenseError4 != null ? !licenseError4.equals(licenseError5) : licenseError5 != null)) {
            return Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.typemismatch"));
        }
        LicenseError licenseError6 = LicenseError.USER_MISMATCH;
        LicenseError licenseError7 = licenseError;
        if (!(licenseError6 != null ? !licenseError6.equals(licenseError7) : licenseError7 != null)) {
            return Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.usermismatch"));
        }
        LicenseError licenseError8 = LicenseError.VERSION_MISMATCH;
        LicenseError licenseError9 = licenseError;
        if (!(licenseError8 != null ? !licenseError8.equals(licenseError9) : licenseError9 != null)) {
            return Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.versionmismatch"));
        }
        LicenseError licenseError10 = LicenseError.EDITION_MISMATCH;
        LicenseError licenseError11 = licenseError;
        if (!(licenseError10 != null ? !licenseError10.equals(licenseError11) : licenseError11 != null)) {
            return Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.edition.mismatch"));
        }
        this.warn("Unknown license error");
        return Some$.MODULE$.apply(InvalidLicenseInfo$.MODULE$.apply("license.unknown.error"));
    }

    private Option<Instant> extractExpirationDate(PluginLicense l) {
        Option<Instant> option;
        try {
            Optional opt = (Optional)Invoker$.MODULE$.invoke(l, "getExpiryZonedDate", ScalaRunTime$.MODULE$.wrapRefArray(new Invoker[0]));
            Optional<Instant> optional = OptionConverters$.MODULE$.RichOptional(opt.map(_$1 -> _$1.toInstant()));
            option = OptionConverters$RichOptional$.MODULE$.toScala$extension(optional);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            com.atlassian.upm.api.util.Option opt = (com.atlassian.upm.api.util.Option)Invoker$.MODULE$.invoke(l, "getExpiryDate", ScalaRunTime$.MODULE$.wrapRefArray(new Invoker[0]));
            option = LicenseChecker$.MODULE$.RichJOption(opt).asScala().map((Function1<Object, Instant> & Serializable)jodaTime -> {
                long epochMillis = BoxesRunTime.unboxToLong(Invoker$.MODULE$.invoke(jodaTime, "getMillis", ScalaRunTime$.MODULE$.wrapRefArray(new Invoker[0])));
                return Instant.ofEpochMilli(epochMillis);
            });
        }
        return option;
    }

    /*
     * Unable to fully structure code
     */
    public scala.collection.immutable.Map<String, Map<String, List<String>>> licenseErrorsForContext(Function1<String, String> translations) {
        var3_2 = this.validateLicense(translations, (Function0<Object>)(Function0<Boolean> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$1(), ()Ljava/lang/Boolean;)(), this.validateLicense$default$3());
        if (!(var3_2 instanceof Some)) ** GOTO lbl-1000
        var4_3 = (Some)var3_2;
        var5_4 = (LicenseIssue)var4_3.value();
        if (var5_4 instanceof InvalidLicenseInfo) {
            var6_5 = (InvalidLicenseInfo)var5_4;
            var7_6 = InvalidLicenseInfo$.MODULE$.unapply(var6_5);
            reason = var8_7 = var7_6._1();
            this.warn(new StringBuilder(15).append("license error: ").append(reason).toString());
            v0 = new Tuple2[1];
            var10_9 = Predef$.MODULE$.ArrowAssoc("details");
            v0[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(var10_9, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((Object)new $colon$colon<Nothing$>((Nothing$)reason, Nil$.MODULE$))).asJava());
            v1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(v0));
        } else if (var5_4 instanceof EvalAbuseDetected) {
            var11_10 = (EvalAbuseDetected)var5_4;
            var12_11 = EvalAbuseDetected$.MODULE$.unapply(var11_10);
            var13_12 = var12_11._1();
            var14_13 = var12_11._2();
            reason = var13_12;
            contactLink = var14_13;
            this.warn(new StringBuilder(15).append("license error: ").append(reason).toString());
            v2 = new Tuple2[2];
            var17_16 = Predef$.MODULE$.ArrowAssoc("details");
            v2[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(var17_16, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((Object)new $colon$colon<Nothing$>((Nothing$)reason, Nil$.MODULE$))).asJava());
            var18_17 = Predef$.MODULE$.ArrowAssoc("link");
            v2[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(var18_17, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((Object)new $colon$colon<Nothing$>((Nothing$)contactLink, Nil$.MODULE$))).asJava());
            v1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(v2));
        } else if (var5_4 instanceof LicenseWarning) {
            var19_18 = (LicenseWarning)var5_4;
            var20_19 = LicenseWarning$.MODULE$.unapply(var19_18);
            warning = var21_20 = var20_19._1();
            this.info(new StringBuilder(17).append("license warning: ").append(warning).toString());
            v3 = new Tuple2[1];
            var23_22 = Predef$.MODULE$.ArrowAssoc("details");
            v3[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(var23_22, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((Object)new $colon$colon<Nothing$>((Nothing$)warning, Nil$.MODULE$))).asJava());
            v1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(v3));
        } else lbl-1000:
        // 2 sources

        {
            v1 = licenseErrors = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
        }
        if (licenseErrors.nonEmpty()) {
            v4 = new Tuple2[1];
            var24_24 = Predef$.MODULE$.ArrowAssoc("errors");
            v4[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(var24_24, CollectionConverters$.MODULE$.MapHasAsJava(licenseErrors).asJava());
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(v4));
        }
        return Predef$.MODULE$.Map().empty();
    }

    private static final boolean validateLicenseJava$$anonfun$1() {
        return false;
    }

    private static final boolean validLicenseWithGracePeriod$$anonfun$1() {
        return true;
    }

    private final Option validateLicense$$anonfun$3() {
        return this.abuseDetection.detectAbuse();
    }

    private static final boolean $anonfun$1() {
        return true;
    }

    public static final class RichJOption<T> {
        private final com.atlassian.upm.api.util.Option<T> optional;

        public RichJOption(com.atlassian.upm.api.util.Option<T> optional) {
            this.optional = optional;
        }

        public com.atlassian.upm.api.util.Option<T> optional() {
            return this.optional;
        }

        public Option<T> asScala() {
            com.atlassian.upm.api.util.Option<T> option = this.optional();
            if (option == null) {
                return null;
            }
            if (this.optional().isDefined()) {
                return Option$.MODULE$.apply(this.optional().get());
            }
            return None$.MODULE$;
        }
    }
}

