/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.shared;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseAddedEvent;
import com.atlassian.upm.api.license.event.PluginLicenseCheckEvent;
import com.atlassian.upm.api.license.event.PluginLicenseEvent;
import com.atlassian.upm.api.license.event.PluginLicenseUpdatedEvent;
import de.communardo.shared.InternalLicenseAbuseDetectionService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class InternalLicenseListener
implements InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalLicenseListener.class);
    @ComponentImport
    private final PluginLicenseEventRegistry licenseEventRegistry;
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    private final InternalLicenseAbuseDetectionService evalLicenseValidationService;

    public void afterPropertiesSet() throws Exception {
        this.licenseEventRegistry.register((Object)this);
    }

    public void destroy() throws Exception {
        this.licenseEventRegistry.unregister((Object)this);
    }

    @EventListener
    public void onEvent(PluginLicenseEvent e) {
        String appKey = this.pluginLicenseManager.getPluginKey();
        if (e.getPluginKey().equals(appKey)) {
            PluginLicenseCheckEvent event;
            log.debug("License validation event: {}", (Object)e);
            if (e instanceof PluginLicenseAddedEvent) {
                PluginLicenseAddedEvent event2 = (PluginLicenseAddedEvent)e;
                this.evalLicenseValidationService.handleAppLicenseCheck(event2.getLicense());
            } else if (e instanceof PluginLicenseUpdatedEvent) {
                PluginLicenseUpdatedEvent event3 = (PluginLicenseUpdatedEvent)e;
                this.evalLicenseValidationService.handleAppLicenseCheck(event3.getLicense());
            } else if (e instanceof PluginLicenseCheckEvent && (event = (PluginLicenseCheckEvent)e).getLicense().isDefined()) {
                this.evalLicenseValidationService.handleAppLicenseCheck((PluginLicense)event.getLicense().get());
            }
        }
    }

    @Generated
    public InternalLicenseListener(PluginLicenseEventRegistry licenseEventRegistry, PluginLicenseManager pluginLicenseManager, InternalLicenseAbuseDetectionService evalLicenseValidationService) {
        this.licenseEventRegistry = licenseEventRegistry;
        this.pluginLicenseManager = pluginLicenseManager;
        this.evalLicenseValidationService = evalLicenseValidationService;
    }
}

