/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.Show;
import cats.data.NonEmptyList;
import cats.data.Validated;
import cats.kernel.Eq;
import io.circe.Decoder;
import io.circe.DecodingFailure;
import io.circe.HCursor;
import io.circe.HCursor$;
import io.circe.Json$;
import io.circe.Json$JArray$;
import io.circe.Json$JBoolean$;
import io.circe.Json$JNull$;
import io.circe.Json$JNumber$;
import io.circe.Json$JObject$;
import io.circe.Json$JString$;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import io.circe.Printer;
import io.circe.Printer$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

public abstract class Json
implements Product,
Serializable {
    public static Json False() {
        return Json$.MODULE$.False();
    }

    public static Json Null() {
        return Json$.MODULE$.Null();
    }

    public static Json True() {
        return Json$.MODULE$.True();
    }

    public static Json arr(Seq<Json> seq) {
        return Json$.MODULE$.arr(seq);
    }

    public static Eq<Json> eqJson() {
        return Json$.MODULE$.eqJson();
    }

    public static Json fromBigDecimal(BigDecimal bigDecimal) {
        return Json$.MODULE$.fromBigDecimal(bigDecimal);
    }

    public static Json fromBigDecimalOrNull(Option<BigDecimal> option) {
        return Json$.MODULE$.fromBigDecimalOrNull(option);
    }

    public static Json fromBigInt(BigInt bigInt) {
        return Json$.MODULE$.fromBigInt(bigInt);
    }

    public static Json fromBigIntOrNull(Option<BigInt> option) {
        return Json$.MODULE$.fromBigIntOrNull(option);
    }

    public static Json fromBoolean(boolean bl) {
        return Json$.MODULE$.fromBoolean(bl);
    }

    public static Json fromBooleanOrNull(Option<Object> option) {
        return Json$.MODULE$.fromBooleanOrNull(option);
    }

    public static Option<Json> fromDouble(double d) {
        return Json$.MODULE$.fromDouble(d);
    }

    public static Json fromDoubleOrNull(double d) {
        return Json$.MODULE$.fromDoubleOrNull(d);
    }

    public static Json fromDoubleOrNull(Option<Object> option) {
        return Json$.MODULE$.fromDoubleOrNull(option);
    }

    public static Json fromDoubleOrString(double d) {
        return Json$.MODULE$.fromDoubleOrString(d);
    }

    public static Json fromFields(Iterable<Tuple2<String, Json>> iterable) {
        return Json$.MODULE$.fromFields(iterable);
    }

    public static Option<Json> fromFloat(float f) {
        return Json$.MODULE$.fromFloat(f);
    }

    public static Json fromFloatOrNull(float f) {
        return Json$.MODULE$.fromFloatOrNull(f);
    }

    public static Json fromFloatOrNull(Option<Object> option) {
        return Json$.MODULE$.fromFloatOrNull(option);
    }

    public static Json fromFloatOrString(float f) {
        return Json$.MODULE$.fromFloatOrString(f);
    }

    public static Json fromInt(int n) {
        return Json$.MODULE$.fromInt(n);
    }

    public static Json fromIntOrNull(Option<Object> option) {
        return Json$.MODULE$.fromIntOrNull(option);
    }

    public static Json fromJsonNumber(JsonNumber jsonNumber) {
        return Json$.MODULE$.fromJsonNumber(jsonNumber);
    }

    public static Json fromJsonObject(JsonObject jsonObject) {
        return Json$.MODULE$.fromJsonObject(jsonObject);
    }

    public static Json fromLong(long l) {
        return Json$.MODULE$.fromLong(l);
    }

    public static Json fromLongOrNull(Option<Object> option) {
        return Json$.MODULE$.fromLongOrNull(option);
    }

    public static Json fromString(String string2) {
        return Json$.MODULE$.fromString(string2);
    }

    public static Json fromStringOrNull(Option<String> option) {
        return Json$.MODULE$.fromStringOrNull(option);
    }

    public static Json fromValues(Iterable<Json> iterable) {
        return Json$.MODULE$.fromValues(iterable);
    }

    public static Json obj(Seq<Tuple2<String, Json>> seq) {
        return Json$.MODULE$.obj(seq);
    }

    public static int ordinal(Json json) {
        return Json$.MODULE$.ordinal(json);
    }

    public static Show<Json> showJson() {
        return Json$.MODULE$.showJson();
    }

    public abstract <X> X foldWith(Folder<X> var1);

    public final <X> X fold(Function0<X> jsonNull, Function1<Object, X> jsonBoolean, Function1<JsonNumber, X> jsonNumber, Function1<String, X> jsonString, Function1<Vector<Json>, X> jsonArray, Function1<JsonObject, X> jsonObject) {
        Json json = this;
        if (((Object)Json$JNull$.MODULE$).equals(json)) {
            return jsonNull.apply();
        }
        if (json instanceof JBoolean) {
            boolean bl;
            JBoolean jBoolean = Json$JBoolean$.MODULE$.unapply((JBoolean)json);
            boolean b = bl = jBoolean._1();
            return jsonBoolean.apply(BoxesRunTime.boxToBoolean(b));
        }
        if (json instanceof JNumber) {
            JsonNumber jsonNumber2;
            JNumber jNumber = Json$JNumber$.MODULE$.unapply((JNumber)json);
            JsonNumber n = jsonNumber2 = jNumber._1();
            return jsonNumber.apply(n);
        }
        if (json instanceof JString) {
            String string2;
            JString jString = Json$JString$.MODULE$.unapply((JString)json);
            String s = string2 = jString._1();
            return jsonString.apply(s);
        }
        if (json instanceof JArray) {
            Vector<Json> vector;
            JArray jArray = Json$JArray$.MODULE$.unapply((JArray)json);
            Vector<Json> a = vector = jArray._1();
            return jsonArray.apply(a);
        }
        if (json instanceof JObject) {
            JsonObject jsonObject2;
            JObject jObject = Json$JObject$.MODULE$.unapply((JObject)json);
            JsonObject o = jsonObject2 = jObject._1();
            return jsonObject.apply(o);
        }
        throw new MatchError(json);
    }

    public final <X> X arrayOrObject(Function0<X> or, Function1<Vector<Json>, X> jsonArray, Function1<JsonObject, X> jsonObject) {
        Json json = this;
        if (((Object)Json$JNull$.MODULE$).equals(json)) {
            return or.apply();
        }
        if (json instanceof JBoolean) {
            JBoolean jBoolean = Json$JBoolean$.MODULE$.unapply((JBoolean)json);
            boolean bl = jBoolean._1();
            return or.apply();
        }
        if (json instanceof JNumber) {
            JNumber jNumber = Json$JNumber$.MODULE$.unapply((JNumber)json);
            JsonNumber jsonNumber = jNumber._1();
            return or.apply();
        }
        if (json instanceof JString) {
            JString jString = Json$JString$.MODULE$.unapply((JString)json);
            String string2 = jString._1();
            return or.apply();
        }
        if (json instanceof JArray) {
            Vector<Json> vector;
            JArray jArray = Json$JArray$.MODULE$.unapply((JArray)json);
            Vector<Json> a = vector = jArray._1();
            return jsonArray.apply(a);
        }
        if (json instanceof JObject) {
            JsonObject jsonObject2;
            JObject jObject = Json$JObject$.MODULE$.unapply((JObject)json);
            JsonObject o = jsonObject2 = jObject._1();
            return jsonObject.apply(o);
        }
        throw new MatchError(json);
    }

    public final HCursor hcursor() {
        return HCursor$.MODULE$.fromJson(this);
    }

    public abstract boolean isNull();

    public abstract boolean isBoolean();

    public abstract boolean isNumber();

    public abstract boolean isString();

    public abstract boolean isArray();

    public abstract boolean isObject();

    public abstract Option<BoxedUnit> asNull();

    public abstract Option<Object> asBoolean();

    public abstract Option<JsonNumber> asNumber();

    public abstract Option<String> asString();

    public abstract Option<Vector<Json>> asArray();

    public abstract Option<JsonObject> asObject();

    public abstract Json withNull(Function0<Json> var1);

    public abstract Json withBoolean(Function1<Object, Json> var1);

    public abstract Json withNumber(Function1<JsonNumber, Json> var1);

    public abstract Json withString(Function1<String, Json> var1);

    public abstract Json withArray(Function1<Vector<Json>, Json> var1);

    public abstract Json withObject(Function1<JsonObject, Json> var1);

    public abstract Json mapBoolean(Function1<Object, Object> var1);

    public abstract Json mapNumber(Function1<JsonNumber, JsonNumber> var1);

    public abstract Json mapString(Function1<String, String> var1);

    public abstract Json mapArray(Function1<Vector<Json>, Vector<Json>> var1);

    public abstract Json mapObject(Function1<JsonObject, JsonObject> var1);

    public final String name() {
        Json json = this;
        if (((Object)Json$JNull$.MODULE$).equals(json)) {
            return "Null";
        }
        if (json instanceof JBoolean) {
            JBoolean jBoolean = Json$JBoolean$.MODULE$.unapply((JBoolean)json);
            boolean bl = jBoolean._1();
            return "Boolean";
        }
        if (json instanceof JNumber) {
            JNumber jNumber = Json$JNumber$.MODULE$.unapply((JNumber)json);
            JsonNumber jsonNumber = jNumber._1();
            return "Number";
        }
        if (json instanceof JString) {
            JString jString = Json$JString$.MODULE$.unapply((JString)json);
            String string2 = jString._1();
            return "String";
        }
        if (json instanceof JArray) {
            JArray jArray = Json$JArray$.MODULE$.unapply((JArray)json);
            Vector<Json> vector = jArray._1();
            return "Array";
        }
        if (json instanceof JObject) {
            JObject jObject = Json$JObject$.MODULE$.unapply((JObject)json);
            JsonObject jsonObject = jObject._1();
            return "Object";
        }
        throw new MatchError(json);
    }

    public final <A> Either<DecodingFailure, A> as(Decoder<A> d) {
        return d.apply(this.hcursor());
    }

    public final <A> Validated<NonEmptyList<DecodingFailure>, A> asAccumulating(Decoder<A> d) {
        return d.decodeAccumulating(this.hcursor());
    }

    public final String printWith(Printer p) {
        return p.print(this);
    }

    public final String noSpaces() {
        return Printer$.MODULE$.noSpaces().print(this);
    }

    public final String spaces2() {
        return Printer$.MODULE$.spaces2().print(this);
    }

    public final String spaces4() {
        return Printer$.MODULE$.spaces4().print(this);
    }

    public final String noSpacesSortKeys() {
        return Printer$.MODULE$.noSpacesSortKeys().print(this);
    }

    public final String spaces2SortKeys() {
        return Printer$.MODULE$.spaces2SortKeys().print(this);
    }

    public final String spaces4SortKeys() {
        return Printer$.MODULE$.spaces4SortKeys().print(this);
    }

    public Json deepMerge(Json that) {
        Tuple2<Option<JsonObject>, Option<JsonObject>> tuple2 = Tuple2$.MODULE$.apply(this.asObject(), that.asObject());
        if (tuple2 != null) {
            Option<JsonObject> option = tuple2._1();
            Option<JsonObject> option2 = tuple2._2();
            if (option instanceof Some) {
                JsonObject lhs = (JsonObject)((Some)option).value();
                if (option2 instanceof Some) {
                    JsonObject rhs = (JsonObject)((Some)option2).value();
                    return Json$.MODULE$.fromJsonObject(lhs.toIterable().foldLeft(rhs, (Function2<JsonObject, Tuple2, JsonObject> & Serializable)(x$1, x$2) -> {
                        Tuple2<JsonObject, Tuple2> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = tuple2._2();
                            JsonObject acc = tuple2._1();
                            if (tuple22 != null) {
                                String key = (String)tuple22._1();
                                Json value = (Json)tuple22._2();
                                return (JsonObject)rhs.apply(key).fold(() -> Json.deepMerge$$anonfun$1$$anonfun$1(acc, key, value), (Function1<Json, JsonObject> & Serializable)r -> acc.add(key, value.deepMerge((Json)r)));
                            }
                        }
                        throw new MatchError(tuple2);
                    }));
                }
            }
        }
        return that;
    }

    public Json dropNullValues() {
        return this.mapObject((Function1<JsonObject, JsonObject> & Serializable)_$1 -> _$1.filter((Function1<Tuple2<String, Json>, Object>)(Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Json v = (Json)tuple2._2();
                return !v.isNull();
            }
            throw new MatchError(tuple2);
        }));
    }

    public Json deepDropNullValues() {
        Folder<Json> folder = new Folder<Json>(){

            public Json onNull() {
                return Json$.MODULE$.Null();
            }

            public Json onBoolean(boolean value) {
                return Json$.MODULE$.fromBoolean(value);
            }

            public Json onNumber(JsonNumber value) {
                return Json$.MODULE$.fromJsonNumber(value);
            }

            public Json onString(String value) {
                return Json$.MODULE$.fromString(value);
            }

            public Json onArray(Vector value) {
                return Json$.MODULE$.fromValues((Iterable)value.collect((PartialFunction)((Object)new Serializable(this){
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Json x) {
                        Json json = x;
                        Json v = json;
                        return !v.isNull();
                    }

                    public final Object applyOrElse(Json x, Function1 function1) {
                        Json json = x;
                        Json v = json;
                        if (!v.isNull()) {
                            return v.foldWith(this.$outer);
                        }
                        return function1.apply(x);
                    }
                })));
            }

            public Json onObject(JsonObject value) {
                return Json$.MODULE$.fromJsonObject(value.filter((Function1<Tuple2<String, Json>, Object>)((Function1<Tuple2, boolean> & Serializable)Json::io$circe$Json$$anon$1$$_$onObject$$anonfun$1)).mapValues((Function1<Json, Json> & Serializable)_$2 -> _$2.foldWith(this)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{io$circe$Json$$anon$1$$_$onObject$$anonfun$1(scala.Tuple2 ), onObject$$anonfun$2(io.circe.Json )}, serializedLambda);
            }
        };
        return this.foldWith(folder);
    }

    public Json dropEmptyValues() {
        return this.mapObject((Function1<JsonObject, JsonObject> & Serializable)_$3 -> _$3.filter((Function1<Tuple2<String, Json>, Object>)(Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Json json = (Json)tuple2._2();
                if (json instanceof JArray) {
                    Vector<Json> vector;
                    JArray jArray = Json$JArray$.MODULE$.unapply((JArray)json);
                    Vector<Json> vec = vector = jArray._1();
                    return vec.nonEmpty();
                }
                if (json instanceof JObject) {
                    JsonObject jsonObject;
                    JObject jObject = Json$JObject$.MODULE$.unapply((JObject)json);
                    JsonObject obj = jsonObject = jObject._1();
                    return obj.nonEmpty();
                }
            }
            return true;
        }));
    }

    public final String toString() {
        return this.spaces2();
    }

    @Override
    public final boolean equals(Object that) {
        Object object = that;
        if (object instanceof Json) {
            Json that2 = (Json)object;
            return Json$.MODULE$.eqJson().eqv(this, that2);
        }
        return false;
    }

    public abstract int hashCode();

    public final List<Json> $bslash$bslash(String key) {
        return this.findAllByKey(key);
    }

    public final List<Json> findAllByKey(String key) {
        Object hh = ListBuffer$.MODULE$.empty();
        Json.loop$1(key, (ListBuffer)hh, this);
        return ((ListBuffer)hh).toList();
    }

    private static final JsonObject deepMerge$$anonfun$1$$anonfun$1(JsonObject acc$1, String key$1, Json value$1) {
        return acc$1.add(key$1, value$1);
    }

    public static final /* synthetic */ boolean io$circe$Json$$anon$1$$_$onObject$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Json v = (Json)tuple2._2();
            return !v.isNull();
        }
        throw new MatchError(tuple2);
    }

    private static final void loop$1(String key$3, ListBuffer hh$1, Json json2) {
        Json json3 = json2;
        if (json3 instanceof JObject) {
            JsonObject jsonObject;
            JObject jObject = Json$JObject$.MODULE$.unapply((JObject)json3);
            JsonObject obj = jsonObject = jObject._1();
            obj.toIterable().foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Json v = (Json)tuple2._2();
                    String string2 = k;
                    String string3 = key$3;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        hh$1.$plus$eq(v);
                    }
                    Json.loop$1(key$3, hh$1, v);
                    return;
                }
                throw new MatchError(tuple2);
            });
            return;
        }
        if (json3 instanceof JArray) {
            Vector<Json> vector;
            JArray jArray = Json$JArray$.MODULE$.unapply((JArray)json3);
            Vector<Json> elems = vector = jArray._1();
            elems.foreach(json -> Json.loop$1(key$3, hh$1, json));
            return;
        }
    }

    public static interface Folder<X>
    extends Serializable {
        public X onNull();

        public X onBoolean(boolean var1);

        public X onNumber(JsonNumber var1);

        public X onString(String var1);

        public X onArray(Vector<Json> var1);

        public X onObject(JsonObject var1);
    }

    public static final class JArray
    extends Json {
        private final Vector value;

        public static JArray apply(Vector<Json> vector) {
            return Json$JArray$.MODULE$.apply(vector);
        }

        public static JArray fromProduct(Product product) {
            return Json$JArray$.MODULE$.fromProduct(product);
        }

        public static JArray unapply(JArray jArray) {
            return Json$JArray$.MODULE$.unapply(jArray);
        }

        public JArray(Vector<Json> value) {
            this.value = value;
        }

        @Override
        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof JArray;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "JArray";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Vector<Json> value() {
            return this.value;
        }

        @Override
        public final <X> X foldWith(Folder<X> folder) {
            return folder.onArray(this.value());
        }

        @Override
        public final boolean isNull() {
            return false;
        }

        @Override
        public final boolean isBoolean() {
            return false;
        }

        @Override
        public final boolean isNumber() {
            return false;
        }

        @Override
        public final boolean isString() {
            return false;
        }

        @Override
        public final boolean isArray() {
            return true;
        }

        @Override
        public final boolean isObject() {
            return false;
        }

        @Override
        public final Option<BoxedUnit> asNull() {
            return None$.MODULE$;
        }

        @Override
        public final Option<Object> asBoolean() {
            return None$.MODULE$;
        }

        @Override
        public final Option<JsonNumber> asNumber() {
            return None$.MODULE$;
        }

        @Override
        public final Option<String> asString() {
            return None$.MODULE$;
        }

        @Override
        public final Option<Vector<Json>> asArray() {
            return Some$.MODULE$.apply(this.value());
        }

        @Override
        public final Option<JsonObject> asObject() {
            return None$.MODULE$;
        }

        @Override
        public final Json withNull(Function0<Json> f) {
            return this;
        }

        @Override
        public final Json withBoolean(Function1<Object, Json> f) {
            return this;
        }

        @Override
        public final Json withNumber(Function1<JsonNumber, Json> f) {
            return this;
        }

        @Override
        public final Json withString(Function1<String, Json> f) {
            return this;
        }

        @Override
        public final Json withArray(Function1<Vector<Json>, Json> f) {
            return f.apply(this.value());
        }

        @Override
        public final Json withObject(Function1<JsonObject, Json> f) {
            return this;
        }

        @Override
        public final Json mapBoolean(Function1<Object, Object> f) {
            return this;
        }

        @Override
        public final Json mapNumber(Function1<JsonNumber, JsonNumber> f) {
            return this;
        }

        @Override
        public final Json mapString(Function1<String, String> f) {
            return this;
        }

        @Override
        public final Json mapArray(Function1<Vector<Json>, Vector<Json>> f) {
            return Json$JArray$.MODULE$.apply(f.apply(this.value()));
        }

        @Override
        public final Json mapObject(Function1<JsonObject, JsonObject> f) {
            return this;
        }

        public JArray copy(Vector<Json> value) {
            return new JArray(value);
        }

        public Vector<Json> copy$default$1() {
            return this.value();
        }

        public Vector<Json> _1() {
            return this.value();
        }
    }

    public static final class JBoolean
    extends Json {
        private final boolean value;

        public static JBoolean apply(boolean bl) {
            return Json$JBoolean$.MODULE$.apply(bl);
        }

        public static JBoolean fromProduct(Product product) {
            return Json$JBoolean$.MODULE$.fromProduct(product);
        }

        public static JBoolean unapply(JBoolean jBoolean) {
            return Json$JBoolean$.MODULE$.unapply(jBoolean);
        }

        public JBoolean(boolean value) {
            this.value = value;
        }

        @Override
        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.value() ? 1231 : 1237);
            return Statics.finalizeHash(n, 1);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof JBoolean;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "JBoolean";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToBoolean(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public boolean value() {
            return this.value;
        }

        @Override
        public final <X> X foldWith(Folder<X> folder) {
            return folder.onBoolean(this.value());
        }

        @Override
        public final boolean isNull() {
            return false;
        }

        @Override
        public final boolean isBoolean() {
            return true;
        }

        @Override
        public final boolean isNumber() {
            return false;
        }

        @Override
        public final boolean isString() {
            return false;
        }

        @Override
        public final boolean isArray() {
            return false;
        }

        @Override
        public final boolean isObject() {
            return false;
        }

        @Override
        public final Option<BoxedUnit> asNull() {
            return None$.MODULE$;
        }

        @Override
        public final Option<Object> asBoolean() {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(this.value()));
        }

        @Override
        public final Option<JsonNumber> asNumber() {
            return None$.MODULE$;
        }

        @Override
        public final Option<String> asString() {
            return None$.MODULE$;
        }

        @Override
        public final Option<Vector<Json>> asArray() {
            return None$.MODULE$;
        }

        @Override
        public final Option<JsonObject> asObject() {
            return None$.MODULE$;
        }

        @Override
        public final Json withNull(Function0<Json> f) {
            return this;
        }

        @Override
        public final Json withBoolean(Function1<Object, Json> f) {
            return f.apply(BoxesRunTime.boxToBoolean(this.value()));
        }

        @Override
        public final Json withNumber(Function1<JsonNumber, Json> f) {
            return this;
        }

        @Override
        public final Json withString(Function1<String, Json> f) {
            return this;
        }

        @Override
        public final Json withArray(Function1<Vector<Json>, Json> f) {
            return this;
        }

        @Override
        public final Json withObject(Function1<JsonObject, Json> f) {
            return this;
        }

        @Override
        public final Json mapBoolean(Function1<Object, Object> f) {
            return Json$JBoolean$.MODULE$.apply(BoxesRunTime.unboxToBoolean(f.apply(BoxesRunTime.boxToBoolean(this.value()))));
        }

        @Override
        public final Json mapNumber(Function1<JsonNumber, JsonNumber> f) {
            return this;
        }

        @Override
        public final Json mapString(Function1<String, String> f) {
            return this;
        }

        @Override
        public final Json mapArray(Function1<Vector<Json>, Vector<Json>> f) {
            return this;
        }

        @Override
        public final Json mapObject(Function1<JsonObject, JsonObject> f) {
            return this;
        }

        public JBoolean copy(boolean value) {
            return new JBoolean(value);
        }

        public boolean copy$default$1() {
            return this.value();
        }

        public boolean _1() {
            return this.value();
        }
    }

    public static final class JNumber
    extends Json {
        private final JsonNumber value;

        public static JNumber apply(JsonNumber jsonNumber) {
            return Json$JNumber$.MODULE$.apply(jsonNumber);
        }

        public static JNumber fromProduct(Product product) {
            return Json$JNumber$.MODULE$.fromProduct(product);
        }

        public static JNumber unapply(JNumber jNumber) {
            return Json$JNumber$.MODULE$.unapply(jNumber);
        }

        public JNumber(JsonNumber value) {
            this.value = value;
        }

        @Override
        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof JNumber;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "JNumber";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public JsonNumber value() {
            return this.value;
        }

        @Override
        public final <X> X foldWith(Folder<X> folder) {
            return folder.onNumber(this.value());
        }

        @Override
        public final boolean isNull() {
            return false;
        }

        @Override
        public final boolean isBoolean() {
            return false;
        }

        @Override
        public final boolean isNumber() {
            return true;
        }

        @Override
        public final boolean isString() {
            return false;
        }

        @Override
        public final boolean isArray() {
            return false;
        }

        @Override
        public final boolean isObject() {
            return false;
        }

        @Override
        public final Option<BoxedUnit> asNull() {
            return None$.MODULE$;
        }

        @Override
        public final Option<Object> asBoolean() {
            return None$.MODULE$;
        }

        @Override
        public final Option<JsonNumber> asNumber() {
            return Some$.MODULE$.apply(this.value());
        }

        @Override
        public final Option<String> asString() {
            return None$.MODULE$;
        }

        @Override
        public final Option<Vector<Json>> asArray() {
            return None$.MODULE$;
        }

        @Override
        public final Option<JsonObject> asObject() {
            return None$.MODULE$;
        }

        @Override
        public final Json withNull(Function0<Json> f) {
            return this;
        }

        @Override
        public final Json withBoolean(Function1<Object, Json> f) {
            return this;
        }

        @Override
        public final Json withNumber(Function1<JsonNumber, Json> f) {
            return f.apply(this.value());
        }

        @Override
        public final Json withString(Function1<String, Json> f) {
            return this;
        }

        @Override
        public final Json withArray(Function1<Vector<Json>, Json> f) {
            return this;
        }

        @Override
        public final Json withObject(Function1<JsonObject, Json> f) {
            return this;
        }

        @Override
        public final Json mapBoolean(Function1<Object, Object> f) {
            return this;
        }

        @Override
        public final Json mapNumber(Function1<JsonNumber, JsonNumber> f) {
            return Json$JNumber$.MODULE$.apply(f.apply(this.value()));
        }

        @Override
        public final Json mapString(Function1<String, String> f) {
            return this;
        }

        @Override
        public final Json mapArray(Function1<Vector<Json>, Vector<Json>> f) {
            return this;
        }

        @Override
        public final Json mapObject(Function1<JsonObject, JsonObject> f) {
            return this;
        }

        public JNumber copy(JsonNumber value) {
            return new JNumber(value);
        }

        public JsonNumber copy$default$1() {
            return this.value();
        }

        public JsonNumber _1() {
            return this.value();
        }
    }

    public static final class JObject
    extends Json {
        private final JsonObject value;

        public static JObject apply(JsonObject jsonObject) {
            return Json$JObject$.MODULE$.apply(jsonObject);
        }

        public static JObject fromProduct(Product product) {
            return Json$JObject$.MODULE$.fromProduct(product);
        }

        public static JObject unapply(JObject jObject) {
            return Json$JObject$.MODULE$.unapply(jObject);
        }

        public JObject(JsonObject value) {
            this.value = value;
        }

        @Override
        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof JObject;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "JObject";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public JsonObject value() {
            return this.value;
        }

        @Override
        public final <X> X foldWith(Folder<X> folder) {
            return folder.onObject(this.value());
        }

        @Override
        public final boolean isNull() {
            return false;
        }

        @Override
        public final boolean isBoolean() {
            return false;
        }

        @Override
        public final boolean isNumber() {
            return false;
        }

        @Override
        public final boolean isString() {
            return false;
        }

        @Override
        public final boolean isArray() {
            return false;
        }

        @Override
        public final boolean isObject() {
            return true;
        }

        @Override
        public final Option<BoxedUnit> asNull() {
            return None$.MODULE$;
        }

        @Override
        public final Option<Object> asBoolean() {
            return None$.MODULE$;
        }

        @Override
        public final Option<JsonNumber> asNumber() {
            return None$.MODULE$;
        }

        @Override
        public final Option<String> asString() {
            return None$.MODULE$;
        }

        @Override
        public final Option<Vector<Json>> asArray() {
            return None$.MODULE$;
        }

        @Override
        public final Option<JsonObject> asObject() {
            return Some$.MODULE$.apply(this.value());
        }

        @Override
        public final Json withNull(Function0<Json> f) {
            return this;
        }

        @Override
        public final Json withBoolean(Function1<Object, Json> f) {
            return this;
        }

        @Override
        public final Json withNumber(Function1<JsonNumber, Json> f) {
            return this;
        }

        @Override
        public final Json withString(Function1<String, Json> f) {
            return this;
        }

        @Override
        public final Json withArray(Function1<Vector<Json>, Json> f) {
            return this;
        }

        @Override
        public final Json withObject(Function1<JsonObject, Json> f) {
            return f.apply(this.value());
        }

        @Override
        public final Json mapBoolean(Function1<Object, Object> f) {
            return this;
        }

        @Override
        public final Json mapNumber(Function1<JsonNumber, JsonNumber> f) {
            return this;
        }

        @Override
        public final Json mapString(Function1<String, String> f) {
            return this;
        }

        @Override
        public final Json mapArray(Function1<Vector<Json>, Vector<Json>> f) {
            return this;
        }

        @Override
        public final Json mapObject(Function1<JsonObject, JsonObject> f) {
            return Json$JObject$.MODULE$.apply(f.apply(this.value()));
        }

        public JObject copy(JsonObject value) {
            return new JObject(value);
        }

        public JsonObject copy$default$1() {
            return this.value();
        }

        public JsonObject _1() {
            return this.value();
        }
    }

    public static final class JString
    extends Json {
        private final String value;

        public static JString apply(String string2) {
            return Json$JString$.MODULE$.apply(string2);
        }

        public static JString fromProduct(Product product) {
            return Json$JString$.MODULE$.fromProduct(product);
        }

        public static JString unapply(JString jString) {
            return Json$JString$.MODULE$.unapply(jString);
        }

        public JString(String value) {
            this.value = value;
        }

        @Override
        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof JString;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "JString";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String value() {
            return this.value;
        }

        @Override
        public final <X> X foldWith(Folder<X> folder) {
            return folder.onString(this.value());
        }

        @Override
        public final boolean isNull() {
            return false;
        }

        @Override
        public final boolean isBoolean() {
            return false;
        }

        @Override
        public final boolean isNumber() {
            return false;
        }

        @Override
        public final boolean isString() {
            return true;
        }

        @Override
        public final boolean isArray() {
            return false;
        }

        @Override
        public final boolean isObject() {
            return false;
        }

        @Override
        public final Option<BoxedUnit> asNull() {
            return None$.MODULE$;
        }

        @Override
        public final Option<Object> asBoolean() {
            return None$.MODULE$;
        }

        @Override
        public final Option<JsonNumber> asNumber() {
            return None$.MODULE$;
        }

        @Override
        public final Option<String> asString() {
            return Some$.MODULE$.apply(this.value());
        }

        @Override
        public final Option<Vector<Json>> asArray() {
            return None$.MODULE$;
        }

        @Override
        public final Option<JsonObject> asObject() {
            return None$.MODULE$;
        }

        @Override
        public final Json withNull(Function0<Json> f) {
            return this;
        }

        @Override
        public final Json withBoolean(Function1<Object, Json> f) {
            return this;
        }

        @Override
        public final Json withNumber(Function1<JsonNumber, Json> f) {
            return this;
        }

        @Override
        public final Json withString(Function1<String, Json> f) {
            return f.apply(this.value());
        }

        @Override
        public final Json withArray(Function1<Vector<Json>, Json> f) {
            return this;
        }

        @Override
        public final Json withObject(Function1<JsonObject, Json> f) {
            return this;
        }

        @Override
        public final Json mapBoolean(Function1<Object, Object> f) {
            return this;
        }

        @Override
        public final Json mapNumber(Function1<JsonNumber, JsonNumber> f) {
            return this;
        }

        @Override
        public final Json mapString(Function1<String, String> f) {
            return Json$JString$.MODULE$.apply(f.apply(this.value()));
        }

        @Override
        public final Json mapArray(Function1<Vector<Json>, Vector<Json>> f) {
            return this;
        }

        @Override
        public final Json mapObject(Function1<JsonObject, JsonObject> f) {
            return this;
        }

        public JString copy(String value) {
            return new JString(value);
        }

        public String copy$default$1() {
            return this.value();
        }

        public String _1() {
            return this.value();
        }
    }
}

