/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.shared;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import de.communardo.shared.LicenseAbuseDetectionService;
import de.communardo.shared.LicenseState;
import de.communardo.shared.LicenseStateRepository;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

@Component
public class InternalLicenseAbuseDetectionService
implements LicenseAbuseDetectionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalLicenseAbuseDetectionService.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final LicenseHandler licenseHandler;
    private final LicenseStateRepository licenseStateRepository;

    @Override
    public boolean isAbuseDetected() {
        String appKey = this.pluginLicenseManager.getPluginKey();
        Optional<LicenseState> licenseState = this.licenseStateRepository.load(appKey);
        Boolean licensesOk = licenseState.map(state -> {
            long diffToStart = Math.abs(ChronoUnit.DAYS.between(LocalDate.now(), state.getLocalStartDate()));
            return state.getLicenses().size() <= 3 || diffToStart <= 90L;
        }).orElse(true);
        return licensesOk == false;
    }

    @Override
    public String getLicenseAbuseInfoText() {
        return "This app is running unlicensed according to our customer agreement. If you require longer evaluation times please do not hesitate to reach out to Communardo Support.";
    }

    @Override
    public String getLicenseAbuseContactLink() {
        Option appNameOption = this.pluginLicenseManager.getLicense();
        String appName = appNameOption.isDefined() ? ((PluginLicense)appNameOption.get()).getPluginName() : this.pluginLicenseManager.getPluginKey();
        return "mailto:products@communardo.de?subject=Request to extend evaluation period&body=Dear Communardo Support team,%0D%0A%0D%0AWe formally request the extension of our evaluation license for the App " + appName + " on the instance " + this.licenseHandler.getServerId() + ". Please provide us with the required information.%0D%0ABest regards.";
    }

    void handleAppLicenseCheck(PluginLicense license) {
        String appKey = this.pluginLicenseManager.getPluginKey();
        if (!license.isValid()) {
            return;
        }
        boolean isEval = license.isEvaluation();
        String hash2 = InternalLicenseAbuseDetectionService.getLicenseHash(license);
        Optional<LicenseState> licenseStateOption = this.licenseStateRepository.load(appKey);
        if (licenseStateOption.isPresent()) {
            LicenseState licenseState = licenseStateOption.get();
            if (isEval) {
                if (!licenseState.getLicenses().contains(hash2)) {
                    if (this.isResetLicense(license)) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(hash2);
                        this.licenseStateRepository.store(appKey, new LicenseState(list));
                        return;
                    }
                    licenseState.getLicenses().add(hash2);
                }
                this.licenseStateRepository.store(appKey, licenseState);
            } else {
                this.licenseStateRepository.remove(appKey);
            }
        } else if (isEval) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(hash2);
            this.licenseStateRepository.store(appKey, new LicenseState(list));
        }
    }

    static String getLicenseHash(PluginLicense license) {
        return InternalLicenseAbuseDetectionService.getLicenseHash(license.getRawLicense());
    }

    static String getLicenseHash(String rawLicense) {
        return DigestUtils.md5DigestAsHex((byte[])rawLicense.getBytes());
    }

    private boolean isResetLicense(PluginLicense license) {
        Iterator iterator = license.getContacts().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        Contact contact = (Contact)iterator.next();
        String email = contact.getEmail();
        return email.endsWith("@communardo.com") || email.endsWith("@bitvoodoo.ch") || email.endsWith("@communardo.de");
    }

    @Generated
    public InternalLicenseAbuseDetectionService(PluginLicenseManager pluginLicenseManager, LicenseHandler licenseHandler, LicenseStateRepository licenseStateRepository) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseHandler = licenseHandler;
        this.licenseStateRepository = licenseStateRepository;
    }
}

