/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.sonar.projectinfo;

import ch.mibex.bamboo.sonar4bamboo.sonar.projectinfo.ProjectBuildAnalyzer;
import ch.mibex.bamboo.sonar4bamboo.sonar.projectinfo.ProjectInfo;
import ch.mibex.bamboo.sonar4bamboo.sonar.projectinfo.ProjectInfo$;
import com.atlassian.bamboo.task.TaskContext;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;

public class SonarMavenAnalyzer
implements ProjectBuildAnalyzer {
    @Override
    public Option<ProjectInfo> analyzeProject(TaskContext taskContext) {
        return this.analyzeProjectKey(taskContext.getWorkingDirectory());
    }

    public Option<ProjectInfo> analyzeProjectKey(File workingDir) {
        Object[] files = this.getPomFiles(workingDir);
        Object object = Predef$.MODULE$.refArrayOps(files);
        return ArrayOps$.MODULE$.headOption$extension(object).flatMap((Function1<File, Option> & Serializable)pomFile -> {
            String fileContent = new String(Files.readAllBytes(pomFile.toPath()), StandardCharsets.UTF_8);
            Model model = new MavenXpp3Reader().read((Reader)new StringReader(fileContent));
            Tuple2<Option<String>, Option<String>> tuple2 = Tuple2$.MODULE$.apply(this.getGroupId(model), this.getArtifactId(model));
            if (tuple2 != null) {
                Option<String> option = tuple2._1();
                Option<String> option2 = tuple2._2();
                if (option instanceof Some) {
                    String groupId = (String)((Some)option).value();
                    if (option2 instanceof Some) {
                        String artifactId = (String)((Some)option2).value();
                        return Some$.MODULE$.apply(ProjectInfo$.MODULE$.apply(new StringBuilder(1).append(groupId).append(":").append(artifactId).toString(), this.substituteMavenVariables(Option$.MODULE$.apply(model.getName()), groupId, artifactId)));
                    }
                }
            }
            return None$.MODULE$;
        });
    }

    private Option<String> substituteMavenVariables(Option<String> projectName, String groupId, String artifactId) {
        return projectName.map((Function1<String, String> & Serializable)name -> name.replace("${project.artifactId}", artifactId)).map((Function1<String, String> & Serializable)name -> name.replace("${project.groupId}", groupId));
    }

    private Option<String> getGroupId(Model model) {
        return Option$.MODULE$.apply(model.getGroupId()).orElse(() -> SonarMavenAnalyzer.getGroupId$$anonfun$1(model));
    }

    private Option<String> getArtifactId(Model model) {
        return Option$.MODULE$.apply(model.getArtifactId()).orElse(() -> SonarMavenAnalyzer.getArtifactId$$anonfun$1(model));
    }

    private File[] getPomFiles(File workingDir) {
        return this.recursiveListFiles(workingDir, "pom.xml");
    }

    private static final Option getGroupId$$anonfun$1(Model model$1) {
        return Option$.MODULE$.apply(model$1.getParent()).map((Function1<Parent, String> & Serializable)_$1 -> _$1.getGroupId());
    }

    private static final Option getArtifactId$$anonfun$1(Model model$2) {
        return Option$.MODULE$.apply(model$2.getParent()).map((Function1<Parent, String> & Serializable)_$2 -> _$2.getArtifactId());
    }
}

