/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.atlassian.dc.telemetry;

import ch.mibex.atlassian.Logging;
import ch.mibex.platform.HostPlatform;
import ch.mibex.telemetry.PlausibleEventAPIClient$;
import ch.mibex.telemetry.TelemetryContext;
import ch.mibex.telemetry.TelemetryEvent;
import io.circe.Encoder$;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.KeyEncoder$;
import io.circe.syntax.package$EncoderOps$;
import java.io.Serializable;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure$;
import scala.util.Try;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import uk.gov.nationalarchives.scb.CircuitBreaker;
import uk.gov.nationalarchives.scb.ExecutionRejectedException;
import uk.gov.nationalarchives.scb.ProtectedTask;
import uk.gov.nationalarchives.scb.RejectedTask;
import uk.gov.nationalarchives.scb.TaskWithFuse;
import uk.gov.nationalarchives.scb.ThreadSafeCircuitBreaker$;
import uk.gov.nationalarchives.scb.support.FunctorAdapter$;

public class HostProductTelemetryContext
implements TelemetryContext,
Logging {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HostProductTelemetryContext.class.getDeclaredField("globallyEnabled$lzy1"));
    private int ch$mibex$telemetry$TelemetryContext$$TOO_MANY_REQUESTS;
    private int ch$mibex$telemetry$TelemetryContext$$SUCCESS;
    private int ch$mibex$telemetry$TelemetryContext$$ERROR;
    private volatile Logger ch$mibex$atlassian$Logging$$logger;
    private final HostPlatform platform;
    private final String telemetryPropertyName;
    private volatile Object globallyEnabled$lzy1;
    private final boolean appIsWhiteListed;
    private final ExecutionContext executionContext;
    private final CircuitBreaker circuitBreaker;
    private final FiniteDuration ConnectionTimeoutDefault;

    public HostProductTelemetryContext(HostPlatform platform2) {
        this.platform = platform2;
        TelemetryContext.$init$(this);
        Logging.$init$(this);
        this.telemetryPropertyName = new StringBuilder(17).append("plugin.").append(platform2.appKey()).append(".telemetry").toString();
        String string2 = this.appKey();
        this.appIsWhiteListed = ((IterableOnceOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"checklist-buddy", "codeowners", "cra", "templates", "sonar4stash", "sonar4bamboo"}))).exists((Function1<CharSequence, Boolean> & Serializable)x$0 -> string2.contains((CharSequence)x$0));
        this.executionContext = platform2.executionContext();
        this.circuitBreaker = ThreadSafeCircuitBreaker$.MODULE$.apply("mibex-telemetry-circuit-breaker", 5, new package.DurationInt(package$.MODULE$.DurationInt(120)).seconds(), 2, new package.DurationInt(package$.MODULE$.DurationInt(300)).days());
        this.ConnectionTimeoutDefault = new package.DurationInt(package$.MODULE$.DurationInt(2)).seconds();
        Statics.releaseFence();
    }

    @Override
    public int ch$mibex$telemetry$TelemetryContext$$TOO_MANY_REQUESTS() {
        return this.ch$mibex$telemetry$TelemetryContext$$TOO_MANY_REQUESTS;
    }

    @Override
    public int ch$mibex$telemetry$TelemetryContext$$SUCCESS() {
        return this.ch$mibex$telemetry$TelemetryContext$$SUCCESS;
    }

    @Override
    public int ch$mibex$telemetry$TelemetryContext$$ERROR() {
        return this.ch$mibex$telemetry$TelemetryContext$$ERROR;
    }

    @Override
    public void ch$mibex$telemetry$TelemetryContext$_setter_$ch$mibex$telemetry$TelemetryContext$$TOO_MANY_REQUESTS_$eq(int x$0) {
        this.ch$mibex$telemetry$TelemetryContext$$TOO_MANY_REQUESTS = x$0;
    }

    @Override
    public void ch$mibex$telemetry$TelemetryContext$_setter_$ch$mibex$telemetry$TelemetryContext$$SUCCESS_$eq(int x$0) {
        this.ch$mibex$telemetry$TelemetryContext$$SUCCESS = x$0;
    }

    @Override
    public void ch$mibex$telemetry$TelemetryContext$_setter_$ch$mibex$telemetry$TelemetryContext$$ERROR_$eq(int x$0) {
        this.ch$mibex$telemetry$TelemetryContext$$ERROR = x$0;
    }

    @Override
    public Logger ch$mibex$atlassian$Logging$$logger() {
        return this.ch$mibex$atlassian$Logging$$logger;
    }

    @Override
    public void ch$mibex$atlassian$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$atlassian$Logging$$logger = x$1;
    }

    public HostPlatform platform() {
        return this.platform;
    }

    public String telemetryPropertyName() {
        return this.telemetryPropertyName;
    }

    private boolean globallyEnabled() {
        Object object = this.globallyEnabled$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean(object);
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean(this.globallyEnabled$lzyINIT1());
    }

    private Object globallyEnabled$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.globallyEnabled$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean(this.platform().getPropertyBoolean(this.telemetryPropertyName(), true));
                        serializable = bl == null ? LazyVals$NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.globallyEnabled$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String hostProductVersion() {
        return this.platform().hostProductVersion();
    }

    @Override
    public String appKey() {
        return this.platform().appKey();
    }

    @Override
    public String appVersion() {
        return this.platform().pluginVersion();
    }

    @Override
    public boolean isDC() {
        return this.platform().isDC();
    }

    public boolean appIsWhiteListed() {
        return this.appIsWhiteListed;
    }

    public boolean whiteListed() {
        return this.appIsWhiteListed() || this.platform().instanceIsWhiteListed();
    }

    @Override
    public boolean useTelemetry() {
        return this.whiteListed() && !this.platform().isDevEnvWithLocalhost() && !this.platform().isTestMode() && this.globallyEnabled();
    }

    @Override
    public String hostUrlHash() {
        return BoxesRunTime.boxToInteger(this.platform().baseUrl().hashCode()).toString();
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public <T> Try<T> protectWithCircuitBreaker(Function0<Try<T>> task) {
        ProtectedTask<Try> protectedTask = this.circuitBreaker.protect(task.apply(), FunctorAdapter$.MODULE$.functorForTry());
        if (protectedTask instanceof RejectedTask) {
            String reason = ((RejectedTask)protectedTask).reason();
            return Failure$.MODULE$.apply(new ExecutionRejectedException(new StringBuilder(57).append(reason).append(", ").append(this.circuitBreaker.name()).append(": rejected telemetry event. Disable telemetry by adding").append(new StringBuilder(36).append(" '").append(this.telemetryPropertyName()).append("=false' to 'bitbucket.properties'.").toString()).toString()));
        }
        if (protectedTask instanceof TaskWithFuse) {
            Try result = (Try)((TaskWithFuse)protectedTask).t();
            return result;
        }
        throw new MatchError(protectedTask);
    }

    private RequestConfig buildRequestConfig() {
        int connectionTimeOutInMilliSeconds = (int)this.ConnectionTimeoutDefault.toMillis();
        return RequestConfig.custom().setCookieSpec("ignoreCookies").setConnectionRequestTimeout(connectionTimeOutInMilliSeconds).setConnectTimeout(connectionTimeOutInMilliSeconds).setSocketTimeout(connectionTimeOutInMilliSeconds).build();
    }

    @Override
    public Try<Object> rawPostEvent(TelemetryEvent event) {
        String body = this.toPlausibleJson(event);
        this.debug(() -> HostProductTelemetryContext.rawPostEvent$$anonfun$1(body));
        return Using$.MODULE$.apply(this::rawPostEvent$$anonfun$2, (Function1<CloseableHttpClient, Integer> & Serializable)client -> {
            HttpPost postEvent = new HttpPost(PlausibleEventAPIClient$.MODULE$.plausibleEventAPIUrl());
            postEvent.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = client.execute((HttpUriRequest)postEvent);
            return response.getStatusLine().getStatusCode();
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public String toPlausibleJson(TelemetryEvent event) {
        String pagePath = StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.appKey()), "/")), StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(event.pagePath()), "/"));
        Map allProps = (Map)event.props().$plus$plus(this.props());
        Tuple2[] tuple2Array = new Tuple2[4];
        String string2 = Predef$.MODULE$.ArrowAssoc("name");
        String string3 = (String)io.circe.syntax.package$.MODULE$.EncoderOps(event.name().toString());
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, package$EncoderOps$.MODULE$.asJson$extension(string3, Encoder$.MODULE$.encodeString()));
        String string4 = Predef$.MODULE$.ArrowAssoc("url");
        String string5 = (String)io.circe.syntax.package$.MODULE$.EncoderOps(new StringBuilder(48).append("https://dummy.invalid/").append(pagePath).append("?utm_source=").append(this.hostUrlHash()).append("&utm_campaign=").append(this.hostUrlHash()).toString());
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, package$EncoderOps$.MODULE$.asJson$extension(string5, Encoder$.MODULE$.encodeString()));
        String string6 = Predef$.MODULE$.ArrowAssoc("domain");
        String string7 = (String)io.circe.syntax.package$.MODULE$.EncoderOps(PlausibleEventAPIClient$.MODULE$.plausibleSiteDomain());
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string6, package$EncoderOps$.MODULE$.asJson$extension(string7, Encoder$.MODULE$.encodeString()));
        String string8 = Predef$.MODULE$.ArrowAssoc("props");
        Map map = (Map)io.circe.syntax.package$.MODULE$.EncoderOps(allProps);
        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string8, package$EncoderOps$.MODULE$.asJson$extension(map, Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString())));
        JsonObject json = JsonObject$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        return json.toJson().spaces2();
    }

    private static final String rawPostEvent$$anonfun$1(String body$1) {
        return new StringBuilder(17).append("Telemetry event: ").append(body$1).toString();
    }

    private final CloseableHttpClient rawPostEvent$$anonfun$2() {
        return HttpClientBuilder.create().setDefaultRequestConfig(this.buildRequestConfig()).build();
    }
}

