<html>

<head>
    <title>[@ww.text name='sonar4bamboo.admin.title' /]</title>
    <meta name="decorator" content="adminpage">
</head>

<body>
<h1>
    [@ww.text name=(editMode == 'update')?string('sonar4bamboo.admin.edit.title', 'sonar4bamboo.admin.add.title') /]
</h1>

[#macro showTokenAuthSection]
    [@ww.select
        name='serverTokenBambooVar' id='serverTokenBambooVar'
        labelKey='sonar4bamboo.admin.host.auth.token.label'
        descriptionKey="sonar4bamboo.admin.host.auth.token.description"
        listKey='key' listValue='key' toggle='true' list=bambooVariables/]

    [@ww.checkbox
        name='usePlaintextVar' id='usePlaintextVarId'
        labelKey='sonar4bamboo.admin.host.auth.token.plain.checkbox.label'
        toggle='true' /]

    [@ui.bambooSection dependsOn='usePlaintextVar'  showOn=true]
        [@ww.password
            name='serverUsertoken' id="plainTextTokenField"
            labelKey='sonar4bamboo.admin.host.auth.token.plain.label'
            descriptionKey='sonar4bamboo.admin.host.auth.token.plain.description'
            showPassword='true' /]
    [/@ui.bambooSection]
[/#macro]

[#macro showPasswordAuthSection]
    [@ww.textfield
    name='serverUsername'
    labelKey='sonar4bamboo.admin.host.auth.simple.username.label'
    descriptionKey='sonar4bamboo.admin.host.auth.simple.username.description' /]

    [@ww.select
    name='serverPwBambooVar' id='serverPwBambooVar'
    labelKey='sonar4bamboo.admin.host.auth.simple.password.label'
    descriptionKey='sonar4bamboo.admin.host.auth.simple.password.description'
    listKey='key' listValue='key' toggle='true' list=bambooVariables/]

    [@ww.password
    name='serverPassword'
    labelKey='sonar4bamboo.admin.host.auth.simple.password.plain.label'
    descriptionKey='sonar4bamboo.admin.host.auth.simple.password.plain.description'
    showPassword='true' /]
[/#macro]

[@ww.form action=(editMode == 'update')?string('updateSonarServerConfig','createSonarServerConfig')
          method='POST'
          submitLabelKey='sonar4bamboo.admin.save'
          showActionErrors='true'
          namespace='/admin/sonar4bamboo'
          onsubmit='ignoreUnusedOptionOnSave()'
          cancelUri='/admin/sonar4bamboo/viewSonarServerConfigs.action']

    [@ui.bambooSection titleKey='sonar4bamboo.admin.host.serverDetailsTitle']
        [@ww.textfield name='serverName' labelKey='sonar4bamboo.admin.server.name' descriptionKey='sonar4bamboo.admin.server.name.description' required='true' /]
        [@ww.textarea name='serverDescription' labelKey='sonar4bamboo.admin.server.description' descriptionKey='sonar4bamboo.admin.server.description.description' rows=5 /]
        [@ww.textfield name='serverHostUrl' id='serverHostUrl' labelKey='sonar4bamboo.admin.host.url' descriptionKey='sonar4bamboo.admin.host.url.description' onchange="updateSonarCloudOrgVisibility()" required='true' cssClass='long-field' /]
        [@ww.textfield name='displayServerUrl' labelKey='sonar4bamboo.admin.host.displayurl' descriptionKey='sonar4bamboo.admin.host.displayurl.description' cssClass='long-field' /]
        <div id="organizationKeySection">
            [@ww.textfield name="organizationKey" labelKey='sonar4bamboo.admin.server.organizationKey' descriptionKey='sonar4bamboo.admin.server.organizationKey.description' /]
        </div>
        <div id="sonarEditionSection">
            [@ww.radio name='sonarEdition' labelKey='sonar4bamboo.admin.host.sonaredition' list='sonarEditionOptions' toggle='true'/]
        </div>
    [/@ui.bambooSection]
    <br>

    [@ui.bambooSection titleKey='sonar4bamboo.admin.host.auth.title' ]

        [@ww.hidden name='editMode' /]
        [#if editMode == 'update']
            [@ww.hidden name='serverConfigId' /]
        [/#if]
        <h4>[@ww.text name='sonar4bamboo.admin.host.auth.token.title' /] </h4>

        [@ww.radio
            name='allowSharedServiceToken'
            labelKey='sonar4bamboo.admin.host.auth.sharedtoken.title'
            descriptionKey='sonar4bamboo.admin.host.auth.sharedtoken.description'
            list="allowSharedServiceTokenOptions"
            toggle="true"/]

        [#if editMode == 'update' ]
            [@ui.messageBox type="info"]
                <a href="[@ww.url action='viewSonarServerUsage' namespace='/admin/sonar4bamboo' /]?serverConfigId=${serverConfigId}" target="_blank">
                    [@ww.text name='sonar4bamboo.admin.server.usage.details' /]
                </a>
            [/@ui.messageBox]
        [/#if]
        <br>
        [@ui.bambooSection dependsOn='allowSharedServiceToken' showOn='allowSharedAuth']

            <p>[@ww.text name='sonar4bamboo.admin.host.auth.sq.permission.note' /]</p>

            [#if editMode == 'update' && authMode == 'useSimpleAuth' ]
                [@ww.radio
                    name="authMode"
                    labelKey="sonar4bamboo.admin.host.auth.method.title"
                    list="authMethods"
                    toggle="true"/]
                <br>

                [@ui.bambooSection dependsOn='authMode' showOn='useTokenAuth']
                    [@showTokenAuthSection/]
                [/@ui.bambooSection]

                [@ui.bambooSection dependsOn='authMode' showOn='useSimpleAuth']
                    [@showPasswordAuthSection/]
                [/@ui.bambooSection]

            [#else]
                [@ww.hidden name='authMode' /]
                [@showTokenAuthSection/]
            [/#if]
        [/@ui.bambooSection]

        <h4> [@ww.text name='sonar4bamboo.admin.host.auth.bitbucket.title' /] </h4>
        [@ww.textfield name="bambooUserName" labelKey="sonar4bamboo.admin.host.bambooUserName" template="userPicker" multiSelect=false placeholderKey="sonar4bamboo.admin.host.bambooUserName.placeholder" /]
    [/@ui.bambooSection]
    <br>

    [@ui.bambooSection titleKey='sonar4bamboo.admin.host.enableQgBuildBreakerTitle' ]
        [@ww.checkbox name='enableQgBuildBreaker' labelKey='sonar4bamboo.admin.host.enableQgBuildBreaker' /]
        [@ww.checkbox name='allowOverrideQgBuildBreaker' labelKey='sonar4bamboo.admin.host.allowOverrideQgBuildBreaker'/]
    [/@ui.bambooSection]

    [@ui.bambooSection titleKey='sonar4bamboo.admin.host.otherOptionsTitle' ]
        [@ww.checkbox name='addSonarProjectLink' labelKey='sonar4bamboo.admin.host.addSonarProjectLink' /]
    [/@ui.bambooSection]

[/@ww.form]

<script type="text/javascript">
    function ignoreUnusedOptionOnSave() {
        const checkbox = document.getElementById("usePlaintextVarId");
        if(checkbox.checked){
            document.getElementById("serverTokenBambooVar").selectedIndex = 0;
        } else {
            document.getElementById("plainTextTokenField").value = '';
        }
    }
    function initPlaintextTokenCheckbox() {
        const checkbox = document.getElementById("usePlaintextVarId");
        const hasNoErrors = document.querySelectorAll("[class~=error][data-field-name='serverUsertoken']").length === 0
        const plainTextFieldIsEmpty = document.getElementById("plainTextTokenField").value.length === 0
        if (hasNoErrors && plainTextFieldIsEmpty) {
            checkbox.removeAttribute("checked")
        } else {
            checkbox.setAttribute("checked", "checked")
        }
    }

    function updateSonarCloudOrgVisibility() {
        const serverURL = document.getElementById("serverHostUrl");
        const orgField = document.getElementById("organizationKeySection");
        const url = serverURL.value.toLowerCase();
        orgField.style.display = (url.includes('https://sonarcloud.io') || url.includes('https://sonarqube.us')) ? 'block' : 'none';
    }

    function toggleSonarEditionField() {
        const sonarEditionSection = document.getElementById("sonarEditionSection");
        const editMode = document.getElementsByName("editMode")[0].value;

        const toggle = () => {

            if (document.querySelector("input[name='allowSharedServiceToken']:checked").value === "enforcePlanToken") {
                // if no Service Account token configured, the SonarQube edition has to be configured manually
                sonarEditionSection.style.display = "block";
            } else {
                // if no token, the SonarQube edition has to be configured manually
                if(editMode == 'create') {
                  sonarEditionSection.style.display = "none";
                }
            }
        };

        document.querySelectorAll("input[name='allowSharedServiceToken']").forEach(radio => {
            radio.addEventListener("change", toggle);
        });

        toggle();
    }

    updateSonarCloudOrgVisibility();
    initPlaintextTokenCheckbox();
    toggleSonarEditionField();
</script>

</body>

</html>
