/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.MonadError;
import io.circe.KeyDecoder;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.UUID;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Symbol;
import scala.Symbol$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class KeyDecoder$
implements Serializable {
    private static final KeyDecoder decodeKeyString;
    private static final KeyDecoder decodeKeySymbol;
    private static final KeyDecoder decodeKeyUUID;
    private static final KeyDecoder decodeKeyURI;
    private static final KeyDecoder decodeKeyByte;
    private static final KeyDecoder decodeKeyShort;
    private static final KeyDecoder decodeKeyInt;
    private static final KeyDecoder decodeKeyLong;
    private static final MonadError keyDecoderInstances;
    public static final KeyDecoder$ MODULE$;

    private KeyDecoder$() {
    }

    static {
        MODULE$ = new KeyDecoder$();
        decodeKeyString = new KeyDecoder.AlwaysKeyDecoder<String>(){

            public final String decodeSafe(String key) {
                return key;
            }
        };
        decodeKeySymbol = new KeyDecoder.AlwaysKeyDecoder<Symbol>(){

            public final Symbol decodeSafe(String key) {
                return Symbol$.MODULE$.apply(key);
            }
        };
        decodeKeyUUID = new KeyDecoder<UUID>(){

            public final Option apply(String key) {
                if (key.length() == 36) {
                    Option option;
                    try {
                        option = Some$.MODULE$.apply(UUID.fromString(key));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        option = None$.MODULE$;
                    }
                    return option;
                }
                return None$.MODULE$;
            }
        };
        decodeKeyURI = new KeyDecoder<URI>(){

            public final Option apply(String key) {
                Option option;
                try {
                    option = Some$.MODULE$.apply(new URI(key));
                }
                catch (Throwable throwable) {
                    Option<Throwable> option2;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = option2.get();
                        option = None$.MODULE$;
                    }
                    throw throwable;
                }
                return option;
            }
        };
        decodeKeyByte = MODULE$.numberInstance((Function1<String, byte> & Serializable)x$0 -> Byte.parseByte(x$0));
        decodeKeyShort = MODULE$.numberInstance((Function1<String, short> & Serializable)x$0 -> Short.parseShort(x$0));
        decodeKeyInt = MODULE$.numberInstance((Function1<String, int> & Serializable)x$0 -> Integer.parseInt(x$0));
        decodeKeyLong = MODULE$.numberInstance((Function1<String, long> & Serializable)x$0 -> Long.parseLong(x$0));
        keyDecoderInstances = new MonadError<KeyDecoder, BoxedUnit>(){

            public final KeyDecoder pure(Object a) {
                return new KeyDecoder<A>(a){
                    private final Object a$1;
                    {
                        this.a$1 = a$3;
                    }

                    public final Option apply(String key) {
                        return Some$.MODULE$.apply(this.a$1);
                    }
                };
            }

            public final KeyDecoder map(KeyDecoder fa, Function1 f) {
                return fa.map(f);
            }

            public final KeyDecoder flatMap(KeyDecoder fa, Function1 f) {
                return fa.flatMap(f);
            }

            public final KeyDecoder raiseError(BoxedUnit e) {
                return new KeyDecoder<A>(){

                    public final Option apply(String key) {
                        return None$.MODULE$;
                    }
                };
            }

            public final KeyDecoder handleErrorWith(KeyDecoder fa, Function1 f) {
                return new KeyDecoder<A>(fa, f){
                    private final KeyDecoder fa$1;
                    private final Function1 f$3;
                    {
                        this.fa$1 = fa$2;
                        this.f$3 = f$9;
                    }

                    public final Option apply(String key) {
                        return this.fa$1.apply(key).orElse(() -> this.apply$$anonfun$2(key));
                    }

                    private final Option apply$$anonfun$2(String key$2) {
                        return ((KeyDecoder)this.f$3.apply(BoxedUnit.UNIT)).apply(key$2);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{apply$$anonfun$2(java.lang.String )}, serializedLambda);
                    }
                };
            }

            public final KeyDecoder tailRecM(Object a, Function1 f) {
                return new KeyDecoder<B>(f, a){
                    private final Function1 f$4;
                    private final Object a$2;
                    {
                        this.f$4 = f$10;
                        this.a$2 = a$4;
                    }

                    private Option step(String key, Object a1) {
                        Option<A> option;
                        block3: {
                            Either either;
                            while (true) {
                                if (None$.MODULE$.equals(option = ((KeyDecoder)this.f$4.apply(a1)).apply(key))) {
                                    return None$.MODULE$;
                                }
                                if (!(option instanceof Some)) break block3;
                                either = (Either)((Some)option).value();
                                if (!(either instanceof Left)) break;
                                A a2 = ((Left)either).value();
                                a1 = a2;
                            }
                            if (either instanceof Right) {
                                B b = ((Right)either).value();
                                return Some$.MODULE$.apply(b);
                            }
                        }
                        throw new MatchError(option);
                    }

                    public final Option apply(String key) {
                        return this.step(key, this.a$2);
                    }
                };
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(KeyDecoder$.class);
    }

    public <A> KeyDecoder<A> apply(KeyDecoder<A> A) {
        return A;
    }

    public <A> KeyDecoder<A> instance(Function1<String, Option<A>> f) {
        return new KeyDecoder<A>(f, this){
            private final Function1 f$5;
            {
                this.f$5 = f$11;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final Option apply(String key) {
                return (Option)this.f$5.apply(key);
            }
        };
    }

    private <A> KeyDecoder<A> numberInstance(Function1<String, A> f) {
        return new KeyDecoder<A>(f, this){
            private final Function1 f$6;
            {
                this.f$6 = f$12;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final Option apply(String key) {
                Option option;
                try {
                    option = Some$.MODULE$.apply(this.f$6.apply(key));
                }
                catch (NumberFormatException numberFormatException) {
                    option = None$.MODULE$;
                }
                return option;
            }
        };
    }

    public KeyDecoder<String> decodeKeyString() {
        return decodeKeyString;
    }

    public KeyDecoder<Symbol> decodeKeySymbol() {
        return decodeKeySymbol;
    }

    public KeyDecoder<UUID> decodeKeyUUID() {
        return decodeKeyUUID;
    }

    public KeyDecoder<URI> decodeKeyURI() {
        return decodeKeyURI;
    }

    public KeyDecoder<Object> decodeKeyByte() {
        return decodeKeyByte;
    }

    public KeyDecoder<Object> decodeKeyShort() {
        return decodeKeyShort;
    }

    public KeyDecoder<Object> decodeKeyInt() {
        return decodeKeyInt;
    }

    public KeyDecoder<Object> decodeKeyLong() {
        return decodeKeyLong;
    }

    public MonadError<KeyDecoder, BoxedUnit> keyDecoderInstances() {
        return keyDecoderInstances;
    }
}

