/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.tasks;

import ch.mibex.atlassian.dc.EvalAbuseDetected;
import ch.mibex.atlassian.dc.InvalidLicenseInfo;
import ch.mibex.atlassian.dc.LicenseChecker;
import ch.mibex.atlassian.dc.LicenseIssue;
import ch.mibex.atlassian.dc.LicenseWarning;
import ch.mibex.bamboo.sonar4bamboo.IncludeBambooKeyProvider$;
import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.Logging$;
import ch.mibex.bamboo.sonar4bamboo.Utils$;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequest;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequestService;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerConfigDao;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerEntity;
import ch.mibex.bamboo.sonar4bamboo.sonar.IncrementalAnalysis;
import ch.mibex.bamboo.sonar4bamboo.sonar.ResponseError;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClient;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarConstants$;
import ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption;
import ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption$;
import ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption$BreakBuildOnBrokenQualityGates$;
import ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption$DefaultServerQualityGate$;
import ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption$IgnoreQualityGates$;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarTaskConfigConstants$;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarTaskConfigHelper$;
import ch.mibex.bamboo.sonar4bamboo.telemetry.events.TelemetryEvents;
import com.atlassian.bamboo.security.EncryptionException;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.serialization.WhitelistedSerializable;
import com.atlassian.bamboo.task.RuntimeTaskDataProvider;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.struts.TextProvider;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class SonarRuntimeDataProvider
implements RuntimeTaskDataProvider,
Logging {
    private Logger log;
    private final SonarServerConfigDao sonarServerConfigDao;
    private final SonarClient sonarClient;
    private final LicenseChecker licenseChecker;
    private final IncrementalAnalysis incrementalAnalysisSupport;
    private final PullRequestService pullRequestHelper;
    private final TextProvider textProvider;
    private final CustomVariableContext customVariableContext;
    private final EncryptionService encryptionService;
    private final TelemetryEvents telemetry;

    public SonarRuntimeDataProvider(SonarServerConfigDao sonarServerConfigDao, SonarClient sonarClient, LicenseChecker licenseChecker, IncrementalAnalysis incrementalAnalysisSupport, PullRequestService pullRequestHelper, TextProvider textProvider, CustomVariableContext customVariableContext, EncryptionService encryptionService, TelemetryEvents telemetry) {
        this.sonarServerConfigDao = sonarServerConfigDao;
        this.sonarClient = sonarClient;
        this.licenseChecker = licenseChecker;
        this.incrementalAnalysisSupport = incrementalAnalysisSupport;
        this.pullRequestHelper = pullRequestHelper;
        this.textProvider = textProvider;
        this.customVariableContext = customVariableContext;
        this.encryptionService = encryptionService;
        this.telemetry = telemetry;
        Logging.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public java.util.Map<String, String> populateRuntimeTaskData(TaskDefinition taskDefinition, CommonContext context) {
        HashMap<String, String> runtimeTaskData = new HashMap<String, String>();
        Tuple2 tuple2 = Logging$.MODULE$.withStashedLogging(taskDefinition, (Function0<Object> & Serializable)() -> {
            this.$anonfun$1(context, runtimeTaskData, taskDefinition);
            return BoxedUnit.UNIT;
        });
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String logLines = tuple2._2();
        String logLines2 = logLines;
        runtimeTaskData.put(SonarConstants$.MODULE$.PreparationLog(), logLines2);
        return runtimeTaskData;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void setQualityGateBuildBreaker(Option<SonarServerEntity> serverConfig, HashMap<String, String> runtimeTaskData, TaskDefinition taskDefinition) {
        block8: {
            block7: {
                var5_4 = serverConfig;
                if (!(var5_4 instanceof Some) || BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply((sc = (SonarServerEntity)((Some)var5_4).value()).getOverrideQgBuildBreaker()).map((Function1<Boolean, Boolean> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$2(java.lang.Boolean ), (Ljava/lang/Boolean;)Ljava/lang/Boolean;)()).getOrElse((Function0<Boolean> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$3(), ()Ljava/lang/Boolean;)()))) break block7;
                v0 = this.serverQualityGateSetting(sc);
                break block8;
            }
            taskConfig = taskDefinition.getConfiguration();
            qualityGateOption = Option$.MODULE$.apply(taskConfig.get(SonarTaskConfigConstants$.MODULE$.BrokenQualityGateOptionField())).map((Function1<String, BrokenQualityGateOption> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$4(java.lang.String ), (Ljava/lang/String;)Lch/mibex/bamboo/sonar4bamboo/tasks/BrokenQualityGateOption;)());
            oldQualityGateFlag = Option$.MODULE$.apply(taskConfig.get(SonarTaskConfigConstants$.MODULE$.OldFailBuildForBrokenQualityGatesField())).map((Function1<String, BrokenQualityGateOption> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$5(java.lang.String ), (Ljava/lang/String;)Lch/mibex/bamboo/sonar4bamboo/tasks/BrokenQualityGateOption;)());
            qualityGateTaskSettings = qualityGateOption.orElse((Function0<Option> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$6(scala.Option ), ()Lscala/Option;)(oldQualityGateFlag));
            this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$7(scala.Option scala.Option scala.Option ), ()Ljava/lang/String;)(qualityGateTaskSettings, qualityGateOption, oldQualityGateFlag));
            var12_10 = qualityGateTaskSettings;
            if (!(var12_10 instanceof Some)) ** GOTO lbl-1000
            v1 = option = (BrokenQualityGateOption)((Some)var12_10).value();
            var14_12 = BrokenQualityGateOption$DefaultServerQualityGate$.MODULE$;
            if (v1 == null ? var14_12 != null : v1.equals(var14_12) == false) {
                v2 /* !! */  = option;
            } else lbl-1000:
            // 2 sources

            {
                this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$8(), ()Ljava/lang/String;)());
                var15_13 = serverConfig;
                if (var15_13 instanceof Some) {
                    server = (SonarServerEntity)((Some)var15_13).value();
                    failBuild = this.serverQualityGateSetting(server);
                    this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$9(ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption ), ()Ljava/lang/String;)((BrokenQualityGateOption)failBuild));
                    v2 /* !! */  = failBuild;
                } else if (None$.MODULE$.equals(var15_13)) {
                    v2 /* !! */  = BrokenQualityGateOption$IgnoreQualityGates$.MODULE$;
                } else {
                    throw new MatchError(var15_13);
                }
            }
            result /* !! */  = v2 /* !! */ ;
            this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$10(ch.mibex.bamboo.sonar4bamboo.tasks.BrokenQualityGateOption ), ()Ljava/lang/String;)((BrokenQualityGateOption)result /* !! */ ));
            v0 = result /* !! */ ;
        }
        v3 = qualityGateOption = v0;
        var18_18 = BrokenQualityGateOption$DefaultServerQualityGate$.MODULE$;
        if (!(v3 != null ? v3.equals(var18_18) == false : var18_18 != null)) {
            throw Scala3RunTime$.MODULE$.assertFailed("Expect to have chosen a quality gate option.");
        }
        runtimeTaskData.put(SonarConstants$.MODULE$.SonarQualityGateOption(), qualityGateOption.id());
    }

    private BrokenQualityGateOption serverQualityGateSetting(SonarServerEntity sc) {
        return (BrokenQualityGateOption)Option$.MODULE$.apply(sc.getEnableQgBuildBreaker()).map((Function1<Boolean, BrokenQualityGateOption> & Serializable)enabled -> {
            if (Predef$.MODULE$.Boolean2boolean((Boolean)enabled)) {
                return BrokenQualityGateOption$BreakBuildOnBrokenQualityGates$.MODULE$;
            }
            return BrokenQualityGateOption$IgnoreQualityGates$.MODULE$;
        }).getOrElse(SonarRuntimeDataProvider::serverQualityGateSetting$$anonfun$2);
    }

    private Object setSonarServerVersion(Option<SonarServerEntity> serverConfig, HashMap<String, String> runtimeTaskData) {
        Option<SonarServerEntity> option = serverConfig;
        if (option instanceof Some) {
            SonarServerEntity sc = (SonarServerEntity)((Some)option).value();
            Either<ResponseError, ArtifactVersion> either = this.sonarClient.getSonarVersion(sc.getServerHostUrl());
            if (either instanceof Left) {
                ResponseError err = (ResponseError)((Left)either).value();
                this.error(new StringBuilder(49).append("Was not able to detect SonarQube server version: ").append(err.reason()).toString());
                return BoxedUnit.UNIT;
            }
            if (either instanceof Right) {
                ArtifactVersion sonarVersion = (ArtifactVersion)((Right)either).value();
                return runtimeTaskData.put(SonarConstants$.MODULE$.SonarServerVersion(), sonarVersion.toString());
            }
            throw new MatchError(either);
        }
        if (None$.MODULE$.equals(option)) {
            this.debug(SonarRuntimeDataProvider::setSonarServerVersion$$anonfun$1);
            return BoxedUnit.UNIT;
        }
        throw new MatchError(option);
    }

    private void setSonarServerParameters(Option<SonarServerEntity> serverConfig, HashMap<String, String> runtimeTaskData, TaskDefinition taskDefinition) {
        Option<SonarServerEntity> option = serverConfig;
        if (option instanceof Some) {
            SonarServerEntity sc = (SonarServerEntity)((Some)option).value();
            this.debug(SonarRuntimeDataProvider::setSonarServerParameters$$anonfun$1);
            Option$.MODULE$.apply(sc.getServerHostUrl()).foreach((Function1<String, String> & Serializable)hostUrl -> runtimeTaskData.put(SonarConstants$.MODULE$.SonarHostUrl(), (String)hostUrl));
            Option$.MODULE$.apply(sc.getDisplayServerHostUrl()).foreach((Function1<String, String> & Serializable)displayUrl -> runtimeTaskData.put(SonarConstants$.MODULE$.DisplaySonarHostUrl(), (String)displayUrl));
            Option$.MODULE$.apply(sc.getOrganizationKey()).foreach((Function1<String, String> & Serializable)organizationKey -> runtimeTaskData.put(SonarConstants$.MODULE$.SonarOrganizationKey(), (String)organizationKey));
            this.setAuthenticationIfNecessary(taskDefinition, runtimeTaskData, sc);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.debug(SonarRuntimeDataProvider::setSonarServerParameters$$anonfun$5);
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setSonarServerEdition(Option<SonarServerEntity> serverConfig, HashMap<String, String> runtimeTaskData, TaskDefinition taskDefinition) {
        Option option;
        Option<SonarServerEntity> option2 = serverConfig;
        if (option2 instanceof Some) {
            SonarServerEntity sc = (SonarServerEntity)((Some)option2).value();
            Option<String> option3 = Option$.MODULE$.apply(sc.getSonarEdition());
            if (option3 instanceof Some) {
                String e2 = (String)((Some)option3).value();
                this.debug(() -> SonarRuntimeDataProvider.$anonfun$11(e2));
                option = Some$.MODULE$.apply(e2);
            } else {
                if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                this.debug(SonarRuntimeDataProvider::$anonfun$12);
                option = None$.MODULE$;
            }
        } else {
            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            Option option4 = Option$.MODULE$.apply(taskDefinition.getConfiguration().get(SonarTaskConfigConstants$.MODULE$.SonarEditionSelectionField()));
            if (option4 instanceof Some) {
                String edition = (String)((Some)option4).value();
                this.debug(() -> SonarRuntimeDataProvider.$anonfun$13(edition));
                option = Some$.MODULE$.apply(edition);
            } else {
                if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                this.debug(SonarRuntimeDataProvider::$anonfun$14);
                option = None$.MODULE$;
            }
        }
        None$ edition = option;
        edition.foreach((Function1<String, String> & Serializable)e -> runtimeTaskData.put(SonarConstants$.MODULE$.SonarEdition(), (String)e));
    }

    private Object setPossibleLicenseError(HashMap<String, String> runtimeTaskData) {
        Option<LicenseIssue> option = this.licenseChecker.validateLicense(Utils$.MODULE$.LicenseTexts(), (Function0<Object>)((Function0<Boolean> & Serializable)SonarRuntimeDataProvider::setPossibleLicenseError$$anonfun$1), this.licenseChecker.validateLicense$default$3());
        if (option instanceof Some) {
            LicenseIssue licenseIssue = (LicenseIssue)((Some)option).value();
            if (licenseIssue instanceof InvalidLicenseInfo) {
                InvalidLicenseInfo licenseIssue2 = (InvalidLicenseInfo)licenseIssue;
                this.error(new StringBuilder(43).append("License problem detected, will fail build: ").append(licenseIssue2.reason()).toString());
                return runtimeTaskData.put(SonarConstants$.MODULE$.RuntimeProviderError(), licenseIssue2.reason());
            }
            if (licenseIssue instanceof EvalAbuseDetected) {
                EvalAbuseDetected licenseIssue3 = (EvalAbuseDetected)licenseIssue;
                this.error(new StringBuilder(75).append("License problem detected, will fail build: ").append(licenseIssue3.reason()).append(" Contact: products@communardo.de").toString());
                return runtimeTaskData.put(SonarConstants$.MODULE$.RuntimeProviderError(), licenseIssue3.reason());
            }
            if (licenseIssue instanceof LicenseWarning) {
                LicenseWarning licenseIssue4 = (LicenseWarning)licenseIssue;
                this.warn(new StringBuilder(26).append("License warning detected: ").append(licenseIssue4.text()).toString());
                return BoxedUnit.UNIT;
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.debug(SonarRuntimeDataProvider::setPossibleLicenseError$$anonfun$2);
            return BoxedUnit.UNIT;
        }
        throw new MatchError(option);
    }

    private void setIncrementalModeParams(Option<SonarServerEntity> serverConfig, HashMap<String, String> runtimeTaskData, CommonContext context, TaskDefinition taskDefinition, Option<scala.collection.immutable.Map<String, String>> repoConfigOpt) {
        if (this.isIncrementalModeEnabled(taskDefinition)) {
            scala.collection.immutable.Map repoConfig = (scala.collection.immutable.Map)repoConfigOpt.getOrElse(SonarRuntimeDataProvider::$anonfun$15);
            this.incrementalAnalysisSupport.applyIncrementalMode(runtimeTaskData, context, taskDefinition, serverConfig, repoConfig);
            return;
        }
        this.debug(SonarRuntimeDataProvider::setIncrementalModeParams$$anonfun$1);
    }

    private Object setBranchTargetName(Option<SonarServerEntity> serverConfig, HashMap<String, String> runtimeTaskData, CommonContext context, TaskDefinition taskDefinition, Option<scala.collection.immutable.Map<String, String>> repoConfigOpt) {
        if (this.shouldApplyBranchTargetName(taskDefinition)) {
            Option<String> option = Utils$.MODULE$.getCurrentGitBranch(this.customVariableContext);
            if (option instanceof Some) {
                String stashBranch;
                String string2 = stashBranch = (String)((Some)option).value();
                String string3 = this.getSonarMainBranchName(taskDefinition);
                if (string2 == null ? string3 != null : !string2.equals(string3)) {
                    Option<scala.collection.immutable.Map<String, String>> option2 = repoConfigOpt;
                    if (None$.MODULE$.equals(option2)) {
                        this.debug(SonarRuntimeDataProvider::setBranchTargetName$$anonfun$1);
                        return BoxedUnit.UNIT;
                    }
                    if (option2 instanceof Some) {
                        scala.collection.immutable.Map repo = (scala.collection.immutable.Map)((Some)option2).value();
                        return this.configureTargetBranchNameFromPullRequest(serverConfig, context, taskDefinition, runtimeTaskData, stashBranch, repo);
                    }
                    throw new MatchError(option2);
                }
            }
            if (None$.MODULE$.equals(option)) {
                this.warn("Unable to set sonar.branch.target: ensure a repository is attached to the plan");
                return BoxedUnit.UNIT;
            }
            this.debug(SonarRuntimeDataProvider::setBranchTargetName$$anonfun$2);
            return BoxedUnit.UNIT;
        }
        this.debug(SonarRuntimeDataProvider::setBranchTargetName$$anonfun$3);
        return BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldApplyBranchTargetName(TaskDefinition taskDefinition) {
        Option<Either<ResponseError, ArtifactVersion>> option = this.findSonarQubeVersion(taskDefinition.getConfiguration());
        if (option instanceof Some) {
            Either versionOrError = (Either)((Some)option).value();
            Either either = versionOrError;
            if (either instanceof Left) {
                ResponseError error = (ResponseError)((Left)either).value();
                throw new IllegalStateException(new StringBuilder(39).append("Error while getting SonarQube version: ").append(error.reason()).toString());
            }
            if (!(either instanceof Right)) throw new MatchError(either);
            ArtifactVersion version = (ArtifactVersion)((Right)either).value();
            if (version.compareTo((Object)new DefaultArtifactVersion("8.1.0")) >= 0) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return false;
    }

    private Option<scala.collection.immutable.Map<String, String>> getBBsRepoConfig(CommonContext context) {
        Option bbsRepo = CollectionConverters$.MODULE$.ListHasAsScala(context.getVcsRepositories()).asScala().find((Function1<PlanRepositoryDefinition, Boolean> & Serializable)rd -> {
            this.debug(() -> SonarRuntimeDataProvider.$anonfun$16$$anonfun$1(rd));
            return rd.getPluginKey().startsWith("com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash");
        });
        return bbsRepo.map((Function1<PlanRepositoryDefinition, scala.collection.immutable.Map> & Serializable)_$2 -> CollectionConverters$.MODULE$.MapHasAsScala(_$2.getVcsLocation().getConfiguration()).asScala().toMap($less$colon$less$.MODULE$.refl()));
    }

    private String getSonarMainBranchName(TaskDefinition taskDefinition) {
        String mainBranch;
        Option option = Option$.MODULE$.apply(taskDefinition.getConfiguration().get(SonarTaskConfigConstants$.MODULE$.SonarMainBranchField()));
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((mainBranch = (String)((Some)option).value()).trim()))) {
            return mainBranch;
        }
        return "master";
    }

    private boolean isIncrementalModeEnabled(TaskDefinition taskDefinition) {
        String incrementalModeEnabled;
        Option option = Option$.MODULE$.apply(taskDefinition.getConfiguration().get(SonarTaskConfigConstants$.MODULE$.IncrementalModeField()));
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(incrementalModeEnabled = (String)((Some)option).value()))) {
            return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(incrementalModeEnabled));
        }
        return false;
    }

    private Object configureTargetBranchNameFromPullRequest(Option<SonarServerEntity> serverConfig, CommonContext context, TaskDefinition taskDefinition, HashMap<String, String> runtimeTaskData, String stashBranch, scala.collection.immutable.Map<String, String> repoConfig) {
        Option<PullRequest> option = this.pullRequestHelper.getPullRequest(context, taskDefinition, stashBranch, serverConfig, repoConfig);
        if (option instanceof Some) {
            PullRequest pr = (PullRequest)((Some)option).value();
            this.debug(() -> SonarRuntimeDataProvider.configureTargetBranchNameFromPullRequest$$anonfun$1(pr));
            return runtimeTaskData.put(SonarConstants$.MODULE$.SonarBranchTargetName(), pr.targetBranch());
        }
        if (None$.MODULE$.equals(option)) {
            this.info("No pull requests found to apply incremental mode. Have you enabled the option WHEN PULL REQUEST IS CREATED in the branches options of your plan?");
            return BoxedUnit.UNIT;
        }
        throw new MatchError(option);
    }

    private boolean isAlreadyPartOfAdditionalParams(TaskDefinition taskDefinition, String paramName) {
        String additionalProps = (String)taskDefinition.getConfiguration().get(SonarTaskConfigConstants$.MODULE$.AdditionalPropertiesField());
        return ((String)Option$.MODULE$.apply(additionalProps).getOrElse(SonarRuntimeDataProvider::isAlreadyPartOfAdditionalParams$$anonfun$1)).contains(new StringBuilder(3).append("-D").append(paramName).append("=").toString()) || ((String)Option$.MODULE$.apply(additionalProps).getOrElse(SonarRuntimeDataProvider::isAlreadyPartOfAdditionalParams$$anonfun$2)).contains(new StringBuilder(4).append("/d:").append(paramName).append("=").toString());
    }

    private void setAuthenticationIfNecessary(TaskDefinition taskDefinition, java.util.Map<String, String> runtimeTaskData, SonarServerEntity entity) {
        java.util.Map config = taskDefinition.getConfiguration();
        boolean loginAlreadyOnCmdLine = this.isAlreadyPartOfAdditionalParams(taskDefinition, SonarConstants$.MODULE$.SonarLogin()) || this.isAlreadyPartOfAdditionalParams(taskDefinition, SonarConstants$.MODULE$.SonarToken()) || this.isAlreadyPartOfAdditionalParams(taskDefinition, SonarConstants$.MODULE$.SonarPassword());
        Option<String> overrideLoginField = Utils$.MODULE$.getValueIfConfigured(Option$.MODULE$.apply(config.get(SonarTaskConfigConstants$.MODULE$.OverrideSonarLoginField())));
        Option<String> overrideLoginVariable = Utils$.MODULE$.getValueIfConfigured(Option$.MODULE$.apply(config.get(SonarTaskConfigConstants$.MODULE$.OverrideSonarLoginVariableField())));
        if (!loginAlreadyOnCmdLine) {
            Object object;
            String overrideLogin;
            Option<String> option = overrideLoginField;
            if (option instanceof Some && StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(overrideLogin = (String)((Some)option).value())) && overrideLoginVariable.nonEmpty()) {
                overrideLoginVariable.foreach((Function1<String, String> & Serializable)v -> runtimeTaskData.put(SonarConstants$.MODULE$.SonarLogin(), this.makeBambooVariable((String)v)));
                object = BoxedUnit.UNIT;
            } else if (Predef$.MODULE$.Boolean2boolean(entity.getAllowSharedServiceToken())) {
                String userName;
                Option<String> option2 = Option$.MODULE$.apply(entity.getServerUsername());
                if (option2 instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((userName = (String)((Some)option2).value()).trim()))) {
                    String pwBambooVar;
                    runtimeTaskData.put(SonarConstants$.MODULE$.SonarLogin(), userName);
                    Option<String> option3 = Option$.MODULE$.apply(entity.getServerPwBambooVar());
                    if (option3 instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((pwBambooVar = (String)((Some)option3).value()).trim()))) {
                        object = runtimeTaskData.put(SonarConstants$.MODULE$.SonarPassword(), this.makeBambooVariable(pwBambooVar));
                    } else {
                        this.decrypt(entity.getServerPassword()).foreach((Function1<String, String> & Serializable)userPw -> runtimeTaskData.put(SonarConstants$.MODULE$.SonarPassword(), (String)userPw));
                        object = BoxedUnit.UNIT;
                    }
                } else if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((String)Option$.MODULE$.apply(entity.getServerTokenBambooVar()).getOrElse(SonarRuntimeDataProvider::setAuthenticationIfNecessary$$anonfun$3)).trim()))) {
                    object = runtimeTaskData.put(SonarConstants$.MODULE$.SonarLogin(), this.makeBambooVariable(entity.getServerTokenBambooVar()));
                } else if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((String)Option$.MODULE$.apply(entity.getServerUsertoken()).getOrElse(SonarRuntimeDataProvider::setAuthenticationIfNecessary$$anonfun$4)).trim()))) {
                    this.decrypt(entity.getServerUsertoken()).foreach((Function1<String, String> & Serializable)userToken -> runtimeTaskData.put(SonarConstants$.MODULE$.SonarLogin(), (String)userToken));
                    object = BoxedUnit.UNIT;
                } else {
                    this.debug(SonarRuntimeDataProvider::setAuthenticationIfNecessary$$anonfun$6);
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = runtimeTaskData.put(SonarConstants$.MODULE$.RuntimeProviderError(), this.textProvider.getText("sonar4bamboo.admin.host.auth.sharedtoken.build.error"));
            }
            return;
        }
    }

    private Option<SonarServerEntity> getGlobalServerConfigForTask(java.util.Map<String, String> runtimeTaskData, TaskDefinition taskDefinition) {
        if (SonarTaskConfigHelper$.MODULE$.useGlobalSonarServerConfig(taskDefinition.getConfiguration())) {
            return SonarTaskConfigHelper$.MODULE$.sonarServerConfig(taskDefinition.getConfiguration(), this.sonarServerConfigDao).orElse(() -> this.getGlobalServerConfigForTask$$anonfun$1(taskDefinition, runtimeTaskData));
        }
        return None$.MODULE$;
    }

    private Option<Either<ResponseError, ArtifactVersion>> findSonarQubeVersion(java.util.Map<String, String> config) {
        Option sonarServerUrl2 = Option$.MODULE$.apply(config.get(SonarTaskConfigConstants$.MODULE$.ChosenSonarConfigIdField())).withFilter((Function1<String, Object>)(Function1<String, Boolean> & Serializable)sonarServerId -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)sonarServerId))).flatMap((Function1<String, Option> & Serializable)sonarServerId -> this.sonarServerConfigDao.findById(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)sonarServerId))).flatMap((Function1<SonarServerEntity, Option> & Serializable)sonarServer -> Option$.MODULE$.apply(sonarServer.getServerHostUrl()).map((Function1<String, String> & Serializable)sonarServerUrl -> sonarServerUrl)));
        return sonarServerUrl2.map((Function1<String, Either> & Serializable)sonarServerUrl -> this.sonarClient.getSonarVersion((String)sonarServerUrl));
    }

    private String makeBambooVariable(String bambooVar) {
        return new StringBuilder(10).append("${bamboo.").append(bambooVar).append("}").toString();
    }

    private Option<String> decrypt(String password) {
        return Option$.MODULE$.apply(password).map((Function1<String, String> & Serializable)_$3 -> {
            String string2;
            try {
                string2 = this.encryptionService.decrypt(password);
            }
            catch (EncryptionException encryptionException) {
                string2 = password;
            }
            return string2;
        });
    }

    public void processRuntimeTaskData(RuntimeTaskDefinition runtimeTaskDefinition, CommonContext commonContext) {
    }

    public java.util.Map<String, WhitelistedSerializable> createRuntimeTaskData(RuntimeTaskDefinition runtimeTaskDefinition, CommonContext commonContext) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]))).asJava();
    }

    private final void $anonfun$1(CommonContext context$1, HashMap runtimeTaskData$1, TaskDefinition taskDefinition$1) {
        Option<scala.collection.immutable.Map<String, String>> repoConfig = this.getBBsRepoConfig(context$1);
        Option<SonarServerEntity> serverConfig = this.getGlobalServerConfigForTask(runtimeTaskData$1, taskDefinition$1);
        this.setSonarServerParameters(serverConfig, runtimeTaskData$1, taskDefinition$1);
        this.setPossibleLicenseError(runtimeTaskData$1);
        this.setIncrementalModeParams(serverConfig, runtimeTaskData$1, context$1, taskDefinition$1, repoConfig);
        this.setBranchTargetName(serverConfig, runtimeTaskData$1, context$1, taskDefinition$1, repoConfig);
        this.setQualityGateBuildBreaker(serverConfig, runtimeTaskData$1, taskDefinition$1);
        this.setSonarServerVersion(serverConfig, runtimeTaskData$1);
        this.setSonarServerEdition(serverConfig, runtimeTaskData$1, taskDefinition$1);
        String taskKey = taskDefinition$1.getPluginKey().substring(IncludeBambooKeyProvider$.MODULE$.appKey().length() + 1);
        String jobKey = context$1.getEntityKey().getKey();
        this.telemetry.postTaskUsed(taskKey, jobKey, taskDefinition$1.getConfiguration(), runtimeTaskData$1);
    }

    private static final /* synthetic */ boolean $anonfun$2(Boolean _$1) {
        return _$1;
    }

    private static final boolean $anonfun$3() {
        return true;
    }

    private static final /* synthetic */ BrokenQualityGateOption $anonfun$4(String id) {
        return BrokenQualityGateOption$.MODULE$.fromString(id);
    }

    private static final /* synthetic */ BrokenQualityGateOption $anonfun$5(String v) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(v)) && StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v))) {
            return BrokenQualityGateOption$BreakBuildOnBrokenQualityGates$.MODULE$;
        }
        return BrokenQualityGateOption$DefaultServerQualityGate$.MODULE$;
    }

    private static final Option $anonfun$6(Option oldQualityGateFlag$1) {
        return oldQualityGateFlag$1;
    }

    private static final Object $anonfun$7$$anonfun$1() {
        return "";
    }

    private static final String $anonfun$7(Option qualityGateTaskSettings$1, Option qualityGateOption$1, Option oldQualityGateFlag$2) {
        return new StringBuilder(48).append("Quality gate status value in task settings: '").append(qualityGateTaskSettings$1.getOrElse(SonarRuntimeDataProvider::$anonfun$7$$anonfun$1)).append("'. ").append(new StringBuilder(10).append("From ").append(SonarTaskConfigConstants$.MODULE$.BrokenQualityGateOptionField()).append("={").append(qualityGateOption$1).append("} ").append(SonarTaskConfigConstants$.MODULE$.OldFailBuildForBrokenQualityGatesField()).append("=").append(oldQualityGateFlag$2).toString()).toString();
    }

    private static final String $anonfun$8() {
        return "no sonarqube quality settings found, will consider server settings";
    }

    private static final String $anonfun$9(BrokenQualityGateOption failBuild$1) {
        return new StringBuilder(26).append("fail build for qg status? ").append(failBuild$1).toString();
    }

    private static final String $anonfun$10(BrokenQualityGateOption result$1) {
        return new StringBuilder(26).append("is legacy branch enabled? ").append(result$1).toString();
    }

    private static final BrokenQualityGateOption serverQualityGateSetting$$anonfun$2() {
        return BrokenQualityGateOption$IgnoreQualityGates$.MODULE$;
    }

    private static final String setSonarServerVersion$$anonfun$1() {
        return "No SonarQube server for this task is configured. Will only use task settings...";
    }

    private static final String setSonarServerParameters$$anonfun$1() {
        return "Going to use global SonarQube server settings for the analysis...";
    }

    private static final String setSonarServerParameters$$anonfun$5() {
        return "no SonarQube server for this task is configured. Will only use task settings...";
    }

    private static final String $anonfun$11(String e$1) {
        return new StringBuilder(24).append("Sonar server is ").append(e$1).append(" edition").toString();
    }

    private static final String $anonfun$12() {
        return "Sonar server is unknown, therefore edition is unknown";
    }

    private static final String $anonfun$13(String edition$1) {
        return new StringBuilder(31).append("No Sonar server. Task is using ").append(edition$1).toString();
    }

    private static final String $anonfun$14() {
        return "No Sonar server and and no edition configured on task";
    }

    private static final boolean setPossibleLicenseError$$anonfun$1() {
        return true;
    }

    private static final String setPossibleLicenseError$$anonfun$2() {
        return "No license error detected";
    }

    private static final scala.collection.immutable.Map $anonfun$15() {
        throw new IllegalStateException("No Bitbucket repository configuration found");
    }

    private static final String setIncrementalModeParams$$anonfun$1() {
        return "Incremental mode is not enabled";
    }

    private static final String setBranchTargetName$$anonfun$1() {
        return "Repository is not a Bitbucket repository, no target branch information available";
    }

    private static final String setBranchTargetName$$anonfun$2() {
        return "Will not set branch target name because current branch is master";
    }

    private static final String setBranchTargetName$$anonfun$3() {
        return "Branch target name will not be set because legacy branching enabled or no Bamboo user configured";
    }

    private static final String $anonfun$16$$anonfun$1(PlanRepositoryDefinition rd$1) {
        return new StringBuilder(28).append("Found repository definition ").append(rd$1.getPluginKey()).toString();
    }

    private static final String configureTargetBranchNameFromPullRequest$$anonfun$1(PullRequest pr$1) {
        return new StringBuilder(49).append("Found pull request '").append(pr$1.id()).append("' to apply branch target name").toString();
    }

    private static final String isAlreadyPartOfAdditionalParams$$anonfun$1() {
        return "";
    }

    private static final String isAlreadyPartOfAdditionalParams$$anonfun$2() {
        return "";
    }

    private static final String setAuthenticationIfNecessary$$anonfun$3() {
        return "";
    }

    private static final String setAuthenticationIfNecessary$$anonfun$4() {
        return "";
    }

    private static final String setAuthenticationIfNecessary$$anonfun$6() {
        return "No authentication enabled";
    }

    private final Option getGlobalServerConfigForTask$$anonfun$1(TaskDefinition taskDefinition$2, java.util.Map runtimeTaskData$9) {
        this.error(new StringBuilder(52).append("Configured SonarQube server (id=").append(SonarTaskConfigHelper$.MODULE$.sonarServerConfigId(taskDefinition$2.getConfiguration())).append(") not found anymore!").toString());
        runtimeTaskData$9.put(SonarTaskConfigConstants$.MODULE$.SonarServerNotFound(), "true");
        return None$.MODULE$;
    }
}

