/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.qgstatus;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.AnalysisInfo;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.AnalysisInfo$;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.QgStatusBuildBreaker$;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.QualityGateStatus;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.QualityGateStatus$;
import ch.mibex.bamboo.sonar4bamboo.results.SonarBuildResultSummary$;
import ch.mibex.bamboo.sonar4bamboo.results.TaskResultQualityGates;
import ch.mibex.bamboo.sonar4bamboo.results.TaskResultQualityGates$;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials$;
import ch.mibex.bamboo.sonar4bamboo.sonar.ResponseError;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClient;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarConstants$;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class QgStatusBuildBreaker
implements Logging {
    private Logger log;
    private final SonarClient sonarClient;
    private final CustomVariableContext customVariableContext;
    private final int MaxIterationsToGetQualityGateStatus;

    public static File[] findSonarReportFiles(File file, File file2, Function1<File, File[]> function1) {
        return QgStatusBuildBreaker$.MODULE$.findSonarReportFiles(file, file2, function1);
    }

    public static File[] findSonarReportFilesRecursivelyIn(File file) {
        return QgStatusBuildBreaker$.MODULE$.findSonarReportFilesRecursivelyIn(file);
    }

    public static Function1<File, File[]> findSonarReportFiles$default$3() {
        return QgStatusBuildBreaker$.MODULE$.findSonarReportFiles$default$3();
    }

    public QgStatusBuildBreaker(SonarClient sonarClient, CustomVariableContext customVariableContext) {
        this.sonarClient = sonarClient;
        this.customVariableContext = customVariableContext;
        Logging.$init$(this);
        this.MaxIterationsToGetQualityGateStatus = 43200;
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public TaskResult breakBuildIfQualityGatesFailed(TaskContext taskContext, boolean breakBuild) {
        Object[] reportFiles = QgStatusBuildBreaker$.MODULE$.findSonarReportFiles(taskContext.getWorkingDirectory(), taskContext.getRootDirectory(), QgStatusBuildBreaker$.MODULE$.findSonarReportFiles$default$3());
        Object object = Predef$.MODULE$.refArrayOps(reportFiles);
        Option option = ArrayOps$.MODULE$.headOption$extension(object);
        if (option instanceof Some) {
            File sonarReportFile = (File)((Some)option).value();
            this.info(new StringBuilder(27).append("Found sonar report file in ").append(sonarReportFile.getAbsolutePath()).toString());
            Option<String> option2 = this.determineCeTaskUrl(sonarReportFile);
            if (option2 instanceof Some) {
                String ceTaskUrl = (String)((Some)option2).value();
                return this.checkTaskStatus(taskContext, ceTaskUrl, breakBuild);
            }
            if (None$.MODULE$.equals(option2)) {
                this.addErrorLogEntry(new StringBuilder(76).append("SonarQube quality gate detection failed: Could not find 'ceTaskUrl' in file ").append(sonarReportFile.getAbsolutePath()).toString(), taskContext);
                return this.failWithErrorTaskResult(taskContext, breakBuild);
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            this.addErrorLogEntry("SonarQube quality gate detection: no report-task.txt file found. You cannot use preview mode (-Dsonar.analysis.mode=preview), need SonarQube >= 5.3 and if you use MSBuild an \"MSBuild.exe end\" call for this feature to work.", taskContext);
            return this.failWithErrorTaskResult(taskContext, breakBuild);
        }
        throw new MatchError(option);
    }

    private TaskResult checkTaskStatus(TaskContext taskContext, String ceTaskUrl, boolean breakBuild) {
        AnalysisInfo analysisInfo;
        Either<ResponseError, AnalysisInfo> either = this.executeUntilTaskStatusReady(taskContext, ceTaskUrl, this.executeUntilTaskStatusReady$default$3());
        if (either instanceof Left) {
            ResponseError err = (ResponseError)((Left)either).value();
            String reason = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(err.reason())) ? new StringBuilder(8).append("Reason: ").append(err.reason()).toString() : "";
            this.reportFailReason(new StringBuilder(41).append("SonarQube quality gate detection failed. ").append(reason).toString(), taskContext, this.reportFailReason$default$3(), this.reportFailReason$default$4());
            return this.failWithErrorTaskResult(taskContext, breakBuild);
        }
        if (either instanceof Right && (analysisInfo = (AnalysisInfo)((Right)either).value()) != null) {
            AnalysisInfo analysisInfo2 = AnalysisInfo$.MODULE$.unapply(analysisInfo);
            Option<String> option = analysisInfo2._1();
            Option<String> option2 = analysisInfo2._2();
            Option<String> option3 = analysisInfo2._3();
            Option<String> option4 = analysisInfo2._4();
            if (option instanceof Some) {
                String string2;
                String status = string2 = (String)((Some)option).value();
                Option<String> projectKey = option3;
                Option<String> projectName = option4;
                String string3 = status;
                String string4 = "FAILED";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    this.reportFailReason("SonarQube quality gate with failed status.", taskContext, projectKey, projectName);
                    return this.failedTaskResult(taskContext, breakBuild);
                }
                String status2 = string2;
                if (option2 instanceof Some) {
                    String analysisId = (String)((Some)option2).value();
                    AnalysisInfo info = analysisInfo;
                    String string5 = status2;
                    String string6 = "SUCCESS";
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        this.debug(QgStatusBuildBreaker::checkTaskStatus$$anonfun$1);
                        return this.determineQualityGateStatus(taskContext, analysisId, info, breakBuild);
                    }
                }
                String status3 = string2;
                Option<String> projectKey2 = option3;
                Option<String> projectName2 = option4;
                this.reportFailReason(new StringBuilder(82).append("SonarQube quality gate task did not finish. SonarQube background task has status: ").append(status3).toString(), taskContext, projectKey2, projectName2);
                return this.failWithErrorTaskResult(taskContext, breakBuild);
            }
        }
        Either<ResponseError, AnalysisInfo> other = either;
        this.error(new StringBuilder(57).append("SonarQube quality gate detection failed. Reason unknown. ").append(other).toString());
        this.reportFailReason(new StringBuilder(57).append("SonarQube quality gate detection failed. Reason unknown. ").append(other).toString(), taskContext, this.reportFailReason$default$3(), this.reportFailReason$default$4());
        return this.failWithErrorTaskResult(taskContext, breakBuild);
    }

    private TaskResult failedTaskResult(TaskContext taskContext, boolean breakBuild) {
        if (breakBuild) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        return this.successfulTaskResult(taskContext);
    }

    private TaskResult failWithErrorTaskResult(TaskContext taskContext, boolean breakBuild) {
        if (breakBuild) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        return this.successfulTaskResult(taskContext);
    }

    private String reportFailReason(String message, TaskContext taskContext, Option<String> projectKey, Option<String> projectName) {
        this.addErrorLogEntry(message, taskContext);
        List enrichedQualityGates = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)QualityGateStatus$.MODULE$.apply("ERROR", new StringBuilder(7).append("Error: ").append(message).toString(), (String)projectKey.getOrElse(QgStatusBuildBreaker::$anonfun$1), (String)projectName.getOrElse(QgStatusBuildBreaker::$anonfun$2))), Nil$.MODULE$));
        return this.rememberQgStatus(taskContext.getBuildContext().getBuildResult(), enrichedQualityGates, taskContext);
    }

    private Option<String> reportFailReason$default$3() {
        return None$.MODULE$;
    }

    private Option<String> reportFailReason$default$4() {
        return None$.MODULE$;
    }

    private Option<String> determineCeTaskUrl(File sonarReportFile) {
        Option option;
        try (FileInputStream fs = new FileInputStream(sonarReportFile.getAbsolutePath());){
            try {
                Properties prop = new Properties();
                prop.load(fs);
                option = Option$.MODULE$.apply(prop.getProperty("ceTaskUrl"));
            }
            catch (IOException e) {
                this.error("Failed to load report-task.txt", e);
                option = None$.MODULE$;
            }
        }
        return option;
    }

    private TaskResult determineQualityGateStatus(TaskContext taskContext, String analysisId, AnalysisInfo analysisInfo, boolean breakBuild) {
        List failingQualityGates;
        Credentials credentials = Credentials$.MODULE$.by(taskContext, this.customVariableContext);
        String sonarHostUrl = (String)taskContext.getRuntimeTaskContext().get(SonarConstants$.MODULE$.SonarHostUrl());
        CurrentBuildResult buildResult = taskContext.getBuildContext().getBuildResult();
        Either<ResponseError, List<String>> either = this.sonarClient.getFailingQualityGates(analysisId, sonarHostUrl, credentials);
        if (either instanceof Left) {
            ResponseError error = (ResponseError)((Left)either).value();
            this.addErrorLogEntry(new StringBuilder(122).append("Failed to retrieve SonarQube quality gate status: ").append(error).append(" ").append("Have you enabled to use a configured Sonar server in the task settings?").toString(), taskContext);
            List enrichedQualityGates = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)QualityGateStatus$.MODULE$.apply("ERROR", "Error: Failed to get Quality gate report", (String)analysisInfo.projectKey().orNull($less$colon$less$.MODULE$.refl()), (String)analysisInfo.projectName().orNull($less$colon$less$.MODULE$.refl()))), Nil$.MODULE$));
            this.rememberQgStatus(buildResult, enrichedQualityGates, taskContext);
            return this.failWithErrorTaskResult(taskContext, breakBuild);
        }
        if (either instanceof Right && (failingQualityGates = (List)((Right)either).value()).nonEmpty()) {
            failingQualityGates.foreach(fqg -> this.addErrorLogEntry(new StringBuilder(31).append("Failed SonarQube quality gate: ").append((String)fqg).toString(), taskContext));
            Object enrichedQualityGates = failingQualityGates.map((Function1<String, QualityGateStatus> & Serializable)message -> QualityGateStatus$.MODULE$.apply("ERROR", (String)message, (String)analysisInfo.projectKey().orNull($less$colon$less$.MODULE$.refl()), (String)analysisInfo.projectName().orNull($less$colon$less$.MODULE$.refl())));
            this.rememberQgStatus(buildResult, (List<QualityGateStatus>)enrichedQualityGates, taskContext);
            return this.failedTaskResult(taskContext, breakBuild);
        }
        List successfulResult = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)QualityGateStatus$.MODULE$.apply("SUCCESS", "All quality gates passed", (String)analysisInfo.projectKey().orNull($less$colon$less$.MODULE$.refl()), (String)analysisInfo.projectName().orNull($less$colon$less$.MODULE$.refl()))), Nil$.MODULE$));
        this.rememberQgStatus(buildResult, successfulResult, taskContext);
        return this.successfulTaskResult(taskContext);
    }

    private String rememberQgStatus(CurrentBuildResult buildResult, List<QualityGateStatus> enrichedQualityGates, TaskContext taskContext) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply(buildResult.getCustomBuildData().get(SonarConstants$.MODULE$.SonarTasksFailedQualityGates())).map((Function1<String, TaskResultQualityGates[]> & Serializable)_$3 -> {
            Object object = Predef$.MODULE$.refArrayOps(SonarBuildResultSummary$.MODULE$.fromTaskResultQualityGates((String)_$3));
            return (TaskResultQualityGates[])ArrayOps$.MODULE$.toArray$extension(object, ClassTag$.MODULE$.apply(TaskResultQualityGates.class));
        }).getOrElse(QgStatusBuildBreaker::$anonfun$5));
        TaskResultQualityGates[] gates = (TaskResultQualityGates[])ArrayOps$.MODULE$.$colon$plus$extension(object, TaskResultQualityGates$.MODULE$.apply(taskContext.getId(), enrichedQualityGates), ClassTag$.MODULE$.apply(TaskResultQualityGates.class));
        return buildResult.getCustomBuildData().put(SonarConstants$.MODULE$.SonarTasksFailedQualityGates(), SonarBuildResultSummary$.MODULE$.toTaskResultQualityGates(gates));
    }

    private TaskResult successfulTaskResult(TaskContext taskContext) {
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    private Either<ResponseError, AnalysisInfo> executeUntilTaskStatusReady(TaskContext taskContext, String ceTaskUrl, int numRuns) {
        Either<ResponseError, JSONObject> either;
        while (true) {
            if (numRuns == this.MaxIterationsToGetQualityGateStatus) {
                return package$.MODULE$.Right().apply(AnalysisInfo$.MODULE$.apply(None$.MODULE$, None$.MODULE$, None$.MODULE$, None$.MODULE$));
            }
            List finishedStati = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"SUCCESS"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"CANCELED"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"FAILED"), Nil$.MODULE$))));
            Credentials credentials = Credentials$.MODULE$.by(taskContext, this.customVariableContext);
            either = this.sonarClient.getAnalysisStatus(ceTaskUrl, credentials);
            if (either instanceof Left) {
                ResponseError error = (ResponseError)((Left)either).value();
                return package$.MODULE$.Left().apply(error);
            }
            if (!(either instanceof Right)) break;
            JSONObject taskInfo = (JSONObject)((Right)either).value();
            String status = taskInfo.getString("status");
            if (finishedStati.contains(status)) {
                return package$.MODULE$.Right().apply(AnalysisInfo$.MODULE$.apply(Option$.MODULE$.apply(status), Option$.MODULE$.apply(taskInfo.optString("analysisId", null)), Option$.MODULE$.apply(taskInfo.optString("componentKey", null)), Option$.MODULE$.apply(taskInfo.optString("componentName", null))));
            }
            this.debug(QgStatusBuildBreaker::executeUntilTaskStatusReady$$anonfun$1);
            Thread.sleep(1000L);
            ++numRuns;
        }
        throw new MatchError(either);
    }

    private int executeUntilTaskStatusReady$default$3() {
        return 0;
    }

    private static final String checkTaskStatus$$anonfun$1() {
        return "SonarQube successful quality gate status.";
    }

    private static final String $anonfun$1() {
        return "Unknown";
    }

    private static final String $anonfun$2() {
        return "Unknown";
    }

    private static final TaskResultQualityGates[] $anonfun$5() {
        return (TaskResultQualityGates[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(TaskResultQualityGates.class));
    }

    private static final String executeUntilTaskStatusReady$$anonfun$1() {
        return "Trying to get SonarQube quality gate status...";
    }
}

