/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.config;

import ch.mibex.atlassian.dc.EvalAbuseDetected;
import ch.mibex.atlassian.dc.EvalAbuseDetected$;
import ch.mibex.atlassian.dc.InvalidLicenseInfo;
import ch.mibex.atlassian.dc.InvalidLicenseInfo$;
import ch.mibex.atlassian.dc.LicenseChecker;
import ch.mibex.atlassian.dc.LicenseIssue;
import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.SonarQubeEdition;
import ch.mibex.bamboo.sonar4bamboo.SonarQubeEdition$;
import ch.mibex.bamboo.sonar4bamboo.Utils$;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.BitbucketClient;
import ch.mibex.bamboo.sonar4bamboo.config.Action$;
import ch.mibex.bamboo.sonar4bamboo.config.AuthMode;
import ch.mibex.bamboo.sonar4bamboo.config.AuthMode$;
import ch.mibex.bamboo.sonar4bamboo.config.DatabaseError;
import ch.mibex.bamboo.sonar4bamboo.config.SharedServiceTokenOptions;
import ch.mibex.bamboo.sonar4bamboo.config.SharedServiceTokenOptions$;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServer;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServer$;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerConfigDao;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerEntity;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerEntityDTO;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerEntityDTO$;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials$;
import ch.mibex.bamboo.sonar4bamboo.sonar.ResponseError;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClient;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarVersions$;
import ch.mibex.bamboo.sonar4bamboo.telemetry.events.TelemetryEvents;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.bamboo.applinks.ImpersonationService;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionImpl;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public class SonarServerConfigAction
extends GlobalAdminAction
implements Logging {
    private Logger log;
    private final SonarServerConfigDao sonarServerConfigDao;
    private final SonarClient sonarClient;
    public final ApplicationLinkService ch$mibex$bamboo$sonar4bamboo$config$SonarServerConfigAction$$applicationLinkService;
    private final ImpersonationService impersonationService;
    private final LicenseChecker licenseChecker;
    private final VariableDefinitionManager variableDefinitionManager;
    private final EncryptionService encryptionService;
    private final TelemetryEvents telemetry;
    private final String CreateMode;
    private final String UpdateMode;
    private final String SonarServerNameField;
    private final String SonarHostUrlField;
    private final String SonarEditionField;
    private final String EnableQgBuildBreakerField;
    private final String AllowOverrideQgBuildBreakerField;
    private final String SonarServerDescriptionField;
    private final String SonarServerUsernameField;
    private final String ServerTokenBambooVarField;
    private final String AuthModeField;
    private final String SonarServerUsertokenField;
    private final String SonarServerPasswordField;
    private final String ServerPwBambooVarField;
    private final String SonarOrganizationKeyField;
    private final String BambooUserNameField;
    private final String AllowSharedServiceTokenField;
    private final String EmptyFieldErrorMsg;
    private final String UniqueFieldErrorMsg;
    private final String CannotUseLoginAndTokenMsg;
    private final String BranchingOptionsRequired;
    private final String UseLoginOrTokenMsg;
    private final String InvalidUrlMsg;
    private String action;
    private String editMode;
    private Integer serverConfigId;
    private String serverName;
    private String bambooUserName;
    private boolean enableQgBuildBreaker;
    private boolean allowOverrideQgBuildBreaker;
    private boolean addSonarProjectLink;
    private String serverHostUrl;
    private String displayServerUrl;
    private String serverDescription;
    private String authMode;
    private String serverUsername;
    private String serverPassword;
    private String serverPwBambooVar;
    private String serverUsertoken;
    private String serverTokenBambooVar;
    private String organizationKey;
    private String sonarEdition;
    private java.util.Map<String, String> sonarEditionOptions;
    private String allowSharedServiceToken;
    private java.util.Map<String, String> allowSharedServiceTokenOptions;
    private java.util.Map<String, String> authMethods;

    public SonarServerConfigAction(SonarServerConfigDao sonarServerConfigDao, SonarClient sonarClient, ApplicationLinkService applicationLinkService, ImpersonationService impersonationService, LicenseChecker licenseChecker, VariableDefinitionManager variableDefinitionManager, EncryptionService encryptionService, TelemetryEvents telemetry) {
        this.sonarServerConfigDao = sonarServerConfigDao;
        this.sonarClient = sonarClient;
        this.ch$mibex$bamboo$sonar4bamboo$config$SonarServerConfigAction$$applicationLinkService = applicationLinkService;
        this.impersonationService = impersonationService;
        this.licenseChecker = licenseChecker;
        this.variableDefinitionManager = variableDefinitionManager;
        this.encryptionService = encryptionService;
        this.telemetry = telemetry;
        Logging.$init$(this);
        this.CreateMode = "create";
        this.UpdateMode = "update";
        this.SonarServerNameField = "serverName";
        this.SonarHostUrlField = "serverHostUrl";
        this.SonarEditionField = "sonarEdition";
        this.EnableQgBuildBreakerField = "enableQgBuildBreaker";
        this.AllowOverrideQgBuildBreakerField = "allowOverrideQgBuildBreaker";
        this.SonarServerDescriptionField = "serverDescription";
        this.SonarServerUsernameField = "serverUsername";
        this.ServerTokenBambooVarField = "serverTokenBambooVar";
        this.AuthModeField = "authMode";
        this.SonarServerUsertokenField = "serverUsertoken";
        this.SonarServerPasswordField = "serverPassword";
        this.ServerPwBambooVarField = "serverPwBambooVar";
        this.SonarOrganizationKeyField = "organizationKey";
        this.BambooUserNameField = "bambooUserName";
        this.AllowSharedServiceTokenField = "allowSharedServiceToken";
        this.EmptyFieldErrorMsg = "sonar4bamboo.admin.server.error.empty";
        this.UniqueFieldErrorMsg = "sonar4bamboo.admin.server.error.unique";
        this.CannotUseLoginAndTokenMsg = "sonar4bamboo.admin.loginandtoken.error";
        this.BranchingOptionsRequired = "sonar4bamboo.admin.branchingoptions.required.error";
        this.UseLoginOrTokenMsg = "sonar4bamboo.admin.loginortoken.required.error";
        this.InvalidUrlMsg = "sonar4bamboo.admin.invalidurl";
        this.sonarEditionOptions = CollectionConverters$.MODULE$.MapHasAsJava(SonarQubeEdition$.MODULE$.editionDescriptionsWithoutBranchPluginOption()).asJava();
        Object object = Predef$.MODULE$.refArrayOps(SharedServiceTokenOptions$.MODULE$.values());
        this.allowSharedServiceTokenOptions = CollectionConverters$.MODULE$.MapHasAsJava(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<SharedServiceTokenOptions, Tuple2> & Serializable)v -> Tuple2$.MODULE$.apply(v.dbKey(), v.displayName()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap($less$colon$less$.MODULE$.refl())).asJava();
        Object object2 = Predef$.MODULE$.refArrayOps(AuthMode$.MODULE$.values());
        this.authMethods = CollectionConverters$.MODULE$.MapHasAsJava(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1<AuthMode, Tuple2> & Serializable)v -> Tuple2$.MODULE$.apply(v.dbKey(), v.displayName()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap($less$colon$less$.MODULE$.refl())).asJava();
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    @StrutsParameter
    public String getAction() {
        return this.action();
    }

    @StrutsParameter
    public void setAction(String action) {
        this.action_$eq(action);
    }

    @StrutsParameter
    public String getEditMode() {
        return this.editMode();
    }

    @StrutsParameter
    public void setEditMode(String editMode) {
        this.editMode_$eq(editMode);
    }

    @StrutsParameter
    public Integer getServerConfigId() {
        return this.serverConfigId();
    }

    @StrutsParameter
    public void setServerConfigId(Integer serverConfigId) {
        this.serverConfigId_$eq(serverConfigId);
    }

    @StrutsParameter
    public String getServerName() {
        return this.serverName();
    }

    @StrutsParameter
    public void setServerName(String serverName) {
        this.serverName_$eq(serverName);
    }

    @StrutsParameter
    public String getBambooUserName() {
        return this.bambooUserName();
    }

    @StrutsParameter
    public void setBambooUserName(String bambooUserName) {
        this.bambooUserName_$eq(bambooUserName);
    }

    @StrutsParameter
    public boolean getEnableQgBuildBreaker() {
        return this.enableQgBuildBreaker();
    }

    @StrutsParameter
    public void setEnableQgBuildBreaker(boolean enableQgBuildBreaker) {
        this.enableQgBuildBreaker_$eq(enableQgBuildBreaker);
    }

    @StrutsParameter
    public boolean getAllowOverrideQgBuildBreaker() {
        return this.allowOverrideQgBuildBreaker();
    }

    @StrutsParameter
    public void setAllowOverrideQgBuildBreaker(boolean allowOverrideQgBuildBreaker) {
        this.allowOverrideQgBuildBreaker_$eq(allowOverrideQgBuildBreaker);
    }

    @StrutsParameter
    public boolean getAddSonarProjectLink() {
        return this.addSonarProjectLink();
    }

    @StrutsParameter
    public void setAddSonarProjectLink(boolean addSonarProjectLink) {
        this.addSonarProjectLink_$eq(addSonarProjectLink);
    }

    @StrutsParameter
    public String getServerHostUrl() {
        return this.serverHostUrl();
    }

    @StrutsParameter
    public void setServerHostUrl(String serverHostUrl) {
        this.serverHostUrl_$eq(serverHostUrl);
    }

    @StrutsParameter
    public String getDisplayServerUrl() {
        return this.displayServerUrl();
    }

    @StrutsParameter
    public void setDisplayServerUrl(String displayServerUrl) {
        this.displayServerUrl_$eq(displayServerUrl);
    }

    @StrutsParameter
    public String getServerDescription() {
        return this.serverDescription();
    }

    @StrutsParameter
    public void setServerDescription(String serverDescription) {
        this.serverDescription_$eq(serverDescription);
    }

    @StrutsParameter
    public String getAuthMode() {
        return this.authMode();
    }

    @StrutsParameter
    public void setAuthMode(String authMode) {
        this.authMode_$eq(authMode);
    }

    @StrutsParameter
    public String getServerUsername() {
        return this.serverUsername();
    }

    @StrutsParameter
    public void setServerUsername(String serverUsername) {
        this.serverUsername_$eq(serverUsername);
    }

    @StrutsParameter
    public String getServerPassword() {
        return this.serverPassword();
    }

    @StrutsParameter
    public void setServerPassword(String serverPassword) {
        this.serverPassword_$eq(serverPassword);
    }

    @StrutsParameter
    public String getServerPwBambooVar() {
        return this.serverPwBambooVar();
    }

    @StrutsParameter
    public void setServerPwBambooVar(String serverPwBambooVar) {
        this.serverPwBambooVar_$eq(serverPwBambooVar);
    }

    @StrutsParameter
    public String getServerUsertoken() {
        return this.serverUsertoken();
    }

    @StrutsParameter
    public void setServerUsertoken(String serverUsertoken) {
        this.serverUsertoken_$eq(serverUsertoken);
    }

    @StrutsParameter
    public String getServerTokenBambooVar() {
        return this.serverTokenBambooVar();
    }

    @StrutsParameter
    public void setServerTokenBambooVar(String serverTokenBambooVar) {
        this.serverTokenBambooVar_$eq(serverTokenBambooVar);
    }

    @StrutsParameter
    public String getOrganizationKey() {
        return this.organizationKey();
    }

    @StrutsParameter
    public void setOrganizationKey(String organizationKey) {
        this.organizationKey_$eq(organizationKey);
    }

    @StrutsParameter
    public String getSonarEdition() {
        return this.sonarEdition();
    }

    @StrutsParameter
    public void setSonarEdition(String sonarEdition) {
        this.sonarEdition_$eq(sonarEdition);
    }

    @StrutsParameter
    public java.util.Map<String, String> getSonarEditionOptions() {
        return this.sonarEditionOptions();
    }

    @StrutsParameter
    public void setSonarEditionOptions(java.util.Map<String, String> sonarEditionOptions) {
        this.sonarEditionOptions_$eq(sonarEditionOptions);
    }

    @StrutsParameter
    public String getAllowSharedServiceToken() {
        return this.allowSharedServiceToken();
    }

    @StrutsParameter
    public void setAllowSharedServiceToken(String allowSharedServiceToken) {
        this.allowSharedServiceToken_$eq(allowSharedServiceToken);
    }

    @StrutsParameter
    public java.util.Map<String, String> getAllowSharedServiceTokenOptions() {
        return this.allowSharedServiceTokenOptions();
    }

    @StrutsParameter
    public void setAllowSharedServiceTokenOptions(java.util.Map<String, String> allowSharedServiceTokenOptions) {
        this.allowSharedServiceTokenOptions_$eq(allowSharedServiceTokenOptions);
    }

    @StrutsParameter
    public java.util.Map<String, String> getAuthMethods() {
        return this.authMethods();
    }

    @StrutsParameter
    public void setAuthMethods(java.util.Map<String, String> authMethods) {
        this.authMethods_$eq(authMethods);
    }

    public String CreateMode() {
        return this.CreateMode;
    }

    public String UpdateMode() {
        return this.UpdateMode;
    }

    public String SonarServerNameField() {
        return this.SonarServerNameField;
    }

    public String SonarHostUrlField() {
        return this.SonarHostUrlField;
    }

    public String SonarEditionField() {
        return this.SonarEditionField;
    }

    public String EnableQgBuildBreakerField() {
        return this.EnableQgBuildBreakerField;
    }

    public String AllowOverrideQgBuildBreakerField() {
        return this.AllowOverrideQgBuildBreakerField;
    }

    public String SonarServerDescriptionField() {
        return this.SonarServerDescriptionField;
    }

    public String SonarServerUsernameField() {
        return this.SonarServerUsernameField;
    }

    public String ServerTokenBambooVarField() {
        return this.ServerTokenBambooVarField;
    }

    public String AuthModeField() {
        return this.AuthModeField;
    }

    public String SonarServerUsertokenField() {
        return this.SonarServerUsertokenField;
    }

    public String SonarServerPasswordField() {
        return this.SonarServerPasswordField;
    }

    public String ServerPwBambooVarField() {
        return this.ServerPwBambooVarField;
    }

    public String SonarOrganizationKeyField() {
        return this.SonarOrganizationKeyField;
    }

    public String BambooUserNameField() {
        return this.BambooUserNameField;
    }

    public String AllowSharedServiceTokenField() {
        return this.AllowSharedServiceTokenField;
    }

    public String EmptyFieldErrorMsg() {
        return this.EmptyFieldErrorMsg;
    }

    public String UniqueFieldErrorMsg() {
        return this.UniqueFieldErrorMsg;
    }

    public String CannotUseLoginAndTokenMsg() {
        return this.CannotUseLoginAndTokenMsg;
    }

    public String BranchingOptionsRequired() {
        return this.BranchingOptionsRequired;
    }

    public String UseLoginOrTokenMsg() {
        return this.UseLoginOrTokenMsg;
    }

    public String InvalidUrlMsg() {
        return this.InvalidUrlMsg;
    }

    public String action() {
        return this.action;
    }

    public void action_$eq(String x$1) {
        this.action = x$1;
    }

    public String editMode() {
        return this.editMode;
    }

    public void editMode_$eq(String x$1) {
        this.editMode = x$1;
    }

    public Integer serverConfigId() {
        return this.serverConfigId;
    }

    public void serverConfigId_$eq(Integer x$1) {
        this.serverConfigId = x$1;
    }

    public String serverName() {
        return this.serverName;
    }

    public void serverName_$eq(String x$1) {
        this.serverName = x$1;
    }

    public String bambooUserName() {
        return this.bambooUserName;
    }

    public void bambooUserName_$eq(String x$1) {
        this.bambooUserName = x$1;
    }

    public boolean enableQgBuildBreaker() {
        return this.enableQgBuildBreaker;
    }

    public void enableQgBuildBreaker_$eq(boolean x$1) {
        this.enableQgBuildBreaker = x$1;
    }

    public boolean allowOverrideQgBuildBreaker() {
        return this.allowOverrideQgBuildBreaker;
    }

    public void allowOverrideQgBuildBreaker_$eq(boolean x$1) {
        this.allowOverrideQgBuildBreaker = x$1;
    }

    public boolean addSonarProjectLink() {
        return this.addSonarProjectLink;
    }

    public void addSonarProjectLink_$eq(boolean x$1) {
        this.addSonarProjectLink = x$1;
    }

    public String serverHostUrl() {
        return this.serverHostUrl;
    }

    public void serverHostUrl_$eq(String x$1) {
        this.serverHostUrl = x$1;
    }

    public String displayServerUrl() {
        return this.displayServerUrl;
    }

    public void displayServerUrl_$eq(String x$1) {
        this.displayServerUrl = x$1;
    }

    public String serverDescription() {
        return this.serverDescription;
    }

    public void serverDescription_$eq(String x$1) {
        this.serverDescription = x$1;
    }

    public String authMode() {
        return this.authMode;
    }

    public void authMode_$eq(String x$1) {
        this.authMode = x$1;
    }

    public String serverUsername() {
        return this.serverUsername;
    }

    public void serverUsername_$eq(String x$1) {
        this.serverUsername = x$1;
    }

    public String serverPassword() {
        return this.serverPassword;
    }

    public void serverPassword_$eq(String x$1) {
        this.serverPassword = x$1;
    }

    public String serverPwBambooVar() {
        return this.serverPwBambooVar;
    }

    public void serverPwBambooVar_$eq(String x$1) {
        this.serverPwBambooVar = x$1;
    }

    public String serverUsertoken() {
        return this.serverUsertoken;
    }

    public void serverUsertoken_$eq(String x$1) {
        this.serverUsertoken = x$1;
    }

    public String serverTokenBambooVar() {
        return this.serverTokenBambooVar;
    }

    public void serverTokenBambooVar_$eq(String x$1) {
        this.serverTokenBambooVar = x$1;
    }

    public String organizationKey() {
        return this.organizationKey;
    }

    public void organizationKey_$eq(String x$1) {
        this.organizationKey = x$1;
    }

    public String sonarEdition() {
        return this.sonarEdition;
    }

    public void sonarEdition_$eq(String x$1) {
        this.sonarEdition = x$1;
    }

    public java.util.Map<String, String> sonarEditionOptions() {
        return this.sonarEditionOptions;
    }

    public void sonarEditionOptions_$eq(java.util.Map<String, String> x$1) {
        this.sonarEditionOptions = x$1;
    }

    public String allowSharedServiceToken() {
        return this.allowSharedServiceToken;
    }

    public void allowSharedServiceToken_$eq(String x$1) {
        this.allowSharedServiceToken = x$1;
    }

    public java.util.Map<String, String> allowSharedServiceTokenOptions() {
        return this.allowSharedServiceTokenOptions;
    }

    public void allowSharedServiceTokenOptions_$eq(java.util.Map<String, String> x$1) {
        this.allowSharedServiceTokenOptions = x$1;
    }

    public java.util.Map<String, String> authMethods() {
        return this.authMethods;
    }

    public void authMethods_$eq(java.util.Map<String, String> x$1) {
        this.authMethods = x$1;
    }

    public String doDefault() {
        Option$.MODULE$.apply(this.action()).foreach(_$1 -> this.addActionMessage(this.getText(new StringBuilder(35).append("sonar4bamboo.admin.messages.action.").append(this.action()).toString())));
        return Action$.MODULE$.SUCCESS();
    }

    public java.util.List<String> getLicenseIssues() {
        Option<LicenseIssue> option = this.validatePluginLicense();
        if (option instanceof Some) {
            LicenseIssue licenseIssue = (LicenseIssue)((Some)option).value();
            if (licenseIssue instanceof InvalidLicenseInfo) {
                String string2;
                InvalidLicenseInfo invalidLicenseInfo = InvalidLicenseInfo$.MODULE$.unapply((InvalidLicenseInfo)licenseIssue);
                String reason = string2 = invalidLicenseInfo._1();
                return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)reason), Nil$.MODULE$))).asJava();
            }
            if (licenseIssue instanceof EvalAbuseDetected) {
                EvalAbuseDetected evalAbuseDetected = EvalAbuseDetected$.MODULE$.unapply((EvalAbuseDetected)licenseIssue);
                String string3 = evalAbuseDetected._1();
                String string4 = evalAbuseDetected._2();
                String reason = string3;
                String contactLink = string4;
                return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)reason), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)contactLink), Nil$.MODULE$)))).asJava();
            }
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(package$.MODULE$.List().empty()).asJava();
    }

    private Option<LicenseIssue> validatePluginLicense() {
        return this.licenseChecker.validateLicense(Utils$.MODULE$.LicenseTexts(), (Function0<Object>)((Function0<Boolean> & Serializable)SonarServerConfigAction::validatePluginLicense$$anonfun$1), this.licenseChecker.validateLicense$default$3());
    }

    public int getServerConfigsWithPasswords() {
        return this.sonarServerConfigDao.findAll().count((Function1<SonarServerEntity, Boolean> & Serializable)c -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((String)Option$.MODULE$.apply(c.getServerUsertoken()).getOrElse(SonarServerConfigAction::getServerConfigsWithPasswords$$anonfun$1$$anonfun$1)).trim())) || StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((String)Option$.MODULE$.apply(c.getServerPassword()).getOrElse(SonarServerConfigAction::getServerConfigsWithPasswords$$anonfun$1$$anonfun$2)).trim())) || StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((String)Option$.MODULE$.apply(c.getJdbcPassword()).getOrElse(SonarServerConfigAction::getServerConfigsWithPasswords$$anonfun$1$$anonfun$3)).trim())));
    }

    @StrutsParameter(depth=1)
    public java.util.List<SonarServerEntityDTO> getSonarServerConfigs() {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)this.sonarServerConfigDao.findAll().map((Function1<SonarServerEntity, SonarServerEntity> & Serializable)s -> {
            s.setServerUsername((String)Credentials$.MODULE$.decrypt(Option$.MODULE$.apply(s.getServerUsername()), this.encryptionService).orNull($less$colon$less$.MODULE$.refl()));
            return (SonarServerEntity)this.migrateConfigsWithNoEdition((SonarServerEntity)s).fold((Function1<RuntimeException, SonarServerEntity> & Serializable)e -> {
                this.addActionError(this.getTextWithArgs("sonar4bamboo.admin.messages.action.editionMigrationFailed", new String[]{s.getServerName(), e.getMessage()}));
                return s;
            }, (Function1<SonarServerEntity, SonarServerEntity> & Serializable)x -> Predef$.MODULE$.identity(x));
        })).map((Function1<SonarServerEntity, SonarServerEntityDTO> & Serializable)sonarServerEntity -> SonarServerEntityDTO$.MODULE$.apply((SonarServerEntity)sonarServerEntity))).asJava();
    }

    private Either<RuntimeException, SonarServerEntity> migrateConfigsWithNoEdition(SonarServerEntity serverConfig) {
        if (this.isEmptyOrNull(serverConfig.getSonarEdition())) {
            Either<ResponseError, SonarQubeEdition> either = this.sonarClient.getSonarQubeEdition(serverConfig.getServerHostUrl(), this.getServerCredentials(), this.sonarClient.getSonarQubeEdition$default$3());
            if (either instanceof Right) {
                SonarQubeEdition edition = (SonarQubeEdition)((Right)either).value();
                return (Either)this.sonarServerConfigDao.updateSonarEdition(serverConfig.getID(), edition).fold((Function1<DatabaseError, Either> & Serializable)e -> package$.MODULE$.Left().apply(new RuntimeException(e.msgKey())), (Function1<SonarServerEntity, Either> & Serializable)s -> package$.MODULE$.Right().apply(s));
            }
            if (either instanceof Left) {
                ResponseError err = (ResponseError)((Left)either).value();
                return package$.MODULE$.Left().apply(new RuntimeException(err.reason()));
            }
            throw new MatchError(either);
        }
        return package$.MODULE$.Right().apply(serverConfig);
    }

    @StrutsParameter(depth=2)
    public java.util.List<VariableDefinition> getBambooVariables() {
        VariableDefinitionImpl noneVar = new VariableDefinitionImpl();
        noneVar.setKey("");
        noneVar.setValue("");
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.variableDefinitionManager.getGlobalVariables()).asScala().$plus$colon(noneVar)).asJava();
    }

    private Option<String> checkPluginLicense() {
        Option<LicenseIssue> option = this.validatePluginLicense();
        if (option instanceof Some) {
            LicenseIssue licenseIssue = (LicenseIssue)((Some)option).value();
            if (licenseIssue instanceof InvalidLicenseInfo) {
                String string2;
                InvalidLicenseInfo invalidLicenseInfo = InvalidLicenseInfo$.MODULE$.unapply((InvalidLicenseInfo)licenseIssue);
                String reason = string2 = invalidLicenseInfo._1();
                this.addActionError(reason);
                return Some$.MODULE$.apply(Action$.MODULE$.ERROR());
            }
            if (licenseIssue instanceof EvalAbuseDetected) {
                EvalAbuseDetected evalAbuseDetected = EvalAbuseDetected$.MODULE$.unapply((EvalAbuseDetected)licenseIssue);
                String string3 = evalAbuseDetected._1();
                String string4 = evalAbuseDetected._2();
                String reason = string3;
                this.addActionError(reason);
                return Some$.MODULE$.apply(Action$.MODULE$.ERROR());
            }
        }
        return None$.MODULE$;
    }

    public String doAdd() {
        this.editMode_$eq(this.CreateMode());
        this.detectSonarEdition().foreach(e -> this.sonarEdition_$eq(e.dbKey()));
        this.initFormFieldsWhenCreate();
        return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doAdd$$anonfun$2);
    }

    public String doEdit() {
        this.editMode_$eq(this.UpdateMode());
        Option<SonarServerEntity> option = this.sonarServerConfigDao.findById(Predef$.MODULE$.Integer2int(this.serverConfigId()));
        if (option instanceof Some) {
            SonarServerEntity server = (SonarServerEntity)((Some)option).value();
            this.initFormFields(server);
            this.addBranchPluginOptionIfSonarEditionIsCommunityBranch(server.getSonarEdition());
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doEdit$$anonfun$1);
        }
        if (None$.MODULE$.equals(option)) {
            this.addActionError(this.getText("sonar4bamboo.admin.no.server.found"));
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doEdit$$anonfun$2);
        }
        throw new MatchError(option);
    }

    public String doDelete() {
        Option<SonarServerEntity> option = this.sonarServerConfigDao.findById(Predef$.MODULE$.Integer2int(this.serverConfigId()));
        if (option instanceof Some) {
            SonarServerEntity server = (SonarServerEntity)((Some)option).value();
            this.initFormFields(server);
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doDelete$$anonfun$1);
        }
        if (None$.MODULE$.equals(option)) {
            this.addActionError(this.getText("sonar4bamboo.admin.no.server.found"));
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doDelete$$anonfun$2);
        }
        throw new MatchError(option);
    }

    public String doRemove() {
        Option<DatabaseError> option = this.sonarServerConfigDao.delete(Predef$.MODULE$.Integer2int(this.serverConfigId()));
        if (option instanceof Some) {
            DatabaseError failure = (DatabaseError)((Some)option).value();
            this.addActionError(this.getText(failure.msgKey()));
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doRemove$$anonfun$1);
        }
        if (None$.MODULE$.equals(option)) {
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doRemove$$anonfun$2);
        }
        throw new MatchError(option);
    }

    public String doUpdate() {
        this.editMode_$eq(this.UpdateMode());
        if (this.isEmptyOrNull(this.sonarEdition())) {
            this.detectSonarEdition().foreach(e -> this.sonarEdition_$eq(e.dbKey()));
        }
        Option<ArtifactVersion> version = this.validateSonarServer();
        this.validateAuthentication();
        if (this.hasAnyErrors()) {
            this.debug(this::doUpdate$$anonfun$2);
            this.addBranchPluginOptionIfSonarEditionIsCommunityBranch(this.sonarEdition());
            this.addActionError(this.getText("sonar4bamboo.admin.server.task.validation.errors"));
            return Action$.MODULE$.ERROR();
        }
        Either<DatabaseError, SonarServerEntity> either = this.sonarServerConfigDao.update(Predef$.MODULE$.Integer2int(this.serverConfigId()), this.collectFormSettings());
        if (either instanceof Left) {
            DatabaseError failure = (DatabaseError)((Left)either).value();
            this.addActionError(this.getText(failure.msgKey()));
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doUpdate$$anonfun$3);
        }
        if (either instanceof Right) {
            SonarServerEntity updatedConfig = (SonarServerEntity)((Right)either).value();
            int amountOfServers = this.sonarServerConfigDao.count();
            this.telemetry.serverConfigured("UPDATED", amountOfServers, version, updatedConfig);
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doUpdate$$anonfun$4);
        }
        throw new MatchError(either);
    }

    public String doCreate() {
        this.editMode_$eq(this.CreateMode());
        this.detectSonarEdition().foreach(e -> this.sonarEdition_$eq(e.dbKey()));
        this.authMode_$eq(AuthMode$.TokenAuth.dbKey());
        Option<ArtifactVersion> version = this.validateSonarServer();
        this.validateAuthentication();
        if (this.hasAnyErrors()) {
            this.debug(this::doCreate$$anonfun$2);
            this.addActionError(this.getText("sonar4bamboo.admin.server.task.validation.errors"));
            return Action$.MODULE$.ERROR();
        }
        SonarServerEntity newSonarServerConfig = this.sonarServerConfigDao.create(this.collectFormSettings());
        this.serverConfigId_$eq(Predef$.MODULE$.int2Integer(newSonarServerConfig.getID()));
        int amountOfServers = this.sonarServerConfigDao.count();
        this.telemetry.serverConfigured("ADDED", amountOfServers, version, newSonarServerConfig);
        return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doCreate$$anonfun$3);
    }

    private void addBranchPluginOptionIfSonarEditionIsCommunityBranch(String edition) {
        String string2 = SonarQubeEdition$.COMMUNITY_EDITION_BRANCH.dbKey();
        String string3 = edition;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String string4 = Predef$.MODULE$.ArrowAssoc(SonarQubeEdition$.COMMUNITY_EDITION_BRANCH.dbKey());
            this.sonarEditionOptions_$eq(CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(this.sonarEditionOptions()).asScala().toMap($less$colon$less$.MODULE$.refl()).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, SonarQubeEdition$.COMMUNITY_EDITION_BRANCH.displayName()))).asJava());
            return;
        }
    }

    private SonarServer collectFormSettings() {
        String string2 = this.serverName();
        String string3 = this.serverHostUrl();
        String string4 = this.displayServerUrl();
        boolean bl = this.enableQgBuildBreaker();
        boolean bl2 = this.allowOverrideQgBuildBreaker();
        boolean bl3 = SharedServiceTokenOptions$.MODULE$.isSharedTokenConfigAllowed(this.allowSharedServiceToken());
        boolean bl4 = this.addSonarProjectLink();
        String string5 = this.serverDescription();
        String string6 = this.bambooUserName();
        String string7 = AuthMode$.MODULE$.isSimpleAuth(this.authMode()) ? this.serverUsername() : null;
        String string8 = AuthMode$.MODULE$.isSimpleAuth(this.authMode()) ? this.serverPassword() : null;
        String string9 = AuthMode$.MODULE$.isSimpleAuth(this.authMode()) ? this.serverPwBambooVar() : null;
        String string10 = AuthMode$.MODULE$.isTokenAuth(this.authMode()) ? this.serverUsertoken() : null;
        String string11 = AuthMode$.MODULE$.isTokenAuth(this.authMode()) ? this.serverTokenBambooVar() : null;
        String string12 = this.organizationKey();
        String string13 = this.sonarEdition();
        return SonarServer$.MODULE$.apply(string2, string3, string4, bl, bl2, bl3, bl4, string5, string12, string6, string7, string8, string9, string10, string11, string13);
    }

    private void initFormFieldsWhenCreate() {
        String string2 = this.editMode();
        String string3 = this.CreateMode();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.allowOverrideQgBuildBreaker_$eq(true);
            this.allowSharedServiceToken_$eq(SharedServiceTokenOptions$.ALLOW_SHARED_AUTH.dbKey());
            return;
        }
    }

    private boolean isEmptyOrNull(String value) {
        return ((String)Option$.MODULE$.apply(value).getOrElse(SonarServerConfigAction::isEmptyOrNull$$anonfun$1)).trim().isEmpty();
    }

    private boolean isNonEmpty(String value) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((String)Option$.MODULE$.apply(value).getOrElse(SonarServerConfigAction::isNonEmpty$$anonfun$1)).trim()));
    }

    private Option<SonarQubeEdition> detectSonarEdition() {
        if (!this.isEmptyOrNull(this.sonarEdition())) {
            return Some$.MODULE$.apply(SonarQubeEdition$.MODULE$.valueOf(this.sonarEdition()));
        }
        if (this.isEmptyOrNull(this.serverHostUrl())) {
            return None$.MODULE$;
        }
        Either<ResponseError, SonarQubeEdition> either = this.sonarClient.getSonarQubeEdition(this.serverHostUrl(), this.getServerCredentials(), this.sonarClient.getSonarQubeEdition$default$3());
        if (either instanceof Left) {
            ResponseError error = (ResponseError)((Left)either).value();
            if (error.statusCode() == 401 && !SharedServiceTokenOptions$.MODULE$.isSharedTokenConfigAllowed(this.allowSharedServiceToken())) {
                this.addFieldError(this.SonarEditionField(), this.getText("sonar4bamboo.admin.server.sonaredition.missing"));
            } else {
                this.addFieldError(this.SonarHostUrlField(), error.reason());
            }
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            SonarQubeEdition edition = (SonarQubeEdition)((Right)either).value();
            return Option$.MODULE$.apply(edition);
        }
        throw new MatchError(either);
    }

    private void validateAuthentication() {
        if (!SharedServiceTokenOptions$.MODULE$.isSharedTokenConfigAllowed(this.allowSharedServiceToken())) {
            return;
        }
        if (AuthMode$.MODULE$.isSimpleAuth(this.authMode()) && this.isEmptyOrNull(this.serverUsername())) {
            this.addFieldError(this.SonarServerUsernameField(), this.getText(this.EmptyFieldErrorMsg()));
        }
        if (AuthMode$.MODULE$.isSimpleAuth(this.authMode()) && this.isEmptyOrNull(this.serverPwBambooVar()) && this.isEmptyOrNull(this.serverPassword())) {
            this.addFieldError(this.ServerPwBambooVarField(), this.getText(this.EmptyFieldErrorMsg()));
        }
        if (AuthMode$.MODULE$.isTokenAuth(this.authMode()) && this.isEmptyOrNull(this.serverTokenBambooVar()) && this.isEmptyOrNull(this.serverUsertoken())) {
            this.addFieldError(this.ServerTokenBambooVarField(), this.getText(this.EmptyFieldErrorMsg()));
        }
        if (this.isNonEmpty(this.serverUsertoken()) && this.isNonEmpty(this.serverTokenBambooVar())) {
            this.addFieldError(this.SonarServerUsertokenField(), this.getText("sonar4bamboo.admin.server.notvariableandtoken"));
        }
        if (this.isNonEmpty(this.serverPwBambooVar()) && this.isNonEmpty(this.serverPassword())) {
            this.addFieldError(this.SonarServerPasswordField(), this.getText("sonar4bamboo.admin.server.notvariableandpassword"));
        }
        if (this.isNonEmpty(this.serverPwBambooVar()) && !PasswordMaskingUtils.shouldBeMasked((String)this.serverPwBambooVar())) {
            this.addFieldError(this.ServerPwBambooVarField(), this.getText("sonar4bamboo.admin.server.nopwvariable"));
        }
        if (this.isNonEmpty(this.serverTokenBambooVar()) && !PasswordMaskingUtils.shouldBeMasked((String)this.serverTokenBambooVar())) {
            this.addFieldError(this.ServerTokenBambooVarField(), this.getText("sonar4bamboo.admin.server.nopwvariable"));
            return;
        }
    }

    private Option<ArtifactVersion> validateSonarServer() {
        if (this.isNonEmpty(this.bambooUserName())) {
            this.checkBitbucketConnection();
        }
        if (this.isEmptyOrNull(this.serverName())) {
            this.addFieldError(this.SonarServerNameField(), this.getText(this.EmptyFieldErrorMsg()));
        } else if (this.serverNameExists(this.serverName())) {
            this.addFieldError(this.SonarServerNameField(), this.getText(this.UniqueFieldErrorMsg()));
        } else if (this.isEmptyOrNull(this.serverHostUrl())) {
            this.addFieldError(this.SonarHostUrlField(), this.getText(this.EmptyFieldErrorMsg()));
        } else if (!this.isValidURI(this.serverHostUrl())) {
            this.addFieldError(this.SonarHostUrlField(), this.getText(this.InvalidUrlMsg()));
        } else {
            return this.checkServerConnection();
        }
        return None$.MODULE$;
    }

    private boolean isValidURI(String uri) {
        boolean bl;
        try {
            URI uRI = URI.create(uri);
            bl = true;
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private boolean serverNameExists(String serverName) {
        Object existingId = Option$.MODULE$.apply(this.serverConfigId()).getOrElse(SonarServerConfigAction::$anonfun$1);
        return this.sonarServerConfigDao.findAll().exists((Function1<SonarServerEntity, Boolean> & Serializable)e -> {
            String string2 = e.getServerName();
            String string3 = serverName;
            return !(string2 != null ? !string2.equals(string3) : string3 != null) && !BoxesRunTime.equals(BoxesRunTime.boxToInteger(e.getID()), existingId);
        });
    }

    private void checkBitbucketConnection() {
        this.impersonationService.runAsUser(this.bambooUserName(), (Callable)new Callable<BoxedUnit>(this){
            private final /* synthetic */ SonarServerConfigAction $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void call() {
                BitbucketClient client = new BitbucketClient(this.$outer.ch$mibex$bamboo$sonar4bamboo$config$SonarServerConfigAction$$applicationLinkService);
                try {
                    client.checkBitbucketConnection();
                }
                catch (CredentialsRequiredException e) {
                    String authUrl = e.getAuthorisationURI().toString();
                    this.$outer.addFieldError(this.$outer.BambooUserNameField(), this.$outer.getText("sonar4bamboo.admin.applink.error", new String[]{authUrl}));
                }
                catch (Exception e) {
                    this.$outer.addFieldError(this.$outer.BambooUserNameField(), e.getMessage());
                }
            }
        }).call();
    }

    private Option<ArtifactVersion> checkServerConnection() {
        Option option;
        block12: {
            try {
                Either<ResponseError, ArtifactVersion> either = this.sonarClient.getSonarVersion(this.serverHostUrl());
                if (either instanceof Left) {
                    ResponseError err = (ResponseError)((Left)either).value();
                    this.addFieldError(this.SonarHostUrlField(), this.getText("sonar4bamboo.admin.server.error.connecting", new String[]{err.reason()}));
                    option = None$.MODULE$;
                    break block12;
                }
                if (either instanceof Right) {
                    ArtifactVersion artifactVersion = (ArtifactVersion)((Right)either).value();
                    ArtifactVersion version = artifactVersion;
                    if (version.compareTo((Object)SonarVersions$.MODULE$.RequiredMinimumVersion()) < 0) {
                        this.addFieldError(this.SonarHostUrlField(), this.getTextWithArgs("sonar4bamboo.admin.server.error.wrongversion", new String[]{SonarVersions$.MODULE$.RequiredMinimumVersion().toString()}));
                        option = None$.MODULE$;
                    } else {
                        ArtifactVersion version2 = artifactVersion;
                        if (SharedServiceTokenOptions$.MODULE$.isSharedTokenConfigAllowed(this.allowSharedServiceToken())) {
                            boolean success;
                            Either<ResponseError, Object> either2 = this.sonarClient.authenticate(this.serverHostUrl(), this.getServerCredentials());
                            if (either2 instanceof Left) {
                                ResponseError err = (ResponseError)((Left)either2).value();
                                this.addFieldError(this.SonarHostUrlField(), this.getText("sonar4bamboo.admin.server.error.connecting", new String[]{err.reason()}));
                                option = None$.MODULE$;
                            } else if (either2 instanceof Right && !(success = BoxesRunTime.unboxToBoolean(((Right)either2).value()))) {
                                this.addFieldError(this.isNonEmpty(this.serverTokenBambooVar()) ? this.ServerTokenBambooVarField() : (this.isNonEmpty(this.serverUsertoken()) ? this.SonarServerUsertokenField() : (this.isNonEmpty(this.serverUsername()) ? this.SonarServerUsernameField() : this.SonarHostUrlField())), this.getText("sonar4bamboo.admin.auth.error"));
                                option = None$.MODULE$;
                            } else {
                                option = Some$.MODULE$.apply(version2);
                            }
                        } else {
                            ArtifactVersion version3 = artifactVersion;
                            option = Some$.MODULE$.apply(version3);
                        }
                    }
                    break block12;
                }
                throw new MatchError(either);
            }
            catch (Exception e) {
                this.addFieldError(this.SonarHostUrlField(), this.getText("sonar4bamboo.admin.server.error.connecting", new String[]{e.getMessage()}));
                option = None$.MODULE$;
            }
        }
        return option;
    }

    private Credentials getServerCredentials() {
        if (AuthMode$.MODULE$.isSimpleAuth(this.authMode())) {
            String pwVariable;
            Option<String> login = Option$.MODULE$.apply(this.serverUsername()).filter((Function1<String, Object>)(Function1<String, Boolean> & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2.trim())));
            Option<String> option = Option$.MODULE$.apply(this.serverPwBambooVar());
            Option<String> pw = option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((pwVariable = (String)((Some)option).value()).trim())) ? Credentials$.MODULE$.getVariableValue(pwVariable, this.variableDefinitionManager) : Credentials$.MODULE$.decrypt(Option$.MODULE$.apply(this.serverPassword()), this.encryptionService);
            return Credentials$.MODULE$.apply((String)login.orNull($less$colon$less$.MODULE$.refl()), pw);
        }
        None$ token = this.isNonEmpty(this.serverTokenBambooVar()) ? Credentials$.MODULE$.getVariableValue(this.serverTokenBambooVar(), this.variableDefinitionManager) : (this.isNonEmpty(this.serverUsertoken()) ? Credentials$.MODULE$.decrypt(Option$.MODULE$.apply(this.serverUsertoken()), this.encryptionService) : None$.MODULE$);
        return Credentials$.MODULE$.apply((String)token.orNull($less$colon$less$.MODULE$.refl()), None$.MODULE$);
    }

    private void initFormFields(SonarServerEntity server) {
        this.serverConfigId_$eq(Predef$.MODULE$.int2Integer(server.getID()));
        this.serverName_$eq(server.getServerName());
        this.enableQgBuildBreaker_$eq(BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply(server.getEnableQgBuildBreaker()).map((Function1<Boolean, Boolean> & Serializable)_$3 -> _$3).getOrElse(SonarServerConfigAction::initFormFields$$anonfun$2)));
        this.allowOverrideQgBuildBreaker_$eq(BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply(server.getOverrideQgBuildBreaker()).map((Function1<Boolean, Boolean> & Serializable)_$4 -> _$4).getOrElse(SonarServerConfigAction::initFormFields$$anonfun$4)));
        this.allowSharedServiceToken_$eq(SharedServiceTokenOptions$.MODULE$.optionFor(server).dbKey());
        this.addSonarProjectLink_$eq(BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply(server.getAddSonarProjectLink()).map((Function1<Boolean, Boolean> & Serializable)_$5 -> _$5).getOrElse(SonarServerConfigAction::initFormFields$$anonfun$6)));
        this.bambooUserName_$eq(server.getBambooUserName());
        this.serverUsername_$eq(server.getServerUsername());
        this.serverUsertoken_$eq(server.getServerUsertoken());
        this.serverTokenBambooVar_$eq(server.getServerTokenBambooVar());
        this.serverPassword_$eq(server.getServerPassword());
        this.serverPwBambooVar_$eq(server.getServerPwBambooVar());
        this.serverHostUrl_$eq(server.getServerHostUrl());
        this.displayServerUrl_$eq(server.getDisplayServerHostUrl());
        this.serverDescription_$eq(server.getServerDescription());
        this.authMode_$eq(AuthMode$.MODULE$.optionFor(server));
        this.organizationKey_$eq(server.getOrganizationKey());
        this.sonarEdition_$eq(this.isNonEmpty(server.getSonarEdition()) ? server.getSonarEdition() : (String)this.detectSonarEdition().map((Function1<SonarQubeEdition, String> & Serializable)_$6 -> _$6.dbKey()).orNull($less$colon$less$.MODULE$.refl()));
    }

    private static final boolean validatePluginLicense$$anonfun$1() {
        return true;
    }

    private static final String getServerConfigsWithPasswords$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final String getServerConfigsWithPasswords$$anonfun$1$$anonfun$2() {
        return "";
    }

    private static final String getServerConfigsWithPasswords$$anonfun$1$$anonfun$3() {
        return "";
    }

    private static final String doAdd$$anonfun$2() {
        return Action$.MODULE$.INPUT();
    }

    private static final String doEdit$$anonfun$1() {
        return Action$.MODULE$.INPUT();
    }

    private static final String doEdit$$anonfun$2() {
        return Action$.MODULE$.ERROR();
    }

    private static final String doDelete$$anonfun$1() {
        return Action$.MODULE$.INPUT();
    }

    private static final String doDelete$$anonfun$2() {
        return Action$.MODULE$.ERROR();
    }

    private static final String doRemove$$anonfun$1() {
        return Action$.MODULE$.ERROR();
    }

    private static final String doRemove$$anonfun$2() {
        return Action$.MODULE$.SUCCESS();
    }

    private final String doUpdate$$anonfun$2() {
        return new StringBuilder(18).append("Validation error: ").append(CollectionConverters$.MODULE$.MapHasAsScala(this.getFieldErrors()).asScala().mkString(",")).toString();
    }

    private static final String doUpdate$$anonfun$3() {
        return Action$.MODULE$.ERROR();
    }

    private static final String doUpdate$$anonfun$4() {
        return Action$.MODULE$.SUCCESS();
    }

    private final String doCreate$$anonfun$2() {
        return new StringBuilder(18).append("Validation error: ").append(CollectionConverters$.MODULE$.MapHasAsScala(this.getFieldErrors()).asScala().mkString(",")).toString();
    }

    private static final String doCreate$$anonfun$3() {
        return Action$.MODULE$.SUCCESS();
    }

    private static final String isEmptyOrNull$$anonfun$1() {
        return "";
    }

    private static final String isNonEmpty$$anonfun$1() {
        return "";
    }

    private static final Object $anonfun$1() {
        return BoxesRunTime.boxToInteger(-1);
    }

    private static final boolean initFormFields$$anonfun$2() {
        return false;
    }

    private static final boolean initFormFields$$anonfun$4() {
        return true;
    }

    private static final boolean initFormFields$$anonfun$6() {
        return false;
    }
}

