/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.atlassian.cache;

import ch.mibex.atlassian.Logging;
import ch.mibex.atlassian.cache.Cache$;
import ch.mibex.cache.CacheStats;
import ch.mibex.cache.CacheStats$;
import ch.mibex.telemetry.TelemetryContext;
import ch.mibex.telemetry.TelemetryEvent;
import ch.mibex.telemetry.events.globals$package$;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class Cache<Input, Key extends Serializable, Value>
implements ch.mibex.cache.Cache<Input, Key, Value>,
Logging {
    private volatile Logger ch$mibex$atlassian$Logging$$logger;
    private final Function1<Input, Key> computeKey0;
    private final Function1<Input, Value> computeValue0;
    private final String cacheName;
    private final Function1<Value, Object> cacheValue;
    private final TelemetryContext telemetry;
    private final com.atlassian.cache.Cache<Key, Value> cache;
    private final AtomicReference<CacheStats> hitsAndMisses;

    public static <Input, Key extends Serializable, Value> Function1<Value, Object> $lessinit$greater$default$8() {
        return Cache$.MODULE$.$lessinit$greater$default$8();
    }

    public Cache(Function1<Input, Key> computeKey0, Function1<Input, Value> computeValue0, boolean immutable, FiniteDuration expiringTime, int maxSize, CacheFactory cacheFactory, String cacheName, Function1<Value, Object> cacheValue, TelemetryContext telemetry) {
        this.computeKey0 = computeKey0;
        this.computeValue0 = computeValue0;
        this.cacheName = cacheName;
        this.cacheValue = cacheValue;
        this.telemetry = telemetry;
        Logging.$init$(this);
        CacheSettingsBuilder builder = new CacheSettingsBuilder().local().maxEntries(maxSize);
        builder = immutable ? builder.expireAfterAccess(expiringTime.toMillis(), TimeUnit.MILLISECONDS) : builder.expireAfterWrite(expiringTime.toMillis(), TimeUnit.MILLISECONDS);
        CacheSettings cacheSettings = builder.build();
        this.cache = cacheFactory.getCache(cacheName, null, cacheSettings);
        this.hitsAndMisses = new AtomicReference<CacheStats>(CacheStats$.MODULE$.apply(CacheStats$.MODULE$.$lessinit$greater$default$1(), CacheStats$.MODULE$.$lessinit$greater$default$2(), CacheStats$.MODULE$.$lessinit$greater$default$3()));
    }

    @Override
    public Logger ch$mibex$atlassian$Logging$$logger() {
        return this.ch$mibex$atlassian$Logging$$logger;
    }

    @Override
    public void ch$mibex$atlassian$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$atlassian$Logging$$logger = x$1;
    }

    private Key computeKey(Input input) {
        return (Key)((Serializable)this.computeKey0.apply(input));
    }

    private Value computeValue(Input input) {
        return this.computeValue0.apply(input);
    }

    @Override
    public Value get(Input input) {
        Key key = this.computeKey(input);
        Object value = this.access$1((Serializable)key, input, (com.atlassian.cache.Cache)this.cache);
        CacheStats stats = this.hitsAndMisses.get();
        if (stats.total() % 10L == 1L) {
            this.debug(() -> this.get$$anonfun$1(stats));
        }
        if (stats.total() % 1000L == 0L) {
            this.telemetry.collectEventDiscard(() -> this.get$$anonfun$2(stats));
        }
        return (Value)value;
    }

    public void removeAll() {
        this.cache.removeAll();
    }

    private final Object access$1(Serializable key$1, Object input$1, com.atlassian.cache.Cache cache) {
        Option<Object> option = Option$.MODULE$.apply(cache.get((Object)key$1));
        if (option instanceof Some) {
            Object value = ((Some)option).value();
            this.hitsAndMisses.updateAndGet(_$2 -> _$2.hit());
            return value;
        }
        if (None$.MODULE$.equals(option)) {
            Serializable serializable;
            Value newValue = this.computeValue(input$1);
            if (BoxesRunTime.unboxToBoolean(this.cacheValue.apply(newValue))) {
                this.hitsAndMisses.updateAndGet(_$3 -> _$3.miss());
                cache.put((Object)key$1, newValue);
                serializable = BoxedUnit.UNIT;
            } else {
                serializable = this.hitsAndMisses.updateAndGet(_$4 -> _$4.uncachable());
            }
            return newValue;
        }
        throw new MatchError(option);
    }

    private final String get$$anonfun$1(CacheStats stats$1) {
        return stats$1.stats(this.cacheName);
    }

    private final TelemetryEvent get$$anonfun$2(CacheStats stats$2) {
        return globals$package$.MODULE$.cacheEvent(stats$2, this.cacheName);
    }
}

