<html>

<head>
    <title>[@ww.text name='sonar4bamboo.admin.servers.title' /]</title>
    <meta name="decorator" content="adminpage">
    <style>
        .sonarPwDeprecationNotice {
            width: 350px;
        }
        .sonarServerNameColumn {
            width: 35%;
        }
        .sonarServerValuesColumn {
            width: 50%;
        }
        .sonarServerActionsColumn {
            width: 15%;
        }
    </style>
</head>

<body>

<h1>[@ww.text name='sonar4bamboo.admin.servers.title' /]</h1>

[@topRightAddButton /]

<p>[@ww.text name='sonar4bamboo.admin.servers.help' /]</p>

[@ww.actionmessage /]

[#if licenseIssues??]
[@ui.messageBox type='error' titleKey='sonar4bamboo.admin.license.error']
    ${licenseIssues}
[/@ui.messageBox]
[/#if]

[#if serverConfigsWithPasswords > 0]
    [@ui.messageBox type='warning' titleKey='sonar4bamboo.admin.passwords.deprecated.warning']
        [@ww.text name='sonar4bamboo.admin.passwords.deprecated.warning.text' /]
        <br>
        <a href="${req.contextPath}/download/resources/ch.mibex.bamboo.sonar4bamboo:sonar4bamboo-resources/images/pwDeprecationNotice.png">
            <img class="sonarPwDeprecationNotice" src="${req.contextPath}/download/resources/ch.mibex.bamboo.sonar4bamboo:sonar4bamboo-resources/images/pwDeprecationNotice.png" alt="Security alert instructions">
        </a>
    [/@ui.messageBox]
[/#if]

[#assign servers = sonarServerConfigs /]
[@ww.actionerror /]

[#if servers!?size > 0]
<table class="aui">
    <thead>
        <tr>
            <th class="sonarServerNameColumn">[@ww.text name='sonar4bamboo.admin.servers.name' /]</th>
            <th class="sonarServerValuesColumn">[@ww.text name='sonar4bamboo.admin.servers.values' /]</th>
            <th class="sonarServerActionsColumn">[@ww.text name='sonar4bamboo.admin.servers.actions' /]</th>
        </tr>
    </thead>
    <tbody>
        [#foreach serverConfig in servers]
            [@serverConfigTableEntry serverConfig /]
        [/#foreach]
    </tbody>
</table>
[#else]
    [@ui.messageBox type='warning' titleKey='sonar4bamboo.admin.none.found']
        [@ww.text name='sonar4bamboo.admin.none.found.text' /]
    [/@ui.messageBox]
[/#if]
</body>

</html>


[#macro topRightAddButton]
<div class="toolbar">
    <div class="aui-toolbar inline">
        <ul class="toolbar-group">
            <li class="toolbar-item">
                <a class="toolbar-trigger" href="[@ww.url action='addSonarServerConfig' namespace='/admin/sonar4bamboo' /]">
                    [@ww.text name='sonar4bamboo.admin.server.add' /]
                </a>
            </li>
        </ul>
    </div>
</div>
[/#macro]

[#macro serverConfigTableEntry serverConfig]
<tr>
    <td>
        [#if serverConfig.serverPassword()?has_content || serverConfig.serverUsertoken()?has_content || serverConfig.jdbcPassword()?has_content]
            <span class="aui-icon aui-icon-small aui-iconfont-warning" title="Configuration uses deprecated passwords or user tokens"></span>
        [/#if]
        <a href="[@ww.url action='editSonarServer' namespace='/admin/sonar4bamboo' /]?serverConfigId=${serverConfig.id()}">
            ${serverConfig.serverName()?html}
        </a>
        <br>
        [#if serverConfig.serverDescription()?has_content]
            <span class="subGrey">${serverConfig.serverDescription()}</span>
        [/#if]
    </td>
    <td>
        <strong>[@ww.text name='sonar4bamboo.admin.host.url' /]:</strong>
        <a href="${serverConfig.serverHostUrl()}">${serverConfig.serverHostUrl()}</a>
        <br>
        [#if !serverConfig.allowSharedServiceToken()]
            <strong>[@ww.text name='sonar4bamboo.admin.host.usertoken.planlevel.enforced.enabled' /]</strong>
        [#elseif serverConfig.serverUsername()?has_content]
            <strong>[@ww.text name='sonar4bamboo.admin.host.auth.simple.username.label' /]:</strong> ${serverConfig.serverUsername()}
        [#elseif serverConfig.serverUsertoken()?has_content || serverConfig.serverTokenBambooVar()?has_content]
            <strong>[@ww.text name='sonar4bamboo.admin.host.usertoken.auth.enabled' /]</strong>
        [#else]
            <strong>[@ww.text name='sonar4bamboo.admin.host.anonymous' /]</strong>
        [/#if]
        <br>
    </td>
    <td>
        <a href="[@ww.url action='editSonarServer' namespace='/admin/sonar4bamboo' /]?serverConfigId=${serverConfig.id()}">
            [@ww.text name='sonar4bamboo.admin.server.edit' /]
        </a>
        |
        <a href="[@ww.url action='deleteSonarServer' namespace='/admin/sonar4bamboo' /]?serverConfigId=${serverConfig.id()}">
            [@ww.text name='sonar4bamboo.admin.server.delete' /]
        </a>
        |
        <a href="[@ww.url action='viewSonarServerUsage' namespace='/admin/sonar4bamboo' /]?serverConfigId=${serverConfig.id()}">
            [@ww.text name='sonar4bamboo.admin.server.usage' /]
        </a>
    </td>
</tr>
[/#macro]