<h3>Branch and Pull Request Analysis</h3>

<div class="onlyCommunity">
    <div class="aui-message info"  id="branchCharCommunityLocation">
        <p>The SonarQube Community Edition does not know about branches and pull requests.
            A separate SonarQube project for each branch is used to show SonarQube information for pull requests and branches.
        </p>
        <p>Include Code Quality uses SonarQube project keys in the format<code class="code">&lt;projectKey&gt;:&lt;branchName&gt;</code> More details can be found in our
            <a  href="https://mibexsoftware.atlassian.net/l/c/gPbq6Qvq" title="https://mibexsoftware.atlassian.net/l/c/gPbq6Qvq" ><strong data-renderer-mark="true">Sonar Analysis Configuration</strong></a> guide
        </p>
    </div>

    [#-- branch char replacement options will be plugged into the dom depending on sonarEdition  --]
    <div id="branchCharContainer">
        [@ww.checkbox
            name="replaceSpecialBranchChars"
            id='replaceChars_community'
            labelKey="sonar4bamboo.taskconfig.replaceSpecialBranchChars"
            toggle="true"/]

        [@ui.bambooSection dependsOn='replaceSpecialBranchChars'showOn='true']
            [@ww.textfield
                name='illegalBranchCharsReplacement'
                id='illegalBranchCharsReplacement_community'
                labelKey='sonar4bamboo.taskconfig.illegalBranchCharsReplacement' /]
        [/@ui.bambooSection]
    </div>
    [@ww.checkbox
        name='disableAutoBranch' id="disableAutoBranchId"
        labelKey='sonar4bamboo.taskconfig.autobranch.disable'
        onchange='setAutoBranching();'
        toggle='true'/]

    [@ui.bambooSection dependsOn='disableAutoBranch' showOn='true']
        [@ww.textfield
        name='sonarBranch'
        labelKey='sonar4bamboo.taskconfig.sonarBranch' /]
    [/@ui.bambooSection]
</div>

<div class="onlyCommercial">
    [@ww.checkbox
        name='sonarPullRequestAnalysis'
        labelKey='sonar4bamboo.taskconfig.sonarPullRequestAnalysis'
        description=" "
        toggle='true'/]
    [@ui.bambooSection dependsOn='sonarPullRequestAnalysis' showOn='false']
        [@ww.textfield name='sonarMainBranch' labelKey='sonar4bamboo.taskconfig.sonarMainBranch' /]
    [/@ui.bambooSection]

    [@ww.checkbox
        name='legacyBranching'
        id='legacyBranchingId'
        labelKey='sonar4bamboo.taskconfig.legacyBranching'
        descriptionKey='sonar4bamboo.taskconfig.legacyBranching.description'
        toggle='true'/]

    [@ui.bambooSection id="branchCharSection" dependsOn='legacyBranching' showOn='true']
        <div id="branchCharCommercialLocation"/>
    [/@ui.bambooSection]
</div>

[@ww.hidden name='autoBranch' id='autoBranchId'/]

<script type="text/javascript">
    function setAutoBranching() {
        const autoBranchField = document.getElementById("autoBranchId")
        autoBranchField.value = !document.getElementById("disableAutoBranchId").checked
    }
    function initAutoBranching() {
        const autoBranchField = document.getElementById("autoBranchId")
        document.getElementById("disableAutoBranchId").checked = autoBranchField.value === 'false'
    }
    initAutoBranching()
</script>
