/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.atlassian.cache;

import ch.mibex.atlassian.Logging;
import ch.mibex.telemetry.TelemetryContext;
import ch.mibex.telemetry.TelemetryEvent;
import ch.mibex.telemetry.events.globals$package$;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;

public class Cache<Input, Key extends Serializable, Value>
implements ch.mibex.cache.Cache<Input, Key, Value> {
    private final Function1<Input, Key> computeKey0;
    private final Function1<Input, Value> computeValue0;
    private final Function1<Key, Object> isValueImmutable0;
    private final String cacheName;
    private final Logging logger;
    private final TelemetryContext telemetry;
    private final com.atlassian.cache.Cache<Key, Value> underlyingChangingCache;
    private final com.atlassian.cache.Cache<Key, Value> underlyingImmutableCache;
    private final AtomicReference<Tuple2<Object, Object>> hitsAndMisses;

    public Cache(Function1<Input, Key> computeKey0, Function1<Input, Value> computeValue0, Function1<Key, Object> isValueImmutable0, FiniteDuration expiringTime, int maxSize, FiniteDuration immutableValueExpiringTime, CacheFactory cacheFactory, String cacheName, Logging logger, TelemetryContext telemetry) {
        this.computeKey0 = computeKey0;
        this.computeValue0 = computeValue0;
        this.isValueImmutable0 = isValueImmutable0;
        this.cacheName = cacheName;
        this.logger = logger;
        this.telemetry = telemetry;
        CacheSettings changingCacheSettings = new CacheSettingsBuilder().local().expireAfterWrite(expiringTime.toMillis(), TimeUnit.MILLISECONDS).maxEntries(maxSize).build();
        this.underlyingChangingCache = cacheFactory.getCache(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(cacheName), "-changing"), null, changingCacheSettings);
        CacheSettings immutableCacheSettings = new CacheSettingsBuilder().local().expireAfterAccess(immutableValueExpiringTime.toMillis(), TimeUnit.MILLISECONDS).maxEntries(maxSize).build();
        this.underlyingImmutableCache = cacheFactory.getCache(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(cacheName), "-immutable"), null, immutableCacheSettings);
        this.hitsAndMisses = new AtomicReference<Tuple2.mcJJ.sp>(new Tuple2.mcJJ.sp(0L, 0L));
    }

    private Key computeKey(Input input) {
        return (Key)((Serializable)this.computeKey0.apply(input));
    }

    private Value computeValue(Input input) {
        return (Value)this.computeValue0.apply(input);
    }

    private boolean isValueImmutable(Key key) {
        return BoxesRunTime.unboxToBoolean((Object)this.isValueImmutable0.apply(key));
    }

    private String cacheStats(long hits, long misses) {
        return new StringBuilder(38).append("Cache [").append(this.cacheName).append("] stats: hits=").append(hits).append(", misses=").append(misses).append(", ratio=").append((double)hits / (double)(hits + misses)).toString();
    }

    @Override
    public Value get(Input input) {
        Key key = this.computeKey(input);
        Object value = this.isValueImmutable(key) ? this.access$1((Serializable)key, input, (com.atlassian.cache.Cache)this.underlyingImmutableCache) : this.access$1((Serializable)key, input, (com.atlassian.cache.Cache)this.underlyingChangingCache);
        Tuple2<Object, Object> tuple2 = this.hitsAndMisses.get();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long hits = tuple2._1$mcJ$sp();
        long misses = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(hits, misses);
        long hits2 = sp2._1$mcJ$sp();
        long misses2 = sp2._2$mcJ$sp();
        long totalCount = hits2 + misses2;
        if (totalCount % 100L == 1L) {
            this.logger.debug(() -> this.get$$anonfun$1(hits2, misses2));
        }
        if (totalCount % 1000L == 0L) {
            this.telemetry.collectEventDiscard((Function0<TelemetryEvent>)((Function0 & Serializable)() -> this.get$$anonfun$2(hits2, misses2)));
        }
        return (Value)value;
    }

    private final Object access$1(Serializable key$1, Object input$1, com.atlassian.cache.Cache cache) {
        Option option = Option$.MODULE$.apply(cache.get((Object)key$1));
        if (option instanceof Some) {
            Object value = ((Some)option).value();
            this.hitsAndMisses.updateAndGet(x$1 -> {
                long l = x$1._1$mcJ$sp();
                long l2 = x$1._2$mcJ$sp();
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(l + 1L)), (Object)BoxesRunTime.boxToLong((long)l2));
            });
            return value;
        }
        if (None$.MODULE$.equals(option)) {
            this.hitsAndMisses.updateAndGet(x$1 -> {
                long l = x$1._1$mcJ$sp();
                long l2 = x$1._2$mcJ$sp();
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToLong((long)(l2 + 1L)));
            });
            Value newValue = this.computeValue(input$1);
            cache.put((Object)key$1, newValue);
            return newValue;
        }
        throw new MatchError((Object)option);
    }

    private final String get$$anonfun$1(long hits$1, long misses$1) {
        return this.cacheStats(hits$1, misses$1);
    }

    private final TelemetryEvent get$$anonfun$2(long hits$2, long misses$2) {
        return globals$package$.MODULE$.cacheEvent(hits$2, misses$2, this.cacheName);
    }
}

