/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.bitbucket;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.BitbucketClient$;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.Path;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequest;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseStatusException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class BitbucketClient
implements Logging {
    private Logger log;
    private final ApplicationLinkService applicationLinkService;

    public static Either<BoxedUnit, Tuple3<List<Path>, Object, Object>> getFilePathsFromResponse(String string) {
        return BitbucketClient$.MODULE$.getFilePathsFromResponse(string);
    }

    public static Iterable<PullRequest> getPullRequestsFromResponse(String string, String string2, String string3) {
        return BitbucketClient$.MODULE$.getPullRequestsFromResponse(string, string2, string3);
    }

    public BitbucketClient(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
        Logging.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public Seq<PullRequest> findPullRequests(String applicationLinkId, String repoSlug, String projectKey, String stashBranch, String latestCommit) {
        ApplicationLink applicationLink = this.getBitbucketApplicationLink(applicationLinkId);
        String url = new StringBuilder(87).append("rest/api/1.0/projects/").append(projectKey).append("/repos/").append(repoSlug).append("/pull-requests?at=refs/heads/").append(stashBranch).append("&direction=outgoing&limit=999").toString();
        String response = this.doGet(url, applicationLink);
        Iterable<PullRequest> pullRequests = BitbucketClient$.MODULE$.getPullRequestsFromResponse(response, projectKey, repoSlug);
        return ((IterableOnceOps)pullRequests.filter((Function1 & Serializable)_$1 -> {
            String string = _$1.latestCommit();
            String string2 = latestCommit;
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).toSeq();
    }

    public void checkBitbucketConnection() {
        ApplicationLink applicationLink = (ApplicationLink)Option$.MODULE$.apply((Object)this.applicationLinkService.getPrimaryApplicationLink(StashApplicationType.class)).getOrElse(BitbucketClient::$anonfun$1);
        String url = "rest/api/1.0/projects?limit=1";
        this.doGet(url, applicationLink);
    }

    public List<Path> findChangedFiles(String applicationLinkId, PullRequest pullRequest) {
        ApplicationLink applicationLink = this.getBitbucketApplicationLink(applicationLinkId);
        ListBuffer changedFiles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[0]));
        boolean isLastPage = false;
        int nextPageStart = 0;
        while (!isLastPage) {
            Tuple3 tuple3;
            String url = new StringBuilder(69).append("rest/api/1.0/projects/").append(pullRequest.projectKey()).append("/repos/").append(pullRequest.repoSlug()).append("/pull-requests/").append(pullRequest.id()).append("/changes?limit=999&start=").append(nextPageStart).toString();
            String response = this.doGet(url, applicationLink);
            Either<BoxedUnit, Tuple3<List<Path>, Object, Object>> either = BitbucketClient$.MODULE$.getFilePathsFromResponse(response);
            if (either instanceof Right && (tuple3 = (Tuple3)((Right)either).value()) != null) {
                List paths = (List)tuple3._1();
                boolean isLast = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                int nextPage = BoxesRunTime.unboxToInt((Object)tuple3._3());
                isLastPage = isLast;
                nextPageStart = nextPage;
                changedFiles.$plus$plus$eq((IterableOnce)paths);
                continue;
            }
            if (either instanceof Left) {
                this.debug(BitbucketClient::findChangedFiles$$anonfun$1);
                return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
            }
            throw new MatchError(either);
        }
        this.debug(() -> BitbucketClient.findChangedFiles$$anonfun$2(pullRequest, changedFiles));
        return changedFiles.toList();
    }

    private ApplicationLink getBitbucketApplicationLink(String applicationLinkId) {
        return (ApplicationLink)CollectionConverters$.MODULE$.IterableHasAsScala(this.applicationLinkService.getApplicationLinks(StashApplicationType.class)).asScala().find((Function1 & Serializable)_$3 -> {
            String string = _$3.getId().get();
            String string2 = applicationLinkId;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).getOrElse(() -> BitbucketClient.getBitbucketApplicationLink$$anonfun$2(applicationLinkId));
    }

    private String doGet(String url, ApplicationLink applicationLink) {
        this.debug(() -> BitbucketClient.doGet$$anonfun$1(url));
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, url);
        request.setConnectionTimeout(180000);
        request.setSoTimeout(180000);
        return (String)request.executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<Response, String>(this){
            private final /* synthetic */ BitbucketClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public String handle(Response response) {
                String responseBody = response.getResponseBodyAsString();
                this.$outer.debug(() -> BitbucketClient.ch$mibex$bamboo$sonar4bamboo$bitbucket$BitbucketClient$$anon$1$$_$handle$$anonfun$1(responseBody, response));
                if (!response.isSuccessful()) {
                    throw new ResponseStatusException(new StringBuilder(2).append(response.getStatusText()).append(": ").append(responseBody).toString(), response);
                }
                return responseBody;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ch$mibex$bamboo$sonar4bamboo$bitbucket$BitbucketClient$$anon$1$$_$handle$$anonfun$1(java.lang.String com.atlassian.sal.api.net.Response )}, serializedLambda);
            }
        });
    }

    private static final ApplicationLink $anonfun$1() {
        throw new IllegalStateException("No Bitbucket Server application link found");
    }

    private static final String findChangedFiles$$anonfun$1() {
        return "Limit of diff size is reached, will do a full analysis";
    }

    private static final String findChangedFiles$$anonfun$2(PullRequest pullRequest$1, ListBuffer changedFiles$1) {
        return new StringBuilder(42).append("Found files in the diff of pull request ").append(pullRequest$1.id()).append(": ").append(((IterableOnceOps)changedFiles$1.map((Function1 & Serializable)_$2 -> _$2.path())).mkString(",")).toString();
    }

    private static final ApplicationLink getBitbucketApplicationLink$$anonfun$2(String applicationLinkId$2) {
        throw new IllegalStateException(new StringBuilder(40).append("No Bitbucket application link found for ").append(applicationLinkId$2).toString());
    }

    private static final String doGet$$anonfun$1(String url$1) {
        return new StringBuilder(15).append("GET request to ").append(url$1).toString();
    }

    public static final String ch$mibex$bamboo$sonar4bamboo$bitbucket$BitbucketClient$$anon$1$$_$handle$$anonfun$1(String responseBody$1, Response response$1) {
        return new StringBuilder(46).append("Got response: ").append(responseBody$1).append(" with status code ").append(response$1.getStatusCode()).append(", successful: ").append(response$1.isSuccessful()).toString();
    }
}

