/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.sonar;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.SonarQubeEdition;
import ch.mibex.bamboo.sonar4bamboo.SonarQubeEdition$;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials;
import ch.mibex.bamboo.sonar4bamboo.sonar.ProjectLink;
import ch.mibex.bamboo.sonar4bamboo.sonar.ProjectLink$;
import ch.mibex.bamboo.sonar4bamboo.sonar.ResponseError;
import ch.mibex.bamboo.sonar4bamboo.sonar.ResponseError$;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarBranch;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarBranch$;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClient;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarUtils$;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.json.JSONArray;
import org.json.JSONObject;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;

public class SonarClientImpl
implements SonarClient,
Logging {
    private Logger log;

    public SonarClientImpl() {
        Logging.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    @Override
    public Either<ResponseError, JSONObject> getAnalysisStatus(String ceTaskUrl, Credentials credentials) {
        return this.doGet(ceTaskUrl, (Function1 & Serializable)response -> new JSONObject(response).getJSONObject("task"), (Option<Credentials>)Some$.MODULE$.apply((Object)credentials), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, List<String>> getFailingQualityGates(String analysisId, String sonarServerUrl, Credentials credentials) {
        String url = new StringBuilder(44).append(sonarServerUrl).append("/api/qualitygates/project_status?analysisId=").append(analysisId).toString();
        return this.doGet(url, (Function1 & Serializable)response -> {
            String overallStatus;
            ListBuffer failingQualityGates = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            JSONObject projectStatus = new JSONObject(response).getJSONObject("projectStatus");
            String string = overallStatus = projectStatus.getString("status");
            String string2 = "ERROR";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                JSONArray conditions = projectStatus.getJSONArray("conditions");
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), conditions.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    JSONObject qualityGateStatus = conditions.getJSONObject(i);
                    String string = qualityGateStatus.getString("status");
                    String string2 = "ERROR";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        String alertText = SonarUtils$.MODULE$.formatQualityGateError(qualityGateStatus);
                        failingQualityGates.$plus$eq((Object)alertText);
                        return;
                    }
                });
            }
            return failingQualityGates.toList();
        }, (Option<Credentials>)Some$.MODULE$.apply((Object)credentials), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, Seq<SonarBranch>> getBranches(String projectKey, String sonarServerUrl, Credentials credentials) {
        String url = new StringBuilder(35).append(sonarServerUrl).append("/api/project_branches/list?project=").append(projectKey).toString();
        return this.doGet(url, (Function1 & Serializable)response -> {
            JSONArray branches = new JSONObject(response).getJSONArray("branches");
            return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), branches.length()).map((Function1 & Serializable)i -> SonarBranch$.MODULE$.apply(branches.getJSONObject(BoxesRunTime.unboxToInt((Object)i)).getString("name")));
        }, (Option<Credentials>)Some$.MODULE$.apply((Object)credentials), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, BoxedUnit> createProjectLink(String projectKey, String bambooBuildResultUrl, String linkName, String sonarServerUrl, Credentials credentials) {
        String linkNameEnc = URLEncoder.encode(linkName, "UTF-8");
        String bambooBuildResultUrlEnc = URLEncoder.encode(bambooBuildResultUrl, "UTF-8");
        String url = new StringBuilder(0).append(sonarServerUrl).append(new StringBuilder(48).append("/api/project_links/create?projectKey=").append(projectKey).append("&name=").append(linkNameEnc).append("&url=").append(bambooBuildResultUrlEnc).toString()).toString();
        return this.doPost(url, (Function1)(JProcedure1 & Serializable)_$1 -> {}, (Option<Credentials>)Some$.MODULE$.apply((Object)credentials), this.doPost$default$4());
    }

    @Override
    public Either<ResponseError, Seq<ProjectLink>> searchProjectLinks(String projectKey, String sonarServerUrl, Credentials credentials) {
        String url = new StringBuilder(0).append(sonarServerUrl).append(new StringBuilder(37).append("/api/project_links/search?projectKey=").append(projectKey).toString()).toString();
        return this.doGet(url, (Function1 & Serializable)response -> {
            JSONArray links = new JSONObject(response).getJSONArray("links");
            return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), links.length()).map((Function1 & Serializable)i -> ProjectLink$.MODULE$.apply(links.getJSONObject(BoxesRunTime.unboxToInt((Object)i)).getString("id"), links.getJSONObject(BoxesRunTime.unboxToInt((Object)i)).getString("name")));
        }, (Option<Credentials>)Some$.MODULE$.apply((Object)credentials), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, BoxedUnit> deleteProjectLink(String linkId, String sonarServerUrl, Credentials credentials) {
        String url = new StringBuilder(0).append(sonarServerUrl).append(new StringBuilder(29).append("/api/project_links/delete?id=").append(linkId).toString()).toString();
        return this.doPost(url, (Function1)(JProcedure1 & Serializable)_$2 -> {}, (Option<Credentials>)Some$.MODULE$.apply((Object)credentials), this.doPost$default$4());
    }

    @Override
    public Either<ResponseError, Object> authenticate(String sonarServerUrl, Credentials credentials) {
        String url = new StringBuilder(28).append(sonarServerUrl).append("/api/authentication/validate").toString();
        return this.doGet(url, (Function1 & Serializable)response -> new JSONObject(response).getBoolean("valid"), (Option<Credentials>)Some$.MODULE$.apply((Object)credentials), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, ArtifactVersion> getSonarVersion(String sonarServerUrl) {
        String url = new StringBuilder(19).append(sonarServerUrl).append("/api/server/version").toString();
        return this.doGet(url, (Function1 & Serializable)response -> new DefaultArtifactVersion(response), this.doGet$default$3(), this.doGet$default$4());
    }

    @Override
    public Either<ResponseError, SonarQubeEdition> getSonarQubeEdition(String sonarServerUrl, Credentials credentials, FiniteDuration requestTimeout) {
        if (sonarServerUrl.contains("sonarcloud.io")) {
            return package$.MODULE$.Right().apply((Object)SonarQubeEdition$.COMMERCIAL_EDITION);
        }
        String languageUrl = new StringBuilder(19).append(sonarServerUrl).append("/api/languages/list").toString();
        Function1 & Serializable callback = (Function1 & Serializable)response -> {
            JSONArray languages = new JSONObject(response).getJSONArray("languages");
            boolean hasCpp = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), languages.length()).map((Function1 & Serializable)_$3 -> SonarClientImpl.$anonfun$2(languages, BoxesRunTime.unboxToInt((Object)_$3))).contains((Object)"cpp");
            return hasCpp;
        };
        Either hasCommercialLanguage = this.doGet(languageUrl, callback, (Option<Credentials>)Some$.MODULE$.apply((Object)credentials), requestTimeout);
        return hasCommercialLanguage.flatMap((Function1 & Serializable)isCommercial -> this.getSonarQubeEdition$$anonfun$1(sonarServerUrl, credentials, requestTimeout, BoxesRunTime.unboxToBoolean((Object)isCommercial)));
    }

    private Either<ResponseError, Object> hasBranchPluginInstalled(String sonarServerUrl, Credentials credentials, FiniteDuration requestTimeout) {
        String pluginsUrl = new StringBuilder(22).append(sonarServerUrl).append("/api/plugins/installed").toString();
        Function1 & Serializable callback = (Function1 & Serializable)response -> {
            JSONArray plugins = new JSONObject(response).getJSONArray("plugins");
            IndexedSeq pluginKeys = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), plugins.length()).map((Function1 & Serializable)_$4 -> SonarClientImpl.$anonfun$4(plugins, BoxesRunTime.unboxToInt((Object)_$4)));
            return pluginKeys.contains((Object)"communityBranchPlugin");
        };
        return this.doGet(pluginsUrl, callback, (Option<Credentials>)Some$.MODULE$.apply((Object)credentials), requestTimeout);
    }

    private <T> Either<ResponseError, T> doGet(String url, Function1<String, T> callback, Option<Credentials> credentials, FiniteDuration requestTimeout) {
        HttpGet httpGet = new HttpGet(url);
        return this.executeRequest((HttpRequestBase)httpGet, url, callback, credentials, requestTimeout);
    }

    private <T> Option<Credentials> doGet$default$3() {
        return None$.MODULE$;
    }

    private <T> FiniteDuration doGet$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds();
    }

    private <T> Either<ResponseError, T> doPost(String url, Function1<String, T> callback, Option<Credentials> credentials, FiniteDuration requestTimeout) {
        HttpPost httpPost = new HttpPost(url);
        return this.executeRequest((HttpRequestBase)httpPost, url, callback, credentials, requestTimeout);
    }

    private <T> FiniteDuration doPost$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds();
    }

    private <T> Either<ResponseError, T> executeRequest(HttpRequestBase http, String url, Function1<String, T> callback, Option<Credentials> credentials, FiniteDuration requestTimeout) {
        Either either;
        http.addHeader("accept", "application/json");
        ObjectRef entity = ObjectRef.create(null);
        int timeout = (int)requestTimeout.toMillis();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).build();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
        try {
            either = (Either)Using$.MODULE$.resource((Object)clientBuilder.build(), (Function1 & Serializable)httpClient -> {
                this.debug(() -> SonarClientImpl.executeRequest$$anonfun$1$$anonfun$1(url));
                credentials.foreach((Function1)(JProcedure1 & Serializable)c -> this.setBasicAuthCredentials(http, (Credentials)c));
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)http);
                entity$1.elem = response.getEntity();
                int statusCode = response.getStatusLine().getStatusCode();
                String resp = (String)Option$.MODULE$.apply((Object)((HttpEntity)entity$1.elem)).map((Function1 & Serializable)x$0 -> EntityUtils.toString((HttpEntity)x$0)).getOrElse(SonarClientImpl::$anonfun$6);
                this.debug(() -> SonarClientImpl.executeRequest$$anonfun$1$$anonfun$3(statusCode, resp));
                if (statusCode < 200 || statusCode > 299) {
                    return package$.MODULE$.Left().apply((Object)ResponseError$.MODULE$.apply(statusCode, resp));
                }
                return package$.MODULE$.Right().apply(callback.apply((Object)resp));
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        catch (Throwable e) {
            this.error("Could not connect to Sonar server", e);
            either = package$.MODULE$.Left().apply((Object)ResponseError$.MODULE$.apply(500, e.getMessage()));
        }
        return either;
    }

    private <T> void setBasicAuthCredentials(HttpRequestBase httpMethod, Credentials c) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)Option$.MODULE$.apply((Object)c.login()).getOrElse(SonarClientImpl::setBasicAuthCredentials$$anonfun$1)))) {
            String auth = new StringBuilder(1).append(c.login()).append(":").append(c.password().getOrElse(SonarClientImpl::$anonfun$7)).toString();
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
            String authHeader = new StringBuilder(6).append("Basic ").append(encodedAuth).toString();
            httpMethod.setHeader("Authorization", authHeader);
            return;
        }
    }

    private static final /* synthetic */ String $anonfun$2(JSONArray languages$1, int _$3) {
        return languages$1.getJSONObject(_$3).getString("key");
    }

    private final /* synthetic */ Either getSonarQubeEdition$$anonfun$1(String sonarServerUrl$1, Credentials credentials$1, FiniteDuration requestTimeout$1, boolean isCommercial) {
        if (isCommercial) {
            return package$.MODULE$.Right().apply((Object)SonarQubeEdition$.COMMERCIAL_EDITION);
        }
        Either<ResponseError, Object> either = this.hasBranchPluginInstalled(sonarServerUrl$1, credentials$1, requestTimeout$1);
        if (either instanceof Right) {
            boolean installed = BoxesRunTime.unboxToBoolean((Object)((Right)either).value());
            return package$.MODULE$.Right().apply((Object)(installed ? SonarQubeEdition$.COMMUNITY_EDITION_BRANCH : SonarQubeEdition$.COMMUNITY_EDITION));
        }
        if (either instanceof Left) {
            ResponseError err = (ResponseError)((Left)either).value();
            return package$.MODULE$.Left().apply((Object)err);
        }
        throw new MatchError(either);
    }

    private static final /* synthetic */ String $anonfun$4(JSONArray plugins$1, int _$4) {
        return plugins$1.getJSONObject(_$4).getString("key");
    }

    private static final String executeRequest$$anonfun$1$$anonfun$1(String url$2) {
        return new StringBuilder(9).append("request: ").append(url$2).toString();
    }

    private static final String $anonfun$6() {
        return "";
    }

    private static final String executeRequest$$anonfun$1$$anonfun$3(int statusCode$1, String resp$1) {
        return new StringBuilder(28).append("response with status code ").append(statusCode$1).append(": ").append(resp$1).toString();
    }

    private static final String setBasicAuthCredentials$$anonfun$1() {
        return "";
    }

    private static final String $anonfun$7() {
        return "";
    }
}

