/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.spring;

import ch.mibex.atlassian.dc.AppKeyProvider;
import ch.mibex.atlassian.dc.telemetry.HostProductTelemetryContext;
import ch.mibex.bamboo.sonar4bamboo.IncludeBambooKeyProvider;
import ch.mibex.bamboo.sonar4bamboo.PluginLifecycleHandler;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.BitbucketHelper;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequestService;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerConfigDao;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerConfigDaoImpl;
import ch.mibex.bamboo.sonar4bamboo.sonar.IncrementalAnalysis;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClient;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClientImpl;
import ch.mibex.bamboo.sonar4bamboo.telemetry.events.TelemetryEvents;
import ch.mibex.platform.AtlassianBasePlatform;
import ch.mibex.platform.HostPlatform;
import ch.mibex.telemetry.TelemetryContext;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.bamboo.admin.configuration.AdministrationConfigurationService;
import com.atlassian.bamboo.applinks.ImpersonationService;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.TaskConfiguratorHelper;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.cache.CacheFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BambooOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.struts.TextProvider;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.PluginLicenseManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Conditional(value={BambooOnly.class})
@Configuration
public class SpringBambooServerConfig {
    @Bean
    public PluginAccessor pluginAccessor() {
        return (PluginAccessor)OsgiServices.importOsgiService(PluginAccessor.class);
    }

    @Bean
    public ApplicationProperties applicationProperties() {
        return (ApplicationProperties)OsgiServices.importOsgiService(ApplicationProperties.class);
    }

    @Bean
    public ActiveObjects activeObjects() {
        return (ActiveObjects)OsgiServices.importOsgiService(ActiveObjects.class);
    }

    @Bean
    public UIConfigSupport uiConfig() {
        return (UIConfigSupport)OsgiServices.importOsgiService(UIConfigSupport.class);
    }

    @Bean
    public ApplicationLinkService applicationLinkService() {
        return (ApplicationLinkService)OsgiServices.importOsgiService(ApplicationLinkService.class);
    }

    @Bean
    public ImpersonationService impersonationService() {
        return (ImpersonationService)OsgiServices.importOsgiService(ImpersonationService.class);
    }

    @Bean
    public PluginLicenseManager pluginLicenseManager() {
        return (PluginLicenseManager)OsgiServices.importOsgiService(PluginLicenseManager.class);
    }

    @Bean
    public EncryptionService encryptionService() {
        return (EncryptionService)OsgiServices.importOsgiService(EncryptionService.class);
    }

    @Bean
    public CacheFactory cacheFactory() {
        return (CacheFactory)OsgiServices.importOsgiService(CacheFactory.class);
    }

    @Bean
    public HostLicenseInformation hostLicenseInformation() {
        return (HostLicenseInformation)OsgiServices.importOsgiService(HostLicenseInformation.class);
    }

    @Bean
    public AdministrationConfigurationService administrationConfigurationService() {
        return (AdministrationConfigurationService)OsgiServices.importOsgiService(AdministrationConfigurationService.class);
    }

    @Bean
    public VariableDefinitionManager variableDefinitionManager() {
        return (VariableDefinitionManager)OsgiServices.importOsgiService(VariableDefinitionManager.class);
    }

    @Bean
    public TextProvider textProvider() {
        return (TextProvider)OsgiServices.importOsgiService(TextProvider.class);
    }

    @Bean
    public TaskConfiguratorHelper taskConfigurationHelper() {
        return (TaskConfiguratorHelper)OsgiServices.importOsgiService(TaskConfiguratorHelper.class);
    }

    @Bean
    public SonarServerConfigDao sonarServerConfigDao() {
        return new SonarServerConfigDaoImpl(this.activeObjects(), this.encryptionService());
    }

    @Bean
    public SonarClient sonarClient() {
        return new SonarClientImpl();
    }

    @Bean
    public BitbucketHelper bitbucketHelper() {
        return new BitbucketHelper(this.impersonationService(), this.applicationLinkService(), this.applicationProperties());
    }

    @Bean
    public PullRequestService pullRequestService(CustomVariableContext customVariableContext) {
        return new PullRequestService(customVariableContext, this.bitbucketHelper());
    }

    @Bean
    public IncrementalAnalysis incrementalAnalysisSupport(CustomVariableContext customVariableContext) {
        return new IncrementalAnalysis(customVariableContext, this.bitbucketHelper(), this.pullRequestService(customVariableContext));
    }

    @Bean
    public AppKeyProvider appKeyProvider() {
        return new IncludeBambooKeyProvider();
    }

    @Bean
    public HostPlatform hostPlatform() {
        return new AtlassianBasePlatform(this.appKeyProvider(), this.applicationProperties(), this.pluginAccessor(), this.hostLicenseInformation());
    }

    @Bean
    public TelemetryContext telemetryContext() {
        return new HostProductTelemetryContext(this.hostPlatform());
    }

    @Bean
    public PluginLifecycleHandler lifecycleHandler() {
        return new PluginLifecycleHandler(this.telemetryContext());
    }

    @Bean
    public TelemetryEvents icqForBambooTelemetry() {
        return new TelemetryEvents(this.telemetryContext());
    }
}

