/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.qgstatus;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.AnalysisInfo;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.AnalysisInfo$;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.QgStatusBuildBreaker$;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.QualityGateStatus;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.QualityGateStatus$;
import ch.mibex.bamboo.sonar4bamboo.results.SonarBuildResultSummary$;
import ch.mibex.bamboo.sonar4bamboo.results.TaskResultQualityGates;
import ch.mibex.bamboo.sonar4bamboo.results.TaskResultQualityGates$;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials$;
import ch.mibex.bamboo.sonar4bamboo.sonar.ResponseError;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClient;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarConstants$;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class QgStatusBuildBreaker
implements Logging {
    private Logger log;
    private final SonarClient sonarClient;
    private final CustomVariableContext customVariableContext;
    private final int MaxIterationsToGetQualityGateStatus;

    public static File[] findSonarReportFiles(File file, File file2, Function1<File, File[]> function1) {
        return QgStatusBuildBreaker$.MODULE$.findSonarReportFiles(file, file2, function1);
    }

    public static File[] findSonarReportFilesRecursivelyIn(File file) {
        return QgStatusBuildBreaker$.MODULE$.findSonarReportFilesRecursivelyIn(file);
    }

    public static Function1<File, File[]> findSonarReportFiles$default$3() {
        return QgStatusBuildBreaker$.MODULE$.findSonarReportFiles$default$3();
    }

    public QgStatusBuildBreaker(SonarClient sonarClient, CustomVariableContext customVariableContext) {
        this.sonarClient = sonarClient;
        this.customVariableContext = customVariableContext;
        Logging.$init$(this);
        this.MaxIterationsToGetQualityGateStatus = 43200;
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public TaskResult breakBuildIfQualityGatesFailed(TaskContext taskContext, boolean breakBuild) {
        Object[] reportFiles = QgStatusBuildBreaker$.MODULE$.findSonarReportFiles(taskContext.getWorkingDirectory(), taskContext.getRootDirectory(), QgStatusBuildBreaker$.MODULE$.findSonarReportFiles$default$3());
        Object object = Predef$.MODULE$.refArrayOps(reportFiles);
        Option option = ArrayOps$.MODULE$.headOption$extension(object);
        if (option instanceof Some) {
            File sonarReportFile = (File)((Some)option).value();
            this.info(new StringBuilder(27).append("Found sonar report file in ").append(sonarReportFile.getAbsolutePath()).toString());
            Option<String> option2 = this.determineCeTaskUrl(sonarReportFile);
            if (option2 instanceof Some) {
                String ceTaskUrl = (String)((Some)option2).value();
                return this.checkTaskStatus(taskContext, ceTaskUrl, breakBuild);
            }
            if (None$.MODULE$.equals(option2)) {
                this.addErrorLogEntry("SonarQube quality gate detection failed: No CE task URL found", taskContext);
                return this.failWithErrorTaskResult(taskContext, breakBuild);
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            this.addErrorLogEntry("SonarQube quality gate detection: no report-task.txt file found. You cannot use preview mode (-Dsonar.analysis.mode=preview), need SonarQube >= 5.3 and if you use MSBuild an \"MSBuild.exe end\" call for this feature to work.", taskContext);
            return this.failWithErrorTaskResult(taskContext, breakBuild);
        }
        throw new MatchError((Object)option);
    }

    private TaskResult checkTaskStatus(TaskContext taskContext, String ceTaskUrl, boolean breakBuild) {
        AnalysisInfo analysisInfo;
        Either<ResponseError, AnalysisInfo> either = this.executeUntilTaskStatusReady(taskContext, ceTaskUrl, this.executeUntilTaskStatusReady$default$3());
        if (either instanceof Left) {
            ResponseError err = (ResponseError)((Left)either).value();
            this.addErrorLogEntry(new StringBuilder(49).append("SonarQube quality gate detection failed. Reason: ").append(err.reason()).toString(), taskContext);
            return this.failWithErrorTaskResult(taskContext, breakBuild);
        }
        if (either instanceof Right && (analysisInfo = (AnalysisInfo)((Right)either).value()) != null) {
            AnalysisInfo analysisInfo2 = AnalysisInfo$.MODULE$.unapply(analysisInfo);
            Option<String> option = analysisInfo2._1();
            Option<String> option2 = analysisInfo2._2();
            Option<String> option3 = analysisInfo2._3();
            Option<String> option4 = analysisInfo2._4();
            if (option instanceof Some) {
                String string;
                String status;
                String string2 = status = (string = (String)((Some)option).value());
                String string3 = "FAILED";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.addErrorLogEntry("SonarQube quality gate with failed status.", taskContext);
                    return this.failedTaskResult(taskContext, breakBuild);
                }
                String status2 = string;
                if (option2 instanceof Some) {
                    String analysisId = (String)((Some)option2).value();
                    AnalysisInfo info = analysisInfo;
                    String string4 = status2;
                    String string5 = "SUCCESS";
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        this.debug(QgStatusBuildBreaker::checkTaskStatus$$anonfun$1);
                        return this.determineQualityGateStatus(taskContext, analysisId, info, breakBuild);
                    }
                }
                String status3 = string;
                this.addErrorLogEntry(new StringBuilder(82).append("SonarQube quality gate task did not finish. SonarQube background task has status: ").append(status3).toString(), taskContext);
                return this.failWithErrorTaskResult(taskContext, breakBuild);
            }
        }
        Either<ResponseError, AnalysisInfo> other = either;
        this.error(new StringBuilder(57).append("SonarQube quality gate detection failed. Reason unknown. ").append(other).toString());
        this.addErrorLogEntry(new StringBuilder(57).append("SonarQube quality gate detection failed. Reason unknown. ").append(other).toString(), taskContext);
        return this.failWithErrorTaskResult(taskContext, breakBuild);
    }

    private TaskResult failedTaskResult(TaskContext taskContext, boolean breakBuild) {
        if (breakBuild) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        return this.successfulTaskResult(taskContext);
    }

    private TaskResult failWithErrorTaskResult(TaskContext taskContext, boolean breakBuild) {
        if (breakBuild) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        return this.successfulTaskResult(taskContext);
    }

    private Option<String> determineCeTaskUrl(File sonarReportFile) {
        None$ none$;
        try (FileInputStream fs = new FileInputStream(sonarReportFile.getAbsolutePath());){
            try {
                Properties prop = new Properties();
                prop.load(fs);
                none$ = Option$.MODULE$.apply((Object)prop.getProperty("ceTaskUrl"));
            }
            catch (IOException e) {
                this.error("Failed to load report-task.txt", e);
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private TaskResult determineQualityGateStatus(TaskContext taskContext, String analysisId, AnalysisInfo analysisInfo, boolean breakBuild) {
        List failingQualityGates;
        Credentials credentials = Credentials$.MODULE$.by(taskContext, this.customVariableContext);
        String sonarHostUrl = (String)taskContext.getRuntimeTaskContext().get(SonarConstants$.MODULE$.SonarHostUrl());
        CurrentBuildResult buildResult = taskContext.getBuildContext().getBuildResult();
        Either<ResponseError, List<String>> either = this.sonarClient.getFailingQualityGates(analysisId, sonarHostUrl, credentials);
        if (either instanceof Left) {
            ResponseError error = (ResponseError)((Left)either).value();
            this.addErrorLogEntry(new StringBuilder(122).append("Failed to retrieve SonarQube quality gate status: ").append(error).append(" ").append("Have you enabled to use a configured Sonar server in the task settings?").toString(), taskContext);
            return this.failWithErrorTaskResult(taskContext, breakBuild);
        }
        if (either instanceof Right && (failingQualityGates = (List)((Right)either).value()).nonEmpty()) {
            failingQualityGates.foreach((Function1)(JProcedure1 & Serializable)fqg -> this.addErrorLogEntry(new StringBuilder(31).append("Failed SonarQube quality gate: ").append((String)fqg).toString(), taskContext));
            List enrichedQualityGates = failingQualityGates.map((Function1 & Serializable)message -> QualityGateStatus$.MODULE$.apply("ERROR", (String)message, (String)analysisInfo.projectKey().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)analysisInfo.projectName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            this.rememberQgStatus(buildResult, (List<QualityGateStatus>)enrichedQualityGates, taskContext);
            return this.failedTaskResult(taskContext, breakBuild);
        }
        List successfulResult = (List)new .colon.colon((Object)QualityGateStatus$.MODULE$.apply("SUCCESS", "All quality gates passed", (String)analysisInfo.projectKey().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)analysisInfo.projectName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (List)Nil$.MODULE$);
        this.rememberQgStatus(buildResult, (List<QualityGateStatus>)successfulResult, taskContext);
        return this.successfulTaskResult(taskContext);
    }

    private String rememberQgStatus(CurrentBuildResult buildResult, List<QualityGateStatus> enrichedQualityGates, TaskContext taskContext) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply(buildResult.getCustomBuildData().get(SonarConstants$.MODULE$.SonarTasksFailedQualityGates())).map((Function1 & Serializable)_$3 -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])SonarBuildResultSummary$.MODULE$.fromTaskResultQualityGates((String)_$3));
            return (TaskResultQualityGates[])ArrayOps$.MODULE$.toArray$extension(object, ClassTag$.MODULE$.apply(TaskResultQualityGates.class));
        }).getOrElse(QgStatusBuildBreaker::$anonfun$3));
        TaskResultQualityGates[] gates = (TaskResultQualityGates[])ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)TaskResultQualityGates$.MODULE$.apply(taskContext.getId(), enrichedQualityGates), ClassTag$.MODULE$.apply(TaskResultQualityGates.class));
        return buildResult.getCustomBuildData().put(SonarConstants$.MODULE$.SonarTasksFailedQualityGates(), SonarBuildResultSummary$.MODULE$.toTaskResultQualityGates(gates));
    }

    private TaskResult successfulTaskResult(TaskContext taskContext) {
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    private Either<ResponseError, AnalysisInfo> executeUntilTaskStatusReady(TaskContext taskContext, String ceTaskUrl, int numRuns) {
        Either<ResponseError, JSONObject> either;
        while (true) {
            if (numRuns == this.MaxIterationsToGetQualityGateStatus) {
                return package$.MODULE$.Right().apply((Object)AnalysisInfo$.MODULE$.apply((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$));
            }
            List finishedStati = (List)new .colon.colon((Object)"SUCCESS", (List)new .colon.colon((Object)"CANCELED", (List)new .colon.colon((Object)"FAILED", (List)Nil$.MODULE$)));
            Credentials credentials = Credentials$.MODULE$.by(taskContext, this.customVariableContext);
            either = this.sonarClient.getAnalysisStatus(ceTaskUrl, credentials);
            if (either instanceof Left) {
                ResponseError error = (ResponseError)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)error);
            }
            if (!(either instanceof Right)) break;
            JSONObject taskInfo = (JSONObject)((Right)either).value();
            String status = taskInfo.getString("status");
            if (finishedStati.contains((Object)status)) {
                return package$.MODULE$.Right().apply((Object)AnalysisInfo$.MODULE$.apply((Option<String>)Option$.MODULE$.apply((Object)status), (Option<String>)Option$.MODULE$.apply((Object)taskInfo.optString("analysisId", null)), (Option<String>)Option$.MODULE$.apply((Object)taskInfo.optString("componentKey", null)), (Option<String>)Option$.MODULE$.apply((Object)taskInfo.optString("componentName", null))));
            }
            this.debug(QgStatusBuildBreaker::executeUntilTaskStatusReady$$anonfun$1);
            Thread.sleep(1000L);
            ++numRuns;
        }
        throw new MatchError(either);
    }

    private int executeUntilTaskStatusReady$default$3() {
        return 0;
    }

    private static final String checkTaskStatus$$anonfun$1() {
        return "SonarQube successful quality gate status.";
    }

    private static final TaskResultQualityGates[] $anonfun$3() {
        return (TaskResultQualityGates[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(TaskResultQualityGates.class));
    }

    private static final String executeUntilTaskStatusReady$$anonfun$1() {
        return "Trying to get SonarQube quality gate status...";
    }
}

