/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.sonar;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.Utils$;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.BitbucketHelper;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequest;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequestService;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerEntity;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarConstants$;
import ch.mibex.bamboo.sonar4bamboo.tasks.BambooUserSettingsHelper$;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarTaskConfigConstants$;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;

public class IncrementalAnalysis
implements Logging {
    private volatile Logger ch$mibex$bamboo$sonar4bamboo$Logging$$logger;
    private final CustomVariableContext customVariableContext;
    private final BitbucketHelper bitbucketHelper;
    private final PullRequestService pullRequestService;

    public IncrementalAnalysis(CustomVariableContext customVariableContext, BitbucketHelper bitbucketHelper, PullRequestService pullRequestService) {
        this.customVariableContext = customVariableContext;
        this.bitbucketHelper = bitbucketHelper;
        this.pullRequestService = pullRequestService;
        Logging.$init$(this);
    }

    @Override
    public Logger ch$mibex$bamboo$sonar4bamboo$Logging$$logger() {
        return this.ch$mibex$bamboo$sonar4bamboo$Logging$$logger;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$bamboo$sonar4bamboo$Logging$$logger = x$1;
    }

    public void applyIncrementalMode(HashMap<String, String> runtimeTaskData, CommonContext context, TaskDefinition taskDefinition, Option<SonarServerEntity> sonarServerConfig, Map<String, String> repoConfig) {
        Option<String> option = Utils$.MODULE$.getCurrentGitBranch(this.customVariableContext);
        if (option instanceof Some) {
            String branchPattern;
            String stashBranch = (String)((Some)option).value();
            java.util.Map taskConfig = taskDefinition.getConfiguration();
            Option option2 = Option$.MODULE$.apply(taskConfig.get(SonarTaskConfigConstants$.MODULE$.IncrementalModeGitBranchPatternField()));
            if (option2 instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(branchPattern = (String)((Some)option2).value())) && stashBranch.matches(branchPattern)) {
                this.setDiffRuntimeVariables(context, taskDefinition, runtimeTaskData, sonarServerConfig, stashBranch, repoConfig);
                return;
            }
            this.info("Will not use incremental mode because branch pattern is not configured");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Incremental mode not possible without a repository added to the plan.");
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDiffRuntimeVariables(CommonContext context, TaskDefinition taskDefinition, HashMap<String, String> runtimeTaskData, Option<SonarServerEntity> sonarServerConfig, String stashBranch, Map<String, String> repoConfig) {
        String string;
        Option<PullRequest> option = this.pullRequestService.getPullRequest(context, taskDefinition, stashBranch, sonarServerConfig, repoConfig);
        if (option instanceof Some) {
            PullRequest pr = (PullRequest)((Some)option).value();
            this.debug(() -> IncrementalAnalysis.setDiffRuntimeVariables$$anonfun$1(pr));
            String bambooUserName = (String)BambooUserSettingsHelper$.MODULE$.getBambooUserName(taskDefinition, sonarServerConfig).getOrElse(IncrementalAnalysis::$anonfun$1);
            List changedFiles = (List)this.bitbucketHelper.callInBambooUserContext(context, repoConfig, bambooUserName, (Function2 & Serializable)(client, applicationLinkId) -> client.findChangedFiles((String)applicationLinkId, pr));
            string = runtimeTaskData.put(SonarConstants$.MODULE$.SonarDiffFiles(), changedFiles.map((Function1 & Serializable)_$1 -> _$1.path()).mkString(","));
            return;
        } else {
            String string2;
            String noPullRequestOption;
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            this.warn(new StringBuilder(49).append("Could not determine pull request information for ").append(stashBranch).toString());
            String noPullRequestSetting = (String)taskDefinition.getConfiguration().get(SonarTaskConfigConstants$.MODULE$.IncrementalNoPullRequestField());
            Option option2 = Option$.MODULE$.apply((Object)noPullRequestSetting);
            if (!(option2 instanceof Some)) throw new IllegalStateException("No pull requests found to apply incremental mode. Have you enabled the option WHEN PULL REQUEST IS CREATED in the branches options of your plan?");
            String string3 = noPullRequestOption = (string2 = (String)((Some)option2).value());
            String string4 = SonarTaskConfigConstants$.MODULE$.IncrementalModeRunFullAnalysisField();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                string = runtimeTaskData.put(SonarConstants$.MODULE$.SonarDiffFiles(), "");
                return;
            } else {
                String noPullRequestOption2;
                String string5 = noPullRequestOption2 = string2;
                String string6 = SonarTaskConfigConstants$.MODULE$.IncrementalModeSkipTaskField();
                if (string5 != null ? !string5.equals(string6) : string6 != null) throw new IllegalStateException("No pull requests found to apply incremental mode. Have you enabled the option WHEN PULL REQUEST IS CREATED in the branches options of your plan?");
                string = runtimeTaskData.put(SonarConstants$.MODULE$.SonarNoPullRequest(), "NO_PULL_REQUEST");
            }
        }
    }

    private static final String setDiffRuntimeVariables$$anonfun$1(PullRequest pr$1) {
        return new StringBuilder(47).append("Found pull request '").append(pr$1.id()).append("' to apply incremental mode").toString();
    }

    private static final String $anonfun$1() {
        throw new IllegalStateException("Expect Bamboo user to be configured in the task settings");
    }
}

