/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.results;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.QualityGateStatus;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.QualityGateStatus$;
import ch.mibex.bamboo.sonar4bamboo.qgstatus.QualityGateStatusString$;
import ch.mibex.bamboo.sonar4bamboo.results.SonarBuildResultSummary$;
import ch.mibex.bamboo.sonar4bamboo.results.TaskResultQualityGates;
import ch.mibex.bamboo.sonar4bamboo.results.TaskResultQualityGates$;
import ch.mibex.bamboo.sonar4bamboo.results.TaskResultVisitUrl;
import ch.mibex.bamboo.sonar4bamboo.results.TaskResultVisitUrl$;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarConstants$;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarUtils$;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.model.AbstractWebPanel;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.log4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public class SonarBuildResultsLinkPanel
extends AbstractWebPanel
implements Logging {
    private volatile Logger ch$mibex$bamboo$sonar4bamboo$Logging$$logger;

    public SonarBuildResultsLinkPanel(PluginAccessor pluginAccessor) {
        super(pluginAccessor);
        Logging.$init$(this);
        String HeaderHtml = "<h2>Sonar analysis results</h2>";
        String TableHeader = "<table class=\"aui\"><thead><tr><th>Project</th><th>Quality gate status</th></tr></thead><tbody>";
        String TableClosing = "</tbody></table>";
    }

    @Override
    public Logger ch$mibex$bamboo$sonar4bamboo$Logging$$logger() {
        return this.ch$mibex$bamboo$sonar4bamboo$Logging$$logger;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$bamboo$sonar4bamboo$Logging$$logger = x$1;
    }

    public String getHtml(Map<String, Object> context) {
        String string;
        try {
            Object object = context.get("resultSummary");
            if (object instanceof ChainResultsSummary) {
                ChainResultsSummary crs = (ChainResultsSummary)object;
                Buffer resultHtmlParts = (Buffer)this.getBuildDataResults(crs).map((Function1 & Serializable)customBuildData -> this.getResultHtmlParts((scala.collection.immutable.Map<String, String>)customBuildData));
                string = ((IterableOnceOps)resultHtmlParts.flatten(Predef$.MODULE$.$conforms())).nonEmpty() ? new StringBuilder(141).append("<h2>Sonar analysis results</h2><table class=\"aui\"><thead><tr><th>Project</th><th>Quality gate status</th></tr></thead><tbody>").append(((IterableOnceOps)resultHtmlParts.flatten(Predef$.MODULE$.$conforms())).mkString("")).append("</tbody></table>").toString() : "";
            } else {
                this.warn("Unable to find build results URL because no chain results summary");
                string = "";
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String stackTrace = sw.toString();
                this.error(new StringBuilder(48).append("Unexpected error while building results summary\n").append(stackTrace).toString());
                string = new StringBuilder(31).append("<h2>Sonar analysis results</h2>").append(new StringBuilder(223).append("<p>Unable to find Sonar analysis results:<br><c style='overflow-y: scroll; height=10em'><code>").append(stackTrace).append("</code></div></p><br><p>Contact support at: <a href=\"https://support.mibexsoftware.com\">https://support.mibexsoftware.com</a></p>").toString()).toString();
            }
            throw throwable;
        }
        return string;
    }

    private Option<String> getResultHtmlParts(scala.collection.immutable.Map<String, String> customBuildData) {
        Option displaySonarHostUrl = customBuildData.get((Object)SonarConstants$.MODULE$.DisplaySonarHostUrl());
        Option sonarHostUrl = customBuildData.get((Object)SonarConstants$.MODULE$.SonarHostUrl());
        Option taskVisitUrls = customBuildData.get((Object)SonarConstants$.MODULE$.SonarTasksVisitUrls());
        Option option = taskVisitUrls;
        if (option instanceof Some) {
            String urls = (String)((Some)option).value();
            Object object = Predef$.MODULE$.refArrayOps((Object[])SonarBuildResultSummary$.MODULE$.fromTaskResultVisitUrls(urls));
            Object[] taskIdToResultUrl = (Tuple2[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                TaskResultVisitUrl taskResultVisitUrl = x$1;
                if (taskResultVisitUrl != null) {
                    TaskResultVisitUrl taskResultVisitUrl2 = TaskResultVisitUrl$.MODULE$.unapply(taskResultVisitUrl);
                    long l = taskResultVisitUrl2._1();
                    String string = taskResultVisitUrl2._2();
                    long taskId = l;
                    String visitUrl = string;
                    Long l2 = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)taskId));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l2, (Object)this.getResultUrlFromVisitUrl((Option<String>)displaySonarHostUrl, (Option<String>)sonarHostUrl, visitUrl));
                }
                throw new MatchError((Object)taskResultVisitUrl);
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            Tuple2[] taskIdToQualityGates = (Tuple2[])customBuildData.get((Object)SonarConstants$.MODULE$.SonarTasksFailedQualityGates()).filter((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1))).map((Function1 & Serializable)qgStr -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])SonarBuildResultSummary$.MODULE$.fromTaskResultQualityGates((String)qgStr));
                return (Tuple2[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                    TaskResultQualityGates taskResultQualityGates = x$1;
                    if (taskResultQualityGates != null) {
                        TaskResultQualityGates taskResultQualityGates2 = TaskResultQualityGates$.MODULE$.unapply(taskResultQualityGates);
                        long l = taskResultQualityGates2._1();
                        List<QualityGateStatus> list = taskResultQualityGates2._2();
                        long taskId = l;
                        List<QualityGateStatus> gates = list;
                        Long l2 = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)taskId));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l2, gates);
                    }
                    throw new MatchError((Object)taskResultQualityGates);
                }, ClassTag$.MODULE$.apply(Tuple2.class));
            }).getOrElse(SonarBuildResultsLinkPanel::$anonfun$5);
            Object object2 = Predef$.MODULE$.refArrayOps(taskIdToResultUrl);
            String tableRows = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    long taskId = BoxesRunTime.unboxToLong((Object)tuple2._1());
                    String resultUrl = (String)tuple2._2();
                    Object object = Predef$.MODULE$.refArrayOps((Object[])taskIdToQualityGates);
                    List qualityGates = (List)ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)_$2 -> BoxesRunTime.unboxToLong((Object)_$2._1()) == taskId).map((Function1 & Serializable)_$3 -> (List)_$3._2()).getOrElse(SonarBuildResultsLinkPanel::$anonfun$9);
                    return this.toFormattedTableRow(resultUrl, (Seq<QualityGateStatus>)qualityGates);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(String.class))).mkString("");
            return Option$.MODULE$.apply((Object)tableRows);
        }
        if (None$.MODULE$.equals(option)) {
            String qualityGatesStr;
            String visitUrl = (String)customBuildData.get((Object)SonarConstants$.MODULE$.SonarVisitUrl()).getOrElse(this::$anonfun$10);
            String resultUrl = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(visitUrl)) ? this.getResultUrlFromVisitUrl((Option<String>)displaySonarHostUrl, (Option<String>)sonarHostUrl, visitUrl) : visitUrl;
            Option option2 = customBuildData.get((Object)SonarConstants$.MODULE$.SonarQualityGateStatus());
            if (option2 instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(qualityGatesStr = (String)((Some)option2).value()))) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])qualityGatesStr.split("\n"));
                List qualityGates = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)str -> QualityGateStatusString$.MODULE$.unapply((String)str), ClassTag$.MODULE$.apply(QualityGateStatus.class))).toList();
                return Option$.MODULE$.apply((Object)this.toFormattedTableRow(resultUrl, (Seq<QualityGateStatus>)qualityGates));
            }
            this.debug(SonarBuildResultsLinkPanel::getResultHtmlParts$$anonfun$1);
            String resultLink = this.getResultUrlHtml(resultUrl, (Option<String>)None$.MODULE$);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(resultLink))) {
                return Option$.MODULE$.apply((Object)this.formatTableRow(resultLink, ""));
            }
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private String toFormattedTableRow(String resultUrl, Seq<QualityGateStatus> qualityGates) {
        Tuple2<Option<String>, Seq<String>> tuple2 = this.getQualityGatesHtml(qualityGates);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option projectName = (Option)tuple2._1();
        Seq qualityGatesHtml = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)projectName, (Object)qualityGatesHtml);
        Option projectName2 = (Option)tuple22._1();
        Seq qualityGatesHtml2 = (Seq)tuple22._2();
        String resultUrlLink = this.getResultUrlHtml(resultUrl, (Option<String>)projectName2);
        return this.formatTableRow(resultUrlLink, qualityGatesHtml2.mkString(""));
    }

    private Tuple2<Option<String>, Seq<String>> getQualityGatesHtml(Seq<QualityGateStatus> qualityGates) {
        Option projectName = qualityGates.headOption().map((Function1 & Serializable)_$4 -> _$4.projectName()).filter((Function1 & Serializable)_$5 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$5)));
        Seq fqStrs = (Seq)qualityGates.map((Function1 & Serializable)fg -> {
            String string = fg.status();
            switch (string == null ? 0 : string.hashCode()) {
                case -1149187101: {
                    if (!"SUCCESS".equals(string)) break;
                    return "<p><span class=\"icon icon-Successful\"></span>&nbsp;Quality gate(s) passed</p>";
                }
                case 66247144: {
                    if (!"ERROR".equals(string)) break;
                    return new StringBuilder(51).append("<p><span class=\"icon icon-Failed\"></span>&nbsp;").append(fg.message()).append("</p>").toString();
                }
                case 433141802: {
                    if (!"UNKNOWN".equals(string)) break;
                    return "<p title=\"Quality gates are only shown if task setting 'Quality gates options' is set accordingly\"><span class=\"aui-icon aui-icon-help\"></span>&nbsp;Ignoring Quality gate(s)</p>";
                }
            }
            throw new MatchError((Object)string);
        });
        return Tuple2$.MODULE$.apply((Object)projectName, (Object)fqStrs);
    }

    private String formatTableRow(String projectName, String qualityGateHtml) {
        return new StringBuilder(27).append("<tr><td>").append(projectName).append("</td><td>").append(StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(qualityGateHtml), "")).append("</td></tr>").toString();
    }

    private String formatResultUrl(String resultUrl, String projectName) {
        return new StringBuilder(15).append("<a href=\"").append(resultUrl).append("\">").append(projectName).append("</a>").toString();
    }

    private String getResultUrlHtml(String resultLink, Option<String> projectName) {
        Option<String> option = projectName;
        if (option instanceof Some) {
            String project = (String)((Some)option).value();
            return this.formatResultUrl(resultLink, project);
        }
        if (None$.MODULE$.equals(option)) {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(resultLink)) && resultLink.contains("?id=")) {
                String componentKey = URLDecoder.decode(SonarUtils$.MODULE$.extractProjectKeyFromVisitUrl(resultLink), "UTF-8");
                return this.formatResultUrl(resultLink, componentKey);
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(resultLink))) {
                return this.formatResultUrl(resultLink, "Unknown");
            }
            return "";
        }
        throw new MatchError(option);
    }

    private String getResultUrlFromVisitUrl(Option<String> displaySonarHostUrl, Option<String> sonarHostUrl, String visitUrl) {
        String url = visitUrl.contains("/dashboard/index") ? visitUrl.replace("/dashboard/index/", "/dashboard?id=") : visitUrl;
        this.debug(() -> SonarBuildResultsLinkPanel.getResultUrlFromVisitUrl$$anonfun$1(displaySonarHostUrl));
        this.debug(() -> SonarBuildResultsLinkPanel.getResultUrlFromVisitUrl$$anonfun$2(sonarHostUrl));
        this.debug(() -> SonarBuildResultsLinkPanel.getResultUrlFromVisitUrl$$anonfun$3(url));
        Option displayUrl2 = displaySonarHostUrl.flatMap((Function1 & Serializable)s -> {
            if (s.trim().isEmpty()) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply(s);
        }).flatMap((Function1 & Serializable)displayUrl -> sonarHostUrl.map((Function1 & Serializable)hostUrl -> url.replace((CharSequence)hostUrl, (CharSequence)displayUrl)));
        return (String)displayUrl2.getOrElse(() -> SonarBuildResultsLinkPanel.getResultUrlFromVisitUrl$$anonfun$4(url));
    }

    private Buffer<scala.collection.immutable.Map<String, String>> getBuildDataResults(ChainResultsSummary crs) {
        return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(crs.getOrderedJobResultSummaries()).asScala().map((Function1 & Serializable)jobSummary -> CollectionConverters$.MODULE$.MapHasAsScala(jobSummary.getCustomBuildData()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private static final Tuple2[] $anonfun$5() {
        return (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private static final List $anonfun$9() {
        return (List)new .colon.colon((Object)QualityGateStatus$.MODULE$.apply("UNKNOWN", "", "", ""), (List)Nil$.MODULE$);
    }

    private final String $anonfun$10() {
        this.warn("Unable to find build results URL because not found in job results");
        return "";
    }

    private static final String getResultHtmlParts$$anonfun$1() {
        return "No failing quality gates found";
    }

    private static final String getResultUrlFromVisitUrl$$anonfun$1(Option displaySonarHostUrl$2) {
        return new StringBuilder(13).append("Display URL: ").append(displaySonarHostUrl$2).toString();
    }

    private static final String getResultUrlFromVisitUrl$$anonfun$2(Option sonarHostUrl$2) {
        return new StringBuilder(10).append("Host URL: ").append(sonarHostUrl$2).toString();
    }

    private static final String getResultUrlFromVisitUrl$$anonfun$3(String url$1) {
        return new StringBuilder(11).append("Sonar URL: ").append(url$1).toString();
    }

    private static final String getResultUrlFromVisitUrl$$anonfun$4(String url$4) {
        return url$4;
    }
}

