/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.config;

import ch.mibex.bamboo.sonar4bamboo.InvalidLicenseInfo;
import ch.mibex.bamboo.sonar4bamboo.InvalidLicenseInfo$;
import ch.mibex.bamboo.sonar4bamboo.LicenseChecker;
import ch.mibex.bamboo.sonar4bamboo.LicenseIssue;
import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.SonarQubeEdition;
import ch.mibex.bamboo.sonar4bamboo.SonarQubeEdition$;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.BitbucketClient;
import ch.mibex.bamboo.sonar4bamboo.config.AuthMode$;
import ch.mibex.bamboo.sonar4bamboo.config.DatabaseError;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServer;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServer$;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerConfigDao;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerEntity;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials$;
import ch.mibex.bamboo.sonar4bamboo.sonar.ResponseError;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClient;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarVersions$;
import ch.mibex.bamboo.sonar4bamboo.telemetry.events.TelemetryEvents;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.bamboo.applinks.ImpersonationService;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionImpl;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public class SonarServerConfigAction
extends GlobalAdminAction
implements Logging {
    private volatile Logger ch$mibex$bamboo$sonar4bamboo$Logging$$logger;
    private final SonarServerConfigDao sonarServerConfigDao;
    private final SonarClient sonarClient;
    public final ApplicationLinkService ch$mibex$bamboo$sonar4bamboo$config$SonarServerConfigAction$$applicationLinkService;
    private final ImpersonationService impersonationService;
    private final PluginLicenseManager pluginLicenseManager;
    private final VariableDefinitionManager variableDefinitionManager;
    private final EncryptionService encryptionService;
    private final TelemetryEvents telemetry;
    private final String CreateMode;
    private final String UpdateMode;
    private final String SonarServerNameField;
    private final String SonarHostUrlField;
    private final String SonarEditionField;
    private final String EnableQgBuildBreakerField;
    private final String AllowOverrideQgBuildBreakerField;
    private final String UseQgStatusWebHookField;
    private final String SonarServerDescriptionField;
    private final String SonarServerUsernameField;
    private final String ServerTokenBambooVarField;
    private final String AuthModeField;
    private final String SonarServerUsertokenField;
    private final String SonarServerPasswordField;
    private final String ServerPwBambooVarField;
    private final String SonarOrganizationKeyField;
    private final String BambooUserNameField;
    private final String EmptyFieldErrorMsg;
    private final String UniqueFieldErrorMsg;
    private final String CannotUseLoginAndTokenMsg;
    private final String BranchingOptionsRequired;
    private final String UseLoginOrTokenMsg;
    private final String InvalidUrlMsg;
    private String action;
    private String editMode;
    private Integer serverConfigId;
    private String serverName;
    private String bambooUserName;
    private boolean enableQgBuildBreaker;
    private boolean allowOverrideQgBuildBreaker;
    private boolean useQgStatusWebHook;
    private boolean addSonarProjectLink;
    private String serverHostUrl;
    private String displayServerUrl;
    private String serverDescription;
    private String authMode;
    private String serverUsername;
    private String serverPassword;
    private String serverPwBambooVar;
    private String serverUsertoken;
    private String serverTokenBambooVar;
    private String organizationKey;
    private String sonarEdition;
    private java.util.Map<String, String> sonarEditionOptions;

    public SonarServerConfigAction(SonarServerConfigDao sonarServerConfigDao, SonarClient sonarClient, ApplicationLinkService applicationLinkService, ImpersonationService impersonationService, PluginLicenseManager pluginLicenseManager, VariableDefinitionManager variableDefinitionManager, EncryptionService encryptionService, TelemetryEvents telemetry) {
        this.sonarServerConfigDao = sonarServerConfigDao;
        this.sonarClient = sonarClient;
        this.ch$mibex$bamboo$sonar4bamboo$config$SonarServerConfigAction$$applicationLinkService = applicationLinkService;
        this.impersonationService = impersonationService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.variableDefinitionManager = variableDefinitionManager;
        this.encryptionService = encryptionService;
        this.telemetry = telemetry;
        Logging.$init$(this);
        this.CreateMode = "create";
        this.UpdateMode = "update";
        this.SonarServerNameField = "serverName";
        this.SonarHostUrlField = "serverHostUrl";
        this.SonarEditionField = "sonarEdition";
        this.EnableQgBuildBreakerField = "enableQgBuildBreaker";
        this.AllowOverrideQgBuildBreakerField = "allowOverrideQgBuildBreaker";
        this.UseQgStatusWebHookField = "useQgStatusWebHook";
        this.SonarServerDescriptionField = "serverDescription";
        this.SonarServerUsernameField = "serverUsername";
        this.ServerTokenBambooVarField = "serverTokenBambooVar";
        this.AuthModeField = "authMode";
        this.SonarServerUsertokenField = "serverUsertoken";
        this.SonarServerPasswordField = "serverPassword";
        this.ServerPwBambooVarField = "serverPwBambooVar";
        this.SonarOrganizationKeyField = "organizationKey";
        this.BambooUserNameField = "bambooUserName";
        this.EmptyFieldErrorMsg = "sonar4bamboo.admin.server.error.empty";
        this.UniqueFieldErrorMsg = "sonar4bamboo.admin.server.error.unique";
        this.CannotUseLoginAndTokenMsg = "sonar4bamboo.admin.loginandtoken.error";
        this.BranchingOptionsRequired = "sonar4bamboo.admin.branchingoptions.required.error";
        this.UseLoginOrTokenMsg = "sonar4bamboo.admin.loginortoken.required.error";
        this.InvalidUrlMsg = "sonar4bamboo.admin.invalidurl";
        this.sonarEditionOptions = CollectionConverters$.MODULE$.MapHasAsJava(SonarQubeEdition$.MODULE$.editionDescriptionsWithoutBranchPluginOption()).asJava();
    }

    @Override
    public Logger ch$mibex$bamboo$sonar4bamboo$Logging$$logger() {
        return this.ch$mibex$bamboo$sonar4bamboo$Logging$$logger;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$$logger_$eq(Logger x$1) {
        this.ch$mibex$bamboo$sonar4bamboo$Logging$$logger = x$1;
    }

    public String getAction() {
        return this.action();
    }

    public void setAction(String action) {
        this.action_$eq(action);
    }

    public String getEditMode() {
        return this.editMode();
    }

    public void setEditMode(String editMode) {
        this.editMode_$eq(editMode);
    }

    public Integer getServerConfigId() {
        return this.serverConfigId();
    }

    public void setServerConfigId(Integer serverConfigId) {
        this.serverConfigId_$eq(serverConfigId);
    }

    public String getServerName() {
        return this.serverName();
    }

    public void setServerName(String serverName) {
        this.serverName_$eq(serverName);
    }

    public String getBambooUserName() {
        return this.bambooUserName();
    }

    public void setBambooUserName(String bambooUserName) {
        this.bambooUserName_$eq(bambooUserName);
    }

    public boolean getEnableQgBuildBreaker() {
        return this.enableQgBuildBreaker();
    }

    public void setEnableQgBuildBreaker(boolean enableQgBuildBreaker) {
        this.enableQgBuildBreaker_$eq(enableQgBuildBreaker);
    }

    public boolean getAllowOverrideQgBuildBreaker() {
        return this.allowOverrideQgBuildBreaker();
    }

    public void setAllowOverrideQgBuildBreaker(boolean allowOverrideQgBuildBreaker) {
        this.allowOverrideQgBuildBreaker_$eq(allowOverrideQgBuildBreaker);
    }

    public boolean getUseQgStatusWebHook() {
        return this.useQgStatusWebHook();
    }

    public void setUseQgStatusWebHook(boolean useQgStatusWebHook) {
        this.useQgStatusWebHook_$eq(useQgStatusWebHook);
    }

    public boolean getAddSonarProjectLink() {
        return this.addSonarProjectLink();
    }

    public void setAddSonarProjectLink(boolean addSonarProjectLink) {
        this.addSonarProjectLink_$eq(addSonarProjectLink);
    }

    public String getServerHostUrl() {
        return this.serverHostUrl();
    }

    public void setServerHostUrl(String serverHostUrl) {
        this.serverHostUrl_$eq(serverHostUrl);
    }

    public String getDisplayServerUrl() {
        return this.displayServerUrl();
    }

    public void setDisplayServerUrl(String displayServerUrl) {
        this.displayServerUrl_$eq(displayServerUrl);
    }

    public String getServerDescription() {
        return this.serverDescription();
    }

    public void setServerDescription(String serverDescription) {
        this.serverDescription_$eq(serverDescription);
    }

    public String getAuthMode() {
        return this.authMode();
    }

    public void setAuthMode(String authMode) {
        this.authMode_$eq(authMode);
    }

    public String getServerUsername() {
        return this.serverUsername();
    }

    public void setServerUsername(String serverUsername) {
        this.serverUsername_$eq(serverUsername);
    }

    public String getServerPassword() {
        return this.serverPassword();
    }

    public void setServerPassword(String serverPassword) {
        this.serverPassword_$eq(serverPassword);
    }

    public String getServerPwBambooVar() {
        return this.serverPwBambooVar();
    }

    public void setServerPwBambooVar(String serverPwBambooVar) {
        this.serverPwBambooVar_$eq(serverPwBambooVar);
    }

    public String getServerUsertoken() {
        return this.serverUsertoken();
    }

    public void setServerUsertoken(String serverUsertoken) {
        this.serverUsertoken_$eq(serverUsertoken);
    }

    public String getServerTokenBambooVar() {
        return this.serverTokenBambooVar();
    }

    public void setServerTokenBambooVar(String serverTokenBambooVar) {
        this.serverTokenBambooVar_$eq(serverTokenBambooVar);
    }

    public String getOrganizationKey() {
        return this.organizationKey();
    }

    public void setOrganizationKey(String organizationKey) {
        this.organizationKey_$eq(organizationKey);
    }

    public String getSonarEdition() {
        return this.sonarEdition();
    }

    public void setSonarEdition(String sonarEdition) {
        this.sonarEdition_$eq(sonarEdition);
    }

    public java.util.Map<String, String> getSonarEditionOptions() {
        return this.sonarEditionOptions();
    }

    public void setSonarEditionOptions(java.util.Map<String, String> sonarEditionOptions) {
        this.sonarEditionOptions_$eq(sonarEditionOptions);
    }

    public String CreateMode() {
        return this.CreateMode;
    }

    public String UpdateMode() {
        return this.UpdateMode;
    }

    public String SonarServerNameField() {
        return this.SonarServerNameField;
    }

    public String SonarHostUrlField() {
        return this.SonarHostUrlField;
    }

    public String SonarEditionField() {
        return this.SonarEditionField;
    }

    public String EnableQgBuildBreakerField() {
        return this.EnableQgBuildBreakerField;
    }

    public String AllowOverrideQgBuildBreakerField() {
        return this.AllowOverrideQgBuildBreakerField;
    }

    public String UseQgStatusWebHookField() {
        return this.UseQgStatusWebHookField;
    }

    public String SonarServerDescriptionField() {
        return this.SonarServerDescriptionField;
    }

    public String SonarServerUsernameField() {
        return this.SonarServerUsernameField;
    }

    public String ServerTokenBambooVarField() {
        return this.ServerTokenBambooVarField;
    }

    public String AuthModeField() {
        return this.AuthModeField;
    }

    public String SonarServerUsertokenField() {
        return this.SonarServerUsertokenField;
    }

    public String SonarServerPasswordField() {
        return this.SonarServerPasswordField;
    }

    public String ServerPwBambooVarField() {
        return this.ServerPwBambooVarField;
    }

    public String SonarOrganizationKeyField() {
        return this.SonarOrganizationKeyField;
    }

    public String BambooUserNameField() {
        return this.BambooUserNameField;
    }

    public String EmptyFieldErrorMsg() {
        return this.EmptyFieldErrorMsg;
    }

    public String UniqueFieldErrorMsg() {
        return this.UniqueFieldErrorMsg;
    }

    public String CannotUseLoginAndTokenMsg() {
        return this.CannotUseLoginAndTokenMsg;
    }

    public String BranchingOptionsRequired() {
        return this.BranchingOptionsRequired;
    }

    public String UseLoginOrTokenMsg() {
        return this.UseLoginOrTokenMsg;
    }

    public String InvalidUrlMsg() {
        return this.InvalidUrlMsg;
    }

    public String action() {
        return this.action;
    }

    public void action_$eq(String x$1) {
        this.action = x$1;
    }

    public String editMode() {
        return this.editMode;
    }

    public void editMode_$eq(String x$1) {
        this.editMode = x$1;
    }

    public Integer serverConfigId() {
        return this.serverConfigId;
    }

    public void serverConfigId_$eq(Integer x$1) {
        this.serverConfigId = x$1;
    }

    public String serverName() {
        return this.serverName;
    }

    public void serverName_$eq(String x$1) {
        this.serverName = x$1;
    }

    public String bambooUserName() {
        return this.bambooUserName;
    }

    public void bambooUserName_$eq(String x$1) {
        this.bambooUserName = x$1;
    }

    public boolean enableQgBuildBreaker() {
        return this.enableQgBuildBreaker;
    }

    public void enableQgBuildBreaker_$eq(boolean x$1) {
        this.enableQgBuildBreaker = x$1;
    }

    public boolean allowOverrideQgBuildBreaker() {
        return this.allowOverrideQgBuildBreaker;
    }

    public void allowOverrideQgBuildBreaker_$eq(boolean x$1) {
        this.allowOverrideQgBuildBreaker = x$1;
    }

    public boolean useQgStatusWebHook() {
        return this.useQgStatusWebHook;
    }

    public void useQgStatusWebHook_$eq(boolean x$1) {
        this.useQgStatusWebHook = x$1;
    }

    public boolean addSonarProjectLink() {
        return this.addSonarProjectLink;
    }

    public void addSonarProjectLink_$eq(boolean x$1) {
        this.addSonarProjectLink = x$1;
    }

    public String serverHostUrl() {
        return this.serverHostUrl;
    }

    public void serverHostUrl_$eq(String x$1) {
        this.serverHostUrl = x$1;
    }

    public String displayServerUrl() {
        return this.displayServerUrl;
    }

    public void displayServerUrl_$eq(String x$1) {
        this.displayServerUrl = x$1;
    }

    public String serverDescription() {
        return this.serverDescription;
    }

    public void serverDescription_$eq(String x$1) {
        this.serverDescription = x$1;
    }

    public String authMode() {
        return this.authMode;
    }

    public void authMode_$eq(String x$1) {
        this.authMode = x$1;
    }

    public String serverUsername() {
        return this.serverUsername;
    }

    public void serverUsername_$eq(String x$1) {
        this.serverUsername = x$1;
    }

    public String serverPassword() {
        return this.serverPassword;
    }

    public void serverPassword_$eq(String x$1) {
        this.serverPassword = x$1;
    }

    public String serverPwBambooVar() {
        return this.serverPwBambooVar;
    }

    public void serverPwBambooVar_$eq(String x$1) {
        this.serverPwBambooVar = x$1;
    }

    public String serverUsertoken() {
        return this.serverUsertoken;
    }

    public void serverUsertoken_$eq(String x$1) {
        this.serverUsertoken = x$1;
    }

    public String serverTokenBambooVar() {
        return this.serverTokenBambooVar;
    }

    public void serverTokenBambooVar_$eq(String x$1) {
        this.serverTokenBambooVar = x$1;
    }

    public String organizationKey() {
        return this.organizationKey;
    }

    public void organizationKey_$eq(String x$1) {
        this.organizationKey = x$1;
    }

    public String sonarEdition() {
        return this.sonarEdition;
    }

    public void sonarEdition_$eq(String x$1) {
        this.sonarEdition = x$1;
    }

    public java.util.Map<String, String> sonarEditionOptions() {
        return this.sonarEditionOptions;
    }

    public void sonarEditionOptions_$eq(java.util.Map<String, String> x$1) {
        this.sonarEditionOptions = x$1;
    }

    public String doDefault() {
        Option$.MODULE$.apply((Object)this.action()).foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.addActionMessage(this.getText(new StringBuilder(35).append("sonar4bamboo.admin.messages.action.").append(this.action()).toString())));
        return "success";
    }

    public String getLicenseIssues() {
        LicenseIssue licenseIssue;
        Option<LicenseIssue> option = this.validatePluginLicense();
        if (option instanceof Some && (licenseIssue = (LicenseIssue)((Some)option).value()) instanceof InvalidLicenseInfo) {
            String string;
            InvalidLicenseInfo invalidLicenseInfo = InvalidLicenseInfo$.MODULE$.unapply((InvalidLicenseInfo)licenseIssue);
            String reason = string = invalidLicenseInfo._1();
            return reason;
        }
        return null;
    }

    private Option<LicenseIssue> validatePluginLicense() {
        LicenseChecker licenseChecker = new LicenseChecker(this.pluginLicenseManager);
        return licenseChecker.validateLicense(licenseChecker.validateLicense$default$1());
    }

    public int getServerConfigsWithPasswords() {
        return this.sonarServerConfigDao.findAll().count((Function1 & Serializable)c -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((String)Option$.MODULE$.apply((Object)c.getServerUsertoken()).getOrElse(SonarServerConfigAction::getServerConfigsWithPasswords$$anonfun$1$$anonfun$1)).trim())) || StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((String)Option$.MODULE$.apply((Object)c.getServerPassword()).getOrElse(SonarServerConfigAction::getServerConfigsWithPasswords$$anonfun$1$$anonfun$2)).trim())) || StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((String)Option$.MODULE$.apply((Object)c.getJdbcPassword()).getOrElse(SonarServerConfigAction::getServerConfigsWithPasswords$$anonfun$1$$anonfun$3)).trim())));
    }

    public List<SonarServerEntity> getSonarServerConfigs() {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.sonarServerConfigDao.findAll().map((Function1 & Serializable)s -> {
            s.setServerUsername((String)Credentials$.MODULE$.decrypt((Option<String>)Option$.MODULE$.apply((Object)s.getServerUsername()), this.encryptionService).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return (SonarServerEntity)this.migrateConfigsWithNoEdition((SonarServerEntity)s).fold((Function1 & Serializable)e -> {
                this.addActionError(this.getTextWithArgs("sonar4bamboo.admin.messages.action.editionMigrationFailed", new String[]{s.getServerName(), e.getMessage()}));
                return s;
            }, (Function1 & Serializable)x -> (SonarServerEntity)Predef$.MODULE$.identity(x));
        })).asJava();
    }

    private Either<RuntimeException, SonarServerEntity> migrateConfigsWithNoEdition(SonarServerEntity serverConfig) {
        if (this.isEmptyOrNull(serverConfig.getSonarEdition())) {
            Either<ResponseError, SonarQubeEdition> either = this.sonarClient.getSonarQubeEdition(serverConfig.getServerHostUrl(), this.getServerCredentials(), this.sonarClient.getSonarQubeEdition$default$3());
            if (either instanceof Right) {
                SonarQubeEdition edition = (SonarQubeEdition)((Right)either).value();
                return (Either)this.sonarServerConfigDao.updateSonarEdition(serverConfig.getID(), edition).fold((Function1 & Serializable)e -> package$.MODULE$.Left().apply((Object)new RuntimeException(e.msgKey())), (Function1 & Serializable)s -> package$.MODULE$.Right().apply(s));
            }
            if (either instanceof Left) {
                ResponseError err = (ResponseError)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)new RuntimeException(err.reason()));
            }
            throw new MatchError(either);
        }
        return package$.MODULE$.Right().apply((Object)serverConfig);
    }

    public List<VariableDefinition> getBambooVariables() {
        VariableDefinitionImpl noneVar = new VariableDefinitionImpl();
        noneVar.setKey("");
        noneVar.setValue("");
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.variableDefinitionManager.getGlobalVariables()).asScala().$plus$colon((Object)noneVar)).asJava();
    }

    private Option<String> checkPluginLicense() {
        LicenseIssue licenseIssue;
        Option<LicenseIssue> option = this.validatePluginLicense();
        if (option instanceof Some && (licenseIssue = (LicenseIssue)((Some)option).value()) instanceof InvalidLicenseInfo) {
            String string;
            InvalidLicenseInfo invalidLicenseInfo = InvalidLicenseInfo$.MODULE$.unapply((InvalidLicenseInfo)licenseIssue);
            String reason = string = invalidLicenseInfo._1();
            this.addActionError(reason);
            return Some$.MODULE$.apply((Object)"error");
        }
        return None$.MODULE$;
    }

    public String doAdd() {
        this.editMode_$eq(this.CreateMode());
        this.detectSonarEdition().foreach((Function1)(JProcedure1 & Serializable)e -> this.sonarEdition_$eq(e.dbKey()));
        this.initFormFieldsWhenCreate();
        return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doAdd$$anonfun$2);
    }

    public String doEdit() {
        this.editMode_$eq(this.UpdateMode());
        Option<SonarServerEntity> option = this.sonarServerConfigDao.findById(Predef$.MODULE$.Integer2int(this.serverConfigId()));
        if (option instanceof Some) {
            SonarServerEntity server = (SonarServerEntity)((Some)option).value();
            this.initFormFields(server);
            this.addBranchPluginOptionIfSonarEditionIsCommunityBranch(server.getSonarEdition());
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doEdit$$anonfun$1);
        }
        if (None$.MODULE$.equals(option)) {
            this.addActionError(this.getText("sonar4bamboo.admin.no.server.found"));
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doEdit$$anonfun$2);
        }
        throw new MatchError(option);
    }

    public String doDelete() {
        Option<SonarServerEntity> option = this.sonarServerConfigDao.findById(Predef$.MODULE$.Integer2int(this.serverConfigId()));
        if (option instanceof Some) {
            SonarServerEntity server = (SonarServerEntity)((Some)option).value();
            this.initFormFields(server);
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doDelete$$anonfun$1);
        }
        if (None$.MODULE$.equals(option)) {
            this.addActionError(this.getText("sonar4bamboo.admin.no.server.found"));
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doDelete$$anonfun$2);
        }
        throw new MatchError(option);
    }

    public String doRemove() {
        Option<DatabaseError> option = this.sonarServerConfigDao.delete(Predef$.MODULE$.Integer2int(this.serverConfigId()));
        if (option instanceof Some) {
            DatabaseError failure = (DatabaseError)((Some)option).value();
            this.addActionError(this.getText(failure.msgKey()));
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doRemove$$anonfun$1);
        }
        if (None$.MODULE$.equals(option)) {
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doRemove$$anonfun$2);
        }
        throw new MatchError(option);
    }

    public String doUpdate() {
        this.editMode_$eq(this.UpdateMode());
        if (this.isEmptyOrNull(this.sonarEdition())) {
            this.detectSonarEdition().foreach((Function1)(JProcedure1 & Serializable)e -> this.sonarEdition_$eq(e.dbKey()));
        }
        Option<ArtifactVersion> version = this.validateSonarServer();
        this.validateAuthentication();
        if (this.hasAnyErrors()) {
            this.debug(this::doUpdate$$anonfun$2);
            this.addBranchPluginOptionIfSonarEditionIsCommunityBranch(this.sonarEdition());
            this.addActionError(this.getText("sonar4bamboo.admin.server.task.validation.errors"));
            return "error";
        }
        Either<DatabaseError, SonarServerEntity> either = this.sonarServerConfigDao.update(Predef$.MODULE$.Integer2int(this.serverConfigId()), this.collectFormSettings());
        if (either instanceof Left) {
            DatabaseError failure = (DatabaseError)((Left)either).value();
            this.addActionError(this.getText(failure.msgKey()));
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doUpdate$$anonfun$3);
        }
        if (either instanceof Right) {
            SonarServerEntity updatedConfig = (SonarServerEntity)((Right)either).value();
            int amountOfServers = this.sonarServerConfigDao.count();
            this.telemetry.serverConfigured("UPDATED", amountOfServers, version, updatedConfig);
            return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doUpdate$$anonfun$4);
        }
        throw new MatchError(either);
    }

    public String doCreate() {
        this.editMode_$eq(this.CreateMode());
        this.detectSonarEdition().foreach((Function1)(JProcedure1 & Serializable)e -> this.sonarEdition_$eq(e.dbKey()));
        this.authMode_$eq(AuthMode$.MODULE$.TokenAuth().toString());
        Option<ArtifactVersion> version = this.validateSonarServer();
        this.validateAuthentication();
        if (this.hasAnyErrors()) {
            this.debug(this::doCreate$$anonfun$2);
            this.addActionError(this.getText("sonar4bamboo.admin.server.task.validation.errors"));
            return "error";
        }
        SonarServerEntity newSonarServerConfig = this.sonarServerConfigDao.create(this.collectFormSettings());
        this.serverConfigId_$eq(Predef$.MODULE$.int2Integer(newSonarServerConfig.getID()));
        int amountOfServers = this.sonarServerConfigDao.count();
        this.telemetry.serverConfigured("ADDED", amountOfServers, version, newSonarServerConfig);
        return (String)this.checkPluginLicense().getOrElse(SonarServerConfigAction::doCreate$$anonfun$3);
    }

    private void addBranchPluginOptionIfSonarEditionIsCommunityBranch(String edition) {
        String string = SonarQubeEdition$.COMMUNITY_EDITION_BRANCH.dbKey();
        String string2 = edition;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)SonarQubeEdition$.COMMUNITY_EDITION_BRANCH.dbKey());
            this.sonarEditionOptions_$eq(CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(this.sonarEditionOptions()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)SonarQubeEdition$.COMMUNITY_EDITION_BRANCH.displayName()))).asJava());
            return;
        }
    }

    private SonarServer collectFormSettings() {
        String string = this.serverName();
        String string2 = this.serverHostUrl();
        String string3 = this.displayServerUrl();
        boolean bl = this.enableQgBuildBreaker();
        boolean bl2 = this.allowOverrideQgBuildBreaker();
        boolean bl3 = this.useQgStatusWebHook();
        boolean bl4 = this.addSonarProjectLink();
        String string4 = this.serverDescription();
        String string5 = this.bambooUserName();
        String string6 = AuthMode$.MODULE$.isSimpleAuth(this.authMode()) ? this.serverUsername() : null;
        String string7 = AuthMode$.MODULE$.isSimpleAuth(this.authMode()) ? this.serverPassword() : null;
        String string8 = AuthMode$.MODULE$.isSimpleAuth(this.authMode()) ? this.serverPwBambooVar() : null;
        String string9 = AuthMode$.MODULE$.isTokenAuth(this.authMode()) ? this.serverUsertoken() : null;
        String string10 = AuthMode$.MODULE$.isTokenAuth(this.authMode()) ? this.serverTokenBambooVar() : null;
        String string11 = this.organizationKey();
        String string12 = this.sonarEdition();
        return SonarServer$.MODULE$.apply(string, string2, string3, bl, bl2, bl3, bl4, string4, string11, string5, string6, string7, string8, string9, string10, string12);
    }

    private void initFormFieldsWhenCreate() {
        String string = this.editMode();
        String string2 = this.CreateMode();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.allowOverrideQgBuildBreaker_$eq(true);
            return;
        }
    }

    private boolean isEmptyOrNull(String value) {
        return ((String)Option$.MODULE$.apply((Object)value).getOrElse(SonarServerConfigAction::isEmptyOrNull$$anonfun$1)).trim().isEmpty();
    }

    private boolean isNonEmpty(String value) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((String)Option$.MODULE$.apply((Object)value).getOrElse(SonarServerConfigAction::isNonEmpty$$anonfun$1)).trim()));
    }

    private Option<SonarQubeEdition> detectSonarEdition() {
        if (this.isEmptyOrNull(this.serverHostUrl())) {
            return None$.MODULE$;
        }
        Either<ResponseError, SonarQubeEdition> either = this.sonarClient.getSonarQubeEdition(this.serverHostUrl(), this.getServerCredentials(), this.sonarClient.getSonarQubeEdition$default$3());
        if (either instanceof Left) {
            ResponseError error = (ResponseError)((Left)either).value();
            String string = this.editMode();
            String string2 = this.CreateMode();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.addFieldError(this.SonarHostUrlField(), error.reason());
            } else {
                this.addFieldError(this.SonarEditionField(), error.reason());
            }
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            SonarQubeEdition edition = (SonarQubeEdition)((Right)either).value();
            return Option$.MODULE$.apply((Object)edition);
        }
        throw new MatchError(either);
    }

    private void validateAuthentication() {
        if (AuthMode$.MODULE$.isSimpleAuth(this.authMode()) && this.isEmptyOrNull(this.serverUsername())) {
            this.addFieldError(this.SonarServerUsernameField(), this.getText(this.EmptyFieldErrorMsg()));
        }
        if (AuthMode$.MODULE$.isSimpleAuth(this.authMode()) && this.isEmptyOrNull(this.serverPwBambooVar()) && this.isEmptyOrNull(this.serverPassword())) {
            this.addFieldError(this.ServerPwBambooVarField(), this.getText(this.EmptyFieldErrorMsg()));
        }
        if (AuthMode$.MODULE$.isTokenAuth(this.authMode()) && this.isEmptyOrNull(this.serverTokenBambooVar()) && this.isEmptyOrNull(this.serverUsertoken())) {
            this.addFieldError(this.ServerTokenBambooVarField(), this.getText(this.EmptyFieldErrorMsg()));
        }
        if (this.isNonEmpty(this.serverUsertoken()) && this.isNonEmpty(this.serverTokenBambooVar())) {
            this.addFieldError(this.SonarServerUsertokenField(), this.getText("sonar4bamboo.admin.server.notvariableandtoken"));
        }
        if (this.isNonEmpty(this.serverPwBambooVar()) && this.isNonEmpty(this.serverPassword())) {
            this.addFieldError(this.SonarServerPasswordField(), this.getText("sonar4bamboo.admin.server.notvariableandpassword"));
        }
        if (this.isNonEmpty(this.serverPwBambooVar()) && !PasswordMaskingUtils.shouldBeMasked((String)this.serverPwBambooVar())) {
            this.addFieldError(this.ServerPwBambooVarField(), this.getText("sonar4bamboo.admin.server.nopwvariable"));
        }
        if (this.isNonEmpty(this.serverTokenBambooVar()) && !PasswordMaskingUtils.shouldBeMasked((String)this.serverTokenBambooVar())) {
            this.addFieldError(this.ServerTokenBambooVarField(), this.getText("sonar4bamboo.admin.server.nopwvariable"));
            return;
        }
    }

    private Option<ArtifactVersion> validateSonarServer() {
        if (this.isNonEmpty(this.bambooUserName())) {
            this.checkBitbucketConnection();
        }
        if (this.isEmptyOrNull(this.serverName())) {
            this.addFieldError(this.SonarServerNameField(), this.getText(this.EmptyFieldErrorMsg()));
        } else if (this.serverNameExists(this.serverName())) {
            this.addFieldError(this.SonarServerNameField(), this.getText(this.UniqueFieldErrorMsg()));
        } else if (this.isEmptyOrNull(this.serverHostUrl())) {
            this.addFieldError(this.SonarHostUrlField(), this.getText(this.EmptyFieldErrorMsg()));
        } else if (!this.isValidURI(this.serverHostUrl())) {
            this.addFieldError(this.SonarHostUrlField(), this.getText(this.InvalidUrlMsg()));
        } else {
            return this.checkServerConnection();
        }
        return None$.MODULE$;
    }

    private boolean isValidURI(String uri) {
        boolean bl;
        try {
            URI uRI = URI.create(uri);
            bl = true;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private boolean serverNameExists(String serverName) {
        Object existingId = Option$.MODULE$.apply((Object)this.serverConfigId()).getOrElse(SonarServerConfigAction::$anonfun$1);
        return this.sonarServerConfigDao.findAll().exists((Function1 & Serializable)e -> {
            String string = e.getServerName();
            String string2 = serverName;
            return !(string != null ? !string.equals(string2) : string2 != null) && !BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)e.getID()), (Object)existingId);
        });
    }

    private void checkBitbucketConnection() {
        this.impersonationService.runAsUser(this.bambooUserName(), (Callable)new Callable<BoxedUnit>(this){
            private final /* synthetic */ SonarServerConfigAction $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void call() {
                BitbucketClient client = new BitbucketClient(this.$outer.ch$mibex$bamboo$sonar4bamboo$config$SonarServerConfigAction$$applicationLinkService);
                try {
                    client.checkBitbucketConnection();
                }
                catch (CredentialsRequiredException e) {
                    String authUrl = e.getAuthorisationURI().toString();
                    this.$outer.addFieldError(this.$outer.BambooUserNameField(), this.$outer.getText("sonar4bamboo.admin.applink.error", new String[]{authUrl}));
                }
                catch (Exception e) {
                    this.$outer.addFieldError(this.$outer.BambooUserNameField(), e.getMessage());
                }
            }
        }).call();
    }

    private Option<ArtifactVersion> checkServerConnection() {
        None$ none$;
        block10: {
            try {
                Either<ResponseError, ArtifactVersion> either = this.sonarClient.getSonarVersion(this.serverHostUrl());
                if (either instanceof Left) {
                    ResponseError err = (ResponseError)((Left)either).value();
                    this.addFieldError(this.SonarHostUrlField(), this.getText("sonar4bamboo.admin.server.error.connecting", new String[]{err.reason()}));
                    none$ = None$.MODULE$;
                    break block10;
                }
                if (either instanceof Right) {
                    ArtifactVersion artifactVersion = (ArtifactVersion)((Right)either).value();
                    ArtifactVersion version = artifactVersion;
                    if (version.compareTo((Object)SonarVersions$.MODULE$.RequiredMinimumVersion()) < 0) {
                        this.addFieldError(this.SonarHostUrlField(), this.getTextWithArgs("sonar4bamboo.admin.server.error.wrongversion", new String[]{SonarVersions$.MODULE$.RequiredMinimumVersion().toString()}));
                        none$ = None$.MODULE$;
                    } else {
                        boolean success;
                        ArtifactVersion version2 = artifactVersion;
                        Either<ResponseError, Object> either2 = this.sonarClient.authenticate(this.serverHostUrl(), this.getServerCredentials());
                        if (either2 instanceof Left) {
                            ResponseError err = (ResponseError)((Left)either2).value();
                            this.addFieldError(this.SonarHostUrlField(), this.getText("sonar4bamboo.admin.server.error.connecting", new String[]{err.reason()}));
                            none$ = None$.MODULE$;
                        } else if (either2 instanceof Right && !(success = BoxesRunTime.unboxToBoolean((Object)((Right)either2).value()))) {
                            this.addFieldError(this.isNonEmpty(this.serverTokenBambooVar()) ? this.ServerTokenBambooVarField() : (this.isNonEmpty(this.serverUsertoken()) ? this.SonarServerUsertokenField() : (this.isNonEmpty(this.serverUsername()) ? this.SonarServerUsernameField() : this.SonarHostUrlField())), this.getText("sonar4bamboo.admin.auth.error"));
                            none$ = None$.MODULE$;
                        } else {
                            none$ = Some$.MODULE$.apply((Object)version2);
                        }
                    }
                    break block10;
                }
                throw new MatchError(either);
            }
            catch (Exception e) {
                this.addFieldError(this.SonarHostUrlField(), this.getText("sonar4bamboo.admin.server.error.connecting", new String[]{e.getMessage()}));
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private Credentials getServerCredentials() {
        if (AuthMode$.MODULE$.isSimpleAuth(this.authMode())) {
            String pwVariable;
            Option login = Option$.MODULE$.apply((Object)this.serverUsername()).filter((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2.trim())));
            Option option = Option$.MODULE$.apply((Object)this.serverPwBambooVar());
            Option<String> pw = option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((pwVariable = (String)((Some)option).value()).trim())) ? Credentials$.MODULE$.getVariableValue(pwVariable, this.variableDefinitionManager) : Credentials$.MODULE$.decrypt((Option<String>)Option$.MODULE$.apply((Object)this.serverPassword()), this.encryptionService);
            return Credentials$.MODULE$.apply((String)login.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), pw);
        }
        Option<String> token = this.isNonEmpty(this.serverTokenBambooVar()) ? Credentials$.MODULE$.getVariableValue(this.serverTokenBambooVar(), this.variableDefinitionManager) : (this.isNonEmpty(this.serverUsertoken()) ? Credentials$.MODULE$.decrypt((Option<String>)Option$.MODULE$.apply((Object)this.serverUsertoken()), this.encryptionService) : None$.MODULE$);
        return Credentials$.MODULE$.apply((String)token.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<String>)None$.MODULE$);
    }

    private String getAuthMode(SonarServerEntity config) {
        if (this.isNonEmpty(config.getServerUsername())) {
            return "useSimpleAuth";
        }
        return "useTokenAuth";
    }

    private void initFormFields(SonarServerEntity server) {
        this.serverConfigId_$eq(Predef$.MODULE$.int2Integer(server.getID()));
        this.serverName_$eq(server.getServerName());
        this.enableQgBuildBreaker_$eq(BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)server.getEnableQgBuildBreaker()).map((Function1 & Serializable)_$3 -> _$3).getOrElse(SonarServerConfigAction::initFormFields$$anonfun$2)));
        this.allowOverrideQgBuildBreaker_$eq(BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)server.getOverrideQgBuildBreaker()).map((Function1 & Serializable)_$4 -> _$4).getOrElse(SonarServerConfigAction::initFormFields$$anonfun$4)));
        this.useQgStatusWebHook_$eq(BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)server.getUseQgStatusWebHook()).map((Function1 & Serializable)_$5 -> _$5).getOrElse(SonarServerConfigAction::initFormFields$$anonfun$6)));
        this.addSonarProjectLink_$eq(BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)server.getAddSonarProjectLink()).map((Function1 & Serializable)_$6 -> _$6).getOrElse(SonarServerConfigAction::initFormFields$$anonfun$8)));
        this.bambooUserName_$eq(server.getBambooUserName());
        this.serverUsername_$eq(server.getServerUsername());
        this.serverUsertoken_$eq(server.getServerUsertoken());
        this.serverTokenBambooVar_$eq(server.getServerTokenBambooVar());
        this.serverPassword_$eq(server.getServerPassword());
        this.serverPwBambooVar_$eq(server.getServerPwBambooVar());
        this.serverHostUrl_$eq(server.getServerHostUrl());
        this.displayServerUrl_$eq(server.getDisplayServerHostUrl());
        this.serverDescription_$eq(server.getServerDescription());
        this.authMode_$eq(this.getAuthMode(server));
        this.organizationKey_$eq(server.getOrganizationKey());
        this.sonarEdition_$eq(this.isNonEmpty(server.getSonarEdition()) ? server.getSonarEdition() : (String)this.detectSonarEdition().map((Function1 & Serializable)_$7 -> _$7.dbKey()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private static final String getServerConfigsWithPasswords$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final String getServerConfigsWithPasswords$$anonfun$1$$anonfun$2() {
        return "";
    }

    private static final String getServerConfigsWithPasswords$$anonfun$1$$anonfun$3() {
        return "";
    }

    private static final String doAdd$$anonfun$2() {
        return "input";
    }

    private static final String doEdit$$anonfun$1() {
        return "input";
    }

    private static final String doEdit$$anonfun$2() {
        return "error";
    }

    private static final String doDelete$$anonfun$1() {
        return "input";
    }

    private static final String doDelete$$anonfun$2() {
        return "error";
    }

    private static final String doRemove$$anonfun$1() {
        return "error";
    }

    private static final String doRemove$$anonfun$2() {
        return "success";
    }

    private final String doUpdate$$anonfun$2() {
        return new StringBuilder(18).append("Validation error: ").append(CollectionConverters$.MODULE$.MapHasAsScala(this.getFieldErrors()).asScala().mkString(",")).toString();
    }

    private static final String doUpdate$$anonfun$3() {
        return "error";
    }

    private static final String doUpdate$$anonfun$4() {
        return "success";
    }

    private final String doCreate$$anonfun$2() {
        return new StringBuilder(18).append("Validation error: ").append(CollectionConverters$.MODULE$.MapHasAsScala(this.getFieldErrors()).asScala().mkString(",")).toString();
    }

    private static final String doCreate$$anonfun$3() {
        return "success";
    }

    private static final String isEmptyOrNull$$anonfun$1() {
        return "";
    }

    private static final String isNonEmpty$$anonfun$1() {
        return "";
    }

    private static final Object $anonfun$1() {
        return BoxesRunTime.boxToInteger((int)-1);
    }

    private static final boolean initFormFields$$anonfun$2() {
        return false;
    }

    private static final boolean initFormFields$$anonfun$4() {
        return true;
    }

    private static final boolean initFormFields$$anonfun$6() {
        return false;
    }

    private static final boolean initFormFields$$anonfun$8() {
        return false;
    }
}

