/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.atlassian.dc;

import ch.mibex.atlassian.Logging;
import ch.mibex.atlassian.dc.InvalidLicenseInfo;
import ch.mibex.atlassian.dc.InvalidLicenseInfo$;
import ch.mibex.atlassian.dc.LicenseChecker$;
import ch.mibex.atlassian.dc.LicenseIssue;
import ch.mibex.atlassian.dc.LicenseWarning;
import ch.mibex.atlassian.dc.LicenseWarning$;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class LicenseChecker
implements Logging {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LicenseChecker.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final PluginLicenseManager licenseManager;
    private final int TwoWeek;

    public static <T> RichJOption<T> RichJOption(com.atlassian.upm.api.util.Option<T> option) {
        return LicenseChecker$.MODULE$.RichJOption(option);
    }

    public static Map<String, String> translations(String string) {
        return LicenseChecker$.MODULE$.translations(string);
    }

    public LicenseChecker(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
        Logging.$init$(this);
        this.TwoWeek = 14;
    }

    @Override
    public Logger log() {
        Object object = this.log$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = Logging.log$(this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String LogPrefix() {
        return "ch.mibex.LicenseChecker: ";
    }

    public int TwoWeek() {
        return this.TwoWeek;
    }

    public Option<InvalidLicenseInfo> validLicenseWithGracePeriod(Function1<String, String> translations) {
        return this.validateLicense(translations, (Function0<Object>)((Function0 & Serializable)LicenseChecker::validLicenseWithGracePeriod$$anonfun$1), this.validateLicense$default$3()).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(LicenseIssue x) {
                LicenseIssue licenseIssue = x;
                if (licenseIssue instanceof InvalidLicenseInfo) {
                    InvalidLicenseInfo i = (InvalidLicenseInfo)licenseIssue;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(LicenseIssue x, Function1 function1) {
                LicenseIssue licenseIssue = x;
                if (licenseIssue instanceof InvalidLicenseInfo) {
                    InvalidLicenseInfo i = (InvalidLicenseInfo)licenseIssue;
                    return i;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Option<LicenseIssue> validateLicense(Function1<String, String> translations, Function0<Object> showLicenseWarnings, Date currentDate) {
        Object object;
        block11: {
            if (Option$.MODULE$.apply((Object)this.licenseManager).isEmpty()) {
                object = Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.noinfo"));
            } else {
                try {
                    Option option = LicenseChecker$.MODULE$.RichJOption(this.licenseManager.getLicense()).asScala();
                    if (option instanceof Some) {
                        PluginLicense pluginLicense = (PluginLicense)((Some)option).value();
                        PluginLicense l = pluginLicense;
                        if (l.isValid()) {
                            DateTime expiryDate;
                            Option option2 = LicenseChecker$.MODULE$.RichJOption(l.getExpiryDate()).asScala();
                            object = option2 instanceof Some && this.getDiff(currentDate, (expiryDate = (DateTime)((Some)option2).value()).toDate()) <= (long)this.TwoWeek() ? Some$.MODULE$.apply((Object)LicenseWarning$.MODULE$.apply("license.expiring.soon.warning")) : None$.MODULE$;
                        } else {
                            LicenseError e;
                            PluginLicense l2 = pluginLicense;
                            Option option3 = LicenseChecker$.MODULE$.RichJOption(l2.getError()).asScala();
                            if (option3 instanceof Some && (e = (LicenseError)((Some)option3).value()) != null) {
                                object = this.handleLicenseError(l2, e);
                            } else {
                                this.warn("No license info found");
                                object = Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.unknown.error"));
                            }
                        }
                        break block11;
                    }
                    if (None$.MODULE$.equals(option)) {
                        object = Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.nolicense"));
                        break block11;
                    }
                    if (option == null) {
                        object = None$.MODULE$;
                        break block11;
                    }
                    throw new MatchError(option);
                }
                catch (Exception e) {
                    this.warn("Failed to retrieve license information", e);
                    object = Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.unresolved.exception"));
                }
            }
        }
        Some result = object;
        return result.filter((Function1 & Serializable)x$1 -> {
            Serializable serializable = x$1;
            if (serializable instanceof LicenseWarning) {
                return showLicenseWarnings.apply$mcZ$sp();
            }
            return true;
        }).map((Function1 & Serializable)x$1 -> {
            Product product;
            Serializable serializable = x$1;
            if (serializable instanceof InvalidLicenseInfo) {
                String string;
                InvalidLicenseInfo invalidLicenseInfo = InvalidLicenseInfo$.MODULE$.unapply((InvalidLicenseInfo)serializable);
                String reason = string = invalidLicenseInfo._1();
                product = InvalidLicenseInfo$.MODULE$.apply((String)translations.apply((Object)reason));
            } else if (serializable instanceof LicenseWarning) {
                String string;
                LicenseWarning licenseWarning = LicenseWarning$.MODULE$.unapply((LicenseWarning)serializable);
                String text = string = licenseWarning._1();
                product = LicenseWarning$.MODULE$.apply((String)translations.apply((Object)text));
            } else {
                throw new MatchError((Object)serializable);
            }
            return product;
        });
    }

    public Date validateLicense$default$3() {
        return new Date();
    }

    private Some<Serializable> handleLicenseError(PluginLicense l, LicenseError e) {
        LicenseError licenseError = e;
        LicenseError licenseError2 = LicenseError.EXPIRED;
        LicenseError licenseError3 = licenseError;
        if (!(licenseError2 != null ? !licenseError2.equals(licenseError3) : licenseError3 != null)) {
            if (l.isEvaluation()) {
                return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.evaluation.expired"));
            }
            if (!l.isDataCenter() && l.isMaintenanceExpired()) {
                return Some$.MODULE$.apply((Object)LicenseWarning$.MODULE$.apply("license.maintenance.expired"));
            }
            return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.expired"));
        }
        LicenseError licenseError4 = LicenseError.TYPE_MISMATCH;
        LicenseError licenseError5 = licenseError;
        if (!(licenseError4 != null ? !licenseError4.equals(licenseError5) : licenseError5 != null)) {
            return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.typemismatch"));
        }
        LicenseError licenseError6 = LicenseError.USER_MISMATCH;
        LicenseError licenseError7 = licenseError;
        if (!(licenseError6 != null ? !licenseError6.equals(licenseError7) : licenseError7 != null)) {
            return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.usermismatch"));
        }
        LicenseError licenseError8 = LicenseError.VERSION_MISMATCH;
        LicenseError licenseError9 = licenseError;
        if (!(licenseError8 != null ? !licenseError8.equals(licenseError9) : licenseError9 != null)) {
            return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.versionmismatch"));
        }
        LicenseError licenseError10 = LicenseError.EDITION_MISMATCH;
        LicenseError licenseError11 = licenseError;
        if (!(licenseError10 != null ? !licenseError10.equals(licenseError11) : licenseError11 != null)) {
            return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.edition.mismatch"));
        }
        this.warn("Unknown license error");
        return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply("license.unknown.error"));
    }

    private long getDiff(Date date1, Date date2) {
        return TimeUnit.DAYS.convert(LicenseChecker.diffInMillis$1(date1, date2), TimeUnit.MILLISECONDS);
    }

    private static final boolean validLicenseWithGracePeriod$$anonfun$1() {
        return true;
    }

    private static final long diffInMillis$1(Date date1$1, Date date2$1) {
        return Math.abs(date2$1.getTime() - date1$1.getTime());
    }

    public static final class RichJOption<T> {
        private final com.atlassian.upm.api.util.Option optional;

        public RichJOption(com.atlassian.upm.api.util.Option<T> optional) {
            this.optional = optional;
        }

        public com.atlassian.upm.api.util.Option<T> optional() {
            return this.optional;
        }

        public Option<T> asScala() {
            com.atlassian.upm.api.util.Option<T> option = this.optional();
            if (option == null) {
                return null;
            }
            if (this.optional().isDefined()) {
                return Option$.MODULE$.apply(this.optional().get());
            }
            return None$.MODULE$;
        }
    }
}

