/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.results;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerConfigDao;
import ch.mibex.bamboo.sonar4bamboo.config.SonarServerEntity;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials;
import ch.mibex.bamboo.sonar4bamboo.sonar.Credentials$;
import ch.mibex.bamboo.sonar4bamboo.sonar.ProjectLink;
import ch.mibex.bamboo.sonar4bamboo.sonar.ResponseError;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarClient;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarConstants$;
import ch.mibex.bamboo.sonar4bamboo.sonar.SonarUtils$;
import ch.mibex.bamboo.sonar4bamboo.tasks.SonarTaskConfigConstants$;
import com.atlassian.bamboo.build.CustomBuildProcessorServer;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.Serializable;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class BambooBackLinkCreator
implements CustomBuildProcessorServer,
Logging {
    private Logger log;
    private final SonarClient sonarClient;
    private final CustomVariableContext customVariableContext;
    private final ApplicationProperties applicationProperties;
    private final SonarServerConfigDao sonarServerConfigDao;

    public BambooBackLinkCreator(SonarClient sonarClient, CustomVariableContext customVariableContext, ApplicationProperties applicationProperties, SonarServerConfigDao sonarServerConfigDao) {
        this.sonarClient = sonarClient;
        this.customVariableContext = customVariableContext;
        this.applicationProperties = applicationProperties;
        this.sonarServerConfigDao = sonarServerConfigDao;
        Logging.$init$(this);
        String BambooLinkName = "Sonar for Bamboo";
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public void init(BuildContext buildContext) {
        this.createBambooBackLinkInSonar(buildContext);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createBambooBackLinkInSonar(BuildContext buildContext) {
        Either<ResponseError, BoxedUnit> either;
        Tuple3 tuple3;
        Option serverParams = this.findSonarTask(buildContext).flatMap((Function1 & Serializable)sonarTask -> this.findSonarVisitUrl(buildContext).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String visitUrl = (String)tuple2._2();
                return true;
            }
            return false;
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String visitUrl = (String)tuple2._2();
                return this.getSonarUrlFromServerConfig((RuntimeTaskDefinition)sonarTask).map((Function1 & Serializable)sonarServer -> Tuple3$.MODULE$.apply((Object)visitUrl, sonarTask, sonarServer));
            }
            throw new MatchError((Object)tuple2);
        }));
        Option option = serverParams;
        if (option instanceof Some && (tuple3 = (Tuple3)((Some)option).value()) != null) {
            String visitUrl = (String)tuple3._1();
            RuntimeTaskDefinition sonarTask2 = (RuntimeTaskDefinition)tuple3._2();
            SonarServerEntity sonarServer = (SonarServerEntity)tuple3._3();
            if (Predef$.MODULE$.Boolean2boolean(sonarServer.getAddSonarProjectLink())) {
                String projectKey = SonarUtils$.MODULE$.extractProjectKeyFromVisitUrl(visitUrl);
                String planUrl = this.createBuildResultUrl(buildContext);
                Credentials credentials = Credentials$.MODULE$.by(sonarTask2, this.customVariableContext);
                Option option2 = Option$.MODULE$.apply((Object)sonarServer.getServerHostUrl());
                if (option2 instanceof Some) {
                    String sonarServerUrl = (String)((Some)option2).value();
                    this.deleteObsoleteBambooProjectLink(sonarServerUrl, projectKey, credentials);
                    either = this.sonarClient.createProjectLink(projectKey, planUrl, "Sonar for Bamboo", sonarServerUrl, credentials);
                    return;
                }
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                this.warn("No SonarQube server URL found to apply Bamboo back link");
                either = BoxedUnit.UNIT;
                return;
            }
        }
        this.debug(BambooBackLinkCreator::createBambooBackLinkInSonar$$anonfun$1);
        either = BoxedUnit.UNIT;
    }

    private void deleteObsoleteBambooProjectLink(String sonarServerUrl, String projectKey, Credentials credentials) {
        Either<ResponseError, Seq<ProjectLink>> either = this.sonarClient.searchProjectLinks(projectKey, sonarServerUrl, credentials);
        if (either instanceof Left) {
            ResponseError err = (ResponseError)((Left)either).value();
            this.error(new StringBuilder(35).append("Failed to find project links for ").append(projectKey).append(": ").append(err.reason()).toString());
            return;
        }
        if (either instanceof Right) {
            Seq links = (Seq)((Right)either).value();
            links.find((Function1 & Serializable)_$1 -> {
                String string = _$1.name();
                String string2 = "Sonar for Bamboo";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).foreach((Function1 & Serializable)link -> this.sonarClient.deleteProjectLink(link.id(), sonarServerUrl, credentials));
            return;
        }
        throw new MatchError(either);
    }

    private Option<Tuple2<String, String>> findSonarVisitUrl(BuildContext buildContext) {
        return CollectionConverters$.MODULE$.MapHasAsScala(buildContext.getCurrentResult().getCustomBuildData()).asScala().find((Function1 & Serializable)_$2 -> {
            Object object = _$2._1();
            String string = SonarConstants$.MODULE$.SonarVisitUrl();
            return !(object != null ? !object.equals(string) : string != null);
        });
    }

    private String createBuildResultUrl(BuildContext buildContext) {
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.AUTO);
        String key = buildContext.getPlanResultKey().toString();
        return new StringBuilder(8).append(baseUrl).append("/browse/").append(key).toString();
    }

    private Option<RuntimeTaskDefinition> findSonarTask(BuildContext buildContext) {
        return CollectionConverters$.MODULE$.ListHasAsScala(buildContext.getRuntimeTaskDefinitions()).asScala().find((Function1 & Serializable)_$3 -> _$3.getPluginKey().contains("ch.mibex.bamboo.sonar4bamboo"));
    }

    private Option<SonarServerEntity> getSonarUrlFromServerConfig(RuntimeTaskDefinition runtimeTaskDefinition) {
        return Option$.MODULE$.apply(runtimeTaskDefinition.getConfiguration().get(SonarTaskConfigConstants$.MODULE$.ChosenSonarConfigIdField())).withFilter((Function1 & Serializable)sonarServerId -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sonarServerId))).flatMap((Function1 & Serializable)sonarServerId -> this.sonarServerConfigDao.findById(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sonarServerId))).map((Function1 & Serializable)sonarServer -> sonarServer));
    }

    public BuildContext call() {
        return null;
    }

    private static final String createBambooBackLinkInSonar$$anonfun$1() {
        return "No Sonar task configuration found to apply Bamboo back link";
    }
}

