/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo;

import ch.mibex.bamboo.sonar4bamboo.InvalidLicenseInfo$;
import ch.mibex.bamboo.sonar4bamboo.LicenseChecker$;
import ch.mibex.bamboo.sonar4bamboo.LicenseIssue;
import ch.mibex.bamboo.sonar4bamboo.LicenseWarning$;
import ch.mibex.bamboo.sonar4bamboo.Logging;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.concurrent.duration.package$;
import scala.runtime.Statics;

public class LicenseChecker
implements Logging {
    private Logger log;
    private final PluginLicenseManager licenseManager;
    private final int TwoWeek;

    public static String EditionMismatchMsg() {
        return LicenseChecker$.MODULE$.EditionMismatchMsg();
    }

    public static String EvaluationLicenseExpiredMsg() {
        return LicenseChecker$.MODULE$.EvaluationLicenseExpiredMsg();
    }

    public static String ExpiringSoonWarningMsg() {
        return LicenseChecker$.MODULE$.ExpiringSoonWarningMsg();
    }

    public static String LicenseExpiredMsg() {
        return LicenseChecker$.MODULE$.LicenseExpiredMsg();
    }

    public static String MaintenanceExpiredMsg() {
        return LicenseChecker$.MODULE$.MaintenanceExpiredMsg();
    }

    public static String NoInfoMsg() {
        return LicenseChecker$.MODULE$.NoInfoMsg();
    }

    public static String NoLicenseFoundMsg() {
        return LicenseChecker$.MODULE$.NoLicenseFoundMsg();
    }

    public static <T> RichJOption<T> RichJOption(com.atlassian.upm.api.util.Option<T> option) {
        return LicenseChecker$.MODULE$.RichJOption(option);
    }

    public static String TypeMismatchMsg() {
        return LicenseChecker$.MODULE$.TypeMismatchMsg();
    }

    public static String UnknownLicenseErrorMsg() {
        return LicenseChecker$.MODULE$.UnknownLicenseErrorMsg();
    }

    public static String UnresolvedExceptionMsg() {
        return LicenseChecker$.MODULE$.UnresolvedExceptionMsg();
    }

    public static String UserMismatchMsg() {
        return LicenseChecker$.MODULE$.UserMismatchMsg();
    }

    public static String VersionMismatchMsg() {
        return LicenseChecker$.MODULE$.VersionMismatchMsg();
    }

    public LicenseChecker(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
        Logging.$init$(this);
        this.TwoWeek = 14;
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public int TwoWeek() {
        return this.TwoWeek;
    }

    public Option<LicenseIssue> validateLicense(Date currentDate) {
        Object object;
        block10: {
            if (Option$.MODULE$.apply((Object)this.licenseManager).isEmpty()) {
                return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.NoInfoMsg()));
            }
            try {
                Option option = LicenseChecker$.MODULE$.RichJOption(this.licenseManager.getLicense()).asScala();
                if (option instanceof Some) {
                    PluginLicense pluginLicense = (PluginLicense)((Some)option).value();
                    PluginLicense l = pluginLicense;
                    if (l.isValid()) {
                        DateTime expiryDate;
                        Option option2 = LicenseChecker$.MODULE$.RichJOption(l.getExpiryDate()).asScala();
                        object = option2 instanceof Some && this.getDiff(currentDate, (expiryDate = (DateTime)((Some)option2).value()).toDate()) <= (long)this.TwoWeek() ? Some$.MODULE$.apply((Object)LicenseWarning$.MODULE$.apply(LicenseChecker$.MODULE$.ExpiringSoonWarningMsg())) : None$.MODULE$;
                    } else {
                        LicenseError e;
                        PluginLicense l2 = pluginLicense;
                        Option option3 = LicenseChecker$.MODULE$.RichJOption(l2.getError()).asScala();
                        if (option3 instanceof Some && (e = (LicenseError)((Some)option3).value()) != null) {
                            object = this.handleLicenseError(l2, e);
                        } else {
                            this.warn("No license info found");
                            object = Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.UnknownLicenseErrorMsg()));
                        }
                    }
                    break block10;
                }
                if (None$.MODULE$.equals(option)) {
                    object = Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.NoLicenseFoundMsg()));
                    break block10;
                }
                if (option == null) {
                    object = None$.MODULE$;
                    break block10;
                }
                throw new MatchError(option);
            }
            catch (Exception e) {
                this.warn("Failed to retrieve license information", e);
                object = Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.UnresolvedExceptionMsg()));
            }
        }
        return object;
    }

    public Date validateLicense$default$1() {
        return new Date();
    }

    private Some<Serializable> handleLicenseError(PluginLicense l, LicenseError e) {
        LicenseError licenseError = e;
        LicenseError licenseError2 = LicenseError.EXPIRED;
        LicenseError licenseError3 = licenseError;
        if (!(licenseError2 != null ? !licenseError2.equals(licenseError3) : licenseError3 != null)) {
            if (l.isEvaluation()) {
                return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.EvaluationLicenseExpiredMsg()));
            }
            if (!l.isDataCenter() && l.isMaintenanceExpired()) {
                return Some$.MODULE$.apply((Object)LicenseWarning$.MODULE$.apply(LicenseChecker$.MODULE$.MaintenanceExpiredMsg()));
            }
            return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.LicenseExpiredMsg()));
        }
        LicenseError licenseError4 = LicenseError.TYPE_MISMATCH;
        LicenseError licenseError5 = licenseError;
        if (!(licenseError4 != null ? !licenseError4.equals(licenseError5) : licenseError5 != null)) {
            return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.TypeMismatchMsg()));
        }
        LicenseError licenseError6 = LicenseError.USER_MISMATCH;
        LicenseError licenseError7 = licenseError;
        if (!(licenseError6 != null ? !licenseError6.equals(licenseError7) : licenseError7 != null)) {
            return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.UserMismatchMsg()));
        }
        LicenseError licenseError8 = LicenseError.VERSION_MISMATCH;
        LicenseError licenseError9 = licenseError;
        if (!(licenseError8 != null ? !licenseError8.equals(licenseError9) : licenseError9 != null)) {
            return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.VersionMismatchMsg()));
        }
        LicenseError licenseError10 = LicenseError.EDITION_MISMATCH;
        LicenseError licenseError11 = licenseError;
        if (!(licenseError10 != null ? !licenseError10.equals(licenseError11) : licenseError11 != null)) {
            return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.EditionMismatchMsg()));
        }
        this.warn("Unknown license error");
        return Some$.MODULE$.apply((Object)InvalidLicenseInfo$.MODULE$.apply(LicenseChecker$.MODULE$.UnknownLicenseErrorMsg()));
    }

    private long getDiff(Date date1, Date date2) {
        return package$.MODULE$.DAYS().convert(LicenseChecker.diffInMillis$1(date1, date2), package$.MODULE$.MILLISECONDS());
    }

    private static final long diffInMillis$1(Date date1$1, Date date2$1) {
        return Math.abs(date2$1.getTime() - date1$1.getTime());
    }

    public static final class RichJOption<T> {
        private final com.atlassian.upm.api.util.Option optional;

        public RichJOption(com.atlassian.upm.api.util.Option<T> optional) {
            this.optional = optional;
        }

        public com.atlassian.upm.api.util.Option<T> optional() {
            return this.optional;
        }

        public Option<T> asScala() {
            com.atlassian.upm.api.util.Option<T> option = this.optional();
            if (option == null) {
                return null;
            }
            if (this.optional().isDefined()) {
                return Option$.MODULE$.apply(this.optional().get());
            }
            return None$.MODULE$;
        }
    }
}

