/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.tasks;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import java.io.Serializable;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public abstract class SonarLogParser
implements Logging {
    private Logger log;
    private final BuildLogger buildLogger;
    private final Regex SonarBrowseResultsUrl;
    private final Regex SonarTaskIdUrl;
    private final Regex SonarSectionStart;

    public SonarLogParser(BuildLogger buildLogger) {
        this.buildLogger = buildLogger;
        Logging.$init$(this);
        this.SonarBrowseResultsUrl = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("ANALYSIS SUCCESSFUL, you can (?:browse|find the results at:) (http.*)"));
        this.SonarTaskIdUrl = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("More about the report processing at http.*?task\\?id=(.*)"));
        this.SonarSectionStart = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i).*sonar.*"));
        Statics.releaseFence();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$0) {
        this.log = x$0;
    }

    public Tuple3<List<String>, Option<String>, Option<String>> parseLog(List<LogEntry> emittedLogLines) {
        BoxedUnit boxedUnit;
        ListBuffer errorLines = new ListBuffer();
        Regex SonarErrorLine = this.getErrorLineRegex();
        BooleanRef isInSonarSection = BooleanRef.create((boolean)false);
        ObjectRef visitUrl = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef taskId = ObjectRef.create((Object)None$.MODULE$);
        emittedLogLines.foreach((Function1)(JProcedure1 & Serializable)l -> {
            String logLine = l.getUnstyledLog();
            if (this.SonarSectionStart.findFirstMatchIn((CharSequence)logLine).isDefined()) {
                boolean bl;
                isInSonarSection$1.elem = bl = true;
            } else if (logLine.contains("org.sonar.plugins.core.issue.notification.SendIssueNotificationsPostJob")) {
                boolean bl;
                isInSonarSection$1.elem = bl = false;
            }
            if (isInSonarSection$1.elem) {
                SonarErrorLine.findFirstMatchIn((CharSequence)logLine).map((Function1 & Serializable)m -> (ListBuffer)errorLines.$plus$eq((Object)m.group(1)));
                this.SonarBrowseResultsUrl.findFirstMatchIn((CharSequence)logLine).foreach((Function1)(JProcedure1 & Serializable)m -> {
                    Some some = Some$.MODULE$.apply((Object)m.group(1));
                    visitUrl$2.elem = some;
                    some = null;
                });
                this.SonarTaskIdUrl.findFirstMatchIn((CharSequence)logLine).foreach((Function1)(JProcedure1 & Serializable)m -> {
                    Some some = Some$.MODULE$.apply((Object)m.group(1));
                    taskId$2.elem = some;
                    some = null;
                });
                return;
            }
        });
        errorLines.$plus$plus$eq(this.getAdditionalErrors(emittedLogLines));
        Option option = (Option)visitUrl.elem;
        if (option instanceof Some) {
            String sonarResultUrl = (String)((Some)option).value();
            this.debug(() -> SonarLogParser.parseLog$$anonfun$2(sonarResultUrl));
            boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit = Option$.MODULE$.apply((Object)this.buildLogger).map((Function1 & Serializable)_$1 -> _$1.addBuildLogEntry("SONAR4BAMBOO: was not able to find a SonarQube result URL"));
        } else {
            throw new MatchError((Object)option);
        }
        return Tuple3$.MODULE$.apply((Object)errorLines.toList(), (Object)((Option)visitUrl.elem), (Object)((Option)taskId.elem));
    }

    public abstract Regex getErrorLineRegex();

    public abstract List<String> getAdditionalErrors(List<LogEntry> var1);

    private static final String parseLog$$anonfun$2(String sonarResultUrl$1) {
        return new StringBuilder(41).append("Was able to find SonarQube result URL at ").append(sonarResultUrl$1).toString();
    }
}

