/*
 * Decompiled with CFR 0.152.
 */
package ch.mibex.bamboo.sonar4bamboo.bitbucket;

import ch.mibex.bamboo.sonar4bamboo.Logging;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.BitbucketClient$;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.Path;
import ch.mibex.bamboo.sonar4bamboo.bitbucket.PullRequest;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseStatusException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005\rr!B\u0007\u000f\u0011\u0003Ib!B\u000e\u000f\u0011\u0003a\u0002\"B\u0012\u0002\t\u0003!\u0003\"B\u0013\u0002\t\u00031\u0003\"\u0002#\u0002\t\u0003)e\u0001B\u000e\u000f\u0001qC\u0001\"Y\u0003\u0003\u0002\u0003\u0006IA\u0019\u0005\u0006G\u0015!\tA\u001c\u0005\u0006c\u0016!\tA\u001d\u0005\u0006}\u0016!\ta \u0005\b\u0003\u0003)A\u0011AA\u0002\u0011\u001d\tY!\u0002C\u0005\u0003\u001bAq!a\u0006\u0006\t\u0013\tI\"A\bCSR\u0014WoY6fi\u000ec\u0017.\u001a8u\u0015\ty\u0001#A\u0005cSR\u0014WoY6fi*\u0011\u0011CE\u0001\rg>t\u0017M\u001d\u001bcC6\u0014wn\u001c\u0006\u0003'Q\taAY1nE>|'BA\u000b\u0017\u0003\u0015i\u0017NY3y\u0015\u00059\u0012AA2i\u0007\u0001\u0001\"AG\u0001\u000e\u00039\u0011qBQ5uEV\u001c7.\u001a;DY&,g\u000e^\n\u0003\u0003u\u0001\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001a\u0003m9W\r\u001e)vY2\u0014V-];fgR\u001chI]8n%\u0016\u001c\bo\u001c8tKR!qE\u000e!C!\rA\u0003g\r\b\u0003S9r!AK\u0017\u000e\u0003-R!\u0001\f\r\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013BA\u0018 \u0003\u001d\u0001\u0018mY6bO\u0016L!!\r\u001a\u0003\u0011%#XM]1cY\u0016T!aL\u0010\u0011\u0005i!\u0014BA\u001b\u000f\u0005-\u0001V\u000f\u001c7SKF,Xm\u001d;\t\u000b]\u001a\u0001\u0019\u0001\u001d\u0002\u0011I,7\u000f]8og\u0016\u0004\"!O\u001f\u000f\u0005iZ\u0004C\u0001\u0016 \u0013\tat$\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f \u0011\u0015\t5\u00011\u00019\u0003)\u0001(o\u001c6fGR\\U-\u001f\u0005\u0006\u0007\u000e\u0001\r\u0001O\u0001\te\u0016\u0004xn\u00157vO\u0006Ar-\u001a;GS2,\u0007+\u0019;ig\u001a\u0013x.\u001c*fgB|gn]3\u0015\u0005\u0019[\u0006\u0003\u0002\u0015H\u00132K!\u0001\u0013\u001a\u0003\r\u0015KG\u000f[3s!\tq\"*\u0003\u0002L?\t!QK\\5u!\u0015qRjT+Y\u0013\tquD\u0001\u0004UkBdWm\r\t\u0004QA\u0013\u0016BA)3\u0005\u0011a\u0015n\u001d;\u0011\u0005i\u0019\u0016B\u0001+\u000f\u0005\u0011\u0001\u0016\r\u001e5\u0011\u0005y1\u0016BA, \u0005\u001d\u0011un\u001c7fC:\u0004\"AH-\n\u0005i{\"aA%oi\")q\u0007\u0002a\u0001qM\u0019Q!H/\u0011\u0005y{V\"\u0001\t\n\u0005\u0001\u0004\"a\u0002'pO\u001eLgnZ\u0001\u0017CB\u0004H.[2bi&|g\u000eT5oWN+'O^5dKB\u00111\r\\\u0007\u0002I*\u0011QMZ\u0001\u0004CBL'BA4i\u0003!\t\u0007\u000f\u001d7j].\u001c(BA5k\u0003%\tG\u000f\\1tg&\fgNC\u0001l\u0003\r\u0019w.\\\u0005\u0003[\u0012\u0014a#\u00119qY&\u001c\u0017\r^5p]2Kgn[*feZL7-\u001a\u000b\u0003_B\u0004\"AG\u0003\t\u000b\u0005<\u0001\u0019\u00012\u0002!\u0019Lg\u000e\u001a)vY2\u0014V-];fgR\u001cHCB:wqfTH\u0010E\u0002)iNJ!!\u001e\u001a\u0003\u0007M+\u0017\u000fC\u0003x\u0011\u0001\u0007\u0001(A\tbaBd\u0017nY1uS>tG*\u001b8l\u0013\u0012DQa\u0011\u0005A\u0002aBQ!\u0011\u0005A\u0002aBQa\u001f\u0005A\u0002a\n1b\u001d;bg\"\u0014%/\u00198dQ\")Q\u0010\u0003a\u0001q\u0005aA.\u0019;fgR\u001cu.\\7ji\u0006A2\r[3dW\nKGOY;dW\u0016$8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0003%\u000b\u0001CZ5oI\u000eC\u0017M\\4fI\u001aKG.Z:\u0015\u000b=\u000b)!a\u0002\t\u000b]T\u0001\u0019\u0001\u001d\t\r\u0005%!\u00021\u00014\u0003-\u0001X\u000f\u001c7SKF,Xm\u001d;\u00027\u001d,GOQ5uEV\u001c7.\u001a;BaBd\u0017nY1uS>tG*\u001b8l)\u0011\ty!!\u0006\u0011\u0007\r\f\t\"C\u0002\u0002\u0014\u0011\u0014q\"\u00119qY&\u001c\u0017\r^5p]2Kgn\u001b\u0005\u0006o.\u0001\r\u0001O\u0001\u0006I><U\r\u001e\u000b\u0006q\u0005m\u0011q\u0004\u0005\u0007\u0003;a\u0001\u0019\u0001\u001d\u0002\u0007U\u0014H\u000eC\u0004\u0002\"1\u0001\r!a\u0004\u0002\u001f\u0005\u0004\b\u000f\\5dCRLwN\u001c'j].\u0004")
public class BitbucketClient
implements Logging {
    private final ApplicationLinkService applicationLinkService;
    private Logger log;

    public static Either<BoxedUnit, Tuple3<List<Path>, Object, Object>> getFilePathsFromResponse(String response) {
        return BitbucketClient$.MODULE$.getFilePathsFromResponse(response);
    }

    public static Iterable<PullRequest> getPullRequestsFromResponse(String response, String projectKey, String repoSlug) {
        return BitbucketClient$.MODULE$.getPullRequestsFromResponse(response, projectKey, repoSlug);
    }

    @Override
    public <T> void debug(Function0<T> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public <T> void debug(Function0<T> msg, Throwable e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(String msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void warn(String msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(String msg, Throwable t) {
        Logging.warn$(this, msg, t);
    }

    @Override
    public void error(String msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(String msg, Throwable t) {
        Logging.error$(this, msg, t);
    }

    @Override
    public <T> T time(String description, Function0<T> block) {
        return (T)Logging.time$(this, description, block);
    }

    @Override
    public void addErrorLogEntry(String msg, TaskContext taskContext) {
        Logging.addErrorLogEntry$(this, msg, taskContext);
    }

    @Override
    public void addBuildLogEntry(String msg, TaskContext taskContext) {
        Logging.addBuildLogEntry$(this, msg, taskContext);
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void ch$mibex$bamboo$sonar4bamboo$Logging$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    public Seq<PullRequest> findPullRequests(String applicationLinkId, String repoSlug, String projectKey, String stashBranch, String latestCommit) {
        ApplicationLink applicationLink = this.getBitbucketApplicationLink(applicationLinkId);
        String url = new StringBuilder(87).append("rest/api/1.0/projects/").append(projectKey).append("/repos/").append(repoSlug).append("/pull-requests?at=refs/heads/").append(stashBranch).append("&direction=outgoing&limit=999").toString();
        String response = this.doGet(url, applicationLink);
        Iterable<PullRequest> pullRequests = BitbucketClient$.MODULE$.getPullRequestsFromResponse(response, projectKey, repoSlug);
        return ((IterableOnceOps)pullRequests.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BitbucketClient.$anonfun$findPullRequests$1(latestCommit, x$1)))).toSeq();
    }

    public void checkBitbucketConnection() {
        ApplicationLink applicationLink = (ApplicationLink)Option$.MODULE$.apply((Object)this.applicationLinkService.getPrimaryApplicationLink(StashApplicationType.class)).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("No Bitbucket Server application link found");
        });
        String url = "rest/api/1.0/projects?limit=1";
        this.doGet(url, applicationLink);
    }

    public List<Path> findChangedFiles(String applicationLinkId, PullRequest pullRequest) {
        ApplicationLink applicationLink = this.getBitbucketApplicationLink(applicationLinkId);
        ListBuffer changedFiles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        boolean isLastPage = false;
        int nextPageStart = 0;
        while (!isLastPage) {
            Right right;
            Tuple3 tuple3;
            String url = new StringBuilder(69).append("rest/api/1.0/projects/").append(pullRequest.projectKey()).append("/repos/").append(pullRequest.repoSlug()).append("/pull-requests/").append(pullRequest.id()).append("/changes?limit=999&start=").append(nextPageStart).toString();
            String response = this.doGet(url, applicationLink);
            Either<BoxedUnit, Tuple3<List<Path>, Object, Object>> either = BitbucketClient$.MODULE$.getFilePathsFromResponse(response);
            if (either instanceof Right && (tuple3 = (Tuple3)(right = (Right)either).value()) != null) {
                List paths = (List)tuple3._1();
                boolean isLast = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                int nextPage = BoxesRunTime.unboxToInt((Object)tuple3._3());
                isLastPage = isLast;
                nextPageStart = nextPage;
                ListBuffer cfr_ignored_0 = (ListBuffer)changedFiles.$plus$plus$eq((IterableOnce)paths);
                continue;
            }
            if (either instanceof Left) {
                this.debug((Function0 & Serializable)() -> "Limit of diff size is reached, will do a full analysis");
                return Nil$.MODULE$;
            }
            throw new MatchError(either);
        }
        this.debug((Function0 & Serializable)() -> new StringBuilder(42).append("Found files in the diff of pull request ").append(pullRequest.id()).append(": ").append(((IterableOnceOps)changedFiles.map((Function1 & Serializable)x$2 -> x$2.path())).mkString(",")).toString());
        return changedFiles.toList();
    }

    private ApplicationLink getBitbucketApplicationLink(String applicationLinkId) {
        return (ApplicationLink)CollectionConverters$.MODULE$.IterableHasAsScala(this.applicationLinkService.getApplicationLinks(StashApplicationType.class)).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BitbucketClient.$anonfun$getBitbucketApplicationLink$1(applicationLinkId, x$3))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(40).append("No Bitbucket application link found for ").append(applicationLinkId).toString());
        });
    }

    private String doGet(String url, ApplicationLink applicationLink) {
        this.debug((Function0 & Serializable)() -> new StringBuilder(15).append("GET request to ").append(url).toString());
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, url);
        request.setConnectionTimeout(180000);
        request.setSoTimeout(180000);
        return (String)request.executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<Response, String>(this){
            private final /* synthetic */ BitbucketClient $outer;

            public String handle(Response response) {
                String responseBody = response.getResponseBodyAsString();
                this.$outer.debug((Function0 & Serializable)() -> new StringBuilder(46).append("Got response: ").append(responseBody).append(" with status code ").append(response.getStatusCode()).append(", successful: ").append(response.isSuccessful()).toString());
                if (!response.isSuccessful()) {
                    throw new ResponseStatusException(new StringBuilder(2).append(response.getStatusText()).append(": ").append(responseBody).toString(), response);
                }
                return responseBody;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handle$1(java.lang.String com.atlassian.sal.api.net.Response )}, serializedLambda);
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$findPullRequests$1(String latestCommit$1, PullRequest x$1) {
        String string = x$1.latestCommit();
        String string2 = latestCommit$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getBitbucketApplicationLink$1(String applicationLinkId$1, ApplicationLink x$3) {
        String string = x$3.getId().get();
        String string2 = applicationLinkId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public BitbucketClient(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
        Logging.$init$(this);
        Statics.releaseFence();
    }
}

