/*
 * Decompiled with CFR 0.152.
 */
package restUtils.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import restUtils.calls.CustomRestApiGET;

public class BalraObject {
    private String bitbucketServerManifestUrl = "";
    @JsonProperty(value="bamboo_project_key")
    private String bambooProjectKey;
    @JsonProperty(value="admin_token")
    private String adminToken;
    @JsonProperty(value="bamboo_server_url")
    private String bambooServerUrl;
    @JsonProperty(value="linked_repo_name")
    private String linkedRepoName;
    @JsonProperty(value="app_link_name")
    private String appLinkName;
    @JsonProperty(value="app_link_id")
    private String appLinkId;
    @JsonProperty(value="bitbucket_project_key")
    private String bitbucketProjectKey;
    @JsonProperty(value="ssh_clone_url")
    private String sshCloneUrl;
    @JsonProperty(value="bitbucket_repository_slug")
    private String bitbucketRepositorySlug;

    public String getAdminToken() {
        return Optional.ofNullable(this.adminToken).orElse("");
    }

    public String getLinkedRepoName() {
        this.linkedRepoName = Optional.ofNullable(this.linkedRepoName).orElse("");
        if (this.linkedRepoName.equals("")) {
            this.linkedRepoName = this.sshCloneUrl.substring(this.sshCloneUrl.lastIndexOf("/") + 1);
            this.linkedRepoName = this.linkedRepoName.substring(0, this.linkedRepoName.length() - 4);
        }
        return this.linkedRepoName;
    }

    public String getAppLinkName() {
        this.appLinkName = Optional.ofNullable(this.appLinkName).orElse("");
        if (this.appLinkName.equals("")) {
            this.appLinkName = new CustomRestApiGET().getLinkIdFromManifest(this.getAdminToken(), this.bitbucketServerManifestUrl, "name");
        }
        return this.appLinkName;
    }

    public String getAppLinkId() {
        this.appLinkId = Optional.ofNullable(this.appLinkId).orElse("");
        if (this.appLinkId.equals("")) {
            this.appLinkId = new CustomRestApiGET().getLinkIdFromManifest(this.getAdminToken(), this.bitbucketServerManifestUrl, "id");
        }
        return this.appLinkId;
    }

    public String getBitbucketProjectKey() {
        this.bitbucketProjectKey = Optional.ofNullable(this.bitbucketProjectKey).orElse("");
        if (this.bitbucketProjectKey.equals("")) {
            this.bitbucketProjectKey = this.sshCloneUrl;
            String[] appLinkArr = this.bitbucketProjectKey.split("/");
            this.bitbucketProjectKey = appLinkArr[appLinkArr.length - 2];
        }
        return this.bitbucketProjectKey;
    }

    public void setSshCloneUrl(String sshCloneUrl) {
        this.sshCloneUrl = sshCloneUrl;
        this.bitbucketServerManifestUrl = sshCloneUrl.replace("bamboo", "bitbucket");
        this.bitbucketServerManifestUrl = this.bitbucketServerManifestUrl.replace("ssh://git@", "@");
        String[] arr = this.bitbucketServerManifestUrl.split(":");
        this.bitbucketServerManifestUrl = arr[0];
        this.bitbucketServerManifestUrl = this.bitbucketServerManifestUrl.replace("@", "https://");
        this.bitbucketServerManifestUrl = this.bitbucketServerManifestUrl + "/rest/applinks/2.0/manifest";
    }

    public String getBitbucketRepositorySlug() {
        this.bitbucketRepositorySlug = Optional.ofNullable(this.bitbucketRepositorySlug).orElse("");
        if (this.bitbucketRepositorySlug.equals("")) {
            this.bitbucketRepositorySlug = this.sshCloneUrl.substring(this.sshCloneUrl.lastIndexOf("/") + 1);
            this.bitbucketRepositorySlug = this.bitbucketRepositorySlug.substring(0, this.bitbucketRepositorySlug.length() - 4);
        }
        return this.bitbucketRepositorySlug;
    }

    public String toString() {
        return "Repository " + this.sshCloneUrl + " has been linked to project " + this.bitbucketProjectKey;
    }

    public void setBambooProjectKey(String bambooProjectKey) {
        this.bambooProjectKey = bambooProjectKey;
    }

    public String getBambooProjectKey() {
        return this.bambooProjectKey;
    }

    public void setAdminToken(String adminToken) {
        this.adminToken = adminToken;
    }

    public String getBambooServerUrl() {
        return this.bambooServerUrl;
    }

    public void setBambooServerUrl(String bambooServerUrl) {
        this.bambooServerUrl = bambooServerUrl;
    }

    public void setLinkedRepoName(String linkedRepoName) {
        this.linkedRepoName = linkedRepoName;
    }

    public void setAppLinkName(String appLinkName) {
        this.appLinkName = appLinkName;
    }

    public void setAppLinkId(String appLinkId) {
        this.appLinkId = appLinkId;
    }

    public void setBitbucketProjectKey(String bitbucketProjectKey) {
        this.bitbucketProjectKey = bitbucketProjectKey;
    }

    public String getSshCloneUrl() {
        return this.sshCloneUrl;
    }
}

