/*
 * Decompiled with CFR 0.152.
 */
package restUtils.endpoints;

import balra.BalHandler;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import restUtils.models.BalraAdminObject;
import restUtils.models.BalraObject;

@ApplicationPath(value="/resources")
@Path(value="/balra")
public class BalraRestApiEndpoint {
    @ComponentImport
    private final BandanaManager bandanaManager;
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    final String adminTokenString = "AdminToken";
    final String bambooServerUrlString = "BambooServerUrl";
    final String persistKey = "system.bamboo.repository.Balra:AdminObject";

    @Inject
    public BalraRestApiEndpoint(BandanaManager bandanaManager, PluginLicenseManager pluginLicenseManager) {
        this.bandanaManager = bandanaManager;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/admin")
    public Response setAdmin(String data) {
        this.checkLicenseValidity();
        try {
            BalraAdminObject balraAdminObject = (BalraAdminObject)new ObjectMapper().readValue(data, BalraAdminObject.class);
            balraAdminObject.checkValues();
            HashMap<String, String> keyValues = new HashMap<String, String>();
            keyValues.put("AdminToken", balraAdminObject.getAdminToken());
            keyValues.put("BambooServerUrl", balraAdminObject.getBambooServerUrl());
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "system.bamboo.repository.Balra:AdminObject", keyValues);
            return Response.status((int)200).entity((Object)"Credentials stored.").build();
        }
        catch (Exception npe) {
            return Response.status((int)500).entity((Object)"Internal error: Incorrect Value or Malformed Json").build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/linkRepository")
    public Response linkRepo(String data) throws JsonProcessingException {
        this.checkLicenseValidity();
        BalraObject balraObject = (BalraObject)new ObjectMapper().readValue(data, BalraObject.class);
        Map<String, String> valueMap = this.getPersistedMapFromKey();
        if (this.credentialsCheck(balraObject, valueMap)) {
            return Response.status((int)401).entity((Object)"No Credentials set.").build();
        }
        return new BalHandler(balraObject).createBalraResponse();
    }

    private Map<String, String> getPersistedMapFromKey() {
        return (Map)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "system.bamboo.repository.Balra:AdminObject");
    }

    private boolean credentialsCheck(BalraObject balraObject, Map<String, String> persistedValues) {
        if (Objects.equals(balraObject.getAdminToken(), "")) {
            try {
                balraObject.setAdminToken(persistedValues.get("AdminToken"));
                balraObject.setBambooServerUrl(persistedValues.get("BambooServerUrl"));
            }
            catch (NullPointerException npe) {
                return true;
            }
        }
        return false;
    }

    private void checkLicenseValidity() {
        boolean isPluginValid = false;
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            boolean bl = isPluginValid = !pluginLicense.getError().isDefined();
        }
        if (!isPluginValid) {
            throw new LicenseException("License is no longer valid. Please renew the license or contact info@xalt.de.");
        }
    }
}

