/*
 * Decompiled with CFR 0.152.
 */
package balra;

import com.atlassian.bamboo.specs.api.BambooSpec;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.applink.ApplicationLink;
import com.atlassian.bamboo.specs.api.builders.repository.viewer.VcsRepositoryViewer;
import com.atlassian.bamboo.specs.builders.repository.bitbucket.server.BitbucketServerRepository;
import com.atlassian.bamboo.specs.builders.repository.viewer.BitbucketServerRepositoryViewer;
import com.atlassian.bamboo.specs.util.AuthenticationProvider;
import com.atlassian.bamboo.specs.util.BambooServer;
import com.atlassian.bamboo.specs.util.SimpleTokenCredentials;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import restUtils.calls.CustomRestApiGET;
import restUtils.calls.RestApiPUTorPOST;
import restUtils.models.BalraObject;
import restUtils.models.BalraResponse;
import restUtils.models.PUTORPOST_ENUM;
import restUtils.models.ResponsePojo;

@BambooSpec
public class BalHandler {
    private final BalraObject balraObject;
    private final BambooServer bambooServer;
    private String repoId;
    private final HashMap<String, String> headers;
    private final ResponsePojo scan;
    private final ResponsePojo permissions;
    private final ResponsePojo repoToBuildPlan;
    private final String jsonBodyData = "{ \"enable\" : true }";
    private final String[] requests = new String[]{"/enableCi", "/enableProjectCreation"};

    public BalHandler(BalraObject balraObject) {
        this.balraObject = balraObject;
        SimpleTokenCredentials simpleTokenCredentials = new SimpleTokenCredentials(balraObject.getAdminToken());
        this.bambooServer = new BambooServer(balraObject.getBambooServerUrl(), (AuthenticationProvider)simpleTokenCredentials);
        this.headers = this.setHeaders();
        this.createLinkedRepo();
        this.getRepoId();
        this.permissions = this.iteratePermissions();
        this.repoToBuildPlan = this.addRepoToBuildPlan();
        this.scan = this.activateScan();
    }

    private HashMap<String, String> setHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.balraObject.getAdminToken());
        headers.put("Content-Type", "application/json");
        return headers;
    }

    private void getRepoId() {
        this.repoId = new CustomRestApiGET().getAndParseRepoId(this.balraObject.getBambooServerUrl(), this.balraObject.getLinkedRepoName(), this.headers);
    }

    private void createLinkedRepo() {
        BitbucketServerRepository linkedRepo = ((BitbucketServerRepository)((BitbucketServerRepository)new BitbucketServerRepository().name(this.balraObject.getLinkedRepoName())).repositoryViewer((VcsRepositoryViewer)new BitbucketServerRepositoryViewer())).server(new ApplicationLink().name(this.balraObject.getAppLinkName()).id(this.balraObject.getAppLinkId())).projectKey(this.balraObject.getBitbucketProjectKey()).sshCloneUrl(this.balraObject.getSshCloneUrl()).repositorySlug(this.balraObject.getBitbucketRepositorySlug());
        this.bambooServer.publish((RootEntityPropertiesBuilder)linkedRepo);
    }

    private ResponsePojo iteratePermissions() {
        for (String request : this.requests) {
            ResponsePojo response = this.putPermissionRequests(request);
            if (response.getResponseCode() == 200) continue;
            response.setResponseMessage("problem adding permission " + response.getResponseMessage());
            return response;
        }
        return new ResponsePojo(200, "adding permissions OK");
    }

    private ResponsePojo putPermissionRequests(String step) {
        String scanApiUrl = this.balraObject.getBambooServerUrl() + "/rest/api/1.0/repository/" + this.repoId;
        return new RestApiPUTorPOST().create(scanApiUrl + step, this.headers, "{ \"enable\" : true }", PUTORPOST_ENUM.PUT);
    }

    private ResponsePojo activateScan() {
        String scanApiUrl = this.balraObject.getBambooServerUrl() + "/rest/api/1.0/repository/" + this.repoId + "/scanNow";
        ResponsePojo res = new RestApiPUTorPOST().create(scanApiUrl, this.headers, "{ \"enable\" : true }", PUTORPOST_ENUM.POST);
        if (res.getResponseMessage() == null) {
            res.setResponseMessage("activate ci scan");
            return res;
        }
        res.setResponseMessage("activate ci scan " + res.getResponseMessage() + " repo id " + this.repoId);
        return res;
    }

    private ResponsePojo addRepoToBuildPlan() {
        String addRepoToBuildPlanApiUrl = this.balraObject.getBambooServerUrl() + "/rest/api/latest/project/" + this.balraObject.getBambooProjectKey() + "/repository";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", this.repoId);
        ResponsePojo res = new RestApiPUTorPOST().create(addRepoToBuildPlanApiUrl, this.headers, jsonObject.toString(), PUTORPOST_ENUM.POST);
        res.setResponseMessage("adding repo to build plan " + res.getResponseMessage());
        return res;
    }

    public Response createBalraResponse() {
        BalraResponse balraResponse = new BalraResponse();
        ArrayList<ResponsePojo> responses = new ArrayList<ResponsePojo>();
        responses.add(this.scan);
        responses.add(this.permissions);
        responses.add(this.repoToBuildPlan);
        balraResponse.setResponses(responses);
        for (ResponsePojo response : responses) {
            if (response.getResponseCode() >= 200 && response.getResponseCode() < 300) continue;
            balraResponse.setValidRequest(false);
        }
        if (!balraResponse.isValidRequest()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)balraResponse).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)balraResponse).build();
    }
}

