/*
 * Decompiled with CFR 0.152.
 */
package restUtils.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import restUtils.calls.CustomRestApiGET;

public class BalraObject {
    private String bitbucketServerManifestUrl = "";
    @JsonProperty(value="admin_token")
    private String adminToken;
    @JsonProperty(value="bamboo_server_url")
    private String bambooServerUrl;
    @JsonProperty(value="repo_name")
    private String repoName;
    @JsonProperty(value="app_link_name")
    private String appLinkName;
    @JsonProperty(value="app_link_id")
    private String appLinkId;
    @JsonProperty(value="project_key")
    private String projectKey;
    @JsonProperty(value="ssh_clone_url")
    private String sshCloneUrl;
    @JsonProperty(value="repository_slug")
    private String repositorySlug;

    public String getAdminToken() {
        return Optional.ofNullable(this.adminToken).orElse("");
    }

    public String getRepoName() {
        this.repoName = Optional.ofNullable(this.repoName).orElse("");
        if (this.repoName.equals("")) {
            this.repoName = this.sshCloneUrl.substring(this.sshCloneUrl.lastIndexOf("/") + 1);
            this.repoName = this.repoName.substring(0, this.repoName.length() - 4);
        }
        return this.repoName;
    }

    public String getAppLinkName() {
        this.appLinkName = Optional.ofNullable(this.appLinkName).orElse("");
        if (this.appLinkName.equals("")) {
            this.appLinkName = new CustomRestApiGET().getLinkIdFromManifest(this.getAdminToken(), this.bitbucketServerManifestUrl, "name");
        }
        return this.appLinkName;
    }

    public String getAppLinkId() {
        this.appLinkId = Optional.ofNullable(this.appLinkId).orElse("");
        if (this.appLinkId.equals("")) {
            this.appLinkId = new CustomRestApiGET().getLinkIdFromManifest(this.getAdminToken(), this.bitbucketServerManifestUrl, "id");
        }
        return this.appLinkId;
    }

    public String getProjectKey() {
        this.projectKey = Optional.ofNullable(this.projectKey).orElse("");
        if (this.projectKey.equals("")) {
            this.projectKey = this.sshCloneUrl;
            String[] appLinkArr = this.projectKey.split("/");
            this.projectKey = appLinkArr[appLinkArr.length - 2];
        }
        return this.projectKey;
    }

    public void setSshCloneUrl(String sshCloneUrl) {
        this.sshCloneUrl = sshCloneUrl;
        this.bitbucketServerManifestUrl = sshCloneUrl.replace("bamboo", "bitbucket");
        this.bitbucketServerManifestUrl = this.bitbucketServerManifestUrl.replace("ssh://git@", "@");
        String[] arr = this.bitbucketServerManifestUrl.split(":");
        this.bitbucketServerManifestUrl = arr[0];
        this.bitbucketServerManifestUrl = this.bitbucketServerManifestUrl.replace("@", "https://");
        this.bitbucketServerManifestUrl = this.bitbucketServerManifestUrl + "/rest/applinks/2.0/manifest";
    }

    public String getRepositorySlug() {
        this.repositorySlug = Optional.ofNullable(this.repositorySlug).orElse("");
        if (this.repositorySlug.equals("")) {
            this.repositorySlug = this.sshCloneUrl.substring(this.sshCloneUrl.lastIndexOf("/") + 1);
            this.repositorySlug = this.repositorySlug.substring(0, this.repositorySlug.length() - 4);
        }
        return this.repositorySlug;
    }

    public String toString() {
        return "Repository " + this.sshCloneUrl + " has been linked to project " + this.projectKey;
    }

    @JsonProperty(value="admin_token")
    public void setAdminToken(String adminToken) {
        this.adminToken = adminToken;
    }

    public String getBambooServerUrl() {
        return this.bambooServerUrl;
    }

    @JsonProperty(value="bamboo_server_url")
    public void setBambooServerUrl(String bambooServerUrl) {
        this.bambooServerUrl = bambooServerUrl;
    }

    @JsonProperty(value="repo_name")
    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    @JsonProperty(value="app_link_name")
    public void setAppLinkName(String appLinkName) {
        this.appLinkName = appLinkName;
    }

    @JsonProperty(value="app_link_id")
    public void setAppLinkId(String appLinkId) {
        this.appLinkId = appLinkId;
    }

    @JsonProperty(value="project_key")
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getSshCloneUrl() {
        return this.sshCloneUrl;
    }
}

