/*
 * Decompiled with CFR 0.152.
 */
package restUtils.calls;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.json.XML;

public class CustomRestApiGET {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAndParseRepoId(String baseUrl, String repoName, Map<String, String> headers) {
        String id;
        String restApiToSearch = "/rest/api/1.0/repository?searchTerm=";
        String fullUrl = baseUrl + restApiToSearch + repoName;
        HttpURLConnection http = null;
        try {
            URL url = new URL(fullUrl);
            http = (HttpURLConnection)url.openConnection();
            headers.forEach(http::setRequestProperty);
            InputStream inputStream = http.getInputStream();
            String text = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            JsonObject jsonObject = JsonParser.parseString(text).getAsJsonObject();
            JsonArray sr = jsonObject.get("searchResults").getAsJsonArray();
            JsonObject jObject = sr.get(0).getAsJsonObject();
            id = jObject.get("id").toString();
        }
        catch (Exception e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLinkIdFromManifest(String admin_token, String bamboo_server_url, String id) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + admin_token);
        headers.put("Content-Type", "application/json");
        HttpURLConnection http = null;
        try {
            URL url = new URL(bamboo_server_url);
            http = (HttpURLConnection)url.openConnection();
            headers.forEach(http::setRequestProperty);
            InputStream inputStream = http.getInputStream();
            String xml = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            JSONObject jsonObject = XML.toJSONObject(xml);
            id = jsonObject.getJSONObject("manifest").getString(id);
        }
        catch (Exception e) {
            id = e.getMessage();
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
        return id;
    }
}

