/*
 * Decompiled with CFR 0.152.
 */
package balra;

import com.atlassian.bamboo.specs.api.BambooSpec;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.applink.ApplicationLink;
import com.atlassian.bamboo.specs.api.builders.repository.viewer.VcsRepositoryViewer;
import com.atlassian.bamboo.specs.builders.repository.bitbucket.server.BitbucketServerRepository;
import com.atlassian.bamboo.specs.builders.repository.viewer.BitbucketServerRepositoryViewer;
import com.atlassian.bamboo.specs.util.AuthenticationProvider;
import com.atlassian.bamboo.specs.util.BambooServer;
import com.atlassian.bamboo.specs.util.SimpleTokenCredentials;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import restUtils.calls.CustomRestApiGET;
import restUtils.calls.RestApiPUTorPOST;
import restUtils.models.BalraObject;
import restUtils.models.PUTORPOST_ENUM;
import restUtils.models.ResponsePojo;

@BambooSpec
public class BalHandler {
    private final BalraObject balraObject;
    private final BambooServer bambooServer;
    private String repoId;
    private final HashMap<String, String> headers;
    private final ResponsePojo scan;
    private final ResponsePojo permissions;
    private final String jsonBodyData = "{ \"enable\" : true }";
    private final String[] requests = new String[]{"/enableCi", "/enableAllRepositoriesAccess", "/enableProjectCreation", "/enableAllProjectsAccess"};

    public BalHandler(BalraObject balraObject) {
        this.balraObject = balraObject;
        SimpleTokenCredentials simpleTokenCredentials = new SimpleTokenCredentials(balraObject.getAdminToken());
        this.bambooServer = new BambooServer(balraObject.getBambooServerUrl(), (AuthenticationProvider)simpleTokenCredentials);
        this.headers = this.setHeaders();
        this.createLinkedRepo();
        this.getRepoId();
        this.permissions = this.iteratePermissions();
        this.scan = this.activateScan();
    }

    private HashMap<String, String> setHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.balraObject.getAdminToken());
        headers.put("Content-Type", "application/json");
        return headers;
    }

    private void getRepoId() {
        this.repoId = new CustomRestApiGET().getAndParseRepoId(this.balraObject.getBambooServerUrl(), this.balraObject.getRepoName(), this.headers);
    }

    private void createLinkedRepo() {
        BitbucketServerRepository linkedRepo = ((BitbucketServerRepository)((BitbucketServerRepository)new BitbucketServerRepository().name(this.balraObject.getRepoName())).repositoryViewer((VcsRepositoryViewer)new BitbucketServerRepositoryViewer())).server(new ApplicationLink().name(this.balraObject.getAppLinkName()).id(this.balraObject.getAppLinkId())).projectKey(this.balraObject.getProjectKey()).sshCloneUrl(this.balraObject.getSshCloneUrl()).repositorySlug(this.balraObject.getRepositorySlug());
        this.bambooServer.publish((RootEntityPropertiesBuilder)linkedRepo);
    }

    private ResponsePojo iteratePermissions() {
        for (String request : this.requests) {
            ResponsePojo response = this.putPermissionRequests(request);
            if (response.getResponseCode() == 200) continue;
            return response;
        }
        return new ResponsePojo(200, "OK");
    }

    private ResponsePojo putPermissionRequests(String step) {
        String scanApiUrl = this.balraObject.getBambooServerUrl() + "/rest/api/1.0/repository/" + this.repoId;
        return new RestApiPUTorPOST().create(scanApiUrl + step, this.headers, "{ \"enable\" : true }", PUTORPOST_ENUM.PUT);
    }

    private ResponsePojo activateScan() {
        String scanApiUrl = this.balraObject.getBambooServerUrl() + "/rest/api/1.0/repository/" + this.repoId + "/scanNow";
        return new RestApiPUTorPOST().create(scanApiUrl, this.headers, "{ \"enable\" : true }", PUTORPOST_ENUM.POST);
    }

    public Response balraResponse() {
        if (this.scan.getResponseCode() == 204 && this.permissions.getResponseCode() == 200) {
            return Response.status((int)200).entity((Object)(this.balraObject.toString() + " with ID: " + this.repoId)).build();
        }
        return Response.status((int)500).entity((Object)("Scan:" + this.scan.getResponseCode() + " / Permissions:" + this.permissions.getResponseCode())).build();
    }
}

